/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedHashMap;

class MemoryCache {
    private static final float LOAD_FACTOR = 0.75f;
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private final LinkedHashMap cacheMap;
    private final int maxSize;
    private final int lifetime;
    private final ReferenceQueue queue;

    public MemoryCache(int maxSize, int lifetime) {
        this.maxSize = maxSize;
        this.lifetime = lifetime * 1000;
        this.queue = new ReferenceQueue();
        int buckets = (int)((float)maxSize / 0.75f) + 1;
        this.cacheMap = new LinkedHashMap(buckets, 0.75f, true);
    }

    private void processQueue() {
        int endSize;
        int startSize = this.cacheMap.size();
        SoftValue entry = null;
        while ((entry = (SoftValue)this.queue.poll()) != null) {
            SoftReference currentEntry;
            Object key = entry.key;
            if (key == null || (currentEntry = (SoftReference)this.cacheMap.remove(key)) == null || entry == currentEntry) continue;
            this.cacheMap.put(key, currentEntry);
        }
        if (debug != null && startSize != (endSize = this.cacheMap.size())) {
            System.out.println("CERTPATH: Cache size is reduced from " + startSize + " to " + endSize + " entries");
        }
    }

    private void expungeExpiredEntries() {
        this.processQueue();
        if (this.lifetime == 0) {
            return;
        }
        int cnt = 0;
        long time = System.currentTimeMillis();
        Iterator t = this.cacheMap.values().iterator();
        while (t.hasNext()) {
            SoftValue entry = (SoftValue)t.next();
            if (entry.isValid(time)) continue;
            t.remove();
            ++cnt;
        }
        if (debug != null && cnt != 0) {
            System.out.println("CERTPATH: Removed " + cnt + " expired entries, remaining " + this.cacheMap.size());
        }
    }

    public synchronized int size() {
        this.expungeExpiredEntries();
        return this.cacheMap.size();
    }

    public synchronized void clear() {
        for (SoftValue entry : this.cacheMap.values()) {
            entry.clear();
        }
        while (this.queue.poll() != null) {
        }
        this.cacheMap.clear();
    }

    public synchronized void put(Object key, Object value) {
        if (this.lifetime > 0) {
            this.processQueue();
            long expirationTime = System.currentTimeMillis() + (long)this.lifetime;
            SoftValue newEntry = new SoftValue(key, value, expirationTime, this.queue);
            SoftValue oldEntry = this.cacheMap.put(key, newEntry);
            if (oldEntry != null) {
                oldEntry.clear();
                return;
            }
            if (this.cacheMap.size() > this.maxSize) {
                this.expungeExpiredEntries();
                if (this.cacheMap.size() > this.maxSize) {
                    Iterator t = this.cacheMap.values().iterator();
                    SoftValue lruEntry = (SoftValue)t.next();
                    if (debug != null) {
                        System.out.println("CERTPATH: ** Overflow removal " + lruEntry.key + " | " + lruEntry.get());
                    }
                    t.remove();
                    lruEntry.clear();
                }
            }
        }
    }

    public synchronized Object get(Object key) {
        long time;
        this.processQueue();
        SoftValue entry = (SoftValue)this.cacheMap.get(key);
        if (entry == null) {
            return null;
        }
        long l = time = this.lifetime == 0 ? 0L : System.currentTimeMillis();
        if (!entry.isValid(time)) {
            this.cacheMap.remove(key);
            return null;
        }
        return entry.get();
    }

    public synchronized void remove(Object key) {
        this.processQueue();
        SoftValue entry = (SoftValue)this.cacheMap.remove(key);
        if (entry != null) {
            entry.clear();
        }
    }

    private static class SoftValue
    extends SoftReference {
        private Object key;
        private long expirationTime;

        SoftValue(Object key, Object value, long expirationTime, ReferenceQueue queue) {
            super(value, queue);
            this.key = key;
            this.expirationTime = expirationTime;
        }

        public boolean isValid(long currentTime) {
            boolean valid;
            boolean bl = valid = currentTime <= this.expirationTime && this.get() != null;
            if (!valid) {
                this.clear();
            }
            return valid;
        }

        @Override
        public void clear() {
            super.clear();
            this.key = null;
            this.expirationTime = -1L;
        }
    }
}

