/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.rmi.registry;

import java.util.Hashtable;
import java.util.Vector;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.rmi.registry.RegistryContext;
import org.apache.harmony.jndi.provider.rmi.rmiURLContextFactory;

public class RegistryContextFactory
implements InitialContextFactory,
ObjectFactory {
    @Override
    public Context getInitialContext(Hashtable<?, ?> hashtable) throws NamingException {
        Object object;
        String string = null;
        if (hashtable != null) {
            string = (String)hashtable.get("java.naming.provider.url");
        }
        if (string == null) {
            string = "rmi:";
        }
        if ((object = new rmiURLContextFactory().getObjectInstance(string, null, null, hashtable)) instanceof Context) {
            return (Context)object;
        }
        throw new NotContextException(Messages.getString("jndi.76", string));
    }

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
        if (!(object instanceof Reference)) {
            return null;
        }
        Reference reference = (Reference)object;
        if (!reference.getFactoryClassName().equals(RegistryContextFactory.class.getName())) {
            return null;
        }
        int n = reference.size();
        if (n < 1) {
            throw new ConfigurationException(Messages.getString("jndi.77"));
        }
        Vector<Object> vector = new Vector<Object>(n);
        Object object2 = reference.getAll();
        while (object2.hasMoreElements()) {
            RefAddr refAddr = object2.nextElement();
            if (!(refAddr instanceof StringRefAddr) || !refAddr.getType().equals("URL")) continue;
            vector.add(refAddr.getContent());
        }
        n = vector.size();
        if (n < 1) {
            throw new ConfigurationException(Messages.getString("jndi.78"));
        }
        object2 = new rmiURLContextFactory().getObjectInstance(vector.toArray(new String[n]), name, context, hashtable);
        if (object2 instanceof RegistryContext) {
            ((RegistryContext)object2).setReference(reference);
        }
        return object2;
    }
}

