/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.dns.ProviderMgr;

class SList {
    public static int NETWORK_FAILURE = 0x7FFFFFFC;
    public static int TIMEOUT = 0x7FFFFFFD;
    public static int SERVER_FAILURE = 0x7FFFFFFE;
    public static int UNKNOWN = 0;
    private Hashtable<String, Vector<Entry>> zones = new Hashtable();
    private Vector<Server> servers = new Vector();
    private static SList instance = new SList();

    private SList() {
    }

    static SList getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateEntry(String string, Server server, int n) {
        String string2 = ProviderMgr.normalizeName(string);
        Entry entry = new Entry(string2, this.getServerNum(server), n);
        Hashtable<String, Vector<Entry>> hashtable = this.zones;
        synchronized (hashtable) {
            Vector<Entry> vector = this.zones.get(ProviderMgr.normalizeName(string2));
            if (vector == null) {
                vector = new Vector();
                vector.addElement(entry);
                this.zones.put(string2, vector);
            } else {
                Entry entry2;
                int n2;
                boolean bl = false;
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    entry2 = vector.elementAt(n2);
                    if (!server.equals(this.serverAtNum(entry2.getServerNum()))) continue;
                    vector.removeElementAt(n2);
                    break;
                }
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    entry2 = vector.elementAt(n2);
                    if (n >= entry2.getResponseTime()) continue;
                    vector.insertElementAt(entry, n2);
                    bl = true;
                    break;
                }
                if (!bl) {
                    vector.addElement(entry);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Server getBestGuess(String string, Hashtable<Server, ?> hashtable) {
        Hashtable<String, Vector<Entry>> hashtable2 = this.zones;
        synchronized (hashtable2) {
            Vector<Entry> vector = this.zones.get(ProviderMgr.normalizeName(string));
            if (vector != null && vector.size() > 0) {
                for (int i = 0; i < vector.size(); ++i) {
                    Entry entry = vector.elementAt(i);
                    if (hashtable != null && hashtable.get(this.serverAtNum(entry.getServerNum())) != null) continue;
                    return this.serverAtNum(entry.getServerNum());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropServer(String string, Server server) {
        Hashtable<String, Vector<Entry>> hashtable = this.zones;
        synchronized (hashtable) {
            Vector<Entry> vector = this.zones.get(ProviderMgr.normalizeName(string));
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Entry entry = vector.elementAt(i);
                    if (!server.equals(this.serverAtNum(entry.getServerNum()))) continue;
                    vector.removeElementAt(i);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasServer(String string, Server server) {
        Hashtable<String, Vector<Entry>> hashtable = this.zones;
        synchronized (hashtable) {
            Vector<Entry> vector = this.zones.get(ProviderMgr.normalizeName(string));
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Entry entry = vector.elementAt(i);
                    if (!server.equals(this.serverAtNum(entry.getServerNum()))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Server getServerByName(String string, String string2, int n) {
        Hashtable<String, Vector<Entry>> hashtable = this.zones;
        synchronized (hashtable) {
            Vector<Entry> vector = this.zones.get(ProviderMgr.normalizeName(string));
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Entry entry = vector.elementAt(i);
                    if (!ProviderMgr.namesAreEqual(string2, this.serverAtNum(entry.getServerNum()).getName()) || n != this.serverAtNum(entry.getServerNum()).getPort()) continue;
                    return this.serverAtNum(entry.getServerNum());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Server getServerByIP(String string, String string2, int n) {
        Hashtable<String, Vector<Entry>> hashtable = this.zones;
        synchronized (hashtable) {
            Vector<Entry> vector = this.zones.get(ProviderMgr.normalizeName(string));
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Entry entry = vector.elementAt(i);
                    if (!string2.equals(this.serverAtNum(entry.getServerNum()).getIP()) || n != this.serverAtNum(entry.getServerNum()).getPort()) continue;
                    return this.serverAtNum(entry.getServerNum());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Server getServerByServer(String string, Server server) {
        Hashtable<String, Vector<Entry>> hashtable = this.zones;
        synchronized (hashtable) {
            Vector<Entry> vector = this.zones.get(ProviderMgr.normalizeName(string));
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Entry entry = vector.elementAt(i);
                    if (!server.equals(this.serverAtNum(entry.getServerNum()))) continue;
                    return this.serverAtNum(entry.getServerNum());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Hashtable<String, Vector<Entry>> hashtable = this.zones;
        synchronized (hashtable) {
            this.zones = new Hashtable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getServerNum(Server server) {
        if (this.servers.contains(server)) {
            return this.servers.indexOf(server);
        }
        Vector<Server> vector = this.servers;
        synchronized (vector) {
            this.servers.addElement(server);
            return this.servers.size() - 1;
        }
    }

    private Server serverAtNum(int n) {
        if (n < this.servers.size()) {
            return this.servers.elementAt(n);
        }
        return null;
    }

    boolean hasServer(String string) {
        return this.servers.contains(new Server(string, null, 53));
    }

    Enumeration<Server> getServersByName(String string) {
        Vector<Server> vector = new Vector<Server>();
        if (string == null) {
            throw new NullPointerException(Messages.getString("jndi.34"));
        }
        for (int i = 0; i < this.servers.size(); ++i) {
            Server server = this.servers.get(i);
            if (server.getName() == null || !ProviderMgr.namesAreEqual(string, server.getName())) continue;
            vector.addElement(server);
        }
        return vector.elements();
    }

    void setServerIP(String string, String string2) {
        String string3 = ProviderMgr.normalizeName(string);
        for (int i = 0; i < this.servers.size(); ++i) {
            Server server = this.servers.elementAt(i);
            if (!string3.equals(server.getName()) || server.getIP() != null) continue;
            server.setIP(string2);
            break;
        }
    }

    static class Server {
        private String serverName;
        private String serverIP;
        private int serverPort;

        public Server(String string, String string2, int n) {
            this.serverName = ProviderMgr.normalizeName(string);
            this.serverIP = string2;
            this.serverPort = n;
        }

        public boolean equals(Object object) {
            Server server = null;
            if (!(object instanceof Server)) {
                return false;
            }
            server = (Server)object;
            if (this.serverIP == null || server.getIP() == null) {
                if (this.getName() == null || server.getName() == null) {
                    return false;
                }
                return ProviderMgr.namesAreEqual(this.getName(), server.getName()) && this.getPort() == server.getPort();
            }
            return this.getIP().equals(server.getIP()) && this.getPort() == server.getPort();
        }

        public String getIP() {
            return this.serverIP;
        }

        public String getName() {
            return this.serverName;
        }

        public int getPort() {
            return this.serverPort;
        }

        public void setIP(String string) {
            this.serverIP = string;
        }

        public void setName(String string) {
            this.serverName = ProviderMgr.normalizeName(string);
        }

        public void setPort(int n) {
            this.serverPort = n;
        }

        public String toString() {
            if (this.serverName != null) {
                return this.serverName + ":" + this.serverPort;
            }
            return this.serverIP + ":" + this.serverPort;
        }
    }

    static class Entry {
        private String zoneName;
        private int serverNum;
        private int responseTime;

        public Entry(String string, int n, int n2) {
            this.zoneName = string;
            this.serverNum = n;
            this.responseTime = n2;
        }

        public int getResponseTime() {
            return this.responseTime;
        }

        public void setResponseTime(int n) {
            this.responseTime = n;
        }

        public int getServerNum() {
            return this.serverNum;
        }

        public void setServerNum(int n) {
            this.serverNum = n;
        }

        public String getZoneName() {
            return this.zoneName;
        }

        public void setZoneName(String string) {
            this.zoneName = string;
        }
    }
}

