/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.apache.harmony.jndi.provider.dns.ProviderMgr;
import org.apache.harmony.jndi.provider.dns.QuestionRecord;
import org.apache.harmony.jndi.provider.dns.ResourceRecord;

class ResolverCache {
    HashMap<String, Vector<CacheEntry>> names = new HashMap();
    private static ResolverCache instance = null;

    private ResolverCache() {
    }

    static ResolverCache getInstance() {
        if (instance == null) {
            instance = new ResolverCache();
        }
        return instance;
    }

    synchronized Enumeration<ResourceRecord> get(QuestionRecord questionRecord) {
        String string = questionRecord.getQName().toLowerCase();
        Vector<CacheEntry> vector = this.names.get(string);
        int n = questionRecord.getQClass();
        int n2 = questionRecord.getQType();
        Vector<ResourceRecord> vector2 = new Vector<ResourceRecord>();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                CacheEntry cacheEntry = vector.elementAt(i);
                ResourceRecord resourceRecord = cacheEntry.getRR();
                if (cacheEntry.getBestBefore() < System.currentTimeMillis()) {
                    vector.removeElementAt(i--);
                    continue;
                }
                if (n == 255 || n != resourceRecord.getRRClass() || n2 == 255 || n2 != resourceRecord.getRRType()) continue;
                vector2.addElement(resourceRecord);
            }
        }
        return vector2.elements();
    }

    synchronized void put(ResourceRecord resourceRecord) {
        String string = resourceRecord.getName().toLowerCase();
        Vector<CacheEntry> vector = this.names.get(string);
        long l = System.currentTimeMillis();
        CacheEntry cacheEntry = null;
        if (vector == null) {
            vector = new Vector();
            this.names.put(string, vector);
        }
        if (resourceRecord.getTtl() >> 31 != 0L) {
            resourceRecord.setTtl(0L);
        }
        if (resourceRecord.getTtl() > 0L && resourceRecord.getName().indexOf(42) == -1) {
            cacheEntry = new CacheEntry(resourceRecord, l + resourceRecord.getTtl());
            for (int i = 0; i < vector.size(); ++i) {
                CacheEntry cacheEntry2 = vector.elementAt(i);
                ResourceRecord resourceRecord2 = cacheEntry2.rr;
                if (!ProviderMgr.namesAreEqual(resourceRecord.getName(), resourceRecord2.getName()) || resourceRecord.getRRClass() != resourceRecord2.getRRClass() || resourceRecord.getRRType() != resourceRecord2.getRRType() || resourceRecord.getRData() == null || resourceRecord2.getRData() == null || !resourceRecord.getRData().equals(resourceRecord2.getRData())) continue;
                vector.remove(i);
                break;
            }
            vector.addElement(cacheEntry);
        }
    }

    synchronized void clear() {
        this.names = new HashMap();
    }

    static class CacheEntry {
        private ResourceRecord rr;
        private long bestBefore;

        public CacheEntry(ResourceRecord resourceRecord, long l) {
            this.rr = resourceRecord;
            this.bestBefore = l;
        }

        public long getBestBefore() {
            return this.bestBefore;
        }

        public ResourceRecord getRR() {
            return this.rr;
        }
    }
}

