/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import java.util.StringTokenizer;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.dns.ProviderMgr;

public class DNSPseudoURL {
    private String host = "localhost";
    private int port = 53;
    private String domain = ".";
    private boolean hostIpWasGiven = false;

    public DNSPseudoURL(String string) throws IllegalArgumentException {
        StringTokenizer stringTokenizer = null;
        StringTokenizer stringTokenizer2 = null;
        if (string == null) {
            throw new NullPointerException(Messages.getString("jndi.67"));
        }
        stringTokenizer = new StringTokenizer(string, "/", true);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException(Messages.getString("jndi.68"));
        }
        String string2 = stringTokenizer.nextToken();
        if (!string2.equals("dns:")) {
            throw new IllegalArgumentException(Messages.getString("jndi.69"));
        }
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!string2.equals("/") || !stringTokenizer.hasMoreTokens()) {
                throw new IllegalArgumentException(Messages.getString("jndi.6A"));
            }
            string2 = stringTokenizer.nextToken();
            if (string2.equals("/")) {
                if (!stringTokenizer.hasMoreElements()) {
                    throw new IllegalArgumentException(Messages.getString("jndi.6A"));
                }
                string2 = stringTokenizer.nextToken();
                stringTokenizer2 = new StringTokenizer(string2, ":");
                this.host = stringTokenizer2.nextToken();
                try {
                    ProviderMgr.parseIpStr(this.host);
                    this.hostIpWasGiven = true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.hostIpWasGiven = false;
                }
                if (stringTokenizer2.hasMoreTokens()) {
                    this.port = Integer.parseInt(stringTokenizer2.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (!string2.equals("/") || !stringTokenizer.hasMoreTokens()) {
                        throw new IllegalArgumentException(Messages.getString("jndi.6A"));
                    }
                    this.domain = ProviderMgr.normalizeName(stringTokenizer.nextToken());
                }
            } else {
                this.domain = ProviderMgr.normalizeName(string2);
            }
            if (stringTokenizer.hasMoreTokens()) {
                throw new IllegalArgumentException(Messages.getString("jndi.66"));
            }
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isHostIpGiven() {
        return this.hostIpWasGiven;
    }

    public int getPort() {
        return this.port;
    }
}

