/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.internal.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.ldap.Rdn;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.internal.parser.AttributeTypeAndValuePair;
import org.apache.harmony.security.x509.DNParser;

public class RelaxedDnParser
extends DNParser {
    private static final char[] specialChars = new char[]{'!', '$', '%', '&', '\'', '(', ')', '*', '/', ':', '<', '=', '>', '?', '@', '[', ']', '^', '_', '`', '{', '|', '}', '~', '\"', '#', '+', ',', '\\', ';'};

    public RelaxedDnParser(String string) throws IOException {
        super(string);
    }

    protected String nextAT() throws IOException {
        int n = this.pos;
        try {
            while (this.chars[n] != '=') {
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException(Messages.getString("ldap.1C"));
        }
        for (int i = this.pos; i < n; ++i) {
            if (this.chars[i] == '\\') {
                throw new IOException(Messages.getString("ldap.1D"));
            }
            for (int j = 0; j < specialChars.length; ++j) {
                if (this.chars[i] != specialChars[j]) continue;
                throw new IOException(Messages.getString("ldap.1E"));
            }
        }
        return super.nextAT();
    }

    protected String hexAV() throws IOException {
        this.beg = this.pos++;
        while (true) {
            if (this.pos == this.length || this.chars[this.pos] == '+' || this.chars[this.pos] == ',' || this.chars[this.pos] == ';') {
                this.end = this.pos;
                break;
            }
            if (this.chars[this.pos] >= 'A' && this.chars[this.pos] <= 'F') {
                int n = this.pos;
                this.chars[n] = (char)(this.chars[n] + 32);
            }
            ++this.pos;
        }
        while (this.end > this.beg + 1 && this.chars[this.end - 1] == ' ') {
            --this.end;
        }
        int n = this.end - this.beg;
        this.encoded = new byte[n / 2];
        int n2 = this.beg + 1;
        for (int i = 0; i < this.encoded.length; ++i) {
            this.encoded[i] = (byte)this.getByte(n2);
            n2 += 2;
        }
        return new String(this.chars, this.beg, n);
    }

    public List parse() throws IOException {
        ArrayList arrayList = new ArrayList();
        String string = this.nextAT();
        ArrayList<AttributeTypeAndValuePair> arrayList2 = new ArrayList<AttributeTypeAndValuePair>();
        String string2 = new String(this.chars);
        while (true) {
            if (this.pos == this.length) {
                arrayList2.add(new AttributeTypeAndValuePair(string, ""));
                arrayList.add(0, arrayList2);
                return arrayList;
            }
            switch (this.chars[this.pos]) {
                case '\"': {
                    int n;
                    String string3 = this.quotedAV();
                    if (string3.length() > 0 && string3.charAt(string3.length() - 1) == ' ') {
                        for (n = this.pos - 1; n >= 0 && string2.charAt(n) == ' '; --n) {
                        }
                        if (n >= 3 && string2.substring(n - 3, n + 1).equals("\\20\"")) {
                            string3 = string3.substring(0, string3.length() - 1);
                        }
                    }
                    arrayList2.add(new AttributeTypeAndValuePair(string, string3));
                    break;
                }
                case '#': {
                    String string3 = this.hexAV();
                    arrayList2.add(new AttributeTypeAndValuePair(string, Rdn.unescapeValue(string3)));
                    break;
                }
                case '+': {
                    arrayList2.add(new AttributeTypeAndValuePair(string, ""));
                    break;
                }
                default: {
                    int n;
                    String string3 = this.escapedAV();
                    if (string3.length() > 0 && string3.charAt(string3.length() - 1) == ' ') {
                        for (n = this.pos - 1; n >= 0 && string2.charAt(n) == ' '; --n) {
                        }
                        if (n >= 2 && string2.substring(n - 2, n + 1).equals("\\20")) {
                            string3 = string3.substring(0, string3.length() - 1);
                        }
                    }
                    arrayList2.add(new AttributeTypeAndValuePair(string, string3));
                }
            }
            if (this.pos >= this.length) {
                arrayList.add(0, arrayList2);
                return arrayList;
            }
            if (this.chars[this.pos] == ',' || this.chars[this.pos] == ';') {
                throw new IOException(Messages.getString("ldap.1F"));
            }
            ++this.pos;
            string = this.nextAT();
        }
    }

    protected char getEscaped() throws IOException {
        ++this.pos;
        if (this.pos == this.length) {
            throw new IOException(Messages.getString("ldap.1F"));
        }
        switch (this.chars[this.pos]) {
            case '\"': {
                return this.chars[this.pos];
            }
            case '\\': {
                this.hasQE = true;
                return RelaxedDnParser.hexToUTF8(new String(this.chars, this.pos++, 2)).charValue();
            }
            case ' ': 
            case '#': 
            case '+': 
            case ',': 
            case ';': 
            case '<': 
            case '=': 
            case '>': {
                return this.chars[this.pos];
            }
        }
        return super.getUTF8();
    }

    public static Character hexToUTF8(String string) throws IOException {
        try {
            return new Character((char)Integer.parseInt(string, 16));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(Messages.getString("ldap.20"));
        }
    }
}

