/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.internal.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.naming.directory.BasicAttribute;
import javax.naming.ldap.Rdn;
import org.apache.harmony.jndi.internal.nls.Messages;

public class LdapTypeAndValueList
implements Map {
    private List list = null;
    private static final long serialVersionUID = -4540483835059087783L;
    private Map attributes = new TreeMap();

    @Override
    public int size() {
        return this.attributes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.attributes.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.attributes.containsValue(object);
    }

    public Object get(Object object) {
        return this.attributes.get(object);
    }

    public Object put(Object object, Object object2) {
        if (this.attributes.get(new ValueWrapper((String)object)) == null) {
            this.list = new ArrayList();
            this.list.add(new ValueWrapper(object2));
            this.attributes.put(new ValueWrapper((String)object), this.list);
        } else {
            this.list = (List)this.attributes.get(new ValueWrapper((String)object));
            this.list.add(new ValueWrapper(object2));
            Collections.sort(this.list);
            this.attributes.put(new ValueWrapper((String)object), this.list);
        }
        return this.list;
    }

    public Object remove(Object object) {
        return this.attributes.remove(object);
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException(Messages.getString("ldap.1B"));
    }

    @Override
    public void clear() {
        this.attributes.clear();
    }

    public Set keySet() {
        return this.attributes.keySet();
    }

    public List toAttributeList() {
        ArrayList<BasicAttribute> arrayList = new ArrayList<BasicAttribute>();
        for (ValueWrapper valueWrapper : this.keySet()) {
            BasicAttribute basicAttribute = new BasicAttribute(valueWrapper.getStringValue(), true);
            List list = (List)this.attributes.get(valueWrapper);
            for (ValueWrapper valueWrapper2 : list) {
                basicAttribute.add(valueWrapper2.getValue());
            }
            arrayList.add(basicAttribute);
        }
        return arrayList;
    }

    public Collection values() {
        throw new UnsupportedOperationException(Messages.getString("ldap.1B"));
    }

    public Set entrySet() {
        return this.attributes.entrySet();
    }

    public String toString() {
        return this.attributes.toString();
    }

    private class ValueWrapper
    implements Comparable {
        private Object value;

        ValueWrapper(Object object) {
            this.value = object;
        }

        public String getStringValue() {
            if (this.value instanceof String) {
                return (String)this.value;
            }
            return Rdn.escapeValue(this.value);
        }

        public Object getValue() {
            return this.value;
        }

        public int compareTo(Object object) {
            return this.getStringValue().toUpperCase().compareTo(((ValueWrapper)object).getStringValue().toUpperCase());
        }
    }
}

