/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.internal.parser;

import java.io.IOException;
import java.util.List;
import javax.naming.InvalidNameException;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.internal.parser.AttributeTypeAndValuePair;
import org.apache.harmony.jndi.internal.parser.LdapParser;
import org.apache.harmony.jndi.internal.parser.LdapTypeAndValueList;
import org.apache.harmony.jndi.internal.parser.RelaxedDnParser;

public class LdapRdnParser
implements LdapParser {
    private String name = null;
    LdapTypeAndValueList list = new LdapTypeAndValueList();
    private List<AttributeTypeAndValuePair> attrList;
    private List<AttributeTypeAndValuePair> listAll;
    private RelaxedDnParser parser = null;

    public LdapRdnParser(String string) {
        this.name = string.endsWith("+") ? string.substring(0, string.lastIndexOf(43)) : string;
    }

    @Override
    public List getList() throws InvalidNameException {
        try {
            this.checkTypeRestrictions(this.name);
            this.parser = new RelaxedDnParser(this.name);
            this.listAll = this.parser.parse();
        }
        catch (IOException iOException) {
            throw (InvalidNameException)new InvalidNameException(Messages.getString("ldap.17") + this.name).initCause(iOException);
        }
        this.attrList = (List)((Object)this.listAll.get(0));
        for (AttributeTypeAndValuePair attributeTypeAndValuePair : this.attrList) {
            this.list.put(attributeTypeAndValuePair.getType(), attributeTypeAndValuePair.getValue());
        }
        return this.list.toAttributeList();
    }

    private void checkTypeRestrictions(String string) throws InvalidNameException {
        int n = string.indexOf("=");
        try {
            if (string.substring(0, n).length() == 0) {
                throw new InvalidNameException(Messages.getString("ldap.18") + string);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new InvalidNameException(Messages.getString("ldap.17") + string);
        }
    }

    public static String escapeValue(Object object) {
        if (object instanceof String) {
            String string = String.valueOf(object);
            return LdapRdnParser.getEscaped(string.toCharArray());
        }
        if (object instanceof byte[]) {
            return LdapRdnParser.getHexValues((byte[])object);
        }
        throw new ClassCastException(Messages.getString("ldap.19"));
    }

    private static String getEscaped(char[] cArray) {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = 0;
        for (n2 = cArray.length - 1; n2 >= 0 && cArray[n2] == ' '; --n2) {
            ++n4;
        }
        for (n = 0; n <= n2 && cArray[n] == ' '; ++n) {
            ++n3;
            stringBuffer.append("\\ ");
        }
        for (n = n3; n < cArray.length - n4; ++n) {
            if (LdapRdnParser.isSpecialChar(cArray, n)) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(new Character(cArray[n]));
        }
        for (n = 0; n < n4; ++n) {
            stringBuffer.append("\\ ");
        }
        return stringBuffer.toString();
    }

    private static String getHexValues(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Integer.toHexString(byArray[i] >> 4 & 0xF));
            stringBuffer.append(Integer.toHexString(byArray[i] & 0xF));
        }
        return '#' + stringBuffer.toString();
    }

    public static Object unescapeValue(String string) {
        int n;
        if (string.startsWith("#") && LdapRdnParser.numeralCounter(string)) {
            return LdapRdnParser.getByteFromHexString(string);
        }
        if (string.startsWith("#")) {
            return LdapRdnParser.getByteFromHexString(string);
        }
        String string2 = string.trim();
        if (string2.length() > 0 && string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"') {
            string = string2.length() == 1 ? "" : string2.substring(1, string2.length() - 1);
        }
        boolean bl = false;
        for (n = string.length() - 1; n >= 0 && string.charAt(n) == ' '; --n) {
            bl = true;
        }
        char[] cArray = n >= 0 && string.charAt(n) == '\\' && bl ? (new String(string.trim()) + " ").toCharArray() : new String(string.trim()).toCharArray();
        return LdapRdnParser.getUnEscapedValues(cArray);
    }

    private static boolean numeralCounter(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '#') continue;
            ++n;
        }
        return n == 1;
    }

    private static String getUnEscapedValues(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            bl = false;
            if (cArray[i] != '\\') {
                stringBuffer.append(cArray[i]);
                continue;
            }
            try {
                if (cArray[i + 1] == ' ') continue;
                if (cArray[i + 1] == '\\') {
                    stringBuffer.append('\\');
                    ++i;
                    continue;
                }
                if (LdapRdnParser.isSpecialChar(cArray, i + 1) || LdapRdnParser.isSpecialChar(cArray, i + 2)) continue;
                try {
                    stringBuffer.append(RelaxedDnParser.hexToUTF8(new String(cArray, i + 1, 2)));
                    if (stringBuffer.charAt(stringBuffer.length() - 1) == ' ') {
                        bl = true;
                    }
                    i += 2;
                    continue;
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException(Messages.getString("ldap.1A"));
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                stringBuffer.append(cArray[i]);
            }
        }
        if (bl && stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == ' ') {
            stringBuffer = stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private static byte[] getByteFromHexString(String string) {
        String string2 = string.substring(string.indexOf("#") + 1);
        if (string2.length() % 2 != 0) {
            throw new IllegalArgumentException(Messages.getString("ldap.1A"));
        }
        byte[] byArray = null;
        try {
            byArray = new byte[string2.length() / 2];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)Integer.parseInt(string2.substring(2 * i, 2 * i + 2), 16);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(Messages.getString("ldap.17") + string);
        }
        return byArray;
    }

    private static boolean isSpecialChar(char[] cArray, int n) {
        switch (cArray[n]) {
            case '\"': 
            case '#': 
            case '+': 
            case ',': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '\\': {
                return true;
            }
        }
        return false;
    }
}

