/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import javax.naming.NamingException;
import javax.naming.ldap.BasicControl;
import org.apache.harmony.jndi.internal.JndiBerInputStream;
import org.apache.harmony.jndi.internal.SortResult;
import org.apache.harmony.jndi.internal.Util;
import org.apache.harmony.security.asn1.ASN1Enumerated;
import org.apache.harmony.security.asn1.ASN1Implicit;
import org.apache.harmony.security.asn1.ASN1OctetString;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;

public final class SortResponseControl
extends BasicControl {
    static ASN1Type ASN1_SORTRESPONSE = new ASN1Sequence(new ASN1Type[]{ASN1Enumerated.getInstance(), new ASN1Implicit(0, (ASN1Type)ASN1OctetString.getInstance())}){
        {
            this.setOptional(1);
        }

        public Object getDecodedObject(BerInputStream berInputStream) {
            Object[] objectArray = (Object[])berInputStream.content;
            int n = new BigInteger((byte[])objectArray[0]).intValue();
            String string = null;
            try {
                string = new String((byte[])objectArray[1], "UTF-8");
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return new SortResult(n, string);
        }
    };
    private static final long serialVersionUID = 5142939176006310877L;
    private int resultCode;
    private String badAttrId;
    private transient boolean sorted = false;
    public static final String OID = "1.2.840.113556.1.4.474";

    public SortResponseControl(String string, boolean bl, byte[] byArray) throws IOException {
        super(string, bl, byArray);
        SortResult sortResult = (SortResult)ASN1_SORTRESPONSE.decode((BerInputStream)new JndiBerInputStream(byArray));
        this.resultCode = sortResult.getSortresult();
        this.badAttrId = sortResult.getAttributeType();
        this.sorted = this.getResultCode() == 0;
    }

    public String getAttributeID() {
        return this.badAttrId;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public NamingException getException() {
        return Util.getExceptionFromErrorCode(this.getResultCode());
    }
}

