/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.ldap.Rdn;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.internal.parser.LdapNameParser;

public class LdapName
implements Name {
    private static final long serialVersionUID = -1595520034788997356L;
    private transient List<Rdn> rdns;
    private transient String rdnsStr;

    public LdapName(List<Rdn> list) {
        if (list == null) {
            throw new NullPointerException("rdns " + Messages.getString("ldap.00"));
        }
        this.rdns = new ArrayList<Rdn>(list);
    }

    public LdapName(String string) throws InvalidNameException {
        this.rdnsStr = string;
        LdapNameParser ldapNameParser = new LdapNameParser(this.rdnsStr);
        this.rdns = ldapNameParser.getList();
    }

    public Name add(int n, Rdn rdn) {
        if (rdn == null) {
            throw new NullPointerException("comp " + Messages.getString("ldap.00"));
        }
        if (n < 0 || n > this.rdns.size()) {
            throw new IndexOutOfBoundsException(Messages.getString("ldap.05"));
        }
        this.rdns.add(n, rdn);
        this.rdnsStr = null;
        return this;
    }

    @Override
    public Name add(int n, String string) throws InvalidNameException {
        return this.add(n, new Rdn(string));
    }

    public Name add(Rdn rdn) {
        return this.add(this.rdns.size(), rdn);
    }

    @Override
    public Name add(String string) throws InvalidNameException {
        return this.add(this.rdns.size(), string);
    }

    public Name addAll(int n, List<Rdn> list) {
        if (list == null) {
            throw new NullPointerException("suffixRdns " + Messages.getString("ldap.00"));
        }
        if (n < 0 || n > this.rdns.size()) {
            throw new IndexOutOfBoundsException(Messages.getString("ldap.00"));
        }
        this.rdns.addAll(n, list);
        this.rdnsStr = null;
        return this;
    }

    @Override
    public Name addAll(int n, Name name) throws InvalidNameException {
        if (name instanceof LdapName) {
            return this.addAll(n, ((LdapName)name).rdns);
        }
        ArrayList<Rdn> arrayList = new ArrayList<Rdn>();
        Enumeration<String> enumeration = name.getAll();
        while (enumeration.hasMoreElements()) {
            arrayList.add(new Rdn(enumeration.nextElement()));
        }
        return this.addAll(n, arrayList);
    }

    public Name addAll(List<Rdn> list) {
        return this.addAll(this.rdns.size(), list);
    }

    @Override
    public Name addAll(Name name) throws InvalidNameException {
        return this.addAll(this.rdns.size(), name);
    }

    @Override
    public Object clone() {
        try {
            if (this.rdnsStr != null) {
                return new LdapName(this.rdnsStr);
            }
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        ArrayList<Rdn> arrayList = new ArrayList<Rdn>();
        for (int i = 0; i < this.rdns.size(); ++i) {
            arrayList.add(this.rdns.get(i));
        }
        return new LdapName(arrayList);
    }

    @Override
    public int compareTo(Object object) {
        if (object == null || !(object instanceof LdapName)) {
            throw new ClassCastException("obj " + Messages.getString("ldap.01"));
        }
        LdapName ldapName = (LdapName)object;
        Iterator<Rdn> iterator = this.rdns.iterator();
        Iterator<Rdn> iterator2 = ldapName.rdns.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            int n = ((Object)iterator.next()).toString().toLowerCase().compareTo(((Object)iterator2.next()).toString().toLowerCase());
            if (n == 0) continue;
            return n;
        }
        if (iterator.hasNext()) {
            return 1;
        }
        if (iterator2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public boolean endsWith(List<Rdn> list) {
        try {
            Iterator<Rdn> iterator = list.iterator();
            Iterator<Rdn> iterator2 = ((LdapName)this.getSuffix((int)(this.rdns.size() - list.size()))).rdns.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().equals(iterator2.next())) continue;
                return false;
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    @Override
    public boolean endsWith(Name name) {
        try {
            return name.equals(this.getSuffix(this.rdns.size() - name.size()));
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof LdapName)) {
            return false;
        }
        LdapName ldapName = (LdapName)object;
        if (ldapName.rdns.size() != this.rdns.size()) {
            return false;
        }
        Iterator<Rdn> iterator = ldapName.rdns.iterator();
        Iterator<Rdn> iterator2 = this.rdns.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().equals(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String get(int n) {
        return this.getRdn(n).toString();
    }

    @Override
    public Enumeration<String> getAll() {
        final Iterator<Rdn> iterator = this.getRdns().iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public String nextElement() {
                return ((Rdn)iterator.next()).toString();
            }
        };
    }

    @Override
    public Name getPrefix(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException(Messages.getString("ldap.02"));
        }
        return new LdapName(this.rdns.subList(0, n));
    }

    public Rdn getRdn(int n) {
        return this.rdns.get(n);
    }

    public List<Rdn> getRdns() {
        return this.rdns;
    }

    @Override
    public Name getSuffix(int n) {
        if (n > this.rdns.size()) {
            throw new IndexOutOfBoundsException(Messages.getString("ldap.02"));
        }
        return new LdapName(this.rdns.subList(n, this.rdns.size()));
    }

    public int hashCode() {
        int n = 0;
        Iterator<Rdn> iterator = this.rdns.iterator();
        while (iterator.hasNext()) {
            n += ((Object)iterator.next()).hashCode();
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.rdns.size() == 0;
    }

    @Override
    public Object remove(int n) throws InvalidNameException {
        this.rdnsStr = null;
        return this.rdns.remove(n).toString();
    }

    @Override
    public int size() {
        return this.rdns.size();
    }

    public boolean startsWith(List<Rdn> list) {
        try {
            Iterator<Rdn> iterator = list.iterator();
            Iterator<Rdn> iterator2 = ((LdapName)this.getPrefix((int)list.size())).rdns.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().equals(iterator2.next())) continue;
                return false;
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    @Override
    public boolean startsWith(Name name) {
        try {
            return name.equals(this.getPrefix(name.size()));
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    public String toString() {
        if (this.rdnsStr != null) {
            return this.rdnsStr;
        }
        if (this.rdns.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.rdns.get(this.rdns.size() - 1).toString());
        for (int i = this.rdns.size() - 2; i >= 0; --i) {
            stringBuffer.append(',');
            stringBuffer.append(this.rdns.get(i).toString());
        }
        return stringBuffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, InvalidNameException {
        objectInputStream.defaultReadObject();
        LdapNameParser ldapNameParser = new LdapNameParser((String)objectInputStream.readObject());
        this.rdns = ldapNameParser.getList();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.toString());
    }
}

