/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import org.apache.harmony.jndi.internal.EnvironmentReader;
import org.apache.harmony.jndi.internal.nls.Messages;

public abstract class ControlFactory {
    protected ControlFactory() {
    }

    public abstract Control getControlInstance(Control var1) throws NamingException;

    public static Control getControlInstance(Control control, Context context, Hashtable<?, ?> hashtable) throws NamingException {
        String[] stringArray;
        for (String string : stringArray = EnvironmentReader.getFactoryNamesFromEnvironmentAndProviderResource(hashtable, context, "java.naming.factory.control")) {
            ControlFactory controlFactory = null;
            try {
                controlFactory = (ControlFactory)ControlFactory.classForName(string).newInstance();
            }
            catch (Exception exception) {
                continue;
            }
            Control control2 = controlFactory.getControlInstance(control);
            if (null == control2) continue;
            return control2;
        }
        return control;
    }

    private static Class<?> classForName(final String string) throws ClassNotFoundException {
        Class clazz = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        return Class.forName(string, true, ClassLoader.getSystemClassLoader());
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        return null;
                    }
                }
            }
        });
        if (clazz == null) {
            throw new ClassNotFoundException(Messages.getString("jndi.1C", string));
        }
        return clazz;
    }
}

