/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.DynamicMXBeanImpl;
import com.ibm.lang.management.ManagementUtils;
import java.lang.management.LockInfo;
import java.lang.management.ManagementPermission;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

public final class ThreadMXBeanImpl
extends DynamicMXBeanImpl
implements ThreadMXBean {
    private static ThreadMXBeanImpl instance = new ThreadMXBeanImpl();

    private ThreadMXBeanImpl() {
        this.setMBeanInfo(ManagementUtils.getMBeanInfo(ThreadMXBean.class.getName()));
    }

    static ThreadMXBeanImpl getInstance() {
        return instance;
    }

    private native long[] findMonitorDeadlockedThreadsImpl();

    public long[] findMonitorDeadlockedThreads() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new ManagementPermission("monitor"));
        }
        return this.findMonitorDeadlockedThreadsImpl();
    }

    private native long[] getAllThreadIdsImpl();

    public long[] getAllThreadIds() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new ManagementPermission("monitor"));
        }
        return this.getAllThreadIdsImpl();
    }

    public long getCurrentThreadCpuTime() {
        long result = -1L;
        if (this.isCurrentThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                result = this.getThreadCpuTimeImpl(Thread.currentThread().getId());
            }
        } else {
            throw new UnsupportedOperationException("CPU time measurement is not supported on this virtual machine.");
        }
        return result;
    }

    public long getCurrentThreadUserTime() {
        long result = -1L;
        if (this.isCurrentThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                result = this.getThreadUserTimeImpl(Thread.currentThread().getId());
            }
        } else {
            throw new UnsupportedOperationException("CPU time measurement is not supported on this virtual machine.");
        }
        return result;
    }

    private native int getDaemonThreadCountImpl();

    public int getDaemonThreadCount() {
        return this.getDaemonThreadCountImpl();
    }

    private native int getPeakThreadCountImpl();

    public int getPeakThreadCount() {
        return this.getPeakThreadCountImpl();
    }

    private native int getThreadCountImpl();

    public int getThreadCount() {
        return this.getThreadCountImpl();
    }

    private native long getThreadCpuTimeImpl(long var1);

    public long getThreadCpuTime(long id) {
        if (id <= 0L) {
            throw new IllegalArgumentException("Thread id must be greater than 0.");
        }
        long result = -1L;
        if (this.isThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                result = this.getThreadCpuTimeImpl(id);
            }
        } else {
            throw new UnsupportedOperationException("CPU time measurement is not supported on this virtual machine.");
        }
        return result;
    }

    public ThreadInfo getThreadInfo(long id) {
        return this.getThreadInfo(id, 0);
    }

    public ThreadInfo[] getThreadInfo(long[] ids) {
        return this.getThreadInfo(ids, 0);
    }

    public ThreadInfo[] getThreadInfo(long[] ids, int maxDepth) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new ManagementPermission("monitor"));
        }
        int i = 0;
        while (i < ids.length) {
            if (ids[i] <= 0L) {
                throw new IllegalArgumentException("Thread id must be greater than 0.");
            }
            ++i;
        }
        if (maxDepth < 0) {
            throw new IllegalArgumentException("maxDepth value cannot be negative.");
        }
        return this.getMultiThreadInfoImpl(ids, maxDepth, false, false);
    }

    public ThreadInfo[] getThreadInfo(long[] ids, boolean lockedMonitors, boolean lockedSynchronizers) {
        if (lockedMonitors && !this.isObjectMonitorUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of object monitors is not supported on this virtual machine");
        }
        if (lockedSynchronizers && !this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of ownable synchronizer usage is not supported on this virtual machine");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new ManagementPermission("monitor"));
        }
        int i = 0;
        while (i < ids.length) {
            if (ids[i] <= 0L) {
                throw new IllegalArgumentException("Thread id must be greater than 0.");
            }
            ++i;
        }
        return this.getMultiThreadInfoImpl(ids, Integer.MAX_VALUE, lockedMonitors, lockedSynchronizers);
    }

    public ThreadInfo getThreadInfo(long id, int maxDepth) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new ManagementPermission("monitor"));
        }
        if (id <= 0L) {
            throw new IllegalArgumentException("Thread id must be greater than 0.");
        }
        if (maxDepth < 0) {
            throw new IllegalArgumentException("maxDepth value cannot be negative.");
        }
        return this.getThreadInfoImpl(id, maxDepth);
    }

    private native Thread getThreadByIdImpl(long var1);

    private native ThreadInfo getThreadInfoImpl(long var1, int var3);

    private native LockInfo[] getLockedSynchronizers(long var1);

    private native MonitorInfo[] getLockedMonitors(long var1);

    private native long getThreadUserTimeImpl(long var1);

    public long getThreadUserTime(long id) {
        if (id <= 0L) {
            throw new IllegalArgumentException("Thread id must be greater than 0.");
        }
        long result = -1L;
        if (this.isThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                result = this.getThreadUserTimeImpl(id);
            }
        } else {
            throw new UnsupportedOperationException("CPU time measurement is not supported on this virtual machine.");
        }
        return result;
    }

    private native long getTotalStartedThreadCountImpl();

    public long getTotalStartedThreadCount() {
        return this.getTotalStartedThreadCountImpl();
    }

    private native boolean isCurrentThreadCpuTimeSupportedImpl();

    public boolean isCurrentThreadCpuTimeSupported() {
        return this.isCurrentThreadCpuTimeSupportedImpl();
    }

    private native boolean isThreadContentionMonitoringEnabledImpl();

    public boolean isThreadContentionMonitoringEnabled() {
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException("Thread contention monitoring is not supported on this virtual machine.");
        }
        return this.isThreadContentionMonitoringEnabledImpl();
    }

    private native boolean isThreadContentionMonitoringSupportedImpl();

    public boolean isThreadContentionMonitoringSupported() {
        return this.isThreadContentionMonitoringSupportedImpl();
    }

    private native boolean isThreadCpuTimeEnabledImpl();

    public boolean isThreadCpuTimeEnabled() {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU timing is not supported on this virtual machine.");
        }
        return this.isThreadCpuTimeEnabledImpl();
    }

    private native boolean isThreadCpuTimeSupportedImpl();

    public boolean isThreadCpuTimeSupported() {
        return this.isThreadCpuTimeSupportedImpl();
    }

    private native void resetPeakThreadCountImpl();

    public void resetPeakThreadCount() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new ManagementPermission("control"));
        }
        this.resetPeakThreadCountImpl();
    }

    private native void setThreadContentionMonitoringEnabledImpl(boolean var1);

    public void setThreadContentionMonitoringEnabled(boolean enable) {
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException("Thread contention monitoring is not supported on this virtual machine.");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new ManagementPermission("control"));
        }
        this.setThreadContentionMonitoringEnabledImpl(enable);
    }

    private native void setThreadCpuTimeEnabledImpl(boolean var1);

    public void setThreadCpuTimeEnabled(boolean enable) {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU timing is not supported on this virtual machine.");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new ManagementPermission("control"));
        }
        this.setThreadCpuTimeEnabledImpl(enable);
    }

    public boolean isObjectMonitorUsageSupported() {
        return this.isObjectMonitorUsageSupportedImpl();
    }

    private native boolean isObjectMonitorUsageSupportedImpl();

    public boolean isSynchronizerUsageSupported() {
        return this.isSynchronizerUsageSupportedImpl();
    }

    private native boolean isSynchronizerUsageSupportedImpl();

    public long[] findDeadlockedThreads() {
        if (!this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of ownable synchronizer usage is not supported on this virtual machine");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new ManagementPermission("monitor"));
        }
        return this.findDeadlockedThreadsImpl();
    }

    private native long[] findDeadlockedThreadsImpl();

    public ThreadInfo[] dumpAllThreads(boolean lockedMonitors, boolean lockedSynchronizers) {
        if (lockedMonitors && !this.isObjectMonitorUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of object monitors is not supported on this virtual machine");
        }
        if (lockedSynchronizers && !this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of ownable synchronizer usage is not supported on this virtual machine");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new ManagementPermission("monitor"));
        }
        return this.dumpAllThreadsImpl(lockedMonitors, lockedSynchronizers);
    }

    private native ThreadInfo[] dumpAllThreadsImpl(boolean var1, boolean var2);

    private native ThreadInfo[] getMultiThreadInfoImpl(long[] var1, int var2, boolean var3, boolean var4);
}

