/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.DynamicMXBeanImpl;
import com.ibm.lang.management.ManagementUtils;
import com.ibm.oti.vm.VM;
import java.lang.management.ManagementPermission;
import java.lang.management.RuntimeMXBean;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RuntimeMXBeanImpl
extends DynamicMXBeanImpl
implements RuntimeMXBean {
    private static RuntimeMXBeanImpl instance = new RuntimeMXBeanImpl();

    private RuntimeMXBeanImpl() {
        this.setMBeanInfo(ManagementUtils.getMBeanInfo(RuntimeMXBean.class.getName()));
    }

    static RuntimeMXBeanImpl getInstance() {
        return instance;
    }

    @Override
    public String getBootClassPath() {
        if (!this.isBootClassPathSupported()) {
            throw new UnsupportedOperationException("VM does not support boot classpath.");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new ManagementPermission("monitor"));
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("sun.boot.class.path");
            }
        });
    }

    @Override
    public String getClassPath() {
        return System.getProperty("java.class.path");
    }

    @Override
    public String getLibraryPath() {
        return System.getProperty("java.library.path");
    }

    @Override
    public String getManagementSpecVersion() {
        return "1.0";
    }

    private native String getNameImpl();

    @Override
    public String getName() {
        return this.getNameImpl();
    }

    @Override
    public String getSpecName() {
        return System.getProperty("java.vm.specification.name");
    }

    @Override
    public String getSpecVendor() {
        return System.getProperty("java.vm.specification.vendor");
    }

    @Override
    public String getSpecVersion() {
        return System.getProperty("java.vm.specification.version");
    }

    private native long getStartTimeImpl();

    @Override
    public long getStartTime() {
        return this.getStartTimeImpl();
    }

    private native long getUptimeImpl();

    @Override
    public long getUptime() {
        return this.getUptimeImpl();
    }

    @Override
    public String getVmName() {
        return System.getProperty("java.vm.name");
    }

    @Override
    public String getVmVendor() {
        return System.getProperty("java.vm.vendor");
    }

    @Override
    public String getVmVersion() {
        return System.getProperty("java.vm.version");
    }

    private native boolean isBootClassPathSupportedImpl();

    @Override
    public boolean isBootClassPathSupported() {
        return this.isBootClassPathSupportedImpl();
    }

    @Override
    public List<String> getInputArguments() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new ManagementPermission("monitor"));
        }
        return ManagementUtils.convertStringArrayToList(VM.getVMArgs());
    }

    @Override
    public Map<String, String> getSystemProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        Properties props = System.getProperties();
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            String propValue = props.getProperty(propName);
            result.put(propName, propValue);
        }
        return result;
    }
}

