/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.enc;

import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import javax.xml.crypto.enc.XMLEncryptionException;

final class XMLEncSecurity {
    private static String XML_ENCRYPTION_FACTORY = "XMLEncryptionFactory";
    static /* synthetic */ Class class$javax$xml$crypto$enc$XMLEncryptionFactory;

    private XMLEncSecurity() {
    }

    private static ProviderProperty getEngineClassName(String mechType, String engineType) throws XMLEncryptionException {
        Provider[] provs = Security.getProviders();
        boolean found = false;
        ProviderProperty entry = null;
        for (int i = 0; i < provs.length && !found; ++i) {
            try {
                entry = XMLEncSecurity.getEngineClassName(mechType, engineType, provs[i]);
                found = true;
                continue;
            }
            catch (XMLEncryptionException xse) {
                // empty catch block
            }
        }
        if (!found) {
            throw new XMLEncryptionException("Mechanism type " + mechType + " not available");
        }
        return entry;
    }

    private static ProviderProperty getEngineClassName(String mechType, String engineType, Provider provider) throws XMLEncryptionException {
        String key = engineType + "." + mechType;
        String className = XMLEncSecurity.getProviderProperty(key, provider);
        if (className == null) {
            String stdName = XMLEncSecurity.getStandardName(mechType, engineType, provider);
            if (stdName != null) {
                key = engineType + "." + stdName;
            }
            if (stdName == null || (className = XMLEncSecurity.getProviderProperty(key, provider)) == null) {
                throw new XMLEncryptionException("no such mechanism type: " + mechType + " for provider " + provider.getName());
            }
        }
        ProviderProperty entry = new ProviderProperty();
        entry.className = className;
        entry.provider = provider;
        return entry;
    }

    private static boolean checkSuperclass(Class subclass, Class superclass) {
        while (!subclass.equals(superclass)) {
            if ((subclass = subclass.getSuperclass()) != null) continue;
            return false;
        }
        return true;
    }

    static Object[] getImpl(String mechType, String type, Provider provider) throws XMLEncryptionException {
        if (provider == null) {
            return XMLEncSecurity.doGetImpl(mechType, type, XMLEncSecurity.getEngineClassName(mechType, type));
        }
        return XMLEncSecurity.doGetImpl(mechType, type, XMLEncSecurity.getEngineClassName(mechType, type, provider));
    }

    private static Object[] doGetImpl(String mechType, String type, ProviderProperty pp) throws XMLEncryptionException {
        String className = pp.className;
        String providerName = pp.provider.getName();
        Class typeClass = null;
        if (type.equals("XMLEncryptionFactory")) {
            typeClass = class$javax$xml$crypto$enc$XMLEncryptionFactory == null ? (class$javax$xml$crypto$enc$XMLEncryptionFactory = XMLEncSecurity.class$("javax.xml.crypto.enc.XMLEncryptionFactory")) : class$javax$xml$crypto$enc$XMLEncryptionFactory;
        }
        try {
            ClassLoader cl = pp.provider.getClass().getClassLoader();
            Class<?> implClass = cl != null ? cl.loadClass(className) : Class.forName(className);
            if (XMLEncSecurity.checkSuperclass(implClass, typeClass)) {
                return new Object[]{implClass.newInstance(), pp.provider};
            }
            throw new XMLEncryptionException("class configured for " + type + ": " + className + " not a " + type);
        }
        catch (ClassNotFoundException e) {
            throw new XMLEncryptionException("class configured for " + type + "(provider: " + providerName + ")" + "cannot be found.\n", e);
        }
        catch (InstantiationException e) {
            throw new XMLEncryptionException("class " + className + " configured for " + type + "(provider: " + providerName + ") cannot be " + "instantiated. ", e);
        }
        catch (IllegalAccessException e) {
            throw new XMLEncryptionException("class " + className + " configured for " + type + "(provider: " + providerName + ") cannot be accessed.\n", e);
        }
        catch (SecurityException e) {
            throw new XMLEncryptionException("class " + className + " configured for " + type + "(provider: " + providerName + ") cannot be accessed.\n", e);
        }
    }

    private static String getProviderProperty(String key, Provider prov) {
        String prop = prov.getProperty(key);
        if (prop != null) {
            return prop;
        }
        Enumeration<Object> e = prov.keys();
        while (e.hasMoreElements()) {
            String matchKey = (String)e.nextElement();
            if (!key.equalsIgnoreCase(matchKey)) continue;
            return prov.getProperty(matchKey);
        }
        return null;
    }

    private static String getStandardName(String alias, String engineType, Provider prov) {
        return XMLEncSecurity.getProviderProperty("Alg.Alias." + engineType + "." + alias, prov);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ProviderProperty {
        String className;
        Provider provider;

        private ProviderProperty() {
        }
    }
}

