/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeListenerProxy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;

public class VetoableChangeSupport
implements Serializable {
    private static final long serialVersionUID = -5090210921595982017L;
    private Hashtable<String, VetoableChangeSupport> children = new Hashtable();
    private transient ArrayList<VetoableChangeListener> globalListeners = new ArrayList();
    private Object source;
    private int vetoableChangeSupportSerializedDataVersion = 2;

    public VetoableChangeSupport(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.source = object;
    }

    public synchronized void removeVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        VetoableChangeSupport vetoableChangeSupport;
        if (string != null && vetoableChangeListener != null && (vetoableChangeSupport = this.children.get(string)) != null) {
            vetoableChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public synchronized void addVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        if (string != null && vetoableChangeListener != null) {
            VetoableChangeSupport vetoableChangeSupport = this.children.get(string);
            if (vetoableChangeSupport == null) {
                vetoableChangeSupport = new VetoableChangeSupport(this.source);
                this.children.put(string, vetoableChangeSupport);
            }
            vetoableChangeSupport.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    public synchronized VetoableChangeListener[] getVetoableChangeListeners(String string) {
        VetoableChangeSupport vetoableChangeSupport = null;
        if (string != null) {
            vetoableChangeSupport = this.children.get(string);
        }
        return vetoableChangeSupport == null ? new VetoableChangeListener[]{} : VetoableChangeSupport.getAsVetoableChangeListenerArray(vetoableChangeSupport);
    }

    public synchronized boolean hasListeners(String string) {
        VetoableChangeSupport vetoableChangeSupport;
        boolean bl;
        boolean bl2 = bl = this.globalListeners.size() > 0;
        if (!bl && string != null && (vetoableChangeSupport = this.children.get(string)) != null) {
            bl = vetoableChangeSupport.globalListeners.size() > 0;
        }
        return bl;
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener != null) {
            this.globalListeners.remove(vetoableChangeListener);
        }
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener != null) {
            if (vetoableChangeListener instanceof VetoableChangeListenerProxy) {
                VetoableChangeListenerProxy vetoableChangeListenerProxy = (VetoableChangeListenerProxy)vetoableChangeListener;
                this.addVetoableChangeListener(vetoableChangeListenerProxy.getPropertyName(), (VetoableChangeListener)vetoableChangeListenerProxy.getListener());
            } else {
                this.globalListeners.add(vetoableChangeListener);
            }
        }
    }

    public synchronized VetoableChangeListener[] getVetoableChangeListeners() {
        ArrayList<VetoableChangeListener> arrayList = new ArrayList<VetoableChangeListener>();
        if (this.globalListeners != null) {
            arrayList.addAll(this.globalListeners);
        }
        for (String string : this.children.keySet()) {
            VetoableChangeSupport vetoableChangeSupport = this.children.get(string);
            VetoableChangeListener[] vetoableChangeListenerArray = vetoableChangeSupport.getVetoableChangeListeners();
            for (int i = 0; i < vetoableChangeListenerArray.length; ++i) {
                arrayList.add(new VetoableChangeListenerProxy(string, vetoableChangeListenerArray[i]));
            }
        }
        return arrayList.toArray(new VetoableChangeListener[arrayList.size()]);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        VetoableChangeListener[] vetoableChangeListenerArray = new VetoableChangeListener[this.globalListeners.size()];
        this.globalListeners.toArray(vetoableChangeListenerArray);
        for (VetoableChangeListener vetoableChangeListener : vetoableChangeListenerArray) {
            if (!(vetoableChangeListener instanceof Serializable)) continue;
            objectOutputStream.writeObject(vetoableChangeListener);
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        this.globalListeners = new ArrayList();
        if (null == this.children) {
            this.children = new Hashtable();
        }
        do {
            object = objectInputStream.readObject();
            this.addVetoableChangeListener((VetoableChangeListener)object);
        } while (object != null);
    }

    public void fireVetoableChange(String string, boolean bl, boolean bl2) throws PropertyVetoException {
        PropertyChangeEvent propertyChangeEvent = this.createPropertyChangeEvent(string, bl, bl2);
        this.doFirePropertyChange(propertyChangeEvent);
    }

    public void fireVetoableChange(String string, int n, int n2) throws PropertyVetoException {
        PropertyChangeEvent propertyChangeEvent = this.createPropertyChangeEvent(string, n, n2);
        this.doFirePropertyChange(propertyChangeEvent);
    }

    public void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        PropertyChangeEvent propertyChangeEvent = this.createPropertyChangeEvent(string, object, object2);
        this.doFirePropertyChange(propertyChangeEvent);
    }

    public void fireVetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        this.doFirePropertyChange(propertyChangeEvent);
    }

    private PropertyChangeEvent createPropertyChangeEvent(String string, Object object, Object object2) {
        return new PropertyChangeEvent(this.source, string, object, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFirePropertyChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        if (object2 != null && object != null && object2.equals(object)) {
            return;
        }
        VetoableChangeSupport vetoableChangeSupport = null;
        VetoableChangeListener[] vetoableChangeListenerArray = this;
        synchronized (this) {
            VetoableChangeListener[] vetoableChangeListenerArray2 = this.globalListeners.toArray(new VetoableChangeListener[0]);
            Object object3 = propertyChangeEvent.getPropertyName();
            if (object3 != null) {
                vetoableChangeSupport = this.children.get(object3);
            }
            // ** MonitorExit[var7_6] (shouldn't be in output)
            try {
                for (VetoableChangeListener vetoableChangeListener : vetoableChangeListenerArray2) {
                    vetoableChangeListener.vetoableChange(propertyChangeEvent);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                object3 = super.createPropertyChangeEvent(string, object2, object);
                for (VetoableChangeListener vetoableChangeListener : vetoableChangeListenerArray2) {
                    try {
                        vetoableChangeListener.vetoableChange((PropertyChangeEvent)object3);
                    }
                    catch (PropertyVetoException propertyVetoException2) {
                        // empty catch block
                    }
                }
                throw propertyVetoException;
            }
            if (vetoableChangeSupport != null) {
                vetoableChangeSupport.fireVetoableChange(propertyChangeEvent);
            }
            return;
        }
    }

    private static VetoableChangeListener[] getAsVetoableChangeListenerArray(VetoableChangeSupport vetoableChangeSupport) {
        return vetoableChangeSupport.globalListeners.toArray(new VetoableChangeListener[0]);
    }
}

