/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;

public class PropertyChangeSupport
implements Serializable {
    private static final long serialVersionUID = 6401253773779951803L;
    private transient List<PropertyChangeListener> globalListeners = new ArrayList<PropertyChangeListener>();
    private Hashtable<String, PropertyChangeSupport> children = new Hashtable();
    private Object source;
    private int propertyChangeSupportSerializedDataVersion = 1;

    public PropertyChangeSupport(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.source = object;
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeEvent propertyChangeEvent = this.createPropertyChangeEvent(string, object, object2);
        this.doFirePropertyChange(propertyChangeEvent);
    }

    public void fireIndexedPropertyChange(String string, int n, Object object, Object object2) {
        this.doFirePropertyChange(new IndexedPropertyChangeEvent(this.source, string, object, object2, n));
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport;
        if (string != null && propertyChangeListener != null && (propertyChangeSupport = this.children.get(string)) != null) {
            propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null && string != null) {
            PropertyChangeSupport propertyChangeSupport = this.children.get(string);
            if (propertyChangeSupport == null) {
                propertyChangeSupport = new PropertyChangeSupport(this.source);
                this.children.put(string, propertyChangeSupport);
            }
            if (propertyChangeListener instanceof PropertyChangeListenerProxy) {
                PropertyChangeListenerProxy propertyChangeListenerProxy = (PropertyChangeListenerProxy)propertyChangeListener;
                propertyChangeSupport.addPropertyChangeListener(new PropertyChangeListenerProxy(propertyChangeListenerProxy.getPropertyName(), (PropertyChangeListener)propertyChangeListenerProxy.getListener()));
            } else {
                propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
            }
        }
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        PropertyChangeSupport propertyChangeSupport = null;
        if (string != null) {
            propertyChangeSupport = this.children.get(string);
        }
        return propertyChangeSupport == null ? new PropertyChangeListener[]{} : propertyChangeSupport.getPropertyChangeListeners();
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        PropertyChangeEvent propertyChangeEvent = this.createPropertyChangeEvent(string, bl, bl2);
        this.doFirePropertyChange(propertyChangeEvent);
    }

    public void fireIndexedPropertyChange(String string, int n, boolean bl, boolean bl2) {
        if (bl != bl2) {
            this.fireIndexedPropertyChange(string, n, (Object)bl, (Object)bl2);
        }
    }

    public void firePropertyChange(String string, int n, int n2) {
        PropertyChangeEvent propertyChangeEvent = this.createPropertyChangeEvent(string, n, n2);
        this.doFirePropertyChange(propertyChangeEvent);
    }

    public void fireIndexedPropertyChange(String string, int n, int n2, int n3) {
        if (n2 != n3) {
            this.fireIndexedPropertyChange(string, n, new Integer(n2), new Integer(n3));
        }
    }

    public synchronized boolean hasListeners(String string) {
        if (this.globalListeners.size() > 0) {
            return true;
        }
        boolean bl = false;
        if (string != null) {
            PropertyChangeSupport propertyChangeSupport = this.children.get(string);
            bl = propertyChangeSupport != null && propertyChangeSupport.hasListeners(string);
        }
        return bl;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener instanceof PropertyChangeListenerProxy) {
            String string = ((PropertyChangeListenerProxy)propertyChangeListener).getPropertyName();
            PropertyChangeListener propertyChangeListener2 = (PropertyChangeListener)((PropertyChangeListenerProxy)propertyChangeListener).getListener();
            this.removePropertyChangeListener(string, propertyChangeListener2);
        } else {
            this.globalListeners.remove(propertyChangeListener);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener instanceof PropertyChangeListenerProxy) {
            String string = ((PropertyChangeListenerProxy)propertyChangeListener).getPropertyName();
            PropertyChangeListener propertyChangeListener2 = (PropertyChangeListener)((PropertyChangeListenerProxy)propertyChangeListener).getListener();
            this.addPropertyChangeListener(string, propertyChangeListener2);
        } else if (propertyChangeListener != null) {
            this.globalListeners.add(propertyChangeListener);
        }
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        ArrayList<PropertyChangeListener> arrayList = new ArrayList<PropertyChangeListener>(this.globalListeners);
        for (String string : this.children.keySet()) {
            PropertyChangeSupport propertyChangeSupport = this.children.get(string);
            PropertyChangeListener[] propertyChangeListenerArray = propertyChangeSupport.getPropertyChangeListeners();
            for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
                arrayList.add(new PropertyChangeListenerProxy(string, propertyChangeListenerArray[i]));
            }
        }
        return arrayList.toArray(new PropertyChangeListener[0]);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        PropertyChangeListener[] propertyChangeListenerArray = this.globalListeners.toArray(new PropertyChangeListener[0]);
        for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
            if (!(propertyChangeListenerArray[i] instanceof Serializable)) continue;
            objectOutputStream.writeObject(propertyChangeListenerArray[i]);
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.globalListeners = new LinkedList<PropertyChangeListener>();
        if (null == this.children) {
            this.children = new Hashtable();
        }
        Object object = null;
        do {
            if ((object = objectInputStream.readObject()) == null) continue;
            this.addPropertyChangeListener((PropertyChangeListener)object);
        } while (object != null);
    }

    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.doFirePropertyChange(propertyChangeEvent);
    }

    private PropertyChangeEvent createPropertyChangeEvent(String string, Object object, Object object2) {
        return new PropertyChangeEvent(this.source, string, object, object2);
    }

    private PropertyChangeEvent createPropertyChangeEvent(String string, boolean bl, boolean bl2) {
        return new PropertyChangeEvent(this.source, string, bl, bl2);
    }

    private PropertyChangeEvent createPropertyChangeEvent(String string, int n, int n2) {
        return new PropertyChangeEvent(this.source, string, n, n2);
    }

    private void doFirePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        PropertyChangeSupport propertyChangeSupport;
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        if (object != null && object2 != null && object.equals(object2)) {
            return;
        }
        PropertyChangeListener[] propertyChangeListenerArray = this.globalListeners.toArray(new PropertyChangeListener[0]);
        for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
            propertyChangeListenerArray[i].propertyChange(propertyChangeEvent);
        }
        if (propertyChangeEvent.getPropertyName() != null && (propertyChangeSupport = this.children.get(propertyChangeEvent.getPropertyName())) != null) {
            propertyChangeSupport.firePropertyChange(propertyChangeEvent);
        }
    }
}

