/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.TooManyListenersException;
import org.apache.harmony.beans.internal.nls.Messages;

public class EventSetDescriptor
extends FeatureDescriptor {
    private Class<?> listenerType;
    private ArrayList<MethodDescriptor> listenerMethodDescriptors;
    private Method[] listenerMethods;
    private Method getListenerMethod;
    private Method addListenerMethod;
    private Method removeListenerMethod;
    private boolean unicast;
    private boolean inDefaultEventSet = true;

    public EventSetDescriptor(Class<?> clazz, String string, Class<?> clazz2, String string2) throws IntrospectionException {
        this.checkNotNull(clazz, string, clazz2, string2);
        this.setName(string);
        this.listenerType = clazz2;
        Method method = this.findListenerMethodByName(string2);
        EventSetDescriptor.checkEventType(string, method);
        this.listenerMethodDescriptors = new ArrayList();
        this.listenerMethodDescriptors.add(new MethodDescriptor(method));
        this.addListenerMethod = this.findMethodByPrefix(clazz, "add", "");
        this.removeListenerMethod = this.findMethodByPrefix(clazz, "remove", "");
        if (this.addListenerMethod == null || this.removeListenerMethod == null) {
            throw new IntrospectionException(Messages.getString("beans.38"));
        }
        this.getListenerMethod = this.findMethodByPrefix(clazz, "get", "s");
        this.unicast = EventSetDescriptor.isUnicastByDefault(this.addListenerMethod);
    }

    public EventSetDescriptor(Class<?> clazz, String string, Class<?> clazz2, String[] stringArray, String string2, String string3) throws IntrospectionException {
        this(clazz, string, clazz2, stringArray, string2, string3, null);
    }

    public EventSetDescriptor(Class<?> clazz, String string, Class<?> clazz2, String[] stringArray, String string2, String string3, String string4) throws IntrospectionException {
        this.checkNotNull(clazz, string, clazz2, stringArray);
        this.setName(string);
        this.listenerType = clazz2;
        this.listenerMethodDescriptors = new ArrayList();
        for (String string5 : stringArray) {
            Method method = this.findListenerMethodByName(string5);
            this.listenerMethodDescriptors.add(new MethodDescriptor(method));
        }
        if (string2 != null) {
            this.addListenerMethod = this.findAddRemoveListenerMethod(clazz, string2);
        }
        if (string3 != null) {
            this.removeListenerMethod = this.findAddRemoveListenerMethod(clazz, string3);
        }
        if (string4 != null) {
            this.getListenerMethod = this.findGetListenerMethod(clazz, string4);
        }
        this.unicast = EventSetDescriptor.isUnicastByDefault(this.addListenerMethod);
    }

    private Method findListenerMethodByName(String string) throws IntrospectionException {
        Method[] methodArray;
        Method method = null;
        for (Method method2 : methodArray = this.listenerType.getMethods()) {
            Class<?>[] classArray;
            if (!string.equals(method2.getName()) || (classArray = method2.getParameterTypes()).length != 1 || !classArray[0].getName().endsWith("Event")) continue;
            method = method2;
            break;
        }
        if (null == method) {
            throw new IntrospectionException(Messages.getString("beans.31", string, this.listenerType.getName()));
        }
        return method;
    }

    public EventSetDescriptor(String string, Class<?> clazz, Method[] methodArray, Method method, Method method2) throws IntrospectionException {
        this(string, clazz, methodArray, method, method2, null);
    }

    public EventSetDescriptor(String string, Class<?> clazz, Method[] methodArray, Method method, Method method2, Method method3) throws IntrospectionException {
        this.setName(string);
        this.listenerType = clazz;
        this.listenerMethods = methodArray;
        if (methodArray != null) {
            this.listenerMethodDescriptors = new ArrayList();
            for (Method method4 : methodArray) {
                this.listenerMethodDescriptors.add(new MethodDescriptor(method4));
            }
        }
        this.addListenerMethod = method;
        this.removeListenerMethod = method2;
        this.getListenerMethod = method3;
        this.unicast = EventSetDescriptor.isUnicastByDefault(method);
    }

    public EventSetDescriptor(String string, Class<?> clazz, MethodDescriptor[] methodDescriptorArray, Method method, Method method2) throws IntrospectionException {
        this(string, clazz, null, method, method2, null);
        if (methodDescriptorArray != null) {
            this.listenerMethodDescriptors = new ArrayList();
            for (MethodDescriptor methodDescriptor : methodDescriptorArray) {
                methodDescriptor.getMethod();
                this.listenerMethodDescriptors.add(methodDescriptor);
            }
        }
    }

    private void checkNotNull(Object object, Object object2, Object object3, Object object4) {
        if (object == null) {
            throw new NullPointerException(Messages.getString("beans.0C"));
        }
        if (object2 == null) {
            throw new NullPointerException(Messages.getString("beans.53"));
        }
        if (object3 == null) {
            throw new NullPointerException(Messages.getString("beans.54"));
        }
        if (object4 == null) {
            throw new NullPointerException(Messages.getString("beans.52"));
        }
    }

    private static void checkEventType(String string, Method method) throws IntrospectionException {
        Class<?>[] classArray = method.getParameterTypes();
        String string2 = null;
        String string3 = EventSetDescriptor.prepareEventTypeName(string);
        if (classArray.length > 0) {
            string2 = EventSetDescriptor.extractShortClassName(classArray[0].getName());
        }
        if (string2 == null || !string2.equals(string3)) {
            throw new IntrospectionException(Messages.getString("beans.51", method.getName(), string3));
        }
    }

    private static String extractShortClassName(String string) {
        int n = string.lastIndexOf(36);
        n = n == -1 ? string.lastIndexOf(46) : n;
        return string.substring(n + 1);
    }

    private static String prepareEventTypeName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null && string.length() > 0) {
            stringBuilder.append(Character.toUpperCase(string.charAt(0)));
            if (string.length() > 1) {
                stringBuilder.append(string.substring(1));
            }
        }
        stringBuilder.append("Event");
        return stringBuilder.toString();
    }

    public Method[] getListenerMethods() {
        int n = 0;
        if (this.listenerMethods != null) {
            return this.listenerMethods;
        }
        if (this.listenerMethodDescriptors != null) {
            this.listenerMethods = new Method[this.listenerMethodDescriptors.size()];
            for (MethodDescriptor methodDescriptor : this.listenerMethodDescriptors) {
                this.listenerMethods[n++] = methodDescriptor.getMethod();
            }
            return this.listenerMethods;
        }
        return null;
    }

    public MethodDescriptor[] getListenerMethodDescriptors() {
        return this.listenerMethodDescriptors == null ? null : this.listenerMethodDescriptors.toArray(new MethodDescriptor[this.listenerMethodDescriptors.size()]);
    }

    public Method getRemoveListenerMethod() {
        return this.removeListenerMethod;
    }

    public Method getGetListenerMethod() {
        return this.getListenerMethod;
    }

    public Method getAddListenerMethod() {
        return this.addListenerMethod;
    }

    public Class<?> getListenerType() {
        return this.listenerType;
    }

    public void setUnicast(boolean bl) {
        this.unicast = bl;
    }

    public void setInDefaultEventSet(boolean bl) {
        this.inDefaultEventSet = bl;
    }

    public boolean isUnicast() {
        return this.unicast;
    }

    public boolean isInDefaultEventSet() {
        return this.inDefaultEventSet;
    }

    private Method findAddRemoveListenerMethod(Class<?> clazz, String string) throws IntrospectionException {
        try {
            return clazz.getMethod(string, this.listenerType);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.findAddRemoveListnerMethodWithLessCheck(clazz, string);
        }
        catch (Exception exception) {
            throw new IntrospectionException(Messages.getString("beans.31", string, this.listenerType.getName()));
        }
    }

    private Method findAddRemoveListnerMethodWithLessCheck(Class<?> clazz, String string) throws IntrospectionException {
        Method[] methodArray;
        String string2 = this.listenerType.getName();
        string2 = string2.substring(string2.lastIndexOf(".") + 1);
        Method method = null;
        for (Method method2 : methodArray = clazz.getMethods()) {
            Class<?>[] classArray;
            if (!method2.getName().equals(string) || (classArray = method2.getParameterTypes()).length != 1) continue;
            method = method2;
            break;
        }
        if (null == method) {
            throw new IntrospectionException(Messages.getString("beans.31", string, this.listenerType.getName()));
        }
        return method;
    }

    private Method findGetListenerMethod(Class<?> clazz, String string) {
        try {
            return clazz.getMethod(string, new Class[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Method findMethodByPrefix(Class<?> clazz, String string, String string2) {
        String string3 = this.listenerType.getName();
        if (this.listenerType.getPackage() != null) {
            string3 = string3.substring(this.listenerType.getPackage().getName().length() + 1);
        }
        String string4 = string + string3 + string2;
        try {
            if (string.equals("get")) {
                return clazz.getMethod(string4, new Class[0]);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Class<?>[] classArray;
            if (!methodArray[i].getName().equals(string4) || (classArray = methodArray[i].getParameterTypes()).length != 1) continue;
            return methodArray[i];
        }
        return null;
    }

    private static boolean isUnicastByDefault(Method method) {
        if (method != null) {
            Class<?>[] classArray;
            for (Class<?> clazz : classArray = method.getExceptionTypes()) {
                if (!clazz.equals(TooManyListenersException.class)) continue;
                return true;
            }
        }
        return false;
    }

    void merge(EventSetDescriptor eventSetDescriptor) {
        super.merge(eventSetDescriptor);
        if (this.addListenerMethod == null) {
            this.addListenerMethod = eventSetDescriptor.addListenerMethod;
        }
        if (this.getListenerMethod == null) {
            this.getListenerMethod = eventSetDescriptor.getListenerMethod;
        }
        if (this.listenerMethodDescriptors == null) {
            this.listenerMethodDescriptors = eventSetDescriptor.listenerMethodDescriptors;
        }
        if (this.listenerMethods == null) {
            this.listenerMethods = eventSetDescriptor.listenerMethods;
        }
        if (this.listenerType == null) {
            this.listenerType = eventSetDescriptor.listenerType;
        }
        if (this.removeListenerMethod == null) {
            this.removeListenerMethod = eventSetDescriptor.removeListenerMethod;
        }
        this.inDefaultEventSet &= eventSetDescriptor.inDefaultEventSet;
    }
}

