/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.BeanInfo;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PersistenceDelegate;
import java.beans.PropertyDescriptor;
import java.beans.Statement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;

public class DefaultPersistenceDelegate
extends PersistenceDelegate {
    private static String[] EMPTY_PROPERTIES = new String[0];
    private String[] propertyNames = EMPTY_PROPERTIES;

    public DefaultPersistenceDelegate() {
    }

    public DefaultPersistenceDelegate(String[] stringArray) {
        if (null != stringArray) {
            this.propertyNames = stringArray;
        }
    }

    @Override
    protected void initialize(Class<?> clazz, Object object, Object object2, Encoder encoder) {
        super.initialize(clazz, object, object2, encoder);
        if (clazz != object.getClass()) {
            return;
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            encoder.getExceptionListener().exceptionThrown(introspectionException);
            return;
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            if (Boolean.TRUE.equals(propertyDescriptorArray[i].getValue("transient")) || null == propertyDescriptorArray[i].getWriteMethod() || null == propertyDescriptorArray[i].getReadMethod()) continue;
            Expression expression = new Expression(object, propertyDescriptorArray[i].getReadMethod().getName(), null);
            try {
                Object object3;
                Object object4 = expression.getValue();
                encoder.writeExpression(expression);
                Object object5 = encoder.get(object4);
                Object object6 = new Expression(object2, propertyDescriptorArray[i].getReadMethod().getName(), null).getValue();
                if (null == object5) {
                    if (null == object6) continue;
                    object3 = new Statement(object, propertyDescriptorArray[i].getWriteMethod().getName(), new Object[]{null});
                    encoder.writeStatement((Statement)object3);
                    continue;
                }
                object3 = encoder.getPersistenceDelegate(object5.getClass());
                if (((PersistenceDelegate)object3).mutatesTo(object5, object6)) continue;
                Statement statement = new Statement(object, propertyDescriptorArray[i].getWriteMethod().getName(), new Object[]{object4});
                encoder.writeStatement(statement);
                continue;
            }
            catch (Exception exception) {
                encoder.getExceptionListener().exceptionThrown(exception);
            }
        }
    }

    private Object getFieldValue(Object object, String string) throws NoSuchFieldException, IllegalAccessException {
        Class<?> clazz = object.getClass();
        final Field field = clazz.getDeclaredField(string);
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                field.setAccessible(true);
                return null;
            }
        });
        return field.get(object);
    }

    private Object getPropertyValue(HashMap<String, PropertyDescriptor> hashMap, Object object, String string) throws Exception {
        PropertyDescriptor propertyDescriptor;
        Method method = null;
        if (null != hashMap && null != (propertyDescriptor = hashMap.get(Introspector.decapitalize(string)))) {
            method = propertyDescriptor.getReadMethod();
        }
        if (null != method) {
            return method.invoke(object, (Object[])null);
        }
        try {
            return this.getFieldValue(object, string);
        }
        catch (Exception exception) {
            throw new NoSuchMethodException("The getter method for the property " + string + " can't be found.");
        }
    }

    @Override
    protected Expression instantiate(Object object, Encoder encoder) {
        Object[] objectArray = null;
        if (this.propertyNames.length > 0) {
            BeanInfo beanInfo = null;
            HashMap<String, PropertyDescriptor> hashMap = null;
            try {
                beanInfo = Introspector.getBeanInfo(object.getClass(), 3);
                hashMap = DefaultPersistenceDelegate.internalAsMap(beanInfo.getPropertyDescriptors());
            }
            catch (IntrospectionException introspectionException) {
                encoder.getExceptionListener().exceptionThrown(introspectionException);
                throw new Error(introspectionException);
            }
            objectArray = new Object[this.propertyNames.length];
            for (int i = 0; i < this.propertyNames.length; ++i) {
                String string = this.propertyNames[i];
                if (null == string || 0 == string.length()) continue;
                try {
                    objectArray[i] = this.getPropertyValue(hashMap, object, this.propertyNames[i]);
                    continue;
                }
                catch (Exception exception) {
                    encoder.getExceptionListener().exceptionThrown(exception);
                }
            }
        }
        return new Expression(object, object.getClass(), "new", objectArray);
    }

    private static HashMap<String, PropertyDescriptor> internalAsMap(PropertyDescriptor[] propertyDescriptorArray) {
        HashMap<String, PropertyDescriptor> hashMap = new HashMap<String, PropertyDescriptor>();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            hashMap.put(propertyDescriptorArray[i].getName(), propertyDescriptorArray[i]);
        }
        return hashMap;
    }

    @Override
    protected boolean mutatesTo(Object object, Object object2) {
        if (null == object || null == object2) {
            return false;
        }
        Class<?> clazz = object.getClass();
        if (this.propertyNames.length > 0) {
            Method method = null;
            try {
                method = clazz.getDeclaredMethod("equals", Object.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (null != method) {
                return object.equals(object2);
            }
        }
        return super.mutatesTo(object, object2);
    }
}

