/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Array;
import org.apache.harmony.beans.internal.nls.Messages;

class CustomizedObjectInputStream
extends ObjectInputStream {
    private ClassLoader cls;

    public CustomizedObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException {
        super(inputStream);
        this.cls = classLoader;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        if (string.startsWith("[")) {
            int n = string.lastIndexOf("[");
            String string2 = string.substring(0, n + 1);
            int[] nArray = new int[string2.length()];
            Class<Comparable<Boolean>> clazz = null;
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = 0;
            }
            String string3 = string.substring(n + 1);
            if (string3.equals("Z")) {
                clazz = Boolean.TYPE;
            } else if (string3.equals("B")) {
                clazz = Byte.TYPE;
            } else if (string3.equals("C")) {
                clazz = Character.TYPE;
            } else if (string3.equals("D")) {
                clazz = Double.TYPE;
            } else if (string3.equals("F")) {
                clazz = Float.TYPE;
            } else if (string3.equals("I")) {
                clazz = Integer.TYPE;
            } else if (string3.equals("L")) {
                clazz = Long.TYPE;
            } else if (string3.equals("S")) {
                clazz = Short.TYPE;
            } else if (!string3.equals("V")) {
                if (string3.startsWith("L")) {
                    clazz = this.cls.loadClass(string3.substring(1, string3.length() - 1));
                } else {
                    throw new IllegalArgumentException(Messages.getString("beans.1E", string));
                }
            }
            return Array.newInstance(clazz, nArray).getClass();
        }
        return Class.forName(string, true, this.cls);
    }
}

