/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom.transform;

import com.ibm.xml.crypto.dsig.Constants;
import com.ibm.xml.crypto.dsig.dom.DOMUtil;
import com.ibm.xml.crypto.dsig.dom.Marshalling;
import com.ibm.xml.crypto.dsig.dom.Unmarshalling;
import com.ibm.xml.crypto.dsig.dom.transform.BinaryData;
import com.ibm.xml.crypto.dsig.dom.transform.C14nTransformer;
import com.ibm.xml.crypto.dsig.dom.transform.C14nUtil;
import com.ibm.xml.crypto.dsig.dom.transform.TransformBase;
import com.ibm.xml.crypto.dsig.dom.transform.TransformUtil;
import com.ibm.xml.crypto.dsig.dom.transform.TreeNodeSetData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.InvalidAlgorithmParameterException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.spec.ExcC14NParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExcC14nTransformer
extends TransformBase
implements CanonicalizationMethod,
Constants {
    static final boolean DEBUG = false;
    protected boolean withComments = false;
    private List prefixList = null;

    public void init(TransformParameterSpec spec) throws InvalidAlgorithmParameterException {
        if (spec == null) {
            this.spec = null;
            this.prefixList = null;
            return;
        }
        if (!(spec instanceof ExcC14NParameterSpec)) {
            throw new InvalidAlgorithmParameterException("ExcC14NParameterSpec is expected: " + spec.getClass().getName());
        }
        this.spec = spec;
        ExcC14NParameterSpec ecspec = (ExcC14NParameterSpec)spec;
        this.prefixList = ecspec.getPrefixList();
        if (this.prefixList.isEmpty()) {
            this.prefixList = null;
        }
        Iterator<String> iter = ecspec.getPrefixList().iterator();
        while (iter.hasNext()) {
            String o = iter.next();
            if (!(o instanceof String)) {
                throw new InvalidAlgorithmParameterException("PrefixList has non-String member: " + o);
            }
            if ("#default".equals(o) || this.checkPrefix(o)) continue;
            throw new InvalidAlgorithmParameterException("Invalid prefix: " + o);
        }
    }

    private boolean checkPrefix(String prefix) {
        return true;
    }

    public void marshalParams(XMLStructure parent, XMLCryptoContext xcontext) throws MarshalException {
        if (parent == null) {
            throw new NullPointerException("XMLStructure must not be null.");
        }
        if (this.spec == null) {
            return;
        }
        Element el = (Element)((DOMStructure)parent).getNode();
        Document factory = el.getOwnerDocument();
        ExcC14NParameterSpec cspec = (ExcC14NParameterSpec)this.spec;
        Iterator<String> iter = cspec.getPrefixList().iterator();
        StringBuffer buffer = new StringBuffer();
        while (iter.hasNext()) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(iter.next());
        }
        Element incl = Marshalling.createElement((DOMCryptoContext)xcontext, factory, "http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces", true);
        incl.setAttributeNS(null, "PrefixList", new String(buffer));
        el.appendChild(incl);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(XMLStructure parent, XMLCryptoContext xcontext) throws InvalidAlgorithmParameterException {
        if (parent == null) {
            throw new NullPointerException("XMLStructure must not be null.");
        }
        Element el = (Element)((DOMStructure)parent).getNode();
        Node param = null;
        Node child = DOMUtil.getFirstChild2(el);
        while (child != null) {
            if (!Unmarshalling.isIgnorableNode2(child)) {
                if (child.getNodeType() != 1) throw new InvalidAlgorithmParameterException("Exc-c14n does not support specified node: " + child.getNodeName());
                if (param != null) throw new InvalidAlgorithmParameterException("Exc-c14n does not support specified parameter element: " + child.getNodeName());
                param = child;
            }
            child = DOMUtil.getNextSibling2(child);
        }
        ExcC14NParameterSpec spec = null;
        if (param != null) {
            void var8_11;
            void var8_8;
            Object var8_7 = null;
            if (!"http://www.w3.org/2001/10/xml-exc-c14n#".equals(param.getNamespaceURI()) || !"InclusiveNamespaces".equals(param.getLocalName())) {
                throw new InvalidAlgorithmParameterException("The parameter must be {http://www.w3.org/2001/10/xml-exc-c14n#, InclusiveNamesapces}: " + param.getNodeName());
            }
            String value = Unmarshalling.getAttributeValue(param, "PrefixList");
            if (value != null) {
                StringTokenizer tokenizer = new StringTokenizer(value, " \r\n\t");
                while (tokenizer.hasMoreTokens()) {
                    String p = tokenizer.nextToken();
                    if ("#default".equals(p)) {
                        p = "#default";
                    }
                    if (var8_8 == null) {
                        LinkedList linkedList = new LinkedList();
                    }
                    var8_8.add(p);
                }
            }
            if (var8_8 == null) {
                LinkedList linkedList = new LinkedList();
            }
            spec = new ExcC14NParameterSpec((List<String>)var8_11);
        }
        this.init(spec);
    }

    public Data transform(Data in, XMLCryptoContext xcontext) throws TransformException {
        ByteArrayOutputStream baos;
        if (in == null) {
            throw new NullPointerException("The Data parameter is null.");
        }
        try {
            NodeSetData nodeSet = this.toNodeSet(in, xcontext);
            baos = new ByteArrayOutputStream();
            OutputStreamWriter wr = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            if (nodeSet instanceof TreeNodeSetData) {
                TreeNodeSetData tree = (TreeNodeSetData)nodeSet;
                ExcC14nTransformer.serializeNode(this.prefixList, tree.getTopNode(), tree.getOmittedNode(), tree.isWithComments() && this.withComments, wr);
            } else {
                ExcC14nTransformer.serializeSubset(this.prefixList, new C14nUtil.NodeListImpl(nodeSet.iterator()), this.withComments, wr);
            }
            ((Writer)wr).close();
            baos.close();
        }
        catch (Exception e) {
            throw new TransformException(e);
        }
        return new BinaryData(baos.toByteArray());
    }

    public static void serializeSubset(List prefixList, NodeList nodeList, boolean withComments, Writer wr) throws IOException, XMLSignatureException {
        Vector<Object> nodeVector = new Vector<Object>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 2) {
                Node attr;
                nodeVector.addElement(node);
                if (node.getNodeType() != 1) continue;
                Hashtable<String, Node> attributes = new Hashtable<String, Node>();
                if (i + 1 < nodeList.getLength() && (attr = nodeList.item(i + 1)).getNodeType() == 2 && ((Attr)attr).getOwnerElement() == node) {
                    ++i;
                    while (i < nodeList.getLength() && (node2 = nodeList.item(i)).getNodeType() == 2 && node == ((Attr)node2).getOwnerElement()) {
                        attributes.put(node2.getNodeName(), node2);
                        ++i;
                    }
                    if (attributes.containsKey("xmlns") && ((Attr)attributes.get("xmlns")).getNodeValue().length() == 0) {
                        attributes.remove("xmlns");
                    }
                    --i;
                }
                nodeVector.addElement(new C14nUtil.Attributes(node, attributes));
                continue;
            }
            Element owner = ((Attr)node).getOwnerElement();
            Hashtable<String, Node> attributes = new Hashtable<String, Node>();
            while (i < nodeList.getLength() && (node2 = nodeList.item(i)).getNodeType() == 2 && owner == ((Attr)node2).getOwnerElement()) {
                attributes.put(node2.getNodeName(), node2);
                ++i;
            }
            nodeVector.addElement(new C14nUtil.Attributes(owner, attributes));
            --i;
        }
        Stack stack = new Stack();
        for (int i = 0; i < nodeVector.size(); ++i) {
            ExcC14nTransformer.serializeSubset(stack, prefixList, nodeVector, i, withComments, wr);
        }
    }

    private static void serializeSubset(Stack stack, List prefixList, Vector nodeVector, int i, boolean withComments, Writer wr) throws IOException, XMLSignatureException {
        Node parent;
        Object obj = nodeVector.elementAt(i);
        if (obj == null) {
            return;
        }
        if (obj instanceof C14nUtil.Attributes) {
            nodeVector.setElementAt(null, i);
            ((C14nUtil.Attributes)obj).serialize(null, prefixList, null, wr);
            return;
        }
        Node node = (Node)obj;
        short type = node.getNodeType();
        if (type == 9) {
            return;
        }
        if (type != 1) {
            C14nTransformer.serializeNode(null, node, null, withComments, true, wr);
            return;
        }
        wr.write("<");
        wr.write(node.getNodeName());
        C14nUtil.Attributes ancestorAttrs = stack.empty() ? null : (C14nUtil.Attributes)stack.peek();
        C14nUtil.Attributes attrs = null;
        int next = i + 1;
        boolean printXmlns = prefixList == null || !prefixList.contains("#default") ? node.getPrefix() == null : true;
        if (next >= nodeVector.size() || nodeVector.elementAt(next) instanceof Node) {
            parent = node.getParentNode();
            if (printXmlns && parent.getNodeType() != 9 && ancestorAttrs != null && ancestorAttrs.contains("xmlns")) {
                wr.write(" xmlns=\"\"");
            }
        } else {
            String prefix;
            attrs = (C14nUtil.Attributes)nodeVector.elementAt(next);
            if (!attrs.contains("xmlns")) {
                parent = node.getParentNode();
                if (printXmlns && parent.getNodeType() != 9 && ancestorAttrs != null && ancestorAttrs.contains("xmlns")) {
                    wr.write(" xmlns=\"\"");
                }
            }
            if ((prefix = node.getPrefix()) == null) {
                prefix = "";
            }
            attrs.serialize(stack, prefixList, prefix, wr);
            nodeVector.setElementAt(null, next);
        }
        wr.write(">");
        stack.push(attrs);
        while (next < nodeVector.size()) {
            if (nodeVector.elementAt(next) == null) {
                ++next;
                continue;
            }
            if (!C14nUtil.isAncestor(nodeVector.elementAt(next), node)) break;
            ExcC14nTransformer.serializeSubset(stack, prefixList, nodeVector, next, withComments, wr);
            nodeVector.setElementAt(null, next++);
        }
        stack.pop();
        wr.write("</");
        wr.write(node.getNodeName());
        wr.write(">");
    }

    public static final void serializeNode(List prefixList, Node node, Node exceptedNode, boolean comments, Writer wr) throws IOException, XMLSignatureException {
        Map initialDecls = TransformUtil.initializeDecls(node.getParentNode());
        ExcC14nTransformer.serializeNode(prefixList, node, exceptedNode, comments, initialDecls, null, wr);
        wr.flush();
    }

    private static final void serializeElement(List prefixList, Node node, Node exceptedNode, boolean comments, Map decls, Map rendered, Writer wr) throws IOException, XMLSignatureException {
        String min;
        String parentPrefix;
        Map currentDecls = TransformUtil.putDecls(decls, node);
        HashMap<String, String> rendering = rendered == null ? new HashMap<String, String>() : null;
        wr.write("<");
        wr.write(node.getNodeName());
        String prefix = node.getPrefix();
        NamedNodeMap attrs = node.getAttributes();
        int nattrs = attrs.getLength();
        if (nattrs == 0 && rendered != null && node.getParentNode() != null && ((parentPrefix = node.getParentNode().getPrefix()) == null && prefix == null || parentPrefix != null && prefix != null && parentPrefix.equals(prefix))) {
            wr.write(">");
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                ExcC14nTransformer.serializeNode(prefixList, child, exceptedNode, comments, currentDecls, rendering == null ? rendered : rendering, wr);
            }
            wr.write("</");
            wr.write(node.getNodeName());
            wr.write(">");
            return;
        }
        if ((prefixList != null && prefixList.contains("#default") || prefix == null) && !currentDecls.containsKey("xmlns") && rendered != null && rendered.containsKey("xmlns") && !rendered.get("xmlns").equals("")) {
            wr.write(" xmlns=\"\"");
            if (rendering == null) {
                rendering = rendered == null ? new HashMap() : new HashMap(rendered);
            }
            rendering.put("xmlns", "");
        }
        do {
            min = null;
            Iterator iter = currentDecls.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                boolean inPrefixList = false;
                if (rendering == null && rendered.containsKey(key) && rendered.get(key).equals(currentDecls.get(key)) || rendering != null && rendering.containsKey(key) && rendering.get(key).equals(currentDecls.get(key))) continue;
                if (prefixList != null) {
                    prefix = key.equals("xmlns") ? "#default" : key.substring(6);
                    inPrefixList = prefixList.contains(prefix);
                }
                if (!inPrefixList && !ExcC14nTransformer.isVisiblyUtilized(key, node)) continue;
                if (min == null) {
                    min = key;
                    continue;
                }
                if (min.compareTo(key) <= 0) continue;
                min = key;
            }
            if (min == null) continue;
            String v = (String)currentDecls.get(min);
            C14nUtil.serializeAttribute(min, v, wr, true);
            if (rendering == null) {
                rendering = rendered == null ? new HashMap() : new HashMap(rendered);
            }
            rendering.put(min, v);
        } while (min != null);
        if (nattrs == 1) {
            Node a = attrs.item(0);
            String name = a.getNodeName();
            if (!name.equals("xmlns") && !name.startsWith("xmlns:")) {
                C14nUtil.serializeAttribute(a, wr, false);
            }
        } else if (nattrs > 1) {
            int i;
            Node[] array = new Node[nattrs];
            int n = 0;
            for (i = 0; i < nattrs; ++i) {
                Node a = attrs.item(i);
                String name = a.getNodeName();
                if (name.equals("xmlns") || name.startsWith("xmlns:")) continue;
                array[n++] = a;
            }
            for (i = 0; i < n - 1; ++i) {
                Node base = array[i];
                for (int j = i + 1; j < n; ++j) {
                    int comp;
                    Node n2 = array[j];
                    String basens = base.getNamespaceURI();
                    String n2ns = n2.getNamespaceURI();
                    if (basens == null) {
                        basens = "";
                    }
                    if (n2ns == null) {
                        n2ns = "";
                    }
                    if ((comp = basens.compareTo(n2ns)) == 0) {
                        String bln = base.getLocalName();
                        String nln = n2.getLocalName();
                        if (bln == null) {
                            bln = base.getNodeName();
                        }
                        if (nln == null) {
                            nln = n2.getNodeName();
                        }
                        comp = bln.compareTo(nln);
                    }
                    if (comp <= 0) continue;
                    array[j] = base;
                    base = n2;
                    array[i] = n2;
                }
            }
            for (i = 0; i < n; ++i) {
                C14nUtil.serializeAttribute(array[i], wr, false);
            }
        }
        wr.write(">");
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            ExcC14nTransformer.serializeNode(prefixList, child, exceptedNode, comments, currentDecls, rendering == null ? rendered : rendering, wr);
        }
        wr.write("</");
        wr.write(node.getNodeName());
        wr.write(">");
    }

    private static final void serializeNode(List prefixList, Node node, Node exceptedNode, boolean comments, Map decls, Map rendered, Writer wr) throws IOException, XMLSignatureException {
        if (exceptedNode == node) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                ExcC14nTransformer.serializeElement(prefixList, node, exceptedNode, comments, decls, rendered, wr);
                break;
            }
            case 3: 
            case 4: {
                C14nUtil.serializeText(node.getNodeValue(), wr);
                break;
            }
            case 5: 
            case 9: {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    ExcC14nTransformer.serializeNode(prefixList, child, exceptedNode, comments, decls, rendered, wr);
                }
                break;
            }
            case 7: {
                C14nUtil.serializePI(node, wr);
                break;
            }
            case 8: {
                if (!comments) break;
                C14nUtil.serializeComment(node, wr);
                break;
            }
            case 10: {
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                throw new RuntimeException("Internal Error: Invalid Node Type: " + node.getNodeType());
            }
        }
    }

    private static final boolean isVisiblyUtilized(String key, Node el) {
        if (key.equals("xmlns")) {
            return el.getPrefix() == null;
        }
        String prefix = key.substring(6);
        if (prefix.equals(el.getPrefix())) {
            return true;
        }
        NamedNodeMap map = el.getAttributes();
        int len = map.getLength();
        for (int i = 0; i < len; ++i) {
            if (!prefix.equals(map.item(i).getPrefix())) continue;
            return true;
        }
        return false;
    }
}

