/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom.transform;

import com.ibm.xml.crypto.dsig.dom.transform.BinaryData;
import com.ibm.xml.crypto.dsig.dom.transform.C14nUtil;
import com.ibm.xml.crypto.dsig.dom.transform.TransformBase;
import com.ibm.xml.crypto.dsig.dom.transform.TransformUtil;
import com.ibm.xml.crypto.dsig.dom.transform.TreeNodeSetData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.xml.crypto.Data;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class C14nTransformer
extends TransformBase
implements CanonicalizationMethod {
    protected boolean withComments = false;

    public Data transform(Data in, XMLCryptoContext xcontext) throws TransformException {
        ByteArrayOutputStream baos;
        if (in == null) {
            throw new NullPointerException("The Data parameter is null.");
        }
        try {
            NodeSetData nodeSet = this.toNodeSet(in, xcontext);
            baos = new ByteArrayOutputStream();
            OutputStreamWriter wr = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            if (nodeSet instanceof TreeNodeSetData) {
                TreeNodeSetData tree = (TreeNodeSetData)nodeSet;
                C14nTransformer.serializeNode(tree.getTopNode(), tree.getTopNode(), tree.getOmittedNode(), tree.isWithComments() && this.withComments, true, wr);
            } else {
                C14nTransformer.serializeSubset(new C14nUtil.NodeListImpl(nodeSet.iterator()), this.withComments, wr);
            }
            ((Writer)wr).close();
            baos.close();
        }
        catch (Exception e) {
            throw new TransformException(e);
        }
        return new BinaryData(baos.toByteArray());
    }

    private static boolean inNodeList(Node node, NodeList list) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i) != node) continue;
            return true;
        }
        return false;
    }

    static void serializeSubset(NodeList nodeList, boolean withComments, Writer wr) throws IOException, XMLSignatureException {
        Vector<Object> nodeVector = new Vector<Object>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 2) {
                Node attr;
                nodeVector.addElement(node);
                if (node.getNodeType() != 1) continue;
                Hashtable<String, Node> attributes = null;
                if (!C14nTransformer.inNodeList(node.getParentNode(), nodeList)) {
                    attributes = C14nTransformer.collectXMLPrefixAttributesInAncestors(node);
                }
                if (i + 1 < nodeList.getLength() && (attr = nodeList.item(i + 1)).getNodeType() == 2 && ((Attr)attr).getOwnerElement() == node) {
                    if (attributes == null) {
                        attributes = new Hashtable<String, Node>();
                    }
                    ++i;
                    while (i < nodeList.getLength() && (node2 = nodeList.item(i)).getNodeType() == 2 && node == ((Attr)node2).getOwnerElement()) {
                        attributes.put(node2.getNodeName(), node2);
                        ++i;
                    }
                    if (attributes.containsKey("xmlns") && ((Attr)attributes.get("xmlns")).getNodeValue().length() == 0) {
                        attributes.remove("xmlns");
                    }
                    --i;
                    nodeVector.addElement(new C14nUtil.Attributes(node, attributes));
                    continue;
                }
                if (attributes == null) continue;
                nodeVector.addElement(new C14nUtil.Attributes(node, attributes));
                continue;
            }
            Element owner = ((Attr)node).getOwnerElement();
            Hashtable<String, Node> attributes = new Hashtable<String, Node>();
            while (i < nodeList.getLength() && (node2 = nodeList.item(i)).getNodeType() == 2 && owner == ((Attr)node2).getOwnerElement()) {
                attributes.put(node2.getNodeName(), node2);
                ++i;
            }
            nodeVector.addElement(new C14nUtil.Attributes(owner, attributes));
            --i;
        }
        Stack stack = new Stack();
        for (int i = 0; i < nodeVector.size(); ++i) {
            C14nTransformer.serializeSubset(stack, nodeVector, i, withComments, wr);
        }
    }

    private static void serializeSubset(Stack stack, Vector nodeVector, int i, boolean withComments, Writer wr) throws IOException, XMLSignatureException {
        Node parent;
        Object obj = nodeVector.elementAt(i);
        if (obj == null) {
            return;
        }
        if (obj instanceof C14nUtil.Attributes) {
            C14nUtil.Attributes ancestorAttrs = stack.empty() ? null : (C14nUtil.Attributes)stack.peek();
            ((C14nUtil.Attributes)obj).serialize(ancestorAttrs, wr);
            nodeVector.setElementAt(null, i);
            return;
        }
        Node node = (Node)obj;
        short type = node.getNodeType();
        if (type == 9) {
            return;
        }
        if (type != 1) {
            C14nTransformer.serializeNode(null, node, null, withComments, true, wr);
            return;
        }
        wr.write("<");
        wr.write(node.getNodeName());
        C14nUtil.Attributes ancestorAttrs = stack.empty() ? null : (C14nUtil.Attributes)stack.peek();
        C14nUtil.Attributes attrs = null;
        int next = i + 1;
        if (next >= nodeVector.size() || nodeVector.elementAt(next) instanceof Node) {
            parent = node.getParentNode();
            if (parent.getNodeType() != 9 && ancestorAttrs != null && ancestorAttrs.contains("xmlns")) {
                wr.write(" xmlns=\"\"");
            }
        } else {
            attrs = (C14nUtil.Attributes)nodeVector.elementAt(next);
            if (!attrs.contains("xmlns") && (parent = node.getParentNode()).getNodeType() != 9 && ancestorAttrs != null && ancestorAttrs.contains("xmlns")) {
                wr.write(" xmlns=\"\"");
            }
            attrs.serialize(ancestorAttrs, wr);
            nodeVector.setElementAt(null, next);
        }
        wr.write(">");
        stack.push(attrs);
        while (next < nodeVector.size()) {
            if (nodeVector.elementAt(next) == null) {
                ++next;
                continue;
            }
            if (!C14nUtil.isAncestor(nodeVector.elementAt(next), node)) break;
            C14nTransformer.serializeSubset(stack, nodeVector, next, withComments, wr);
            nodeVector.setElementAt(null, next++);
        }
        stack.pop();
        wr.write("</");
        wr.write(node.getNodeName());
        wr.write(">");
    }

    static void serializeNode(Node topNode, Node node, Node exceptedNode, boolean withComments, boolean xmlAttributes, Writer wr) throws IOException, XMLSignatureException {
        C14nTransformer.serializeNode(topNode, null, node, exceptedNode, withComments, xmlAttributes, wr);
    }

    private static void serializeNode(Node topNode, Stack stack, Node node, Node exceptedNode, boolean withComments, boolean xmlAttributes, Writer wr) throws IOException, XMLSignatureException {
        if (exceptedNode == node) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                if (stack == null) {
                    stack = new Stack();
                }
                wr.write("<");
                wr.write(node.getNodeName());
                C14nTransformer.serializeAttributes(topNode, stack, (Element)node, xmlAttributes, wr);
                wr.write(">");
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    C14nTransformer.serializeNode(topNode, stack, child, exceptedNode, withComments, xmlAttributes, wr);
                }
                stack.pop();
                wr.write("</");
                wr.write(node.getNodeName());
                wr.write(">");
                break;
            }
            case 3: 
            case 4: {
                C14nUtil.serializeText(node.getNodeValue(), wr);
                break;
            }
            case 5: 
            case 9: {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    C14nTransformer.serializeNode(topNode, stack, child, exceptedNode, withComments, xmlAttributes, wr);
                }
                break;
            }
            case 7: {
                C14nUtil.serializePI(node, wr);
                break;
            }
            case 8: {
                if (!withComments) break;
                C14nUtil.serializeComment(node, wr);
                break;
            }
            case 10: {
                break;
            }
            case 2: {
                String an = node.getNodeName();
                C14nUtil.serializeAttribute(node, wr, an.equals("xmlns") || an.startsWith("xmlns:"));
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                throw new RuntimeException("Internal Error: Invalid Node Type: " + node.getNodeType());
            }
        }
    }

    private static boolean isTopElement(Node topNode, Element element) {
        if (topNode == element) {
            return true;
        }
        Node parent = element.getParentNode();
        if (parent != null) {
            switch (parent.getNodeType()) {
                case 9: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 5: {
                    parent = parent.getParentNode();
                }
            }
            throw new RuntimeException("Internal Error: Unexpected node type: " + parent.getNodeType());
        }
        return true;
    }

    private static void serializeAttributes(Node topNode, Stack stack, Element element, boolean xmlAttributes, Writer wr) throws IOException, XMLSignatureException {
        Hashtable xmlattrs;
        Hashtable nsattrs = C14nTransformer.collectNamespaceNodesInAncestors(element, false);
        NamedNodeMap nnm = element.getAttributes();
        int atlen = nnm.getLength();
        for (int i = 0; i < atlen; ++i) {
            nsattrs.put(nnm.item(i).getNodeName(), nnm.item(i));
        }
        if (xmlAttributes && (xmlattrs = C14nTransformer.collectXMLPrefixAttributesInAncestors(element)) != null) {
            Enumeration enumeration = xmlattrs.elements();
            while (enumeration.hasMoreElements()) {
                Attr attr = (Attr)enumeration.nextElement();
                nsattrs.put(attr.getNodeName(), attr);
            }
        }
        Hashtable parentAttrs = stack.isEmpty() ? null : (Hashtable)stack.peek();
        stack.push(nsattrs);
        atlen = nsattrs.size();
        String[] as = new String[atlen];
        int[] indexMap = new int[atlen];
        Attr[] attrs = new Attr[atlen];
        int i = 0;
        Enumeration en = nsattrs.elements();
        while (en.hasMoreElements()) {
            Attr attr = (Attr)en.nextElement();
            indexMap[i] = i;
            attrs[i] = attr;
            as[i] = C14nUtil.createSortedString(attr, element);
            ++i;
        }
        C14nUtil.heapSort(indexMap, as, atlen);
        for (int j = 0; j < atlen; ++j) {
            Attr xa;
            Attr a = attrs[indexMap[j]];
            String attrName = a.getNodeName();
            boolean checkURI = false;
            if (attrName.equals("xmlns:xml")) continue;
            if (attrName.equals("xmlns") && a.getNodeValue().length() == 0) {
                if (C14nTransformer.isTopElement(topNode, element)) continue;
                boolean found = false;
                for (int depth = stack.size() - 1; depth >= 0; --depth) {
                    Hashtable attrs2 = (Hashtable)stack.elementAt(depth);
                    Attr attr = (Attr)attrs2.get("xmlns");
                    if (attr == null || attr.getNodeValue().length() <= 0) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (attrName.equals("xmlns") || attrName.startsWith("xmlns:")) {
                Attr nsa;
                checkURI = true;
                if (parentAttrs != null && (nsa = (Attr)parentAttrs.get(attrName)) != null && nsa.getNodeValue().equals(a.getNodeValue())) {
                    continue;
                }
            } else if (attrName.startsWith("xml:") && parentAttrs != null && (xa = (Attr)parentAttrs.get(attrName)) != null && xa.getNodeValue().equals(a.getNodeValue())) continue;
            C14nUtil.serializeAttribute(a, wr, checkURI);
        }
    }

    public static Hashtable collectNamespaceNodesInAncestors(Node startNode, boolean useProxy) {
        Node node = startNode;
        Hashtable<String, Attr> nsnodes = new Hashtable<String, Attr>();
        Document factory = startNode.getOwnerDocument();
        if (node.getNodeType() == 1 && ((Element)node).getAttributeNode("xmlns:xml") == null) {
            Attr xa;
            if (useProxy) {
                xa = new TransformUtil.AttrProxy(startNode, factory, "http://www.w3.org/2000/xmlns/", "xmlns:xml", "http://www.w3.org/XML/1998/namespace");
            } else {
                xa = factory.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xml");
                xa.setNodeValue("http://www.w3.org/XML/1998/namespace");
            }
            nsnodes.put("xmlns:xml", xa);
        }
        do {
            NamedNodeMap attributeList;
            if ((attributeList = node.getAttributes()) == null) continue;
            int nAttrs = attributeList.getLength();
            for (int j = 0; j < nAttrs; ++j) {
                Attr newAttr;
                Attr attr = (Attr)attributeList.item(j);
                String attrName = attr.getNodeName();
                if (!attrName.equals("xmlns") && !attrName.startsWith("xmlns:") || nsnodes.containsKey(attrName)) continue;
                if (node == startNode) {
                    nsnodes.put(attrName, attr);
                    continue;
                }
                if (useProxy) {
                    newAttr = new TransformUtil.AttrProxy(startNode, factory, "http://www.w3.org/2000/xmlns/", attrName, attr.getNodeValue());
                } else {
                    newAttr = factory.createAttributeNS("http://www.w3.org/2000/xmlns/", attrName);
                    newAttr.setNodeValue(attr.getNodeValue());
                }
                nsnodes.put(attrName, newAttr);
            }
        } while ((node = node.getParentNode()) != null);
        return nsnodes;
    }

    public static Hashtable collectXMLPrefixAttributesInAncestors(Node startNode) {
        NamedNodeMap attributeList;
        Hashtable<String, Attr> attrs = null;
        for (Node node = startNode.getParentNode(); node != null; node = node.getParentNode()) {
            NamedNodeMap attributeList2 = node.getAttributes();
            if (attributeList2 == null) continue;
            int nAttrs = attributeList2.getLength();
            for (int j = 0; j < nAttrs; ++j) {
                Attr attr = (Attr)attributeList2.item(j);
                String attrName = attr.getNodeName();
                if (!attrName.startsWith("xml:") || attrs != null && attrs.containsKey(attrName)) continue;
                if (attrs == null) {
                    attrs = new Hashtable<String, Attr>();
                }
                attrs.put(attrName, attr);
            }
        }
        if (attrs != null && (attributeList = startNode.getAttributes()) != null) {
            int nAttrs = attributeList.getLength();
            for (int j = 0; j < nAttrs; ++j) {
                Attr attr = (Attr)attributeList.item(j);
                String attrName = attr.getNodeName();
                if (!attrName.startsWith("xml:") || !attrs.containsKey(attrName)) continue;
                attrs.remove(attrName);
            }
        }
        return attrs;
    }
}

