/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.converter.util;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.plugin.converter.ResourceHandler;
import sun.plugin.converter.util.CommandLineException;
import sun.plugin.converter.util.FileAccessException;
import sun.plugin.converter.util.NotDirectoryException;

public class CommandLine {
    private String[] commandLine;
    private boolean gui = false;
    private boolean params = false;
    private boolean help = false;
    private boolean processSubDirs = false;
    private boolean simulate = false;
    private boolean logFile = false;
    private boolean forceOverwrite = false;
    private String sourceStr;
    private String destStr;
    private String backupStr;
    private String templateStr;
    private String logPath;
    private String progressStr = "false";
    private Vector fileSpecs = new Vector();
    private boolean staticVersioning = true;
    private String sep = System.getProperty("file.separator");
    private String destPathSuffix = "_CONV";
    private String backupPathSuffix = "_BAK";
    private int maxFileCharLength = 27;
    private boolean stdin = false;
    private boolean stdout = false;

    public CommandLine(String[] stringArray) throws CommandLineException, IndexOutOfBoundsException {
        if (stringArray == null || stringArray.length == 0) {
            this.params = false;
        } else {
            this.params = true;
            this.commandLine = stringArray;
            this.readLine();
            if (!this.isStdIn() && this.fileSpecs.isEmpty()) {
                String string = ResourceHandler.getMessage("converter_gui.lablel2");
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
                while (stringTokenizer.hasMoreTokens()) {
                    this.fileSpecs.add(stringTokenizer.nextToken());
                }
            }
            this.checkForProblems();
        }
    }

    public void readLine() throws CommandLineException, IndexOutOfBoundsException {
        try {
            for (int i = 0; i < this.commandLine.length; ++i) {
                String string = this.commandLine[i];
                String string2 = string.trim().toUpperCase(Locale.US);
                if (string2.startsWith("-")) {
                    if (this.isCmdLineOption(string2)) {
                        if (string2.equals("-GUI")) {
                            ++i;
                            this.gui = true;
                            --i;
                            continue;
                        }
                        if (string2.equals("-HELP")) {
                            ++i;
                            this.help = true;
                            --i;
                            continue;
                        }
                        if (string2.equals("-F")) {
                            this.forceOverwrite = true;
                            continue;
                        }
                        if (string2.equals("-SUBDIRS")) {
                            this.processSubDirs = true;
                            continue;
                        }
                        if (string2.equals("-SOURCE")) {
                            this.sourceStr = this.commandLine[++i];
                            continue;
                        }
                        if (string2.equals("-DEST")) {
                            this.destStr = this.commandLine[++i];
                            continue;
                        }
                        if (string2.equals("-BACKUP")) {
                            this.backupStr = this.commandLine[++i];
                            continue;
                        }
                        if (string2.equals("-TEMPLATE")) {
                            this.templateStr = this.commandLine[++i];
                            continue;
                        }
                        if (string2.equals("-LOG")) {
                            this.logFile = true;
                            this.logPath = this.commandLine[++i];
                            continue;
                        }
                        if (string2.equals("-PROGRESS")) {
                            this.progressStr = this.commandLine[++i];
                            continue;
                        }
                        if (string2.equals("-SIMULATE")) {
                            this.simulate = true;
                            continue;
                        }
                        if (!string2.equals("-LATEST")) continue;
                        this.staticVersioning = false;
                        continue;
                    }
                    throw new CommandLineException();
                }
                this.fileSpecs.add(string);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.help = true;
            throw indexOutOfBoundsException;
        }
    }

    private void checkForProblems() throws CommandLineException {
        if (this.backupStr != null && this.destStr != null) {
            File file = new File(this.backupStr);
            File file2 = new File(this.destStr);
            if (file2.getAbsolutePath().equals(file.getAbsolutePath())) {
                System.out.println(ResourceHandler.getMessage("illegal_source_and_backup.info"));
                throw new CommandLineException();
            }
        }
    }

    public boolean isLogFile() {
        return this.logFile;
    }

    public boolean areParams() {
        return this.params;
    }

    public boolean justHelp() {
        return this.help;
    }

    public boolean doSubDirs() {
        return this.processSubDirs;
    }

    public boolean doGUI() {
        return this.gui;
    }

    public boolean showProgress() {
        return this.progressStr.equals("true");
    }

    public boolean justSimulate() {
        return this.simulate;
    }

    public boolean isOverwrite() {
        return this.forceOverwrite;
    }

    public boolean isStdIn() {
        if (this.sourceStr != null && this.sourceStr.equals("-")) {
            this.stdin = true;
            this.sourceStr = null;
        }
        return this.stdin;
    }

    public boolean isStdOut() {
        if (this.destStr != null && this.destStr.equals("-")) {
            this.stdout = true;
            this.destStr = null;
        }
        return this.stdout;
    }

    public String getSourceDir() {
        if (this.sourceStr != null) {
            String string = this.doesExistAndAbsolute(this.sourceStr);
            return string;
        }
        return null;
    }

    public String getDestDir() {
        if (this.destStr != null) {
            String string = this.doesExistAndAbsolute(this.destStr);
            return string;
        }
        return null;
    }

    public String getBackupDir() {
        return this.backupStr;
    }

    public String getTemplateDir() {
        if (this.templateStr != null) {
            File file = new File(this.templateStr);
            String string = this.doesExistAndAbsolute(this.templateStr);
            return string;
        }
        return null;
    }

    public String getLogFile() {
        String string = null;
        if (this.logPath != null) {
            File file = new File(this.logPath);
            string = this.doesExistAndAbsolute(file.getParent()) + File.separator + file.getName();
        }
        return string;
    }

    public Vector getFileSpecs() {
        return this.fileSpecs;
    }

    public boolean getStaticVersioning() {
        return this.staticVersioning;
    }

    private boolean isCmdLineOption(String string) {
        String string2 = string.trim().toUpperCase(Locale.US);
        return string2.equals("-SOURCE") || string2.equals("-DEST") || string2.equals("-BACKUP") || string2.equals("-F") || string2.equals("-SUBDIRS") || string2.equals("-TEMPLATE") || string2.equals("-LOG") || string2.equals("-PROGRESS") || string2.equals("-GUI") || string2.equals("-HELP") || string2.equals("-SIMULATE") || string2.equals("-LATEST");
    }

    private String truncateString(String string, int n) {
        if (string.length() > n) {
            string = string.substring(0, n - 1);
        }
        return string;
    }

    private String doesExistAndAbsolute(String string) {
        File file = new File(string);
        try {
            if (file.exists()) {
                if (file.isAbsolute()) {
                    return string;
                }
                file = new File(System.getProperty("user.dir") + this.sep + string);
                if (file.exists()) {
                    return file.getAbsolutePath();
                }
                throw new NotDirectoryException(ResourceHandler.getMessage("caption.reldirnotfound") + ":  " + file.getAbsolutePath());
            }
            throw new NotDirectoryException(ResourceHandler.getMessage("caption.absdirnotfound") + ":  " + file.getAbsolutePath());
        }
        catch (NotDirectoryException notDirectoryException) {
            System.out.println(ResourceHandler.getMessage("caption.absdirnotfound") + ":  " + file.getAbsolutePath());
            return null;
        }
    }

    public Vector getStandardInput() throws FileAccessException {
        byte[] byArray = new byte[2048];
        int n = 0;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        String string = ".tmpSource_stdin";
        File file = new File(string);
        File file2 = new File(System.getProperty("user.dir") + this.sep + string);
        if (!file2.exists()) {
            try {
                fileInputStream = new FileInputStream(FileDescriptor.in);
                fileOutputStream = new FileOutputStream(file);
                while ((n = fileInputStream.read(byArray, 0, 2048)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                System.out.println(ResourceHandler.getMessage("plugin_converter.write_permission"));
                return null;
            }
        } else {
            throw new FileAccessException(ResourceHandler.getMessage("plugin_converter.overwrite"));
        }
        file2 = new File(System.getProperty("user.dir") + this.sep + string);
        if (file2.exists()) {
            this.fileSpecs.add(string);
            return this.fileSpecs;
        }
        throw new FileAccessException(ResourceHandler.getMessage("plugin_converter.write_permission"));
    }
}

