<?xml version="1.0" encoding="UTF-8"?> 
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" indent="yes" omit-xml-declaration="yes" doctype-system="update.dtd"/>

<!-- Parameter declaration begin -->

<!-- xsl:param name="wasinstallroot"/ -->
<xsl:param name="fileseparator"/>
<xsl:param name="logdirpath"/>
<xsl:param name="backupdirpath"/>

<!-- Parameter declaration end -->

    <xsl:template name="ptf" match="maintenance-history">
        
        <xsl:for-each select="maintenance">
            <xsl:variable name="maintenance_name" select="@name"/>
            <xsl:variable name="description">
                <xsl:for-each select="param[@name='info']">
                    <xsl:value-of select="@value"/>
                </xsl:for-each>
            </xsl:variable>
            <xsl:variable name="package_filename">
                <xsl:for-each select="param[@name='filename']">
                    <xsl:value-of select="@value"/>
                </xsl:for-each>
            </xsl:variable>
            <xsl:variable name="base_file_name">
                <xsl:value-of select="substring-before($package_filename,'.pak')"/>
            </xsl:variable>
            <xsl:variable name="build_date">
                <xsl:for-each select="param[@name='builddate']">
                    <xsl:value-of select="@value"/>
                </xsl:for-each>
            </xsl:variable>
            
            <xsl:element name="ptf">
                <xsl:attribute name="id">
                    <xsl:value-of select="$base_file_name"/>
                </xsl:attribute>
                <xsl:attribute name="short-description">
                    <xsl:value-of select="$description"/>
                </xsl:attribute>
                <xsl:attribute name="build-version">
                    <xsl:value-of select="$build_date"/>
                </xsl:attribute>
                <xsl:attribute name="build-date">
                    <xsl:value-of select="$build_date"/>
                </xsl:attribute>
                
                <xsl:for-each select="param[@name='component']">
                    <xsl:element name="component-name">
                        <xsl:value-of select="@value"/>
                    </xsl:element>
                </xsl:for-each>
            </xsl:element>
        </xsl:for-each>
    </xsl:template>
</xsl:stylesheet>
                        
                
                