/*
 * @(#)src/tools/pfm/java_md.c, tool, axdev, 20060406 1.52
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */






/*
 * Function:
 *     Platform specific code for the java launcher for Unix platforms
 *
 * Change activity:
 *
 * Reason   Date   Origin    Description
 * ------   ----   ------    --------------------------------------------------
 *  41302   040302 kwb       Globalize the java launcher
 *  42361   010402 ansriniv  failed to create VM
 *  42483   100402 sgollapa  Add jre/bin path to LD_LIBRARY_PATH .
 *  42183.1 130502 ansriniv JDK 1.3.1 is broken out-of-the-box on RH 7.1
 *  51090   200502 pratunga  42183.1 changes required only for IA32
 *  51253   210602 smithwil  Add dummy reference to __moddi3 for linking
 *  53141   110702 nmasson   Fix FindJVMDLL
 *  53433   230702 nrichard  Correct LDT_works calculation
 *  53864   010802 nrichard  Enhancement to disable_floating_stacks calculation
 *  55562   260902 kwb       Map zh_HK and zh_MO to use zh_TW
 *  54075   241002 bygravec  Move gdbjava functionality into executable
 *  57930.1 210203 ansriniv Set env. var for LKP automatically
 *  57204   150103 websterm Sidecar launcher
 *  63576.1 130803 nmasson  Add IBM_USE_FLOATING_STACKS override
 *  64690   260903 psman     Back out 51253
 *  65255   291003 belldav   enable IBM_JVM_DEBUG_PROG across Linux
 *  67702   140104 dineeno   Make Error loading DLL message more helpful
 *  67741   050204 mbluemel  Support -Xpd (launch PD build libraries)
 *  74242   090604 dineeno   Stop launcher stripping items from LD_LIBRARY_PATH
 *  71326   230604 pratunga  Produce correct -X usage text for J9
 *  88734   180505 nichanir  Rename the launcher's java*.properties files to
 *                           launcher*.properties
 *  88699   130505 kaaruna   Upgrade to 5.0 launcher
 *  89166   200505 bygravec  #includes across all Linux architectures
 *  91094   140705 bygravec  Search for IBM SDKs to satisfy -version:
 *  76310   210705 bygravec  Remove J9J2SE ifdefs
 *  93221   260705 bygravec  Missing strdup
 *  93551   030805 bygravec  Check bin dir for libjvm
 *  98079.1 061205 andyt     Multi-symlinks to executeable fails
 */


#include "java.h"
#include <dlfcn.h>
#include <string.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <locale.h>
#include <dirent.h>							/*ibm@88699*/
#include "manifest_info.h"					/*ibm@88699*/
#include "version_comp.h"					/*ibm@88699*/
//ibm@7468  begin
#if defined(IBM_LINUX)
/*
 *  libgen.h removed from Linux as it redefines basename to be
 *  __xpg_basename which gives incorrect results.  The prototypes for
 *  dirname and basename are instead defined here
 */
extern char *basename(const char *filename);
extern char *dirname(const char *path);
#define TRUE 1						    /*ibm@7468*/
#define FALSE 0						    /*ibm@7468*/
#else
#include <libgen.h>
#endif
//ibm.@7468  end
#include <sys/stat.h>					    /*ibm@106*/
#include <errno.h>					    /*ibm@7468*/

#if defined(IBM_LINUX)                      /*ibm@89166*/
#include <sys/utsname.h>					 /*ibm@42183.1*/
#include <sys/unistd.h>						/*ibm@53433*/
#define JNI_LIB_PREFIX		"lib"
#define JNI_LIB_SUFFIX		".so"
#define SYS_LIBRARY_PATH	"LD_LIBRARY_PATH"
#else
#define JNI_LIB_PREFIX		"lib"
#define JNI_LIB_SUFFIX		".a"
#define SYS_LIBRARY_PATH	"LIBPATH"
#endif

#if defined(IBM_BUILD_TYPE_dev)
    #define JVM_DLL  JNI_LIB_PREFIX "jvm" JNI_LIB_SUFFIX       /*ibm@67741*/
#elif defined(IBM_BUILD_TYPE_col)
    #define JVM_DLL  JNI_LIB_PREFIX "jvm_g" JNI_LIB_SUFFIX
#else
    #define JVM_DLL  JNI_LIB_PREFIX "jvm" JNI_LIB_SUFFIX
#endif

static char * JavaHomeDir;     /* Home directory - sdk		   */
static char * JavaJREDir;      /* JRE directory  - jre/sdk	   */
static char JavaLibDir[MAXPATHLEN];               /*ibm@67741*/
static char * JavaJVMDir;      /* JVM directory  - sdk/jre/classic */
static char JVMType[16];       /* JVM type  "", "classic"	   */

static char * IBM_VERSIONS_FILE = "/jre/lib/ibmversions.txt"; /*ibm@91094*/

/* start ibm@1369
 * Expand command line arguments.
 */
void
ExpandCommandLineArgs() {
    /* DO NOTHING */
}
/* end   ibm@1369 */

/**************************************************************************
 * name		- ibmFindJVMDLL
 * description  -
 *      Find a JVM DLL.
 *
 * parameters   - jvmtype (the name of the jvm type : "classic" or "hotspot")
 * returns      - path to JVM DLL
 **************************************************************************/
static char *						     /*ibm@106*/
ibmFindJVMDLL(char * jvmtype) {
    struct stat s;
    char   home[MAXPATHLEN];
    char * p;

/*ibm@67741*/
#define JRE_BIN "/jre/bin/"
#define JRE_PD_BIN "/jre/pd/bin/"
#define BIN "/bin/"
#define PD_BIN "/pd/bin/"

    char *binDir;
    char *jreBinDir;
/*ibm@67741*/

    memset(JVMType, 0, 16);
    if (jvmtype) {                                      /*ibm@67741*/
        if (strcmp(jvmtype,"sovPd") != 0) {             /*ibm@67741*/
            strncpy(JVMType, jvmtype, 15);
            binDir = BIN;                               /*ibm@67741*/
            jreBinDir = JRE_BIN;                        /*ibm@67741*/
        } else {                                        /*ibm@67741*/
            strcpy(JVMType,"classic");                  /*ibm@67741*/
            binDir = PD_BIN;                            /*ibm@67741*/
            jreBinDir = JRE_PD_BIN;                     /*ibm@67741*/
        }
    } else {
        memset(JVMType, 0, 16);
        binDir = BIN;                                   /*ibm@67741*/
        jreBinDir = JRE_BIN;                            /*ibm@67741*/
    }                                                   /*ibm@67741*/

    GetApplicationHome(home, MAXPATHLEN-50);
    if (!*home)
	return NULL;
    p = home + strlen(home);       /* pointer to end of home */

    /* Try to load J9 JVM. */
    /*ibm@57204*/
    if (jvmtype != NULL) {
        strcpy(p, jreBinDir);      /*ibm@67741*/
        strcat(p, JVMType);
        strcat(p, "/" JVM_DLL);
        /*ibm@93551...*/
        if (0 != stat(home, &s)) {
            strcpy(p, binDir);
            strcat(p, JVMType);
            strcat(p, "/" JVM_DLL);
        }
        if (0 != stat(home, &s)) {
            jvmtype = NULL;
        } else {
            return strdup(home);
        }
        /*...ibm@93551*/
    }

    if (jvmtype==NULL) {
	/* Try <home>/jre(/pd)/bin */
	strcpy(p, jreBinDir);
	strcat(p, JVM_DLL);        /*ibm@67741*/
	if (stat(home, &s) == 0) {
	    return strdup(home);
	}

	/* try <home>(/pd)/bin */
	strcpy(p, binDir);        /*ibm@67741*/
	strcat(p, JVM_DLL);       /*ibm@67741*/
	if (stat(home, &s) == 0) {
	    return strdup(home);
	}
	strcpy(JVMType, "classic");
    }

    /* try <home>/jre(/pd)/bin/classic */
    strcpy(p, jreBinDir);         /*ibm@67741*/
    strcat(p, JVMType);
    strcat(p, "/" JVM_DLL);
    if (stat(home, &s) == 0) {
	return strdup(home);
    }

    /* try <home>(/pd)/bin/classic */
    strcpy(p, binDir);					/*ibm@53141,ibm@67741*/
    strcat(p, JVMType);
    strcat(p, "/" JVM_DLL);				/*ibm@53141*/
    if (stat(home, &s) == 0) {
	return strdup(home);
    }

    /* JVM not found */
    return(char *)NULL;
}


/**************************************************************************
 * name	       - LoadJavaVM (ibm@149)
 * description -
 *      Load JVM and initialize the invocation functions.  Dynamically
 *      open the jvm shared library and find the entry points.
 *
 * parameters  - jvmtype (name of jvm type, currently "classic")
 *		 ifn (vector of functions which receives the function
 *		      pointers found in the jvm DLL)
 * returns     - JNI_TRUE if successful
 **************************************************************************/
jboolean
LoadJavaVM(char *jvmtype, InvocationFunctions *ifn) {
    char * jvmpath, * jp;
    void * hJvm;

    if (!JavaJVMDir) {					/*ibm@53141*/
	showMessage(stderr, "JVM.not.found", c2jc(JVM_DLL), NULL, 0);
	return JNI_FALSE;
    }
    jvmpath = MemAlloc(strlen(JavaJVMDir) + 50);
    strcpy(jvmpath, JavaJVMDir);
    strcat(jvmpath, "/"JVM_DLL);
    hJvm = dlopen(jvmpath,RTLD_LAZY);
    if (hJvm==NULL) {
	if (_launcher_debug) {							/*ibm@88699*/
	    fprintf(stderr, "LoadJavaVM: unable to open DLL (%s)\n", jvmpath);
	    fprintf(stderr, "%s\n", dlerror());
	}
	if (errno == ENAMETOOLONG) {
	    showMessage(stderr, "Path.too.long", c2jc(SYS_LIBRARY_PATH), NULL, 0);
	} else {
	    showMessage(stderr, "Error.loading", c2jc(dlerror()), NULL, 0); /*ibm@67702*/    
	}
	free(jvmpath);
	return JNI_FALSE;
    }

    ifn->CreateJavaVM = (jint (JNICALL *)(JavaVM **pvm, void **penv, void *args))
			dlsym(hJvm,"JNI_CreateJavaVM");
    ifn->GetDefaultJavaVMInitArgs = (jint (JNICALL *)(void *args))
				    dlsym(hJvm,"JNI_GetDefaultJavaVMInitArgs");
/*ibm@76310..*/
    ifn->GetXUsage = (jint (JNICALL *)(char *exename))
                     dlsym(hJvm,"GetXUsage");
/*..ibm@76310*/

    if (ifn->CreateJavaVM == 0 ||
	ifn->GetDefaultJavaVMInitArgs == 0) {
	showMessage(stderr, "JNI.interfaces.not.found", c2jc(jvmpath), NULL, 0);
	return JNI_FALSE;
    }
    free(jvmpath);
    return JNI_TRUE;
}

/**************************************************************************
 * name	       - GetXUsagePath
 * description -
 *      Get the path to the file that has the usage message for -X options.
 *
 * parameters  - buf (the receiving buffer for the path)
 *		 bufsize (the size of buf)
 * returns     -
 **************************************************************************/
void
GetXUsagePath(char *buf, jint bufsize) {
    *buf = 0;
}


/**************************************************************************
 * name	       - ResolveSymbol (ibm@7468)                       ibm@98079.1
 * description -
 *      Given a buffer containing a path resolve any symbols in the last
 *      component of the path. If the symbol resolves to a relative path
 *      add it to the original. Otherwise replace it.
 *
 * parameters  - pUsed (ptr to a buffer holding the current path)
 * returns     -
 *************************************************************************/
static void
ResolveSymbol(char *pUsed) {
    char buffer[MAXPATHLEN];

    if (realpath(pUsed, buffer)) {
        strcpy(pUsed, buffer);
    }
}

/**************************************************************************
 * name	       - BuildHomeDir (ibm@7468)
 * description -
 *      From the supplied executable name determine the true home directory.
 *      This function is called once to set up JavaHomeDir.
 *
 * parameters  - fname (The name of this executable, may be short or long)
 * returns     -
 *************************************************************************/
void
BuildHomeDir(char *fname) {
    char *path;
    char *p;
    int len;
    char dir[MAXPATHLEN];
    char *found = NULL;
    struct stat s;
    mode_t mode;							/*ibm@39752.1*/

    /*
     *  Is the exe name fully, or partially qualified?
     */
    if (strchr(fname, '/') != NULL && stat(fname, &s) == 0) {
	if (fname[0] == '/') {
	    strcpy(dir, fname);
	    found = dir;
	} else {
	    getcwd(dir, MAXPATHLEN);

	    path = dir;
	    p = fname;
	    while (p[0] == '.') {
		if (strstr(p, "../") == p) {
		    p = p+3;
		    path = dirname(path);
		} else {
		    p = p+2;
		}
	    }
	    strcat(path, "/");
	    strcat(path, p);

	    found = path;
	}
    } else {
	/*
	 * If not found, assume it's a short name and search the path variable...
	 */

	path = getenv("PATH");

	while (path != NULL) {
	    /*
	     *  Get the first element of the path
	     */

	    p = strchr(path, ':');

	    if (p != NULL) {

		/*
		 * There is more than one
		 */
		len = p - path;
		strncpy(dir, path, len);
		dir[len] = 0;
		path = p+1;
	    } else {

		/*
		 * Last path element...
		 */
		strcpy(dir, path);
		path = NULL;
	    }

	    /*
	     * Add the exe name to the path element and check it points to a file.
	     */
	    len = strlen(dir);					   /*ibm@42361*/
	    if (dir[len - 1] != '/') {				   /*ibm@42361*/
		strcat(dir, "/");
	    }							   /*ibm@42361*/
	    strcat(dir, fname);
	    if (stat(dir, &s) == 0) {
		mode = s.st_mode & S_IFMT;				/*ibm@39752.1*/
		if (mode == S_IFREG) {					/*ibm@39752.1*/
		    /*
		     * We have found a match!
		     */
		    found = dir;
		    break;
		}							/*ibm@39752.1*/
	    }

	}

    }

    /*
     * Did we find it?
     */
    if (found != NULL) {
	/*
	 * Resolve symbolic link in name
	 */
	ResolveSymbol(found);

	/*
	 * Strip the exc's name off the end.
	 */
	p = dirname(found);
	if (found != p) {
	    strcpy(found, p);
	}

	if (strcmp(basename(found), "exe") == 0) {
	    p = dirname(found);
	    if (found != p) {
		strcpy(found, p);
	    }
	}
	JavaJREDir = strdup(found);
	if (_launcher_debug) {						/*ibm@53141,ibm@88699*/
	    fprintf(stderr, "JavaJREDir  = %s\n", JavaJREDir);
	}
	/*
	 * Remove the next component which should be /bin
	 */
	p = dirname(found);
	if (found != p) {
	    strcpy(found, p);
	}

	/*
	 * If the next component is /jre remove it
	 */
	if (strcmp(basename(found),"jre") == 0) {
	    p = dirname(found);
	    if (found != p) {
		strcpy(found, p);
	    }
	}
	JavaHomeDir = strdup(found);
	if (_launcher_debug) {					/*ibm@88699*/
	    fprintf(stderr, "JavaHomeDir = %s\n", JavaHomeDir);/*ibm@53141*/
	}
    }
}

/**************************************************************************
 * name	       - GetApplicationHome (ibm@7468)
 * description -
 *      Get the application home directory, which will have been calculated
 *      by BuildHomeDir.
 *
 * parameters  - buf     The receiving buffer for the path
 *		 bufsize The size of the receiving buffer (not used)
 * returns     - JNI_TRUE
 **************************************************************************/
jboolean
GetApplicationHome(char *buf, jint bufsize) {
    strncpy(buf, JavaHomeDir, bufsize-1); /*ibm@26075*/
    buf[bufsize-1] = 0;
    return JNI_TRUE;
}

/**************************************************************************
 * name	       - setLibPath (ibm@7468)
 * description -
 *      Clean up the LD_LIBRARY_PATH environment variable, and add our bin
 *      directory to it.
 *
 * parameters  -
 * returns     -
 **************************************************************************/
void
setLibPath(char *jvmtype) {

    char * newpath;
    char *p;
    char *path = getenv(SYS_LIBRARY_PATH);
    int len;
    int totlen;

    if (!path) path = "";
    totlen = strlen(path)+strlen(JavaHomeDir)*3+100; /*ibm@42483*/
    newpath = MemAlloc(totlen);

    /*
     * Add the jre(/pd)/bin directory to the start of LD_LIBRARY_PATH
     */
    strcpy(newpath, SYS_LIBRARY_PATH "=");
    strcat(newpath, JavaLibDir);                    /*ibm@67741*/
    if (strcmp(JavaLibDir, JavaJVMDir)) {           /*ibm@67741*/
	strcat(newpath, ":");
	strcat(newpath, JavaJVMDir);
	strcat(newpath, ":"); /*ibm@42483*/
	strcat(newpath, JavaHomeDir); /*ibm@42483*/
        if (strcmp(jvmtype,"sovPd") != 0) {        /*ibm@67741*/
	    strcat(newpath, "/jre/bin"); /*ibm@42483*/
        } else {
	    strcat(newpath, "/jre/pd/bin");        /*ibm@67741*/
        }
    }

    /*
     * Now clean up LD_LIBRARY_PATH
     */
    while (path != NULL) {

	/* Get the first element of the path */

	p = strchr(path, ':');

	if (p == path) {
	    /* Discard null path entry "::" */
	    p++;
	} else {
	    if (p != NULL) {
		len = p - path;
		p++;
	    } else {
		len = strlen(path);
	    }

            if (len > 0) {
	        /* Discard trailing path separator */
	        if (path[len-1] == '/') {
		    len--;
	        }
		strcat(newpath, ":");
		strncat(newpath, path, len);
	    }
	}

	/* Move to the next path item */
	path = p;

    }

    putenv(strdup(newpath));
    MemFree(newpath);
}

/**************************************************************************
 * name	       - setEnvVars (ibm@6796)
 * description -
 *      Set the environment variables needed by Java.
 *
 * parameters  -
 * returns     -
 **************************************************************************/
void
setEnvVars() {
#ifdef IBM_AIX
    putenv("MALLOCMULTIHEAP=1");				/*ibm@8392*/
    putenv("AIXTHREAD_SCOPE=S");				/*ibm@8392*/

    /* IBM@8872 We need these options below for all builds now */
    putenv("AIXTHREAD_MUTEX_DEBUG=OFF");			/*ibm@8392*/
    putenv("AIXTHREAD_RWLOCK_DEBUG=OFF");			/*ibm@8392*/
    putenv("AIXTHREAD_COND_DEBUG=OFF");				/*ibm@8392*/

#if defined(__64BIT__)
    putenv("NULLPTR=NOSEGV");					/*ibm@24449*/
#endif
#endif

}

/**************************************************************************
 * name	       - setLibAndExec (ibm@7468)
 * description -
 *      AIX and Linux dlopen have problems with LD_LIBRARY_PATH changes
 *      made in the same process that is calling dlopen. Both use the
 *      value of LD_LIBRARY_PATH at process exec time. If JAVA has been
 *      executed without LD_LIBRARY_PATH containing the java lib paths,
 *      this function adds them, and re-execs JAVA to ensure that dlopen
 *      sees the new LD_LIBRARY_PATH setting.
 *
 * parameters  - argc (The count of arguments passed to main)
 *		 arcv (Array of parameters taken from the command line)
 * returns     -
 **************************************************************************/
void
setLibAndExec(int argc, char *argv[], char * jvmtype) {
    char *p, *path;
    char *buffer;
    char * jvmpath, * jp;
    int lib1 = FALSE, lib2 = FALSE;
    int new_scope_needed = FALSE;
    int new_ulimit_needed = FALSE;
    int libfound;
#ifdef IBM_AIX
    struct rlimit64 limit;
#endif
/*ibm@42183.1, start*/
#if defined(IBM_LINUX) && defined(i386)				/*ibm@51090*/
    struct utsname uinfo;
    unsigned int k_major = 0;
    unsigned int k_minor = 0;
    unsigned int k_delta = 0;
    int is_MP = FALSE;						/*ibm@53433*/
    int disable_floating_stacks;				/*ibm@53433*/
    char sysname[10];                                            /*ibm@57930.1*/
    FILE *sys_file = NULL;                                       /*ibm@57930.1*/
#endif
/*ibm@65255 start*/
    const int MAX_ARGS=(20);
    char *debugProg = NULL;                                     /*ibm@54075*/
    char **debugJavaArgs = (char**) malloc(sizeof(char *)*(MAX_ARGS+argc));
    char *delim = NULL;
    char *token = NULL;
    int argCount = 0;
    int count = 0;
/*ibm@65255 end*/

/*ibm@42183.1, end*/
    /*
     * Duplicate this here to make sure that we get the debug output
     * before the LIBPATH is set up.
     */
    if (getenv("_JAVA_LAUNCHER_DEBUG") != 0) {
	_launcher_debug = JNI_TRUE;					/*ibm@88699*/
    }

    /*
     * Find the application home dir from the application name
     */
    BuildHomeDir(argv[0]);

    //ibm.41302  begin
    /*
     * Find the JVM
     */
    jvmpath = ibmFindJVMDLL(jvmtype);
    if (!jvmpath)
	return;
    JavaJVMDir = strdup(jvmpath);
    jp = strrchr(JavaJVMDir, '/');
    if (jp) *jp=0;
    if (_launcher_debug)						/*ibm@88699*/
	fprintf(stderr, "JavaJVMDir  = %s\n", JavaJVMDir);
    //ibm.41302  end

    /*
     * Look through LIBPATH for the java libraries.  Ensure
     * the current java libraries are before other potentially
     * conflicting libraries.
     */
   /*ibm@67741 - hack "pd" into paths if necessary*/
    strcpy(JavaLibDir,JavaJREDir);
    if (strcmp(jvmtype,"sovPd") == 0) {
        p=strrchr(JavaLibDir,'/');
        strcpy(p,"/pd/bin");
    }

    p = getenv(SYS_LIBRARY_PATH);
    if (!p) p = "";
    buffer = strdup(p);
    path = buffer;
    while (path != NULL) {
	if ((p = strchr(path, ':')) != NULL) {
	    *p++ = 0;
	}
	if (!strcmp(path, JavaJVMDir)) {
	    lib1 = TRUE;
	    if (!strcmp(path, JavaLibDir))      /*ibm@67741*/
		lib2 = TRUE;
	} else if (!strcmp(path, JavaLibDir)) { /*ibm@67741*/
	    lib2 = TRUE;
	} else {
	    break;
	}
	path = p;
    }
    free (buffer);

    if (!lib1 || !lib2) {
	setLibPath(jvmtype);                    /*ibm@67741*/
    }

#ifdef IBM_AIX
    /*
     * If the user has not set the thread scope, or has not set it to 'S',
     * we must reset it. This will enable a user with the correct environment
     * to avoid an execvp, the same is true for the otehr flags below.
     */
    p = getenv("AIXTHREAD_SCOPE");				/*ibm@9197*/
    if (!(p && !strcmp(p, "S"))) {				/*ibm@9197*/
	new_scope_needed=TRUE;					/*ibm@9197*/
    }

    p = getenv("AIXTHREAD_MUTEX_DEBUG");			/*ibm@8872*/
    if (!(p && !strcmp(p, "OFF"))) {				/*ibm@8872*/
	new_scope_needed=TRUE;					/*ibm@8872*/
    }

    p = getenv("AIXTHREAD_RWLOCK_DEBUG");			/*ibm@8872*/
    if (!(p && !strcmp(p, "OFF"))) {				/*ibm@8872*/
	new_scope_needed=TRUE;					/*ibm@8872*/
    }

    p = getenv("AIXTHREAD_COND_DEBUG");				/*ibm@8872*/
    if (!(p && !strcmp(p, "OFF"))) {				/*ibm@8872*/
	new_scope_needed=TRUE;					/*ibm@8872*/
    }
#endif


    /* This was moved in IBM@9197 but cannot be placed before tests above */
    /* or they will always see the correct settings		  IBM@8872*/
    setEnvVars();

#ifdef IBM_AIX
    /*
     * ibm@24999
     * This mechanism is implemented in AIX on both PowerPC and
     * IA64 and is related to the static linker binder option
     * -bmaxdata, but is more flexible because the user
     * may set their own environment variable value of number of
     * segments for private data that is used for malloc() memory
     * allocations including thread stacks and the default Java
     * heap.
     * ibm@29024
     * Using LDR_CNTRL=MAXDATA is needed in both 32-bit and 64-bit
     * to use its ability to override the user soft data limit.
     */

    #if !defined(__64BIT__) || defined(_ARCH_IA64)      /* ibm@32140*/

    /* If NOT PPC64 - Check for "LDR_CNTRL" */

    p = getenv("LDR_CNTRL");
    if (p == NULL) {
	/*
	 * The maximum value is 0x80000000 for 8x256Mb segments.
	 *
	 * The user has not already specified another value, so
	 * use the 0x80000000 value to give the same behaviour
	 * as our legacy AIX PowerPC 32-bit 1.3 JVM which was
	 * statically linked with -bmaxdata for all of the launcher
	 * executables.
	 * NB. This applies to 32-bit on both IA64 and PowerPC;
	 * at some future time, we should look at removing use of
	 * the -bmaxdata binder option on PowerPC.
	 */
	putenv("LDR_CNTRL=MAXDATA=0x80000000");
	new_scope_needed = TRUE;
    }

    #endif       /* ibm@32140*/

    #if defined(__64BIT__)   /*ibm@33012*/
	getrlimit64(RLIMIT_DATA,&limit);			    /*ibm@32147*/
    if ((limit.rlim_cur) != RLIM64_INFINITY) {			/*ibm@32147*/
	limit.rlim_cur = RLIM64_INFINITY;			/*ibm@32147*/
	setrlimit64(RLIMIT_DATA,&limit);			/*ibm@32147*/
	new_ulimit_needed=TRUE;					/*ibm@32147*/
    }								/*ibm@32147*/
    #endif		     /*ibm@33012*/
#endif    /* IBM_AIX */

/*ibm@42183.1
 * IBM.FIXME
 * This fix is a workaround to disable the floating stacks on the Linux machines
 * with kernel < 2.4 (on UP), < 2.4.10 (on SMP) or with glibc which doesn't have
 * pthread_getattr_np.
 * At this point of time the supported distros include RH Advanced Server 7.2
 * which is shipped with 2.4.9 kernel. So we need the fix here.
 * Once the supported distros ships with the above requirements,
 * we do not require the fix here.
 *
 */

/*ibm@42183.1, start*/
#if defined(IBM_LINUX) && defined(i386)				/*ibm@51090*/
    /*ibm@57930.1, start*/
    if ((sys_file = fopen("/proc/version", "r")) != NULL) {
        if ((fscanf(sys_file, "%9s ", sysname) == 1) && !strcmp(sysname, "LKP")) {
            putenv(strdup("IBM_NOLDT=1"));
        }
        fclose(sys_file);
    }
    /*ibm@57930.1, end*/
    uname(&uinfo);
    sscanf(uinfo.release, "%u.%u.%u", &k_major, &k_minor, &k_delta);
    is_MP = (sysconf(_SC_NPROCESSORS_CONF) > 1);		/*ibm@53433*/

    /*ibm@53864 start*/
    disable_floating_stacks = TRUE;
    if ((k_major > 2) ||
	((k_major == 2) &&
	 ((k_minor > 4) ||
	  ((k_minor == 4) &&
	   (k_delta >= 10))))) {
	disable_floating_stacks = FALSE;
    } else if (!is_MP &&
	       ((k_major > 2) ||
		((k_major == 2) &&
		 (k_minor >= 4)))) {
	/*
	 * Floating stacks can only be supported if the system call
	 * pthread_getattr_np() is available (otherwise we run the risk
	 * of hitting a kernel bug when finding out thread stack info.
	 *
	 * NB: This should match the logic whic hworks this out in the HPI.
	 */
	const char* fn_name = "pthread_getattr_np";
	void* known_symbol;
	void* pthread_getattr_np;

	/*
	 * First, discover whether we've already got libpthread loaded,
	 * by searching for a symbol which will always be in our global
	 * scope if it is - pthread_create, for example.
	 */
	known_symbol = dlsym(RTLD_DEFAULT, "pthread_create");

	if (known_symbol != NULL) {
	    /*
	     * libpthread is already loaded, so if pthread_getattr_np
	     * exists, it will be found in our global scope.
	     */
	    pthread_getattr_np = dlsym(RTLD_DEFAULT, fn_name);
	} else {
	    void* pthread_lib;

	    /*
	     * libpthread isn't loaded yet, so do so using
	     * sysLoadLibrary(), then try to find pthread_getattr_np
	     * within it.
	     */
	    pthread_lib = dlopen("libpthread.so", RTLD_LAZY | RTLD_GLOBAL);
	    if (pthread_lib != NULL) {
		pthread_getattr_np = dlsym(pthread_lib, fn_name);
		dlclose(pthread_lib);
	    }
	}

	if (pthread_getattr_np != NULL) {
	    disable_floating_stacks = FALSE;
	}
    }
    /*ibm@53864 end*/

    /*ibm@63576.1 Override the above determination if the environment variable 
     * IBM_USE_FLOATING_STACKS is set
     */
    if (disable_floating_stacks) {
	if(getenv("IBM_USE_FLOATING_STACKS") == NULL) {		/*ibm@63576.1*/
	    putenv(strdup("LD_ASSUME_KERNEL=2.2.5"));
	}
    }
#endif
/*ibm@42183.1, end*/

    /*ibm@65255 start*/
    /*ibm@54075 start*/
    debugProg = getenv("IBM_JVM_DEBUG_PROG");
    if (debugProg && strcmp(debugProg, "")) {
        putenv(strdup("IBM_JVM_DEBUG_PROG="));
        printf("Found IBM_JVM_DEBUG_PROG=%s\n", debugProg);
        delim = " ";
        token = strtok(debugProg, delim);
        debugJavaArgs[argCount] = token;
        argCount++;
        token = strtok(NULL, delim);

        while(token != NULL) {
                if (argCount >= MAX_ARGS-3) {
                    printf("USAGE ERROR: too many arguments in IBM_JVM_DEBUG_PROG\n");
                    exit(-1);
                }
            debugJavaArgs[argCount] = token;
            token = strtok(NULL, delim);
            argCount++;
        }
        debugJavaArgs[argCount] = argv[0];

        count=1;
        if(!(strcmp(debugJavaArgs[argCount-1], "--args"))){
            for(;count<argc;count++) {
                debugJavaArgs[count+argCount] = argv[count];
            }
        }
        debugJavaArgs[count+argCount] = NULL;
        execvp(debugProg, debugJavaArgs);

        fprintf(stderr, "Execution of %s failed, ignoring IBM_JVM_DEBUG_PROG\n",
 debugProg);
        fflush(stderr);
    }
    /*ibm@54075 end*/
    /*ibm@65255 end*/

    if (!lib1 || !lib2 || new_scope_needed || new_ulimit_needed) {      /*ibm@9197,ibm@32147*/
	execvp(argv[0], argv);					/*ibm@9197*/
    }								/*ibm@9197*/
}


/*
 * Parse a platform name to separate the path and the file
 */
char * PlatformName(char * in, char * * cpath) {
    *cpath = ".";
    if (in[0]=='/') {
	char nbuf[PATH_MAX+1], * nptr;
	if (realpath(in, nbuf)) {
	    char * out = strdup(nbuf);
	    nptr = strrchr(out, '/');
	    if (out < nptr) {
		*cpath = out;
		*nptr = 0;
		return nptr+1;
	    }
	}
    }
    return in;
}


/*
 * Show a Unicode string.  This assumes that the wide char encoding
 * is in Unicode.  This is true for most current Unix systems.
 */
void ShowUnicode(FILE * f, jchar * str, int len) {
    char  * sbuf = MemAlloc(len*4 + 1);
    char  * sp;
    int     i, rc;

    for (i=0, sp=sbuf; i<len; i++) {
	rc = wctomb(sp, (wchar_t)str[i]);
	if (rc>0)
	    sp += rc;
    }
    *sp = 0;
    fwrite(sbuf, 1, (sp-sbuf), f);
    fflush(f);
    free(sbuf);
}


/*
 * Get the message file for this locale
 */
char * GetMessageFile(char *buf, jint bufsize) {
    char * cp;
    char   langname[8];
    char   ctryname[8];
    char * lc;

    /* Get the lang and country strings */
    lc = setlocale(LC_CTYPE, "");
    if (!lc) lc = "en";
    strncpy(langname, lc, 7);
    langname[7] = 0;
    ctryname[0] = 0;
    cp = strchr(langname, '_');
    if (cp) {
	*cp = 0;
	strcpy(ctryname, cp+1);
	ctryname[2] = 0;
    }

    /* Get the directory one up from that containing the jvm.dll */
    if ((strlen(JavaJREDir)+24) > bufsize) {
	return NULL;
    }

    strcpy(buf, JavaJREDir);
    cp = buf+strlen(buf);
    strcpy(cp, "/launcher_");          /*ibm@88734*/
    cp += 10;                          /*ibm@88734*/

    /* Try for launcher_ll_CC.properties */  /*ibm@88734*/
    if (*ctryname) {
	strcpy(cp, langname);
	strcat(cp, "_");
	strcat(cp, ctryname);
	strcat(cp, ".properties");
	if (!access(buf, 4))
            return buf;
    }

    //ibm.55562  begin
    /* Special case to map traditional chinese */
    if (!strcmp(langname, "zh") &&
        (!strcmp(ctryname, "HK") || !strcmp(ctryname, "MO"))) {
        strcpy(cp, "zh_TW.properties");
        if (!access(buf, 4))
            return buf;
    }
    //ibm.55562  end

    /* Try for launcher_ll.properties */    /*ibm@88734*/
    if (*langname) {
        strcpy(cp, langname);
        strcat(cp, ".properties");
        if (!access(buf, 4))
            return buf;
    }

    /* Try for launcher.properties */       /*ibm@88734*/
    strcpy(cp-1, ".properties");
    if (!access(buf, 4))
        return buf;

    return 0;
}

/*ibm@88699 start*/
static const char *system_dir	= "/opt";
/*static const char *user_dir	= "/java";*/
static char *SetExecname(char **argv);
/*ibm@88699 end*/
/*  ibm@88699
 *      Since using the file system as a registry is a bit risky, perform
 *      additional sanity checks on the identified directory to validate
 *      it as a valid jre/sdk.
 *
 *      Return 0 if the tests fail; otherwise return non-zero (true).
 *
 *      Note that checking for anything more than the existence of an
 *      executable object at bin/java relative to the path being checked
 *      will break the regression tests.
 *
 * ibm@91094
 *      Without checking for more than bin/java we won't detect IBM JRE
 *      installations, which do not install a softlink to jre/bin/java.
 */
static int
CheckSanity(char *path, char *dir)
{
    char    buffer[PATH_MAX];

    if (strlen(path) + strlen(dir) + 15 > PATH_MAX)
        return (0);     /* Silently reject "impossibly" long paths */

    (void)strcat(strcat(strcat(strcpy(buffer, path), "/"), dir), "/bin/java");
    /*ibm@91094..*/
    if (access(buffer, X_OK) == 0) {
        return 1;
    } else {
        (void)strcat(strcat(strcat(strcpy(buffer, path), "/"), dir),
            "/jre/bin/java");
        return ((access(buffer, X_OK) == 0) ? 1 : 0);
    }
    /*..ibm@91094*/
}

/*  ibm@88699
 *	Determine if there is an acceptable JRE in the directory dirname.
 *	Upon locating the "best" one, return a fully qualified path to
 *	it. "Best" is defined as the most advanced JRE meeting the
 *	constraints contained in the manifest_info. If no JRE in this
 *	directory meets the constraints, return NULL.
 *
 *	Note that we don't check for errors in reading the directory
 *	(which would be done by checking errno).  This is because it
 *	doesn't matter if we get an error reading the directory, or
 *	we just don't find anything interesting in the directory.  We
 *	just return NULL in either case.
 *
 *	The historical names of j2sdk and j2re were changed to jdk and
 *	jre respecively as part of the 1.5 rebranding effort.  Since the
 *	former names are legacy on Linux, they must be recognized for
 *	all time.  Fortunately, this is a minor cost.
 */
static char
*ProcessDir(manifest_info *info, char *dirname)
{
    DIR	    *dirp,*temp_dirp;
    struct dirent *dp;
    char    *best = NULL;
    int     offset;
    int	    best_offset = 0;
    char    *ret_str = NULL;
    char    buffer[PATH_MAX];
	char	szTemp[PATH_MAX];
    
    if ((dirp = opendir(dirname)) == NULL)
	return (NULL);

    do {
	if ((dp = readdir(dirp)) != NULL) {
	    offset = 0;
	    if ((strncmp(dp->d_name, "jre", 3) == 0) ||
	        (strncmp(dp->d_name, "jdk", 3) == 0))
		offset = 3;
	    else if (strncmp(dp->d_name, "j2re", 4) == 0)
		offset = 4;
	    else if (strncmp(dp->d_name, "j2sdk", 5) == 0)
		offset = 5;
	    if (offset > 0) {
	    	if ((acceptable_release(dp->d_name + offset,
		    info->jre_version)) && CheckSanity(dirname, dp->d_name))
	    	    if ((best == NULL) || (exact_version_id(
		      dp->d_name + offset, best + best_offset) > 0)) {
			if (best != NULL)
			    free(best);
			best = strdup(dp->d_name);
			best_offset = offset;
		    }
	    }
	}
    } while (dp != NULL);
    (void) closedir(dirp);
    if (best == NULL)
	return (NULL);
    else {
	ret_str = MemAlloc(strlen(dirname) + strlen(best) + 2);
	ret_str = strcat(strcat(strcpy(ret_str, dirname), "/"), best);
	free(best);
	return (ret_str);
    }
}

/*  ibm@88699
 *	This is the global entry point. It examines the host for the optimal
 *	JRE to be used by scanning a set of directories.  The set of directories
 *	is platform dependent and can be overridden by the environment
 *	variable JAVA_VERSION_PATH.
 *
 *	This routine itself simply determines the set of appropriate
 *	directories before passing control onto ProcessDir().
 */
char*
LocateJRE(manifest_info* info)
{
    char    *path;
    char    *home;
    char    *target = NULL;
    char    *dp;
    char    *cp;
    /*ibm@91094..*/
    char    filepath[MAXPATHLEN];
    FILE    *ibmfile;
    char    buf[MAXPATHLEN+10];
    char    *ibmdir;
    char    *ibmversion;

    /* Open the properties file and check for a matching JRE
     * If a match is found, return it, else drop through to
     * Sun default behaviour
     */
    GetApplicationHome(filepath, MAXPATHLEN);
    strncat(filepath, IBM_VERSIONS_FILE, MAXPATHLEN - strlen(filepath));
    if ((ibmfile = fopen(filepath, "r")) != NULL) {
        if (_launcher_debug)
            printf("Parsing %s\n", filepath);
        fgets(buf, MAXPATHLEN + 10, ibmfile);
        while (!feof(ibmfile)) {
            ibmversion = strtok(buf, "=");
            if (ibmversion != NULL &&
                acceptable_release(ibmversion, info->jre_version)) {
                ibmdir = strtok(NULL, "\n");
                if (ibmdir != NULL && CheckSanity(ibmdir, "/")) {
                    if (_launcher_debug)
                        printf("Found %s\n", ibmdir);
                    return strdup(ibmdir);    /*ibm@93221*/
                }
            }
            fgets(buf, MAXPATHLEN + 10, ibmfile);
        }
        fclose(ibmfile);
    } else {
        if (_launcher_debug)
            printf("File %s not found\n", filepath);
        // no file found, so drop through to Sun default behaviour
    }

    /*
     * If we are still here, try getting JAVA_VERSION_PATH
     */
    /*..ibm@91094*/
    if (info->jre_restrict_search)
	path = strdup(system_dir);
    else if ((path = getenv("JAVA_VERSION_PATH")) != NULL)
	path = strdup(path);
    else
	if ((home = getenv("HOME")) != NULL) {
	    path = (char *)MemAlloc((strlen(home) + strlen(":") + strlen(system_dir)+ 1));
	    path = strcat(strcat(strcpy(path, home), ":"), system_dir);
	} else
	    path = strdup(system_dir);

    /*
     * Step through each directory on the path. Terminate the scan with
     * the first directory with an acceptable JRE.
     */
    cp = dp = path;
    while (dp != NULL) {
	cp = strchr(dp, (int)':');
	if (cp != NULL)
	    *cp = (char)NULL;
	if ((target = ProcessDir(info, dp)) != NULL)
	    break;
	dp = cp;
	if (dp != NULL)
	    dp++;
    }
    free(path);
    return (target);
}

/* ibm@88699
 * Given a path to a jre to execute, this routine checks if this process
 * is indeed that jre.  If not, it exec's that jre.
 *
 * We want to actually check the paths rather than just the version string
 * built into the executable, so that given version specification (and
 * JAVA_VERSION_PATH) will yield the exact same Java environment, regardless
 * of the version of the arbitrary launcher we start with.
 */
void
ExecJRE(char *jre, char **argv)
{
    char    wanted[PATH_MAX];
    char    *execname;
    char    *progname;
    size_t  wanted_len;  /*ibm@91094*/

    /*
     * Resolve the real path to the directory containing the selected JRE.
     */
    if (realpath(jre, wanted) == NULL) {
	fprintf(stderr, "Unable to resolve %s\n", jre);
	exit(1);
    }

    /*
     * Resolve the real path to the currently running launcher.
     */
    execname = SetExecname(argv);
    if (execname == NULL) {
	fprintf(stderr, "Unable to resolve current executable\n");
	exit(1);
    }

    /*
     * If the path to the selected JRE directory is a match to the initial
     * portion of the path to the currently executing JRE, we have a winner!
     * If so, just return.
     */
    if (strncmp(wanted, execname, strlen(wanted)) == 0)
	return;			/* I am the droid you were looking for */

    /*
     * If this isn't the selected version, exec the selected version.
     */
#ifdef JAVA_ARGS  /* javac, jar and friends. */
    progname = "java";
#else             /* java, oldjava, javaw and friends */
#ifdef PROGNAME
    progname = PROGNAME;
#else
	{
		char *s;
		progname = *argv;
		if ((s = strrchr(progname, FILE_SEPARATOR)) != 0) {
			progname = s + 1;
		}
	}
#endif /* PROGNAME */
#endif /* JAVA_ARGS */

    /*
     * This should never happen (because of the selection code in SelectJRE),
     * but check for "impossibly" long path names just because buffer overruns
     * can be so deadly.
     */
    if (strlen(wanted) + strlen(progname) + 10 > PATH_MAX) {
        fprintf(stderr, "Path length exceeds maximum length (PATH_MAX)\n");
        exit(1);
    }

    /*
     * Construct the path and exec it.
     */
    /*ibm@91094..*/
    wanted_len = strlen(wanted);
    (void)strcat(strcat(wanted, "/bin/"), progname);
    if (access(wanted, X_OK) != 0) {
        *(wanted+wanted_len) = '\0';
        (void)strcat(strcat(wanted, "/jre/bin/"), progname);
    }
    argv[0] = wanted;
    /*..ibm@91094*/
    if (_launcher_debug) {							/*ibm@88699*/
        int i;
        printf("execv(\"%s\"", wanted);
        for (i = 0; argv[i] != NULL; i++)
            printf(", \"%s\"", argv[i]);
        printf(")\n");
    }
    execv(wanted, argv);
    fprintf(stderr, "Exec of %s failed\n", wanted);
    exit(1);
}

/* ibm@88699
 * "Borrowed" from Solaris 10 where the unsetenv() function is being added
 * to libc thanks to SUSv3 (Standard Unix Specification, version 3). As
 * such, in the fullness of time this will appear in libc on all relevant
 * Solaris/Linux platforms and maybe even the Windows platform.  At that
 * time, this stub can be removed.
 *
 * This implementation removes the environment locking for multithreaded
 * applications.  (We don't have access to these mutexes within libc and
 * the launcher isn't multithreaded.)  Note that what remains is platform
 * independent, because it only relies on attributes that a POSIX environment
 * defines.
 *
 * Returns 0 on success, -1 on failure.
 *
 * Also removed was the setting of errno.  The only value of errno set
 * was EINVAL ("Invalid Argument").
 */

/*
 * s1(environ) is name=value
 * s2(name) is name(not the form of name=value).
 * if names match, return value of 1, else return 0
 */
static int
match_noeq(const char *s1, const char *s2)
{
	while (*s1 == *s2++) {
		if (*s1++ == '=')
			return (1);
	}
	if (*s1 == '=' && s2[-1] == '\0')
		return (1);
	return (0);
}

/* ibm@88699
 * added for SUSv3 standard
 *
 * Delete entry from environ.
 * Do not free() memory!  Other threads may be using it.
 * Keep it around forever.
 */
static int
borrowed_unsetenv(const char *name)
{
	long	idx;		/* index into environ */

	if (name == NULL || *name == '\0' ||
	    strchr(name, '=') != NULL) {
		return (-1);
	}

	for (idx = 0; environ[idx] != NULL; idx++) {
		if (match_noeq(environ[idx], name))
			break;
	}
	if (environ[idx] == NULL) {
		/* name not found but still a success */
		return (0);
	}
	/* squeeze up one entry */
	do {
		environ[idx] = environ[idx+1];
	} while (environ[++idx] != NULL);

	return (0);
}
/* --- End of "borrowed" code --- */

/* ibm@88699
 * Wrapper for unsetenv() function.
 */
int
UnsetEnv(char *name)
{
    return(borrowed_unsetenv(name));
}
/* ibm@88699
 * Return true if the named program exists
 */
static int
ProgramExists(char *name)
{
    struct stat sb;
    if (stat(name, &sb) != 0) return 0;
    if (S_ISDIR(sb.st_mode)) return 0;
    return (sb.st_mode & S_IEXEC) != 0;
}

/* ibm@88699
 * Find a command in a directory, returning the path.
 */
static char *
Resolve(char *indir, char *cmd)
{
    char name[PATH_MAX + 2], *real;

    if ((strlen(indir) + strlen(cmd) + 1)  > PATH_MAX) return 0;
    sprintf(name, "%s%c%s", indir, FILE_SEPARATOR, cmd);
    if (!ProgramExists(name)) return 0;
    real = MemAlloc(PATH_MAX + 2);
    if (!realpath(name, real)) 
	strcpy(real, name);
    return real;
}

/* ibm@88699
 * Find a path for the executable
 */
static char *
FindExecName(char *program)
{
    char cwdbuf[PATH_MAX+2];
    char *path;
    char *tmp_path;
    char *f;
    char *result = NULL;

    /* absolute path? */
    if (*program == FILE_SEPARATOR || 
	(FILE_SEPARATOR=='\\' && strrchr(program, ':')))
	return Resolve("", program+1);

    /* relative path? */
    if (strrchr(program, FILE_SEPARATOR) != 0) {
	char buf[PATH_MAX+2];
	return Resolve(getcwd(cwdbuf, sizeof(cwdbuf)), program);
    }

    /* from search path? */
    path = getenv("PATH");
    if (!path || !*path) path = ".";
    tmp_path = MemAlloc(strlen(path) + 2);
    strcpy(tmp_path, path);

    for (f=tmp_path; *f && result==0; ) {
	char *s = f;
	while (*f && (*f != PATH_SEPARATOR)) ++f;
	if (*f) *f++ = 0;
	if (*s == FILE_SEPARATOR)
	    result = Resolve(s, program);
	else {
	    /* relative path element */
	    char dir[2*PATH_MAX];
	    sprintf(dir, "%s%c%s", getcwd(cwdbuf, sizeof(cwdbuf)), 
		    FILE_SEPARATOR, s);
	    result = Resolve(dir, program);
	}
	if (result != 0) break;
    }

    free(tmp_path);
    return result;
}

/* Store the name of the executable once computed */
static char *execname = NULL;

/* ibm@88699
 * Compute the name of the executable
 *
 * In order to re-exec securely we need the absolute path of the
 * executable. On Solaris getexecname(3c) may not return an absolute
 * path so we use dladdr to get the filename of the executable and
 * then use realpath to derive an absolute path. From Solaris 9
 * onwards the filename returned in DL_info structure from dladdr is
 * an absolute pathname so technically realpath isn't required.
 * On Linux we read the executable name from /proc/self/exe.
 * As a fallback, and for platforms other than Solaris and Linux,
 * we use FindExecName to compute the executable name.
 */
static char *
SetExecname(char **argv)
{
    char* exec_path = NULL;

    if (execname != NULL)	/* Already determined */
	return (execname);
   
#if defined(__sun)
    {
        Dl_info dlinfo;
        if (dladdr((void*)&SetExecname, &dlinfo)) {
	    char *resolved = (char*)MemAlloc(PATH_MAX+1);
   	    if (resolved != NULL) {
		exec_path = realpath(dlinfo.dli_fname, resolved);
		if (exec_path == NULL) {
		    free(resolved);
		}
	    }
        }
    }
#elif defined(__linux__)
    {
	const char* self = "/proc/self/exe";
        char buf[PATH_MAX+1];
        int len = readlink(self, buf, PATH_MAX);
        if (len >= 0) {
	    buf[len] = '\0';		/* readlink doesn't nul terminate */
	    exec_path = strdup(buf);
	}
    }
#else /* !__sun && !__linux */
    {
        /* Not implemented */
    }
#endif 

    if (exec_path == NULL) {
        exec_path = FindExecName(argv[0]);
    }
    execname = exec_path;
    return exec_path;
}

/*ibm@88699 start*/
void ReportErrorMessage(char * message, jboolean always) {
  if (always) {
    fprintf(stderr, "%s\n", message);
  }
}

void ReportErrorMessage2(char * format, char * string, jboolean always) {
  if (always) {
    fprintf(stderr, format, string);
    fprintf(stderr, "\n");
  }
}

void  ReportExceptionDescription(JNIEnv * env) {
  (*env)->ExceptionDescribe(env);
}

jboolean RemovableMachineDependentOption(char * option) {
  /*
   * Unconditionally remove both -d32 and -d64 options since only
   * the last such options has an effect; e.g. 
   * java -d32 -d64 -d32 -version
   * is equivalent to 
   * java -d32 -version
   */

  if( (strcmp(option, "-d32")  == 0 ) || 
      (strcmp(option, "-d64")  == 0 ))
    return JNI_TRUE;
  else
    return JNI_FALSE;
}

/*ibm@88699 end*/
