/*
 * @(#)src/classes/sov/javax/swing/plaf/ListUI.java, swing, asdev, 20060428 1.15
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */

/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 74904  071004 chenerys  Upgrade to 5.0 Swing 
 *
 * ===========================================================================
 * Module Information:
 * 
 * DESCRIPTION: IBM.WRITEME
 * ===========================================================================
 */

/*
 * @(#)ListUI.java	1.12 03/12/19
 *
 */

package javax.swing.plaf;

import javax.swing.JList;
import java.awt.Point;
import java.awt.Rectangle;


/**
 * The JList pluggable look and feel delegate.  This interface adds
 * methods that allow the JList component to map locations, e.g. mouse
 * coordinates, to list cells and from cell indices to the bounds of 
 * the cell.
 *
 * @version 1.12 12/19/03
 * @author Hans Muller
 */

public abstract class ListUI extends ComponentUI
{
    /** 
     * Convert a point in <code>JList</code> coordinates to the closest index
     * of the cell at that location. To determine if the cell actually
     * contains the specified location use a combination of this method and
     * <code>getCellBounds</code>.  Returns -1 if the model is empty.
     * 
     * @param location The JList relative coordinates of the cell
     * @return The index of the cell at location, or -1.
     */
    public abstract int locationToIndex(JList list, Point location);


    /** 
     * Returns the origin of the specified item in JList
     * coordinates, null if index isn't valid.
     * 
     * @param index The index of the JList cell.
     * @return The origin of the index'th cell.
     */
    public abstract Point indexToLocation(JList list, int index);


    /** 
     * Returns the bounds of the specified item in JList
     * coordinates, null if index isn't valid.
     * 
     * @param index The index of the JList cell.
     * @return The bounds of the index'th cell.
     */
    public abstract Rectangle getCellBounds(JList list, int index1, int index2);
}
