/*
 * @(#)src/classes/sov/java/sql/Date.java, jdbc, asdev, 20060428 1.18
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */



/*
 * ===========================================================================
 * Change activity:
 *
 * Reason   Date   Origin   Description
 * ------   ------ -------- ----------------------------------------------------
 * 083215.1 110505 stalleyj Formate dates < 1000 correctly
 * 090776   030805 preece   Correct signatures
 * 102196   220306 kilnerm   Prevent cached values being returned following an update
 *
 */
 
 
/*
 * @(#)Date.java	1.33 04/05/18
 */

package java.sql;

import com.ibm.jvm.DateCache;                                      /*ibm@62015*/

/**
 * <P>A thin wrapper around a millisecond value that allows
 * JDBC to identify this as an SQL <code>DATE</code> value.  A 
 * milliseconds value represents the number of milliseconds that 
 * have passed since January 1, 1970 00:00:00.000 GMT.
 * <p>
 * To conform with the definition of SQL <code>DATE</code>, the 
 * millisecond values wrapped by a <code>java.sql.Date</code> instance 
 * must be 'normalized' by setting the 
 * hours, minutes, seconds, and milliseconds to zero in the particular
 * time zone with which the instance is associated.
 */
public class Date extends java.util.Date {

    static final long serialVersionUID = 1511598038487230103L;    /*ibm@59794*/

    private transient DateCache cache;                            /*ibm@59794*/

    /**
     * Constructs a <code>Date</code> object initialized with the given
     * year, month, and day.
     * <P>
     * The result is undefined if a given argument is out of bounds.
     *
     * @param year the year minus 1900; must be 0 to 8099. (Note that
     *        8099 is 9999 minus 1900.)
     * @param month 0 to 11
     * @param day 1 to 31
     * @deprecated instead use the constructor <code>Date(long date)</code>
     */
    @Deprecated
    public Date(int year, int month, int day) {
	super(year, month, day);
        cache = DateCache.ymd(year, month, day);                  /*ibm@59794*/
    }

    /**
     * Constructs a <code>Date</code> object using the given milliseconds 
     * time value.  If the given milliseconds value contains time 
     * information, the driver will set the time components to the
     * time in the default time zone (the time zone of the Java virtual
     * machine running the application) that corresponds to zero GMT.
     *
     * @param date milliseconds since January 1, 1970, 00:00:00 GMT not
     *        to exceed the milliseconds representation for the year 8099.
     *        A negative number indicates the number of milliseconds
     *        before January 1, 1970, 00:00:00 GMT.
     */
    public Date(long date) {
	// If the millisecond date value contains time info, mask it out.
	super(date);
	
    }

    /**
     * Sets an existing <code>Date</code> object 
     * using the given milliseconds time value. 
     * If the given milliseconds value contains time information, 
     * the driver will set the time components to the
     * time in the default time zone (the time zone of the Java virtual
     * machine running the application) that corresponds to zero GMT.
     *
     * @param date milliseconds since January 1, 1970, 00:00:00 GMT not
     *        to exceed the milliseconds representation for the year 8099.
     *        A negative number indicates the number of milliseconds
     *        before January 1, 1970, 00:00:00 GMT.
     */
    public void setTime(long date) {
	// If the millisecond date value contains time info, mask it out.
	super.setTime(date);	 
        cache = null;                                             /*ibm@59794*/
    }

    @Deprecated                                                   /*ibm@90776*/
    public int getYear()                                          /*ibm@59794*/
    {                                                             /*ibm@59794*/
        if (cache == null)                                        /*ibm@59794*/
       {                                                          /*ibm@59794*/
            return super.getYear();                               /*ibm@59794*/
        }                                                         /*ibm@59794*/
        else                                                      /*ibm@59794*/
        {                                                         /*ibm@59794*/
            return cache.year;                                    /*ibm@59794*/
        }                                                         /*ibm@59794*/
    }                                                             /*ibm@59794*/

    @Deprecated                                                   /*ibm@90776*/
    public int getMonth()                                         /*ibm@59794*/
    {                                                             /*ibm@59794*/
        if (cache == null)                                        /*ibm@59794*/
        {                                                         /*ibm@59794*/
            return super.getMonth();                              /*ibm@59794*/
        }                                                         /*ibm@59794*/
        else                                                      /*ibm@59794*/
        {                                                         /*ibm59794*/
            return cache.month;                                   /*ibm@59794*/
        }                                                         /*ibm@59794*/
    }                                                             /*ibm@59794*/

    @Deprecated                                                   /*ibm@90776*/
    public int getDate()                                          /*ibm@59794*/
    {                                                             /*ibm@59794*/
        if (cache == null)                                        /*ibm@59794*/
        {                                                         /*ibm@59794*/
            return super.getDate();                               /*ibm@59794*/
        }                                                         /*ibm@59794*/
        else                                                      /*ibm@59794*/
        {                                                         /*ibm@59794*/
            return cache.date;                                    /*ibm@59794*/
        }                                                         /*ibm@59794*/
    }                                                             /*ibm@59794*/

    /*ibm@102196 Starts*/
    @Deprecated
    public void setYear(int year)
    {
	cache = null;
	super.setYear(year);
    }

    @Deprecated
    public void setMonth(int month)
    {
        cache = null;
        super.setMonth(month);
    }

    @Deprecated
    public void setDate(int date)
    {
        cache = null;
        super.setDate(date);
    }
    /*ibm@102196 Ends*/

    /**
     * Converts a string in JDBC date escape format to
     * a <code>Date</code> value.
     *
     * @param s a <code>String</code> object representing a date in 
     *        in the format "yyyy-mm-dd"
     * @return a <code>java.sql.Date</code> object representing the
     *         given date
     * @throws IllegalArgumentException if the date given is not in the
     *         JDBC date escape format (yyyy-mm-dd)
     */
    public static Date valueOf(String s) {
	int year;
	int month;
	int day;
	int firstDash;
	int secondDash;

	if (s == null) throw new java.lang.IllegalArgumentException();

	firstDash = s.indexOf('-');
	secondDash = s.indexOf('-', firstDash+1);
	if ((firstDash > 0) & (secondDash > 0) & (secondDash < s.length()-1)) {
	    year = Integer.parseInt(s.substring(0, firstDash)) - 1900;
	    month = Integer.parseInt(s.substring(firstDash+1, secondDash)) - 1;
	    day = Integer.parseInt(s.substring(secondDash+1));	 
	} else {
	    throw new java.lang.IllegalArgumentException();
	}
			
	return new Date(year, month, day);
    }

    /**
     * Formats a date in the date escape format yyyy-mm-dd.  
     * <P>
     * NOTE:  To specify a date format for the class
     * <code>SimpleDateFormat</code>, use "yyyy.MM.dd" rather than
     * "yyyy-mm-dd".  In the context of <code>SimpleDateFormat</code>,
     * "mm" indicates minutes rather than the month.  
     * For example:
     * <PRE>
     *
     *  Format Pattern                         Result
     *  --------------                         -------
     *	"yyyy.MM.dd G 'at' hh:mm:ss z"    ->>  1996.07.10 AD at 15:08:56 PDT
     * </PRE>
     * @return a String in yyyy-mm-dd format
     */
    public String toString () {

        int year;                                                 /*ibm@59794*/
        int month;                                                /*ibm@59794*/
        int day;                                                  /*ibm@59794*/
        String yearString;
        String monthString;
        String dayString;

        if (cache == null)                                        /*ibm@59794*/
        {                                                         /*ibm@59794*/
            year = super.getYear() + 1900;                        /*ibm@59794*/
            month = super.getMonth() + 1;                         /*ibm@59794*/
            day = super.getDate();                                /*ibm@59794*/
        }                                                         /*ibm@59794*/
        else                                                      /*ibm@59794*/
        {                                                         /*ibm@59794*/
            year = cache.year + 1900;                             /*ibm@59794*/
            month = cache.month + 1;                              /*ibm@59794*/
            day = cache.date;                                     /*ibm@59794*/
        }                                                         /*ibm@59794*/

        if (year > 999) {                                         /*ibm@83215.1 starts*/
            yearString = Integer.toString(year);
        } else if (year > 99) {
            yearString = "0" + year;
        } else if (year > 9) {
            yearString = "00" + year;
        } else {
            yearString = "000" + year;
        }                                                         /*ibm@83215.1 ends*/

        if (month < 10)
        {
            monthString = "0" + month;
        }
        else
        {
            monthString = Integer.toString(month);
        }
        if (day < 10)
        {
            dayString = "0" + day;
        }
        else
        {
            dayString = Integer.toString(day);
        }

        return ( yearString + "-" + monthString + "-" + dayString);
    }

    // Override all the time operations inherited from java.util.Date;

   /**
    * This method is deprecated and should not be used because SQL Date 
    * values do not have a time component.
    *
    * @deprecated
    * @exception java.lang.IllegalArgumentException if this method is invoked
    * @see #setHours
    */
    @Deprecated
    public int getHours() {
	throw new java.lang.IllegalArgumentException();
    }

   /**
    * This method is deprecated and should not be used because SQL Date 
    * values do not have a time component.
    *
    * @deprecated
    * @exception java.lang.IllegalArgumentException if this method is invoked
    * @see #setMinutes
    */
    @Deprecated
    public int getMinutes() {
	throw new java.lang.IllegalArgumentException();
    }
    
   /**
    * This method is deprecated and should not be used because SQL Date 
    * values do not have a time component.
    *
    * @deprecated
    * @exception java.lang.IllegalArgumentException if this method is invoked
    * @see #setSeconds
    */
    @Deprecated
    public int getSeconds() {
	throw new java.lang.IllegalArgumentException();
    }

   /**
    * This method is deprecated and should not be used because SQL Date 
    * values do not have a time component.
    *
    * @deprecated
    * @exception java.lang.IllegalArgumentException if this method is invoked
    * @see #getHours
    */
    @Deprecated
    public void setHours(int i) {
	throw new java.lang.IllegalArgumentException();
    }

   /**
    * This method is deprecated and should not be used because SQL Date 
    * values do not have a time component.
    *
    * @deprecated
    * @exception java.lang.IllegalArgumentException if this method is invoked
    * @see #getMinutes
    */
    @Deprecated
    public void setMinutes(int i) {
	throw new java.lang.IllegalArgumentException();
    }

   /**
    * This method is deprecated and should not be used because SQL Date 
    * values do not have a time component.
    *
    * @deprecated
    * @exception java.lang.IllegalArgumentException if this method is invoked
    * @see #getSeconds
    */
    @Deprecated
    public void setSeconds(int i) {
	throw new java.lang.IllegalArgumentException();
    }
}

