/*
 * @(#)src/classes/sov/java/nio/charset/UnsupportedCharsetException.java, i18n, asdev, 20060428 1.4
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */




/*
 * ===========================================================================
 * Change activity:
 *
 * Reason  Date   Origin  Description
 * ------  ----   ------  ----------------------------------------------------
 * 061774  030603 pabbott Remove autogeneration of NIO source files.
 *
 */

package java.nio.charset;

/**
 * Unchecked exception thrown when no support is available
 * for a requested charset.
 *
 * @version 1.2, 01/09/17
 * @since 1.4
 */

public class UnsupportedCharsetException extends IllegalArgumentException {

   private String charsetName;

   /**
    * Constructs an instance of this class. </p>
    *
    * @param  charsetName
    *         The name of the unsupported charset
    */
   public UnsupportedCharsetException(String charsetName) {
      super(String.valueOf(charsetName));
      this.charsetName = charsetName;
   }

   /**
    * Retrieves the name of the unsupported charset. </p>
    *
    * @return  The name of the unsupported charset
    */
   public String getCharsetName() {
      return charsetName;
   }

}
