/*
 * @(#)src/classes/sov/java/beans/beancontext/BeanContextServicesListener.java, bean, asdev, 20060428 1.11
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */

/*
 * @(#)BeanContextServicesListener.java	1.9 03/12/19
 *
 */

package java.beans.beancontext;

import java.beans.beancontext.BeanContextServiceAvailableEvent;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServiceRevokedListener;

/**
 * The listener interface for receiving 
 * <code>BeanContextServiceAvailableEvent</code> objects. 
 * A class that is interested in processing a 
 * <code>BeanContextServiceAvailableEvent</code> implements this interface. 
 */
public interface BeanContextServicesListener extends BeanContextServiceRevokedListener {

    /**
     * The service named has been registered. getService requests for
     * this service may now be made.
     * @param bcsae the <code>BeanContextServiceAvailableEvent</code> 
     */
    void serviceAvailable(BeanContextServiceAvailableEvent bcsae);
}
