<?xml version="1.0" encoding="UTF-8"?> 
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" indent="yes" omit-xml-declaration="yes" doctype-system="applied.dtd"/>


<!-- Parameter declaration begin -->

<!-- xsl:param name="wasinstallroot"/ -->
<xsl:param name="fileseparator"/>
<xsl:param name="logdirpath"/>
<xsl:param name="backupdirpath"/>

<xsl:param name="notapplicable">
    <xsl:text>not applicable</xsl:text>
</xsl:param>
<xsl:param name="update_type_replace">
    <xsl:text>replace</xsl:text>
</xsl:param>

<!-- Parameter declaration end -->

    <xsl:template name="ptf_driver" match="maintenance-history">
        <xsl:for-each select="maintenance">
            <xsl:variable name="maintenance_name" select="@name"/>
            <xsl:variable name="package_filename">
                <xsl:for-each select="param[@name='filename']">
                    <xsl:value-of select="@value"/>
                </xsl:for-each>
            </xsl:variable>
            <xsl:variable name="base_file_name">
                <xsl:value-of select="substring-before($package_filename,'.pak')"/>
            </xsl:variable>
            <xsl:variable name="description">
                <xsl:for-each select="param[@name='info']">
                    <xsl:value-of select="@value"/>
                </xsl:for-each>
            </xsl:variable>
            <xsl:variable name="build_date">
                <xsl:for-each select="param[@name='builddate']">
                    <xsl:value-of select="@value"/>
                </xsl:for-each>
            </xsl:variable>
            <xsl:variable name="update_type">
                <xsl:value-of select="$update_type_replace"/>
            </xsl:variable> 
            <xsl:variable name="isofficialfix">
                <xsl:for-each select="param[@name='isofficialfix']">
                    <xsl:value-of select="@value"/>
                </xsl:for-each>
            </xsl:variable>
                
            <xsl:element name="ptf-driver">
                <xsl:attribute name="id">
                    <xsl:value-of select="$base_file_name"/>
                </xsl:attribute>
                <xsl:attribute name="short-description">
                    <xsl:value-of select="$description"/>
                </xsl:attribute>
                <xsl:attribute name="build-date">
                    <xsl:value-of select="$build_date"/>
                </xsl:attribute>
                
                <xsl:for-each select="param[@name='component']">
                    <xsl:element name="component-update">
                        <xsl:attribute name="component-name">
                            <xsl:value-of select="@value"/>
                        </xsl:attribute>
                        <xsl:attribute name="update-type">
                            <xsl:value-of select="$update_type"/>
                        </xsl:attribute>
                        <xsl:attribute name="primary-content">
                            <xsl:value-of select="$package_filename"/>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:for-each>
                
                <xsl:for-each select="param[@name='apar']">
                    <xsl:element name="included-efix">
                        <xsl:attribute name="efix-id">
                            <xsl:value-of select="@value"/>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:for-each>
            </xsl:element>    
        </xsl:for-each>
    </xsl:template>
</xsl:stylesheet>
                        
                
                