/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.AlgorithmStatus;
import com.ibm.crypto.fips.provider.DSAPrivateKey;
import com.ibm.crypto.fips.provider.DSAPublicKey;
import com.ibm.crypto.fips.provider.FIPSRuntimeException;
import com.ibm.crypto.fips.provider.SelfTest;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class DSAKeyFactory
extends KeyFactorySpi
implements AlgorithmStatus {
    public boolean isFipsApproved() {
        return true;
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (SelfTest.isFipsRunnable()) {
            return this.a(keySpec);
        }
        throw new FIPSRuntimeException();
    }

    protected PrivateKey a(KeySpec keySpec) throws InvalidKeySpecException {
        block6: {
            try {
                if (keySpec instanceof DSAPrivateKeySpec) {
                    DSAPrivateKeySpec dSAPrivateKeySpec = (DSAPrivateKeySpec)keySpec;
                    BigInteger bigInteger = dSAPrivateKeySpec.getP();
                    BigInteger bigInteger2 = dSAPrivateKeySpec.getQ();
                    BigInteger bigInteger3 = dSAPrivateKeySpec.getG();
                    BigInteger bigInteger4 = dSAPrivateKeySpec.getX();
                    try {
                        return new DSAPrivateKey(bigInteger4, bigInteger, bigInteger2, bigInteger3);
                    }
                    catch (Exception exception) {
                        break block6;
                    }
                }
                if (keySpec instanceof PKCS8EncodedKeySpec) {
                    return new DSAPrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                }
                throw new InvalidKeySpecException(DSAKeyFactory.a("\b \u0003|\b(*Uv\u00018n\u0006m\u0001\""));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidKeySpecException(DSAKeyFactory.a("\b \u0003|\b(*Uv\u00018n\u0006m\u0001\"tU") + invalidKeyException);
            }
        }
        return null;
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (SelfTest.isFipsRunnable()) {
            return this.b(keySpec);
        }
        throw new FIPSRuntimeException();
    }

    protected PublicKey b(KeySpec keySpec) throws InvalidKeySpecException {
        block6: {
            try {
                if (keySpec instanceof DSAPublicKeySpec) {
                    DSAPublicKeySpec dSAPublicKeySpec = (DSAPublicKeySpec)keySpec;
                    BigInteger bigInteger = dSAPublicKeySpec.getP();
                    BigInteger bigInteger2 = dSAPublicKeySpec.getQ();
                    BigInteger bigInteger3 = dSAPublicKeySpec.getG();
                    BigInteger bigInteger4 = dSAPublicKeySpec.getY();
                    try {
                        return new DSAPublicKey(bigInteger4, bigInteger, bigInteger2, bigInteger3);
                    }
                    catch (Exception exception) {
                        break block6;
                    }
                }
                if (keySpec instanceof X509EncodedKeySpec) {
                    return new DSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
                }
                throw new InvalidKeySpecException(DSAKeyFactory.a("\b \u0003|\b(*Uv\u00018n\u0006m\u0001\""));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidKeySpecException(DSAKeyFactory.a("\b \u0003|\b(*Uv\u00018n\u0006m\u0001\"tU") + invalidKeyException);
            }
        }
        return null;
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (SelfTest.isFipsRunnable()) {
            return this.a(key, clazz);
        }
        throw new FIPSRuntimeException();
    }

    protected KeySpec a(Key key, Class clazz) throws InvalidKeySpecException {
        try {
            if (key instanceof java.security.interfaces.DSAPublicKey) {
                Class<?> clazz2 = Class.forName(DSAKeyFactory.a("+/\u0003|J2+\u0016h\u0016(:\f3\u00171+\u00163 \u0012\u000f%h\u0006-'\u0016V\u00018\u001d\u0005x\u0007"));
                Class<?> clazz3 = Class.forName(DSAKeyFactory.a("+/\u0003|J2+\u0016h\u0016(:\f3\u00171+\u00163<t~LX\n\"!\u0011x\u0000\n+\fN\u0014$-"));
                if (clazz2.isAssignableFrom(clazz)) {
                    java.security.interfaces.DSAPublicKey dSAPublicKey = (java.security.interfaces.DSAPublicKey)key;
                    DSAParams dSAParams = dSAPublicKey.getParams();
                    return new DSAPublicKeySpec(dSAPublicKey.getY(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
                }
                if (clazz3.isAssignableFrom(clazz)) {
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException(DSAKeyFactory.a("\b \u0014m\u00143!\u0005o\r :\u0010=\u000f$7Un\u0014$-\u001c{\r\"/\u0001t\u000b/"));
            }
            if (key instanceof java.security.interfaces.DSAPrivateKey) {
                Class<?> clazz4 = Class.forName(DSAKeyFactory.a("+/\u0003|J2+\u0016h\u0016(:\f3\u00171+\u00163 \u0012\u000f%o\r7/\u0001x/$7&m\u0001\""));
                Class<?> clazz5 = Class.forName(DSAKeyFactory.a("+/\u0003|J2+\u0016h\u0016(:\f3\u00171+\u001634\n\r&%!/-\u001ay\u0001%\u0005\u0010d71+\u0016"));
                if (clazz4.isAssignableFrom(clazz)) {
                    java.security.interfaces.DSAPrivateKey dSAPrivateKey = (java.security.interfaces.DSAPrivateKey)key;
                    DSAParams dSAParams = dSAPrivateKey.getParams();
                    return new DSAPrivateKeySpec(dSAPrivateKey.getX(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
                }
                if (clazz5.isAssignableFrom(clazz)) {
                    return new PKCS8EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException(DSAKeyFactory.a("\b \u0014m\u00143!\u0005o\r :\u0010=\u000f$7Un\u0014$-\u001c{\r\"/\u0001t\u000b/"));
            }
            throw new InvalidKeySpecException(DSAKeyFactory.a("\b \u0014m\u00143!\u0005o\r :\u0010=\u000f$7Ui\u001d1+"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidKeySpecException(DSAKeyFactory.a("\u0014 \u0006h\u00141!\u0007i\u0001%n\u001ex\u001da=\u0005x\u0007((\u001c~\u00055'\u001as^a") + classNotFoundException.getMessage());
        }
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException(DSAKeyFactory.a("\n+\f=\u0013 =Us\u0011-\""));
        }
        if (key instanceof java.security.interfaces.DSAPublicKey || key instanceof java.security.interfaces.DSAPrivateKey) {
            return key;
        }
        throw new InvalidKeyException(DSAKeyFactory.a("\n+\f=\u0013 =Us\u0011-\""));
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl = true;
        block6: do {
            if (bl && !(bl = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 65;
                        break;
                    }
                    case 1: {
                        n5 = 78;
                        break;
                    }
                    case 2: {
                        n5 = 117;
                        break;
                    }
                    case 3: {
                        n5 = 29;
                        break;
                    }
                    default: {
                        n5 = 100;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

