/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.Record;
import com.ibm.security.cmskeystore.RecordHashGenerator;
import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory;
import com.ibm.security.sequence.bytes.ByteSequenceIterator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class RecordHashGeneratorFactory {
    private RecordHashGeneratorFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static RecordHashGenerator newRecordHashGenerator() {
        return new RecordHashGeneratorImpl();
    }

    private static final class RecordHashGeneratorImpl
    implements RecordHashGenerator {
        RecordHashGeneratorImpl() {
        }

        public ByteSequence generateHash(Record record, ByteSequence password) throws NullPointerException, NoSuchAlgorithmException {
            if (record == null || password == null) {
                throw new NullPointerException();
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            ByteSequenceIterator i = record.getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = password.getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            byte[] digest = md.digest();
            return ByteSequenceFactory.newByteSequence(digest);
        }
    }
}

