/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.x509.IPAddressName;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

class KMUtil {
    public static boolean printDebugMsg = false;
    public static String defaultDebugDumpFileName = "ikmgdbg.log";
    public static FileOutputStream debugDumpOutputStream = null;
    public static PrintWriter debugPrintWriter;
    private static int msgIndent;

    KMUtil() {
    }

    public static String changeFileNameExtension(String fileName, String frmExt, String toExt) {
        if (fileName == null || frmExt == null || toExt == null) {
            return null;
        }
        if (frmExt.length() == 0 || toExt.length() == 0) {
            return null;
        }
        String newFileName = null;
        if (!fileName.endsWith(frmExt)) {
            newFileName = fileName + toExt;
        } else {
            int extStartPos = fileName.length() - frmExt.length();
            if (extStartPos < 1) {
                return null;
            }
            newFileName = fileName.substring(0, extStartPos) + toExt;
        }
        return newFileName;
    }

    public static String changeFileNameExtension(String fileName, String toExt) {
        if (fileName == null || toExt == null) {
            return null;
        }
        if (toExt.length() == 0) {
            return null;
        }
        String newFileName = null;
        int extStartPos = fileName.lastIndexOf(46);
        newFileName = extStartPos < 0 ? fileName + toExt : fileName.substring(0, extStartPos) + toExt;
        return newFileName;
    }

    public static synchronized String getTmpFileName(String fileName, String tmpExt, String restrictNameExt) {
        if (tmpExt == null || tmpExt.length() == 0) {
            return null;
        }
        String tmpFileName = fileName + tmpExt;
        boolean tmpFileNameFound = false;
        do {
            String restrictFileName;
            File frestrictFile;
            File file = new File(tmpFileName);
            if (restrictNameExt != null && !restrictNameExt.equals("") && (frestrictFile = new File(restrictFileName = KMUtil.changeFileNameExtension(tmpFileName, tmpExt, restrictNameExt))).exists()) {
                tmpFileName = tmpFileName + tmpExt;
                continue;
            }
            if (file.exists()) {
                tmpFileName = tmpFileName + tmpExt;
                continue;
            }
            tmpFileNameFound = true;
            break;
        } while (!tmpFileNameFound);
        return tmpFileName;
    }

    public static synchronized String getTmpFileName(String fileName, String tmpExt) {
        return KMUtil.getTmpFileName(fileName, tmpExt, null);
    }

    public static String formatBinaryDataWithColon(byte[] data) {
        String output = "- not computed -";
        if (data == null || data.length > 24) {
            return output;
        }
        StringBuffer strbuf = new StringBuffer(48);
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                strbuf.append(':');
            }
            byte b = data[i];
            strbuf.append("0123456789ABCDEF".charAt(b >> 4 & 0xF));
            strbuf.append("0123456789ABCDEF".charAt(b & 0xF));
        }
        output = strbuf.toString();
        return output;
    }

    public static String getDigest(byte[] data, String digestMethod) {
        String fingerPrint = null;
        try {
            MessageDigest md = MessageDigest.getInstance(digestMethod);
            byte[] fingerPrintData = md.digest(data);
            fingerPrint = KMUtil.formatBinaryDataWithColon(fingerPrintData);
        }
        catch (NoSuchAlgorithmException e1) {
            fingerPrint = "- the given digest algorithm is not supported -";
        }
        catch (Exception e2) {
            fingerPrint = "- not computed -";
        }
        return fingerPrint;
    }

    public static String getMD2(byte[] data) {
        return KMUtil.getDigest(data, "MD2");
    }

    public static String getMD5(byte[] data) {
        return KMUtil.getDigest(data, "MD5");
    }

    public static String getSHA1(byte[] data) {
        return KMUtil.getDigest(data, "SHA-1");
    }

    public static String getSHA(byte[] data) {
        return KMUtil.getDigest(data, "SHA");
    }

    public static int greater(int i, int j) {
        return i >= j ? i : j;
    }

    public static int max(int[] nums) {
        if (nums == null) {
            return 0;
        }
        return KMUtil.max(nums, nums.length);
    }

    public static int max(int[] nums, int numCnt) {
        int cnt = nums.length;
        if (cnt == 0) {
            return 0;
        }
        if (cnt == 1 || numCnt <= 1) {
            return nums[0];
        }
        return KMUtil.greater(KMUtil.max(nums, numCnt - 1), nums[numCnt - 1]);
    }

    public static String trimBlankSpace(String s) {
        return KMUtil.trimBlankSpace(s, true, true);
    }

    public static String trimBlankSpace(String s, boolean trimLeading, boolean trimTrailing) {
        if (!trimLeading && !trimTrailing) {
            return s;
        }
        if (s == null || s.length() == 0) {
            return null;
        }
        String trimmed = null;
        int len = s.length();
        if (trimLeading && trimTrailing) {
            trimmed = s.trim();
            if (trimmed.length() == 0) {
                trimmed = null;
            }
        } else if (trimLeading) {
            int nonLeadBlankPos;
            for (nonLeadBlankPos = 0; nonLeadBlankPos < len && s.charAt(nonLeadBlankPos) == ' '; ++nonLeadBlankPos) {
            }
            trimmed = nonLeadBlankPos == len ? null : s.substring(nonLeadBlankPos, len);
        } else if (trimTrailing) {
            int nonTrailBlankPos;
            for (nonTrailBlankPos = len - 1; nonTrailBlankPos >= 0 && s.charAt(nonTrailBlankPos) == ' '; --nonTrailBlankPos) {
            }
            trimmed = nonTrailBlankPos == -1 ? null : s.substring(0, nonTrailBlankPos + 1);
        }
        return trimmed;
    }

    public static boolean isValidFileName(String fileName) {
        boolean b = false;
        if (fileName != null) {
            File currPathFile = new File(fileName);
            try {
                if (currPathFile.getCanonicalPath() != null) {
                    b = true;
                }
            }
            catch (IOException e) {
                b = false;
            }
        }
        return b;
    }

    public static String getFullPathFileName(String fileName) {
        KMUtil.debugMsg("KMUtil::getFullPathFileName() 0000, fileName=" + fileName);
        String fullPathName = null;
        if (fileName != null) {
            File currPathFile = new File(fileName);
            try {
                fullPathName = currPathFile.getCanonicalPath();
                if (currPathFile.isDirectory() && !fullPathName.endsWith(File.separator)) {
                    fullPathName = fullPathName + File.separator;
                }
            }
            catch (IOException e) {
                fullPathName = null;
            }
        }
        KMUtil.debugMsg("KMUtil::getFullPathFileName() 9999");
        return fullPathName;
    }

    public static String toStringObjectArray(Object[] aObj) {
        if (aObj == null) {
            return "";
        }
        String retStr = "";
        for (int i = 0; i < aObj.length; ++i) {
            retStr = retStr + i + "." + aObj[i] + " ";
        }
        return retStr;
    }

    public static String toStringVector(Vector aVector) {
        if (aVector == null) {
            return "<null vector>";
        }
        String retStr = "";
        String tmp = null;
        Enumeration enumeration = aVector.elements();
        while (enumeration.hasMoreElements()) {
            tmp = (String)enumeration.nextElement();
            tmp = tmp == null ? "null" : tmp;
            retStr = retStr + ", " + tmp;
        }
        return retStr;
    }

    public static void createTmpFilefrmBuffer(String fullPathCAFileName, byte[] fbuffer) {
        File caFile = new File(fullPathCAFileName);
        FileOutputStream fouts = null;
        try {
            fouts = new FileOutputStream(caFile);
            fouts.write(fbuffer);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (fouts != null) {
            try {
                fouts.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
    }

    public static void debugMsg(String s) {
        if (msgIndent < 0) {
            msgIndent = 0;
        }
        if (s.indexOf("9999") != -1) {
            msgIndent -= 2;
            s = "<<" + s;
        } else if (s.indexOf("0000") != -1) {
            s = ">>" + s;
        }
        for (int i = 0; i < msgIndent; ++i) {
            s = " " + s;
        }
        if (s.indexOf("0000") != -1) {
            msgIndent += 2;
        }
        if (printDebugMsg) {
            if (debugDumpOutputStream != null && debugPrintWriter != null) {
                debugPrintWriter.println(s);
            } else {
                System.out.println(s);
            }
        }
    }

    public static void closeDebugDumpFile() {
        if (debugDumpOutputStream != null && debugPrintWriter != null) {
            debugPrintWriter.close();
            try {
                debugDumpOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        debugDumpOutputStream = null;
        debugPrintWriter = null;
    }

    public static void initDebugMsg(String aFileName) {
        printDebugMsg = true;
        defaultDebugDumpFileName = aFileName;
        try {
            debugDumpOutputStream = new FileOutputStream(aFileName);
            debugPrintWriter = new PrintWriter(debugDumpOutputStream, true);
        }
        catch (IOException e) {
            if (debugDumpOutputStream != null) {
                try {
                    debugDumpOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            debugDumpOutputStream = null;
            debugPrintWriter = null;
        }
    }

    public static boolean isDBCSString(String s) {
        char[] charFromString = s.toCharArray();
        boolean bDBCS = false;
        for (int p = 0; p < charFromString.length; ++p) {
            if (charFromString[p] == '\u20a9') {
                bDBCS = false;
            }
            if (!('\u0080' <= charFromString[p] && charFromString[p] <= '\u00a1' || '\u00a4' == charFromString[p] || '\u00a7' <= charFromString[p] && charFromString[p] <= '\u00ab' || '\u00ad' <= charFromString[p] && charFromString[p] <= '\u00ae' || '\u0600' <= charFromString[p] && charFromString[p] <= '\u06ff' || '\u0f00' <= charFromString[p] && charFromString[p] <= '\u0fff' || '\u1100' <= charFromString[p] && charFromString[p] <= '\u11ff' || '\u1800' <= charFromString[p] && charFromString[p] <= '\u18ff' || '\u1e00' <= charFromString[p] && charFromString[p] <= '\u27bf' || '\u2ff0' <= charFromString[p] && charFromString[p] <= '\u2ffb' || '\u3000' <= charFromString[p] && charFromString[p] <= '\u33ff' || '\u3400' <= charFromString[p] && charFromString[p] <= '\u4dff' || '\u4e00' <= charFromString[p] && charFromString[p] <= '\u9fa5' || '\ua000' <= charFromString[p] && charFromString[p] <= '\ua4ff' || '\uac00' <= charFromString[p] && charFromString[p] <= '\ud7a3' || '\ue000' <= charFromString[p] && charFromString[p] <= '\uf86f' || '\uf900' <= charFromString[p] && charFromString[p] <= '\ufb4f' || '\ufb50' <= charFromString[p] && charFromString[p] <= '\ufdff' || '\ufe20' <= charFromString[p] && charFromString[p] <= '\ufe6f' || '\ufe70' <= charFromString[p] && charFromString[p] <= '\ufeff' || '\uff00' <= charFromString[p] && charFromString[p] <= '\uff5f' || '\uffe0' <= charFromString[p] && charFromString[p] <= '\uffe6') && ('\ufff0' > charFromString[p] || charFromString[p] > '\uffff')) continue;
            bDBCS = true;
        }
        return bDBCS;
    }

    public static boolean isInvalidIPAddressValid(String s) {
        boolean ipinvalid = true;
        try {
            StringTokenizer st = new StringTokenizer(s, ".");
            if (st.countTokens() != 0 && st.countTokens() >= 5) {
                KMUtil.debugMsg("KMUtil::isIPAddressValid(1 args) 0000, st.countTokens()= " + st.countTokens());
                throw new Exception("JCE defect");
            }
            IPAddressName a = new IPAddressName(s);
            ipinvalid = false;
        }
        catch (Exception e) {
            ipinvalid = true;
            KMUtil.debugMsg("KMUtil::isIPAddressValid(1 args) 0000, input ip= " + s + ", with exception= " + e.toString());
        }
        return ipinvalid;
    }

    static {
        msgIndent = 0;
    }
}

