/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.FileHeader;
import com.ibm.security.cmskeystore.FileHeaderHashGenerator;
import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory;
import com.ibm.security.sequence.bytes.ByteSequenceIterator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class FileHeaderHashGeneratorFactory {
    private FileHeaderHashGeneratorFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static FileHeaderHashGenerator newFileHeaderHashGenerator() {
        return new FileHeaderHashGeneratorImpl();
    }

    private static final class FileHeaderHashGeneratorImpl
    implements FileHeaderHashGenerator {
        FileHeaderHashGeneratorImpl() {
        }

        public ByteSequence generateHash(FileHeader header, ByteSequence password) throws NullPointerException, NoSuchAlgorithmException {
            if (header == null || password == null) {
                throw new NullPointerException();
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            ByteSequenceIterator i = header.getMagicNumber().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getMajorVersionNumber().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getMinorVersionNumber().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getPasswordExpirationTime().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getFileType().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getFixedRecordLength().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getRecordsAllocated().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getFileLabel().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = password.getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            byte[] digest = md.digest();
            return ByteSequenceFactory.newByteSequence(digest);
        }
    }
}

