/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.BERObject;
import com.ibm.security.cmskeystore.BERObjectParser;
import com.ibm.security.cmskeystore.DNItem;
import com.ibm.security.cmskeystore.KMUtil;
import java.util.Date;

class CertificateItem
extends BERObject
implements BERObjectParser {
    public static final short X509V1 = 1;
    public static final short X509V2 = 2;
    public static final short X509V3 = 3;
    public static final String[] CERTIFICATE_VERSIONS = new String[]{"X509 V1", "X509 V2", "X509 V3"};
    private short version;
    private short keySize;
    private String serialNum;
    private DNItem issuer;
    private DNItem subject;
    private Date validNotBefore;
    private Date validNotAfter;
    private byte[] signature;
    private BERObject sigAlgIdBER;
    private String sigAlgIdOID;
    private String sigAlgIdOIDName;
    private BERObject spkiBER;
    private BERObject certExtensionsBER;
    private boolean isIssuerUniIdPresent;
    private boolean isSubjUniIdPresent;
    private boolean isExtsPresent;
    private byte[] unsignedCert;

    public CertificateItem(byte[] berData) {
        super(berData);
    }

    public CertificateItem() {
        this(1, 0, (String)null, (DNItem)null, (DNItem)null, null, null, (BERObject)null, (BERObject)null, (byte[])null, (BERObject)null, (String)null, (String)null, (byte[])null, (byte[])null);
    }

    public CertificateItem(short version, short keySize, String serialNumber, DNItem issuerName, DNItem subjectName, Date effectDate, Date expDate, BERObject spkiBER, BERObject certExtsBER, byte[] sig, BERObject sigAlgIdBER, String sigAlgIdOID, String sigAlgIdOIDName) {
        this(version, keySize, serialNumber, issuerName, subjectName, effectDate, expDate, spkiBER, certExtsBER, sig, sigAlgIdBER, sigAlgIdOID, sigAlgIdOIDName, (byte[])null, (byte[])null);
        this.collapse();
    }

    public CertificateItem(short version, short keySize, String serialNumber, DNItem issuerName, DNItem subjectName, Date effectDate, Date expDate, BERObject spkiBER, BERObject certExtsBER, byte[] sig, BERObject sigAlgIdBER, String sigAlgIdOID, String sigAlgIdOIDName, byte[] encodedBER) {
        this(version, keySize, serialNumber, issuerName, subjectName, effectDate, expDate, spkiBER, certExtsBER, sig, sigAlgIdBER, sigAlgIdOID, sigAlgIdOIDName, (byte[])null, encodedBER);
    }

    public CertificateItem(short version, short keySize, String serialNumber, DNItem issuerName, DNItem subjectName, long effectDateTime, long expireDateTime, BERObject spkiBER, BERObject certExtsBER, byte[] sig, BERObject sigAlgIdBER, String sigAlgIdOID, String sigAlgIdOIDName, byte[] unsignedCertBER, byte[] encodedBER) {
        this(version, keySize, serialNumber, issuerName, subjectName, new Date(effectDateTime * 1000L), new Date(expireDateTime * 1000L), spkiBER, certExtsBER, sig, sigAlgIdBER, sigAlgIdOID, sigAlgIdOIDName, unsignedCertBER, encodedBER);
    }

    public CertificateItem(short version, short keySize, String serialNumber, DNItem issuerName, DNItem subjectName, Date effectDate, Date expDate, BERObject spkiBER, BERObject certExtsBER, byte[] sig, BERObject sigAlgIdBER, String sigAlgIdOID, String sigAlgIdOIDName, byte[] unsignedCertBER, byte[] encodedBER) {
        this.version = version;
        this.keySize = keySize;
        this.serialNum = serialNumber;
        this.issuer = issuerName;
        this.subject = subjectName;
        this.validNotBefore = effectDate != null ? new Date(effectDate.getTime()) : null;
        this.validNotAfter = expDate != null ? new Date(expDate.getTime()) : null;
        if (sig == null) {
            this.signature = null;
        } else {
            this.signature = new byte[sig.length];
            System.arraycopy(sig, 0, this.signature, 0, sig.length);
        }
        this.sigAlgIdBER = sigAlgIdBER;
        this.sigAlgIdOID = sigAlgIdOID;
        this.sigAlgIdOIDName = sigAlgIdOIDName;
        this.spkiBER = spkiBER;
        this.certExtensionsBER = certExtsBER;
        this.isIssuerUniIdPresent = false;
        this.isSubjUniIdPresent = false;
        this.isExtsPresent = this.certExtensionsBER != null;
        if (unsignedCertBER == null) {
            this.unsignedCert = null;
        } else {
            this.unsignedCert = new byte[unsignedCertBER.length];
            System.arraycopy(unsignedCertBER, 0, this.unsignedCert, 0, unsignedCertBER.length);
        }
        this.setEncoded(encodedBER);
    }

    public void expand() {
    }

    public void collapse() {
        this.berData = null;
    }

    public String getFingerPrint() {
        String fingerPrint = "- not computed -";
        if (this.berData != null) {
            fingerPrint = KMUtil.getSHA1(this.berData);
        }
        return fingerPrint;
    }

    public short getVersion() {
        return this.version;
    }

    public short getKeySize() {
        return this.keySize;
    }

    public String getSerialNumber() {
        return this.serialNum;
    }

    public DNItem getIssuer() {
        return this.issuer;
    }

    public DNItem getSubject() {
        return this.subject;
    }

    public void setSubject(DNItem subject) {
        this.subject = subject;
    }

    public Date getValidNotBefore() {
        return this.validNotBefore;
    }

    public Date getValidNotAfter() {
        return this.validNotAfter;
    }

    public boolean isExpired() {
        boolean expired = false;
        if (this.validNotAfter != null && this.validNotAfter.before(new Date())) {
            expired = true;
        }
        return expired;
    }

    public BERObject getSubjectPublicKeyInfoBER() {
        return this.spkiBER;
    }

    public BERObject getCertificateExtensions() {
        return this.certExtensionsBER;
    }

    public byte[] getUnsignedCert() {
        return this.unsignedCert;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public String getSigAlgorithmIdOID() {
        return this.sigAlgIdOID;
    }

    public String getSigAlgorithmIdOIDName() {
        return this.sigAlgIdOIDName;
    }

    public boolean isIssuerUniqueIdPresent() {
        return this.isIssuerUniIdPresent;
    }

    public boolean isSubjUniqueIdPresent() {
        return this.isSubjUniIdPresent;
    }

    public boolean isExtensionsPresent() {
        return this.isExtsPresent;
    }

    public String toString() {
        return this.paramString();
    }

    public String paramString() {
        String subjectStr = this.subject == null ? "null" : this.subject.toString();
        String issuerStr = this.issuer == null ? "null" : this.issuer.toString();
        try {
            return super.toString() + ", version=" + CERTIFICATE_VERSIONS[this.version - 1] + ", serialNum=" + this.serialNum + ", keySize=" + this.keySize + ", subject" + this.subject + ", issuer=" + this.issuer + ", validity=[" + this.validNotBefore + ", " + this.validNotAfter + "], signatureAlgorithm=" + this.sigAlgIdOIDName + "(" + this.sigAlgIdOID + "), extensions=" + this.certExtensionsBER;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
        return null;
    }
}

