/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.Buffer;
import com.ibm.security.cmskeystore.BufferFactory;
import com.ibm.security.cmskeystore.ByteSequenceXorFactory;
import com.ibm.security.cmskeystore.CACertificates;
import com.ibm.security.cmskeystore.CMSLoadParameter;
import com.ibm.security.cmskeystore.CMSStoreParameter;
import com.ibm.security.cmskeystore.DatabaseHashGeneratorFactory;
import com.ibm.security.cmskeystore.FileHeader;
import com.ibm.security.cmskeystore.FileHeaderFactory;
import com.ibm.security.cmskeystore.FileHeaderHashGeneratorFactory;
import com.ibm.security.cmskeystore.FileType;
import com.ibm.security.cmskeystore.IntableByteSequence;
import com.ibm.security.cmskeystore.IntableByteSequenceFactory;
import com.ibm.security.cmskeystore.KeyDatabase;
import com.ibm.security.cmskeystore.KeyDatabaseFactory;
import com.ibm.security.cmskeystore.MagicNumberValidatorFactory;
import com.ibm.security.cmskeystore.QueryableKeyDatabase;
import com.ibm.security.cmskeystore.QueryableKeyDatabaseFactory;
import com.ibm.security.cmskeystore.Record;
import com.ibm.security.cmskeystore.RecordDataHashGenerator;
import com.ibm.security.cmskeystore.RecordDataHashGeneratorFactory;
import com.ibm.security.cmskeystore.RecordEncoding;
import com.ibm.security.cmskeystore.RecordEncodingFactory;
import com.ibm.security.cmskeystore.RecordFactory;
import com.ibm.security.cmskeystore.RecordFlag;
import com.ibm.security.cmskeystore.StashedPasswordProtection;
import com.ibm.security.cmskeystore.VersionNumber;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.sequence.Sequence;
import com.ibm.security.sequence.SequenceFactory;
import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory;
import com.ibm.security.sequence.bytes.ByteSequenceIterator;
import com.ibm.security.x509.X500Name;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMSKeyStoreSpi
extends KeyStoreSpi {
    private static final int FIXED_RECORD_LENGTH = 5000;
    private static final IntableByteSequence ZERO = IntableByteSequenceFactory.newIntableByteSequence(ByteSequenceFactory.newConstantByteSequence((byte)0, 4));
    private static final IntableByteSequence ZERO_MD5_HASH = IntableByteSequenceFactory.newIntableByteSequence(ByteSequenceFactory.newConstantByteSequence((byte)0, 16));
    private static final IntableByteSequence FIXED_RECORD_LENGTH_SEQUENCE = IntableByteSequenceFactory.newIntableByteSequence(5000);
    private static final IntableByteSequence CA_RECORD_NUMBER = IntableByteSequenceFactory.newIntableByteSequence(CACertificates.CACERTS.size());
    private static final ByteSequence UNUSED_FILE_LABEL = ByteSequenceFactory.newConstantByteSequence((byte)0, 24);
    private static final String STASH_FILE_EXT = ".sth";
    private QueryableKeyDatabase cmsKeyDatabase;
    private List<String> aliases;
    private String storePassword;

    static PasswordExtractor newPasswordExtractor(KeyStore.ProtectionParameter protParam) {
        if (protParam instanceof KeyStore.CallbackHandlerProtection) {
            return new PEFromCBHandler((KeyStore.CallbackHandlerProtection)protParam);
        }
        if (protParam instanceof KeyStore.PasswordProtection) {
            return new PEFromPwdProtection((KeyStore.PasswordProtection)protParam);
        }
        if (protParam instanceof StashedPasswordProtection) {
            return new PEFromStashedPwdProtection((StashedPasswordProtection)protParam);
        }
        return null;
    }

    private void rebuildAliasesList() throws IOException {
        if (this.cmsKeyDatabase == null) {
            return;
        }
        this.aliases = null;
        this.aliases = new ArrayList<String>();
        Sequence<Record> records = this.cmsKeyDatabase.getRecords();
        for (Record record : records) {
            Buffer label = record.getLabel();
            byte[] labelContent = new byte[label.getHeader().toInt()];
            label.getContent().getInputStream().read(labelContent);
            this.aliases.add(new String(labelContent, "UTF-8"));
        }
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws UnrecoverableKeyException {
        if (!this.engineContainsAlias(alias)) {
            return null;
        }
        try {
            if (!this.cmsKeyDatabase.checkPassword(password)) {
                throw new UnrecoverableKeyException("Incorrect Password.");
            }
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnrecoverableKeyException("Error occured while checking the password validity: " + e.getMessage());
        }
        Record record = this.cmsKeyDatabase.getRecordByLabel(alias);
        if (record == null) {
            return null;
        }
        RecordEncoding encoding = record.getEncoding();
        if (!encoding.isPrivateKeyPresent()) {
            return null;
        }
        try {
            return encoding.getPrivateKey(password);
        }
        catch (Exception e) {
            throw new UnrecoverableKeyException("Error occured while extracting the private key: " + e.getMessage());
        }
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        if (!this.engineContainsAlias(alias)) {
            return null;
        }
        ArrayList<Certificate> chain = new ArrayList<Certificate>();
        int index = 0;
        try {
            Record issuerRecord;
            Record endEntityRecord = this.cmsKeyDatabase.getRecordByLabel(alias);
            chain.add(index++, endEntityRecord.getEncoding().getCertificate());
            while (!(issuerRecord = this.cmsKeyDatabase.getIssuerRecord(endEntityRecord)).getSubjectNameHash().equals(endEntityRecord.getSubjectNameHash())) {
                endEntityRecord = issuerRecord;
                chain.add(index++, endEntityRecord.getEncoding().getCertificate());
            }
        }
        catch (Exception e) {
            return null;
        }
        return chain.toArray(new Certificate[index]);
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        if (!this.engineContainsAlias(alias)) {
            return null;
        }
        Record certRecord = this.cmsKeyDatabase.getRecordByLabel(alias);
        if (certRecord == null) {
            return null;
        }
        try {
            return certRecord.getEncoding().getCertificate();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        String existingAlias;
        if (!key.getFormat().equals("PKCS#8")) {
            throw new KeyStoreException("This keystore allows only PKCS#8 encoded private keys");
        }
        try {
            if (password != null && !this.cmsKeyDatabase.checkPassword(password)) {
                throw new KeyStoreException("Invalid password provided. Password must be null or the same as the KeyStore password.");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyStoreException("Error occured while checking the password validity.", e);
        }
        if (chain == null) {
            throw new KeyStoreException("Certificate chain must be provided for this keystore");
        }
        for (int i = 0; i < chain.length; ++i) {
            if (chain[i] instanceof X509Certificate) continue;
            throw new KeyStoreException("One of the chain elements is not an X509Certificate");
        }
        String signerAlias = null;
        RecordDataHashGenerator hashGen = RecordDataHashGeneratorFactory.newRecordDataHashGenerator();
        ArrayList<Record> records = new ArrayList<Record>(chain.length);
        for (int i = chain.length - 1; i > 0; --i) {
            if (this.engineGetCertificateAlias(chain[i]) != null) continue;
            X500Name x500name = (X500Name)((X509Certificate)chain[i]).getSubjectDN();
            if (x500name == null) {
                throw new KeyStoreException("The Subject DN of certificate #" + i + " is not in X.500 form");
            }
            try {
                signerAlias = x500name.getCommonName();
            }
            catch (IOException ex1) {
                try {
                    signerAlias = x500name.getOrganizationalUnit();
                }
                catch (IOException ex2) {
                    throw new KeyStoreException("Cannot add the certificate: " + x500name + " without at least CN or OU name in the Subject DN.", ex2);
                }
            }
            if (this.engineContainsAlias(signerAlias)) {
                throw new KeyStoreException("A signer certificate with alias: " + signerAlias + " already exists but it contains diffrent public key");
            }
            try {
                int id = this.cmsKeyDatabase.getNextRecordID();
                ByteSequence aliasSeq = IntableByteSequenceFactory.newIntableByteSequence(signerAlias.length()).append(ByteSequenceFactory.newByteSequence(signerAlias.getBytes("UTF-8")));
                X509Certificate certificate = (X509Certificate)chain[i];
                ByteSequence record = RecordFlag.CREATED.append(IntableByteSequenceFactory.newIntableByteSequence(id)).append(RecordEncodingFactory.newTrustedRecordEncoding(id, certificate, signerAlias)).append(BufferFactory.newBuffer(aliasSeq.getInputStream())).append(ZERO).append(hashGen.generateCertificateSignatureHash(certificate)).append(hashGen.generateTBSCertificateHash(certificate)).append(hashGen.generateSubjectNameHash(certificate)).append(hashGen.generateSubjectPublicKeyInfoHash(certificate)).append(hashGen.generateIssuerAndSerialNumberHash(certificate));
                records.add(RecordFactory.newRecord(record.getInputStream(), 5000));
                continue;
            }
            catch (Exception e) {
                throw new KeyStoreException("Error occued while adding the certificate chain to KeyStore.");
            }
        }
        try {
            ByteSequence aliasSeq = IntableByteSequenceFactory.newIntableByteSequence(alias.length()).append(ByteSequenceFactory.newByteSequence(alias.getBytes("UTF-8")));
            int id = this.cmsKeyDatabase.getNextRecordID();
            X509Certificate certificate = (X509Certificate)chain[0];
            ByteSequence record = RecordFlag.CREATED.append(IntableByteSequenceFactory.newIntableByteSequence(id)).append(RecordEncodingFactory.newKeyRecordEncoding(id, certificate, (PrivateKey)key, this.storePassword.toCharArray(), alias)).append(BufferFactory.newBuffer(aliasSeq.getInputStream())).append(ZERO).append(hashGen.generateCertificateSignatureHash(certificate)).append(hashGen.generateTBSCertificateHash(certificate)).append(hashGen.generateSubjectNameHash(certificate)).append(hashGen.generateSubjectPublicKeyInfoHash(certificate)).append(hashGen.generateIssuerAndSerialNumberHash(certificate));
            records.add(RecordFactory.newRecord(record.getInputStream(), 5000));
        }
        catch (Exception e) {
            throw new KeyStoreException("Error occued while adding the End Entity certificate to KeyStore.");
        }
        if (this.engineContainsAlias(alias)) {
            this.engineDeleteEntry(alias);
        }
        if ((existingAlias = this.engineGetCertificateAlias(chain[0])) != null && !existingAlias.equalsIgnoreCase(alias)) {
            this.engineDeleteEntry(existingAlias);
        }
        try {
            Sequence additionalRecords = SequenceFactory.newSequence(records);
            Sequence<Record> totalRecords = this.cmsKeyDatabase.getRecords().append(additionalRecords);
            ByteSequence newStoreSequence = MagicNumberValidatorFactory.MAGIC_NUMBER.append(VersionNumber.THREE).append(VersionNumber.TWO).append(ZERO).append(FileType.X509KEY).append(FIXED_RECORD_LENGTH_SEQUENCE).append(IntableByteSequenceFactory.newIntableByteSequence(totalRecords.length())).append(UNUSED_FILE_LABEL).append(ZERO_MD5_HASH).append(ZERO_MD5_HASH);
            for (Record rec : totalRecords) {
                newStoreSequence = newStoreSequence.append(rec);
            }
            this.cmsKeyDatabase = QueryableKeyDatabaseFactory.newQueryableKeyDatabase(KeyDatabaseFactory.newKeyDatabase(newStoreSequence.getInputStream()));
            this.updateHeaderHashes();
            this.rebuildAliasesList();
        }
        catch (Exception e) {
            throw new KeyStoreException(e);
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("CMS cannot accept externally encoded PKCS#8 objects");
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        try {
            String existingAlias;
            if (!(cert instanceof X509Certificate)) {
                throw new KeyStoreException("Only X509 Certificates are expected.");
            }
            if (this.engineContainsAlias(alias)) {
                if (!this.engineIsCertificateEntry(alias)) {
                    throw new KeyStoreException("Alias already exists and is associated with key entry.");
                }
                this.engineDeleteEntry(alias);
            }
            if ((existingAlias = this.engineGetCertificateAlias(cert)) != null) {
                this.engineDeleteEntry(existingAlias);
            }
            int id = this.cmsKeyDatabase.getNextRecordID();
            RecordDataHashGenerator hashGen = RecordDataHashGeneratorFactory.newRecordDataHashGenerator();
            ByteSequence aliasSeq = IntableByteSequenceFactory.newIntableByteSequence(alias.length()).append(ByteSequenceFactory.newByteSequence(alias.getBytes("UTF-8")));
            X509Certificate certificate = (X509Certificate)cert;
            ByteSequence recordSequence = RecordFlag.CREATED.append(IntableByteSequenceFactory.newIntableByteSequence(id)).append(RecordEncodingFactory.newTrustedRecordEncoding(id, certificate, alias)).append(BufferFactory.newBuffer(aliasSeq.getInputStream())).append(ZERO).append(hashGen.generateCertificateSignatureHash(certificate)).append(hashGen.generateTBSCertificateHash(certificate)).append(hashGen.generateSubjectNameHash(certificate)).append(hashGen.generateSubjectPublicKeyInfoHash(certificate)).append(hashGen.generateIssuerAndSerialNumberHash(certificate));
            Record record = RecordFactory.newRecord(recordSequence.getInputStream(), 5000);
            try {
                Sequence<Record> additionalRecords = SequenceFactory.newSequence(record);
                Sequence<Record> totalRecords = this.cmsKeyDatabase.getRecords().append(additionalRecords);
                ByteSequence newStoreSequence = MagicNumberValidatorFactory.MAGIC_NUMBER.append(VersionNumber.THREE).append(VersionNumber.TWO).append(ZERO).append(FileType.X509KEY).append(FIXED_RECORD_LENGTH_SEQUENCE).append(IntableByteSequenceFactory.newIntableByteSequence(totalRecords.length())).append(UNUSED_FILE_LABEL).append(ZERO_MD5_HASH).append(ZERO_MD5_HASH);
                for (Record rec : totalRecords) {
                    newStoreSequence = newStoreSequence.append(rec);
                }
                this.cmsKeyDatabase = QueryableKeyDatabaseFactory.newQueryableKeyDatabase(KeyDatabaseFactory.newKeyDatabase(newStoreSequence.getInputStream()));
                this.updateHeaderHashes();
                this.rebuildAliasesList();
            }
            catch (Exception e) {
                throw new KeyStoreException(e);
            }
        }
        catch (Exception ex) {
            throw new KeyStoreException("Key Insertion Failed: " + ex.getMessage(), ex);
        }
    }

    private void updateHeaderHashes() throws NoSuchAlgorithmException, IOException {
        ByteSequence newHeaderSequence;
        ByteSequence passwordBuffer = ByteSequenceFactory.newByteSequence(this.storePassword.getBytes("UTF-8"));
        FileHeader header = this.cmsKeyDatabase.getHeader();
        ByteSequence headerHash = FileHeaderHashGeneratorFactory.newFileHeaderHashGenerator().generateHash(header, passwordBuffer);
        ByteSequence keystoreSequence = newHeaderSequence = header.getSubSequence(0, header.length() - 2 * ZERO_MD5_HASH.length()).append(headerHash).append(ZERO_MD5_HASH);
        for (Record rec : this.cmsKeyDatabase.getRecords()) {
            keystoreSequence = keystoreSequence.append(rec);
        }
        KeyDatabase db = KeyDatabaseFactory.newKeyDatabase(keystoreSequence.getInputStream());
        ByteSequence dbHash = DatabaseHashGeneratorFactory.newDatabaseHashGenerator().generateHash(db, passwordBuffer);
        header = db.getHeader();
        keystoreSequence = newHeaderSequence = header.getSubSequence(0, header.length() - ZERO_MD5_HASH.length()).append(dbHash);
        for (Record rec : db.getRecords()) {
            keystoreSequence = keystoreSequence.append(rec);
        }
        this.cmsKeyDatabase = QueryableKeyDatabaseFactory.newQueryableKeyDatabase(KeyDatabaseFactory.newKeyDatabase(keystoreSequence.getInputStream()));
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        try {
            if (!this.engineContainsAlias(alias)) {
                return;
            }
            Record record = this.cmsKeyDatabase.getRecordByLabel(alias);
            Sequence<Record> allRecords = this.cmsKeyDatabase.getRecords();
            int index = allRecords.indexOf(record);
            Sequence<Record> remaining = allRecords.getSubSequence(0, index).append(allRecords.getSubSequence(index + 1, allRecords.length()));
            ByteSequence newStoreSequence = MagicNumberValidatorFactory.MAGIC_NUMBER.append(VersionNumber.THREE).append(VersionNumber.TWO).append(ZERO).append(FileType.X509KEY).append(FIXED_RECORD_LENGTH_SEQUENCE).append(IntableByteSequenceFactory.newIntableByteSequence(remaining.length())).append(UNUSED_FILE_LABEL).append(ZERO_MD5_HASH).append(ZERO_MD5_HASH);
            for (Record rec : remaining) {
                newStoreSequence = newStoreSequence.append(rec);
            }
            this.cmsKeyDatabase = QueryableKeyDatabaseFactory.newQueryableKeyDatabase(KeyDatabaseFactory.newKeyDatabase(newStoreSequence.getInputStream()));
            this.updateHeaderHashes();
            this.rebuildAliasesList();
        }
        catch (Exception e) {
            throw new KeyStoreException(e.getMessage(), e);
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        return Collections.enumeration(this.aliases);
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.aliases.contains(alias);
    }

    @Override
    public int engineSize() {
        return this.aliases.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        Record record = this.cmsKeyDatabase.getRecordByLabel(alias);
        return record.getEncoding().isPrivateKeyPresent();
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return !this.engineIsKeyEntry(alias);
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        if (!(cert instanceof X509Certificate)) {
            return null;
        }
        Record record = this.cmsKeyDatabase.getRecordByPublicKeyInfo(cert);
        if (record == null) {
            return null;
        }
        Buffer label = record.getLabel();
        byte[] labelContent = new byte[label.getHeader().toInt()];
        try {
            label.getContent().getInputStream().read(labelContent);
            return new String(labelContent, "UTF-8");
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException {
        if (stream == null) {
            throw new NullPointerException();
        }
        try {
            String pwd;
            if (password != null && !this.storePassword.equals(pwd = new String(password))) {
                this.updateEncryptedRecords(this.storePassword.toCharArray(), pwd.toCharArray());
                this.storePassword = pwd;
                this.updateHeaderHashes();
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        ByteSequenceIterator it = this.cmsKeyDatabase.getIterator();
        while (it.hasNextByte()) {
            stream.write(it.getNextByte());
        }
    }

    private void updateEncryptedRecords(char[] currentPassword, char[] newPassword) throws IOException, PKCSException, CertificateEncodingException, CertificateException {
        Sequence<Record> keys = this.cmsKeyDatabase.getKeyRecords();
        HashMap<Integer, Record> newKeys = new HashMap<Integer, Record>(keys.length());
        for (Record record : keys) {
            Buffer aliasBuffer = record.getLabel();
            byte[] contents = new byte[aliasBuffer.getHeader().toInt()];
            aliasBuffer.getContent().getInputStream().read(contents);
            String alias = new String(contents, "UTF-8");
            RecordEncoding encoding = record.getEncoding();
            RecordEncoding newEncoding = RecordEncodingFactory.newKeyRecordEncoding(record.getRecordId().toInt(), encoding.getCertificate(), encoding.getPrivateKey(currentPassword), newPassword, alias);
            ByteSequence newRecordSequence = record.getRecordFlag().append(record.getRecordId()).append(newEncoding).append(record.getLabel()).append(ZERO).append(record.getSignatureHash()).append(record.getUnsignedCertHash()).append(record.getSubjectNameHash()).append(record.getSubjectPublicKeyInfoHash()).append(record.getIssuerAndSerialNumberHash());
            newKeys.put(record.getRecordId().toInt(), RecordFactory.newRecord(newRecordSequence.getInputStream(), 5000));
        }
        ByteSequence newKeystore = this.cmsKeyDatabase.getHeader();
        for (Record record : this.cmsKeyDatabase.getRecords()) {
            Record rec = (Record)newKeys.get(record.getRecordId().toInt());
            if (rec != null) {
                newKeystore = newKeystore.append(rec);
                continue;
            }
            newKeystore = newKeystore.append(record);
        }
        this.cmsKeyDatabase = QueryableKeyDatabaseFactory.newQueryableKeyDatabase(KeyDatabaseFactory.newKeyDatabase(newKeystore.getInputStream()));
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException {
        if (password == null) {
            throw new IllegalArgumentException("Password is requird to create a new or load an existing KeyStore");
        }
        this.cmsKeyDatabase = null;
        this.storePassword = new String(password);
        if (stream == null) {
            try {
                ByteSequence headerSequence = MagicNumberValidatorFactory.MAGIC_NUMBER.append(VersionNumber.THREE).append(VersionNumber.TWO).append(ZERO).append(FileType.X509KEY).append(FIXED_RECORD_LENGTH_SEQUENCE).append(CA_RECORD_NUMBER).append(UNUSED_FILE_LABEL).append(ZERO_MD5_HASH).append(ZERO_MD5_HASH);
                FileHeader header = FileHeaderFactory.newFileHeader(headerSequence.getInputStream());
                ByteSequence passwordBuffer = ByteSequenceFactory.newByteSequence(this.storePassword.getBytes("UTF-8"));
                ByteSequence headerHash = FileHeaderHashGeneratorFactory.newFileHeaderHashGenerator().generateHash(header, passwordBuffer);
                ByteSequence keystoreSequence = headerSequence = headerSequence.getSubSequence(0, headerSequence.length() - 2 * ZERO_MD5_HASH.length()).append(headerHash).append(ZERO_MD5_HASH);
                Iterator<String> iterator = CACertificates.getAliases();
                int id = 0;
                RecordDataHashGenerator hashGen = RecordDataHashGeneratorFactory.newRecordDataHashGenerator();
                while (iterator.hasNext()) {
                    String alias = iterator.next();
                    ByteSequence aliasSeq = IntableByteSequenceFactory.newIntableByteSequence(alias.length()).append(ByteSequenceFactory.newByteSequence(alias.getBytes("UTF-8")));
                    X509Certificate certificate = (X509Certificate)CACertificates.getCACertificate(alias);
                    ByteSequence record = RecordFlag.CREATED.append(IntableByteSequenceFactory.newIntableByteSequence(++id)).append(RecordEncodingFactory.newTrustedRecordEncoding(id, certificate, alias)).append(BufferFactory.newBuffer(aliasSeq.getInputStream())).append(ZERO).append(hashGen.generateCertificateSignatureHash(certificate)).append(hashGen.generateTBSCertificateHash(certificate)).append(hashGen.generateSubjectNameHash(certificate)).append(hashGen.generateSubjectPublicKeyInfoHash(certificate)).append(hashGen.generateIssuerAndSerialNumberHash(certificate));
                    keystoreSequence = keystoreSequence.append(RecordFactory.newRecord(record.getInputStream(), 5000));
                }
                KeyDatabase db = KeyDatabaseFactory.newKeyDatabase(keystoreSequence.getInputStream());
                ByteSequence dbHash = DatabaseHashGeneratorFactory.newDatabaseHashGenerator().generateHash(db, passwordBuffer);
                headerSequence = headerSequence.getSubSequence(0, headerSequence.length() - ZERO_MD5_HASH.length()).append(dbHash);
                keystoreSequence = headerSequence.append(keystoreSequence.getSubSequence(headerSequence.length(), keystoreSequence.length() - 1));
                this.cmsKeyDatabase = QueryableKeyDatabaseFactory.newQueryableKeyDatabase(KeyDatabaseFactory.newKeyDatabase(keystoreSequence.getInputStream()));
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.cmsKeyDatabase = QueryableKeyDatabaseFactory.newQueryableKeyDatabase(KeyDatabaseFactory.newKeyDatabase(stream));
            if (password != null && !this.cmsKeyDatabase.checkKeyStoreIntegrity(password)) {
                throw new IOException("Incorrect Password.");
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Invalid KeyStore Format.", e);
        }
        this.rebuildAliasesList();
    }

    @Override
    public boolean engineEntryInstanceOf(String alias, Class<? extends KeyStore.Entry> entryClass) {
        if (this.engineIsKeyEntry(alias)) {
            return entryClass.isAssignableFrom(KeyStore.PrivateKeyEntry.class);
        }
        if (this.engineIsCertificateEntry(alias)) {
            return entryClass.isAssignableFrom(KeyStore.TrustedCertificateEntry.class);
        }
        return false;
    }

    @Override
    public KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protParam) throws KeyStoreException, UnrecoverableEntryException {
        KeyStore.Entry entry;
        block9: {
            entry = null;
            try {
                if (!this.engineContainsAlias(alias)) {
                    return null;
                }
                Record record = this.cmsKeyDatabase.getRecordByLabel(alias);
                RecordEncoding encoding = record.getEncoding();
                if (encoding.isPrivateKeyPresent()) {
                    if (protParam != null) {
                        PasswordExtractor pwextractor = CMSKeyStoreSpi.newPasswordExtractor(protParam);
                        if (pwextractor == null) {
                            throw new UnrecoverableEntryException("Invalid Protection Parameter.");
                        }
                        char[] password = pwextractor.getPassword();
                        if (password != null && !this.cmsKeyDatabase.checkPassword(password)) {
                            throw new UnrecoverableEntryException("Incorrect password provided.");
                        }
                    }
                    PrivateKey key = encoding.getPrivateKey(this.storePassword.toCharArray());
                    Certificate[] certChain = this.engineGetCertificateChain(alias);
                    entry = new KeyStore.PrivateKeyEntry(key, certChain);
                    break block9;
                }
                if (encoding.isTrusted()) {
                    Certificate cert = encoding.getCertificate();
                    entry = new KeyStore.TrustedCertificateEntry(cert);
                    break block9;
                }
                throw new UnrecoverableEntryException("The key type that the alias is referring to is not supported.");
            }
            catch (UnrecoverableEntryException e) {
                throw e;
            }
            catch (Exception e) {
                throw new KeyStoreException(e);
            }
        }
        return entry;
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter loadstoreParam) throws IOException, IllegalArgumentException {
        if (loadstoreParam == null) {
            throw new IllegalArgumentException("CMS KeyStore requires LoadStoreParameter to load.");
        }
        if (!(loadstoreParam instanceof CMSLoadParameter)) {
            throw new IllegalArgumentException("The provided LoadStoreParameter is not recognized");
        }
        CMSLoadParameter parameter = (CMSLoadParameter)loadstoreParam;
        PasswordExtractor extractor = CMSKeyStoreSpi.newPasswordExtractor(parameter.getProtectionParameter());
        if (extractor == null) {
            throw new IllegalArgumentException("Invalid Protection Parameter.");
        }
        FileInputStream instream = null;
        if (parameter.getKeyStoreFile() != null) {
            instream = new FileInputStream(parameter.getKeyStoreFile());
        }
        this.engineLoad(instream, extractor.getPassword());
    }

    @Override
    public void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException, IllegalArgumentException {
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            char[] password = null;
            if (protParam != null) {
                PasswordExtractor pwdExtractor = CMSKeyStoreSpi.newPasswordExtractor(protParam);
                if (pwdExtractor == null) {
                    throw new IllegalArgumentException("Invalid Protection Parameter.");
                }
                try {
                    password = pwdExtractor.getPassword();
                    if (password != null && !this.cmsKeyDatabase.checkPassword(password)) {
                        throw new KeyStoreException("The password supplied throug the ProtectionParameter interface is invalid, it must match the KeyStore password or null");
                    }
                }
                catch (Exception e) {
                    throw new KeyStoreException(e);
                }
            }
            KeyStore.PrivateKeyEntry privateEntry = (KeyStore.PrivateKeyEntry)entry;
            this.engineSetKeyEntry(alias, privateEntry.getPrivateKey(), this.storePassword.toCharArray(), privateEntry.getCertificateChain());
        } else if (entry instanceof KeyStore.TrustedCertificateEntry) {
            KeyStore.TrustedCertificateEntry trustedEntry = (KeyStore.TrustedCertificateEntry)entry;
            this.engineSetCertificateEntry(alias, trustedEntry.getTrustedCertificate());
        } else {
            throw new KeyStoreException("Invalid Key Entry.");
        }
    }

    @Override
    public void engineStore(KeyStore.LoadStoreParameter loadstoreParam) throws IOException, IllegalArgumentException {
        if (loadstoreParam == null) {
            throw new IllegalArgumentException("CMS KeyStore requires LoadStoreParameter to store.");
        }
        if (!(loadstoreParam instanceof CMSStoreParameter)) {
            throw new IllegalArgumentException("The given LoadStoreParameter is not recognized");
        }
        CMSStoreParameter parameter = (CMSStoreParameter)loadstoreParam;
        KeyStore.ProtectionParameter protection = parameter.getProtectionParameter();
        char[] password = null;
        if (protection != null) {
            PasswordExtractor extractor = CMSKeyStoreSpi.newPasswordExtractor(protection);
            if (extractor == null) {
                throw new IllegalArgumentException("Invalid Protection Parameter.");
            }
            password = extractor.getPassword();
        }
        this.engineStore(new FileOutputStream(parameter.getKeyStoreFile()), password);
        if (parameter.isStashPassword()) {
            String kdbPath = parameter.getKeyStoreFile().getAbsolutePath();
            int index = kdbPath.lastIndexOf(46);
            if (index == -1) {
                index = kdbPath.length();
            }
            StringBuilder builder = new StringBuilder(kdbPath.subSequence(0, index)).append(STASH_FILE_EXT);
            this.stashKeyDbPwd(builder.toString());
        }
    }

    private void stashKeyDbPwd(String absolutePath) throws IOException {
        byte[] buffer = new byte[129];
        byte[] pwdBuffer = this.storePassword.getBytes("UTF-8");
        for (int i = 0; i < 129; ++i) {
            buffer[i] = i < pwdBuffer.length ? pwdBuffer[i] : (i == pwdBuffer.length ? (byte)0 : (byte)i);
        }
        ByteSequence paddedPassword = ByteSequenceFactory.newByteSequence(buffer);
        ByteSequence key = ByteSequenceFactory.newConstantByteSequence((byte)-11, 129);
        ByteSequence stashedPwd = ByteSequenceXorFactory.newByteSequenceXor().xor(paddedPassword, key);
        FileOutputStream out = new FileOutputStream(absolutePath);
        ByteSequenceIterator it = stashedPwd.getIterator();
        while (it.hasNextByte()) {
            ((OutputStream)out).write(it.getNextByte());
        }
    }

    private static final class PEFromStashedPwdProtection
    implements PasswordExtractor {
        StashedPasswordProtection protParam;

        private PEFromStashedPwdProtection() {
        }

        PEFromStashedPwdProtection(StashedPasswordProtection protParam) {
            this.protParam = protParam;
        }

        public char[] getPassword() throws IOException {
            return this.protParam.getPassword();
        }

        public void destroyPassword() throws DestroyFailedException {
            this.protParam.destroy();
        }
    }

    private static final class PEFromPwdProtection
    implements PasswordExtractor {
        KeyStore.PasswordProtection protParam;

        private PEFromPwdProtection() {
        }

        PEFromPwdProtection(KeyStore.PasswordProtection protParam) {
            this.protParam = protParam;
        }

        public char[] getPassword() {
            return this.protParam.getPassword();
        }

        public void destroyPassword() throws DestroyFailedException {
            this.protParam.destroy();
        }
    }

    private static final class PEFromCBHandler
    implements PasswordExtractor {
        private KeyStore.CallbackHandlerProtection callbackProtection = null;
        private Callback[] callbacks = null;
        private static final String prompt = "Please Enter the KeyStore Password:";

        private PEFromCBHandler() {
        }

        PEFromCBHandler(KeyStore.CallbackHandlerProtection protParam) {
            this.callbackProtection = protParam;
            this.callbacks = new Callback[1];
        }

        public char[] getPassword() throws IOException {
            char[] password = null;
            if (this.callbacks[0] == null) {
                CallbackHandler cbHandler = this.callbackProtection.getCallbackHandler();
                PasswordCallback pwdCB = new PasswordCallback(prompt, false);
                this.callbacks[0] = pwdCB;
                try {
                    cbHandler.handle(this.callbacks);
                }
                catch (UnsupportedCallbackException e) {
                    throw new RuntimeException(e);
                }
                password = pwdCB.getPassword();
            } else {
                password = ((PasswordCallback)this.callbacks[0]).getPassword();
            }
            return password;
        }

        public void destroyPassword() {
            if (this.callbacks[0] != null) {
                ((PasswordCallback)this.callbacks[0]).clearPassword();
                this.callbacks[0] = null;
            }
        }
    }

    static interface PasswordExtractor {
        public char[] getPassword() throws IOException;

        public void destroyPassword() throws DestroyFailedException;
    }
}

