/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.BERObject;
import com.ibm.security.cmskeystore.CMSKeyDatabaseException;
import com.ibm.security.cmskeystore.CertificateItem;
import com.ibm.security.cmskeystore.EncryptedPrivateKeyInfoItem;
import com.ibm.security.cmskeystore.KeyItem;
import com.ibm.security.cmskeystore.PrivateKeyInfoItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CMSKeyDatabase {
    private String keyDbFileName;
    private String keyDbPwd;
    private long keyDbPwdExpireTime;
    private List<String> keyLabelList = null;

    private static native int c_CMSInit(boolean var0);

    public CMSKeyDatabase(String keyDbFileName, String keyDbPwd, long expireTime) {
        this.keyDbFileName = keyDbFileName;
        this.keyDbPwd = keyDbPwd;
        this.keyDbPwdExpireTime = expireTime;
    }

    public native int c_CreateNewKeyDb(String var1, String var2, long var3);

    public native int c_OpenKeyDb(String var1, String var2);

    public native int c_BuildKeyLabelList(String var1, String var2);

    public native KeyItem c_GetKeyItemByLabel(String var1, String var2, String var3, boolean var4);

    public native KeyItem[] c_GetKeyItemsByPublicKey(String var1, String var2, int var3, byte[] var4);

    public native boolean c_ChangeKeyDbPwd(String var1, String var2, String var3, long var4);

    public native boolean c_IsPrivateKeyPresent(String var1, String var2, String var3);

    public native int c_InsertKey(String var1, String var2, String var3, int var4, byte[] var5, int var6, byte[] var7, boolean var8, boolean var9);

    public native int c_DeleteKeyByLabel(String var1, String var2, String var3, boolean var4);

    public native KeyItem[] c_GetKeyItemListByLabel(String var1, String var2, String var3);

    public static native PrivateKeyInfoItem c_DecryptPrivateKey(int var0, byte[] var1, String var2);

    public static native EncryptedPrivateKeyInfoItem c_EncryptPrivateKey(int var0, byte[] var1, String var2);

    public static native boolean c_StashKeyDbPwd(String var0, String var1);

    public synchronized void create() throws CMSKeyDatabaseException {
        int errCode = this.c_CreateNewKeyDb(this.keyDbFileName, this.keyDbPwd, this.keyDbPwdExpireTime);
        if (errCode != 0) {
            throw new CMSKeyDatabaseException(errCode, "An error occurred while creating the specified key database.");
        }
        this.buildKeyLabelList();
    }

    public synchronized void open() throws CMSKeyDatabaseException {
        int errCode = this.c_OpenKeyDb(this.keyDbFileName, this.keyDbPwd);
        if (errCode != 0) {
            throw new CMSKeyDatabaseException(errCode, "An error occurred while opening the specified key database.");
        }
        this.buildKeyLabelList();
    }

    public synchronized void changeKeyDbPwd(String newKeyDbPwd, long newKeyDbPwdExpireTime) throws CMSKeyDatabaseException {
        if (!this.c_ChangeKeyDbPwd(this.keyDbFileName, this.keyDbPwd, newKeyDbPwd, newKeyDbPwdExpireTime)) {
            throw new CMSKeyDatabaseException("An error occurred while changing key database password.");
        }
        this.keyDbPwd = newKeyDbPwd;
        this.keyDbPwdExpireTime = newKeyDbPwdExpireTime;
    }

    public synchronized boolean isPrivateKeyPresent(String keyLabel) {
        return this.c_IsPrivateKeyPresent(this.keyDbFileName, this.keyDbPwd, keyLabel);
    }

    public synchronized void buildKeyLabelList() throws CMSKeyDatabaseException {
        if (this.keyLabelList != null) {
            return;
        }
        this.keyLabelList = new ArrayList<String>();
        int errCode = this.c_BuildKeyLabelList(this.keyDbFileName, this.keyDbPwd);
        if (errCode != 0) {
            throw new CMSKeyDatabaseException(errCode, "An error occurred while getting key information of the database.");
        }
    }

    public synchronized KeyItem getKeyItemByLabel(String keyLabel) {
        boolean isKeyPair = false;
        KeyItem keyItem = this.c_GetKeyItemByLabel(this.keyDbFileName, this.keyDbPwd, keyLabel, isKeyPair);
        return keyItem;
    }

    public synchronized Iterator<KeyItem> getKeyItemsByPublicKey(BERObject subjectPublicKeyInfo) throws CMSKeyDatabaseException {
        byte[] spkiBER = subjectPublicKeyInfo.getEncoded();
        int spkiBERLen = subjectPublicKeyInfo.getLength();
        KeyItem[] keyItems = this.c_GetKeyItemsByPublicKey(this.keyDbFileName, this.keyDbPwd, spkiBERLen, spkiBER);
        if (keyItems == null) {
            throw new CMSKeyDatabaseException("An error occurred while retrieving key information by the given public key.");
        }
        return Arrays.asList(keyItems).iterator();
    }

    public synchronized void deleteKeyByLabel(String keyLabel) throws CMSKeyDatabaseException {
        if (keyLabel == null) {
            return;
        }
        if (this.c_GetKeyItemByLabel(this.keyDbFileName, this.keyDbPwd, keyLabel, false) == null && this.c_GetKeyItemByLabel(this.keyDbFileName, this.keyDbPwd, keyLabel, true) == null) {
            return;
        }
        boolean isKeyPair = false;
        int errCode = this.c_DeleteKeyByLabel(this.keyDbFileName, this.keyDbPwd, keyLabel, isKeyPair);
        if (errCode != 0) {
            throw new CMSKeyDatabaseException(errCode, "An error occurred while deleting the specified key.");
        }
        this.keyLabelList.remove(keyLabel);
    }

    public synchronized void insertKey(KeyItem aKeyItem) throws CMSKeyDatabaseException {
        boolean isDefault;
        boolean isTrusted;
        byte[] certBER;
        CertificateItem certItem;
        int certBERLen;
        int errCode;
        String keyLabel = aKeyItem.getKeyLabel();
        int epkiBERLen = 0;
        byte[] epkiBER = null;
        EncryptedPrivateKeyInfoItem epkiItem = aKeyItem.getEncryptedPrivateKeyInfoItem();
        if (epkiItem != null) {
            epkiBER = epkiItem.getEncoded();
            epkiBERLen = epkiItem.getLength();
        }
        if ((errCode = this.c_InsertKey(this.keyDbFileName, this.keyDbPwd, keyLabel, certBERLen = (certItem = aKeyItem.getCertificateChain().elementAt(0)).getLength(), certBER = certItem.getEncoded(), epkiBERLen, epkiBER, isTrusted = aKeyItem.isTrusted(), isDefault = aKeyItem.isDefault())) != 0) {
            throw new CMSKeyDatabaseException(errCode, "An error occurred while inserting keys to the database.");
        }
        this.addKeyLabelAt(keyLabel, 0);
    }

    public synchronized Iterator<KeyItem> getKeyItemListByLabel(String keyLabel) throws CMSKeyDatabaseException {
        KeyItem[] keyItems = this.c_GetKeyItemListByLabel(this.keyDbFileName, this.keyDbPwd, keyLabel);
        if (keyItems == null) {
            throw new CMSKeyDatabaseException("An error occurred while retrieving key information for the selected key label.");
        }
        return Arrays.asList(keyItems).iterator();
    }

    public static synchronized PrivateKeyInfoItem decryptPrivateKey(EncryptedPrivateKeyInfoItem encPvtKey, String password) throws CMSKeyDatabaseException {
        PrivateKeyInfoItem pvtKey = null;
        byte[] keyBER = null;
        int keyLen = 0;
        if (encPvtKey != null) {
            keyBER = encPvtKey.getEncoded();
            keyLen = encPvtKey.getLength();
            pvtKey = CMSKeyDatabase.c_DecryptPrivateKey(keyLen, keyBER, password);
        }
        if (pvtKey == null) {
            throw new CMSKeyDatabaseException("An error occurred while decrypting the private key for the selected key label.");
        }
        return pvtKey;
    }

    public static synchronized EncryptedPrivateKeyInfoItem encryptPrivateKey(PrivateKeyInfoItem pvtKey, String password) throws CMSKeyDatabaseException {
        EncryptedPrivateKeyInfoItem ePvtKey = null;
        byte[] keyBER = null;
        int keyLen = 0;
        if (pvtKey != null) {
            keyBER = pvtKey.getEncoded();
            keyLen = pvtKey.getLength();
            ePvtKey = CMSKeyDatabase.c_EncryptPrivateKey(keyLen, keyBER, password);
        }
        if (ePvtKey == null) {
            throw new CMSKeyDatabaseException("An error occurred while encrypting the private key for the selected key label.");
        }
        return ePvtKey;
    }

    public List<String> getKeyLabelList() {
        return this.keyLabelList;
    }

    private void addKeyLabel(String aLabel) {
        if (aLabel == null) {
            return;
        }
        if (this.keyLabelList == null) {
            this.keyLabelList = new ArrayList<String>();
        }
        this.keyLabelList.add(aLabel);
    }

    private void addKeyLabelAt(String aLabel, int pos) {
        if (aLabel == null) {
            return;
        }
        if (this.keyLabelList == null) {
            this.keyLabelList = new ArrayList<String>();
        }
        this.keyLabelList.add(pos, aLabel);
    }

    static {
        int err;
        String trace = System.getProperty("cmsprovider.jni.trace");
        boolean enableTracing = false;
        if (trace != null && trace.equalsIgnoreCase("on")) {
            enableTracing = true;
        }
        if ((err = CMSKeyDatabase.c_CMSInit(enableTracing)) != 0) {
            throw new RuntimeException("Error initialiazing CMS library.");
        }
    }
}

