/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import com.ibm.security.cert.CertPathUtil;
import com.ibm.security.x509.GeneralSubtrees;
import com.ibm.security.x509.NameConstraintsExtension;
import com.ibm.security.x509.OIDMap;
import java.io.IOException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class NameChecker
extends PKIXCertPathChecker {
    static final int NAME_CONSTRAINTS_ERROR = 5;
    static final String[] myExtensions = new String[]{OIDMap.getOID((String)"x509.info.extensions.NameConstraints").toString(), OIDMap.getOID((String)"x509.info.extensions.SubjectAlternativeName").toString()};
    private int numberOfCertsInCertPath;
    private CertPath certPath;
    private int currentCertIndex;
    private GeneralSubtrees permittedSubtrees;
    private GeneralSubtrees excludedSubtrees;
    private String sigProvider;
    private static final Debug debug = Debug.getInstance((String)"certpath");

    public NameChecker(CertPath certPath, String sigProvider) throws CertPathValidatorException {
        this.certPath = certPath;
        List<? extends Certificate> certPathCerts = certPath.getCertificates();
        this.numberOfCertsInCertPath = certPathCerts.size();
        this.currentCertIndex = this.numberOfCertsInCertPath - 1;
        this.sigProvider = sigProvider;
        this.permittedSubtrees = null;
        this.excludedSubtrees = null;
    }

    public void init(boolean forward) throws CertPathValidatorException {
        if (forward) {
            throw new CertPathValidatorException("The direction of forward is not supported.");
        }
    }

    public Set getSupportedExtensions() {
        return null;
    }

    public boolean isForwardCheckingSupported() {
        return false;
    }

    public void check(Certificate certificate, Collection unresolvedCritExts) throws CertPathValidatorException {
        X509Certificate currentCert = (X509Certificate)certificate;
        if (!((Object)currentCert.getIssuerDN()).equals(currentCert.getSubjectDN()) || this.currentCertIndex <= 0) {
            if (this.excludedSubtrees == null) {
                try {
                    this.excludedSubtrees = new GeneralSubtrees(new Vector());
                }
                catch (IOException e) {
                    throw new CertPathValidatorException("An internal error has occurred.", e);
                }
            }
            X509CertSelector selector = null;
            try {
                NameConstraintsExtension nce = new NameConstraintsExtension(this.permittedSubtrees, this.excludedSubtrees);
                if (debug != null) {
                    int i;
                    System.out.print("CERTPATH: Checking name constraints");
                    if (this.permittedSubtrees != null) {
                        System.out.println("permitted trees:");
                        for (i = 0; i < this.permittedSubtrees.size(); ++i) {
                            System.out.println(this.permittedSubtrees.get(i));
                        }
                    }
                    if (this.excludedSubtrees != null) {
                        System.out.println("excluded trees:");
                        for (i = 0; i < this.excludedSubtrees.size(); ++i) {
                            System.out.println(this.excludedSubtrees.get(i));
                        }
                    }
                }
                selector = new X509CertSelector();
                selector.setNameConstraints(nce.getExtensionValue());
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred.", e);
            }
            if (!selector.match(currentCert)) {
                throw new CertPathValidatorException("The certificate failed the name constraint check", null, this.certPath, this.currentCertIndex);
            }
            if (this.currentCertIndex < this.numberOfCertsInCertPath) {
                this.processNameConstraints(currentCert);
            }
        }
        --this.currentCertIndex;
        CertPathUtil.removeExtensions(unresolvedCritExts, myExtensions);
    }

    public Object clone() {
        return null;
    }

    private void processNameConstraints(X509Certificate cert) throws CertPathValidatorException {
        NameConstraintsExtension ext = null;
        Object[] extObj = CertPathUtil.getExtension("x509.info.extensions.NameConstraints", cert);
        if (extObj[1] != null) {
            try {
                ext = new NameConstraintsExtension((Boolean)extObj[0], extObj[1]);
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred.", e);
            }
        }
        if (ext != null) {
            if (!ext.isCritical()) {
                throw new CertPathValidatorException("The NameConstraints extension was not critical.");
            }
            try {
                GeneralSubtrees permSTFromCert = (GeneralSubtrees)ext.get("permitted_subtrees");
                if (permSTFromCert != null) {
                    if (this.permittedSubtrees == null) {
                        this.permittedSubtrees = (GeneralSubtrees)permSTFromCert.clone();
                    } else {
                        GeneralSubtrees newExcluded = this.permittedSubtrees.intersect(permSTFromCert);
                        if (newExcluded != null) {
                            if (this.excludedSubtrees != null) {
                                this.excludedSubtrees.union(newExcluded);
                            } else {
                                this.excludedSubtrees = (GeneralSubtrees)newExcluded.clone();
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred.", e);
            }
            try {
                GeneralSubtrees exclSTFromCert = (GeneralSubtrees)ext.get("excluded_subtrees");
                if (exclSTFromCert != null) {
                    if (this.excludedSubtrees == null) {
                        this.excludedSubtrees = (GeneralSubtrees)exclSTFromCert.clone();
                    } else {
                        this.excludedSubtrees.union(exclSTFromCert);
                    }
                }
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred.", e);
            }
        }
    }
}

