/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.BASE64Decoder;
import com.ibm.security.cert.CertPathImpl;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.X509CRLImpl;
import com.ibm.security.x509.X509CertImpl;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateFactoryImpl
extends CertificateFactorySpi {
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";
    private static int defaultExpectedLineLength = 80;
    private Iterator supported_encodings;
    protected static final String pkcs7String = "PKCS7";
    protected static final String pkipString = "PkiPath";
    protected static final String x509String = "X.509";
    private ArrayList<String> supported_encodings_vector = new ArrayList(2);

    public CertificateFactoryImpl() {
        this.supported_encodings_vector.add(pkipString);
        this.supported_encodings_vector.add(pkcs7String);
        this.supported_encodings = Collections.unmodifiableList(this.supported_encodings_vector).iterator();
    }

    @Override
    public Certificate engineGenerateCertificate(InputStream is) throws CertificateException {
        if (is == null) {
            throw new CertificateException("Missing input stream");
        }
        try {
            if (!is.markSupported()) {
                byte[] totalBytes = this.getTotalBytes(new BufferedInputStream(is));
                is = new ByteArrayInputStream(totalBytes);
            }
            if (this.isBase64(is)) {
                byte[] data = this.base64_to_binary(is);
                return new X509CertImpl(data);
            }
            return new X509CertImpl(is);
        }
        catch (IOException ioe) {
            throw new CertificateException(ioe.getMessage());
        }
    }

    public Collection<Certificate> engineGenerateCertificates(InputStream is) throws CertificateException {
        if (is == null) {
            throw new CertificateException("Missing input stream");
        }
        try {
            if (!is.markSupported()) {
                byte[] totalBytes = this.getTotalBytes(new BufferedInputStream(is));
                is = new ByteArrayInputStream(totalBytes);
            }
            return this.parseX509orPKCS7Cert(is);
        }
        catch (IOException ioe) {
            throw new CertificateException(ioe.getMessage());
        }
    }

    @Override
    public CRL engineGenerateCRL(InputStream is) throws CRLException {
        if (is == null) {
            throw new CRLException("Missing input stream");
        }
        try {
            if (!is.markSupported()) {
                byte[] totalBytes = this.getTotalBytes(new BufferedInputStream(is));
                is = new ByteArrayInputStream(totalBytes);
            }
            if (this.isBase64(is)) {
                byte[] data = this.base64_to_binary(is);
                return new X509CRLImpl(data);
            }
            return new X509CRLImpl(is);
        }
        catch (IOException ioe) {
            throw new CRLException(ioe.getMessage());
        }
    }

    public Collection<CRL> engineGenerateCRLs(InputStream is) throws CRLException {
        if (is == null) {
            throw new CRLException("Missing input stream");
        }
        try {
            if (!is.markSupported()) {
                byte[] totalBytes = this.getTotalBytes(new BufferedInputStream(is));
                is = new ByteArrayInputStream(totalBytes);
            }
            return this.parseX509orPKCS7CRL(is);
        }
        catch (IOException ioe) {
            throw new CRLException(ioe.getMessage());
        }
    }

    private Collection<Certificate> parseX509orPKCS7Cert(InputStream is) throws CertificateException, IOException {
        ArrayList<Certificate> coll = new ArrayList<Certificate>();
        boolean first = true;
        while (is.available() != 0) {
            InputStream is2 = is;
            if (this.isBase64(is2)) {
                is2 = new ByteArrayInputStream(this.base64_to_binary(is2));
            }
            if (first) {
                is2.mark(is2.available());
            }
            try {
                coll.add((Certificate)new X509CertImpl(is2));
            }
            catch (CertificateException e) {
                if (first) {
                    is2.reset();
                    byte[] data = new byte[is2.available()];
                    is2.read(data);
                    Certificate[] certs = null;
                    try {
                        SignedData pkcs7data = new SignedData(data);
                        certs = pkcs7data.getCertificates();
                    }
                    catch (IOException e1) {
                        try {
                            ContentInfo cif = new ContentInfo(data);
                            Content ct = cif.getContent();
                            if (ct instanceof SignedData) {
                                certs = ((SignedData)ct).getCertificates();
                            }
                        }
                        catch (IOException e2) {
                            throw new CertificateException("Fail to parse input stream");
                        }
                    }
                    if (certs != null) {
                        return Arrays.asList(certs);
                    }
                    return new ArrayList<Certificate>(0);
                }
                throw e;
            }
            if (!first) continue;
            first = false;
        }
        return coll;
    }

    private List<CRL> parseX509orPKCS7CRL(InputStream is) throws CRLException, IOException {
        ArrayList<CRL> coll = new ArrayList<CRL>();
        boolean first = true;
        while (is.available() != 0) {
            InputStream is2 = is;
            if (this.isBase64(is)) {
                is2 = new ByteArrayInputStream(this.base64_to_binary(is2));
            }
            if (first) {
                is2.mark(is2.available());
            }
            try {
                coll.add((CRL)new X509CRLImpl(is2));
            }
            catch (CRLException e) {
                if (first) {
                    is2.reset();
                    byte[] data = new byte[is2.available()];
                    is2.read(data);
                    CRL[] crls = null;
                    try {
                        SignedData pkcs7data = new SignedData(data);
                        crls = pkcs7data.getCRLs();
                    }
                    catch (IOException e1) {
                        try {
                            ContentInfo cif = new ContentInfo(data);
                            Content ct = cif.getContent();
                            if (ct instanceof SignedData) {
                                crls = ((SignedData)ct).getCRLs();
                            }
                        }
                        catch (IOException e2) {
                            throw new CRLException("Fail to parse input stream");
                        }
                    }
                    if (crls != null) {
                        return Arrays.asList(crls);
                    }
                    return new ArrayList<CRL>(0);
                }
                throw e;
            }
            if (!first) continue;
            first = false;
        }
        return coll;
    }

    private byte[] base64_to_binary(InputStream is) throws IOException {
        long len = 0L;
        is.mark(is.available());
        BufferedInputStream bufin = new BufferedInputStream(is);
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader((InputStream)bufin, "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            isr = new InputStreamReader(bufin);
        }
        BufferedReader br = new BufferedReader(isr);
        String temp = this.readLine(br);
        if (temp == null || !temp.startsWith("-----BEGIN")) {
            throw new IOException("Unsupported encoding");
        }
        len += (long)temp.length();
        StringBuffer strBuf = new StringBuffer();
        while ((temp = this.readLine(br)) != null && !temp.startsWith("-----END")) {
            strBuf.append(temp);
        }
        if (temp == null) {
            throw new IOException("Unsupported encoding");
        }
        len += (long)temp.length();
        is.reset();
        is.skip(len += (long)strBuf.length());
        BASE64Decoder decoder = new BASE64Decoder();
        return decoder.decodeBuffer(strBuf.toString());
    }

    private byte[] getTotalBytes(InputStream is) throws IOException {
        int n;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        baos.reset();
        while ((n = is.read(buffer, 0, buffer.length)) != -1) {
            baos.write(buffer, 0, n);
        }
        return baos.toByteArray();
    }

    private boolean isBase64(InputStream is) throws IOException {
        if (is.available() >= 10) {
            is.mark(10);
            int c1 = is.read();
            int c2 = is.read();
            int c3 = is.read();
            int c4 = is.read();
            int c5 = is.read();
            int c6 = is.read();
            int c7 = is.read();
            int c8 = is.read();
            int c9 = is.read();
            int c10 = is.read();
            is.reset();
            return c1 == 45 && c2 == 45 && c3 == 45 && c4 == 45 && c5 == 45 && c6 == 66 && c7 == 69 && c8 == 71 && c9 == 73 && c10 == 78;
        }
        throw new IOException("Cannot determine encoding format");
    }

    private String readLine(BufferedReader br) throws IOException {
        int c;
        char[] endBoundary = new char[]{'-', '-', '-', '-', '-', 'E', 'N', 'D'};
        int i = 0;
        boolean isMatch = true;
        boolean matched = false;
        StringBuffer sb = new StringBuffer(defaultExpectedLineLength);
        do {
            c = br.read();
            if (isMatch && i < endBoundary.length) {
                boolean bl = isMatch = (char)c == endBoundary[i++];
            }
            if (!matched) {
                matched = isMatch && i == endBoundary.length;
            }
            sb.append((char)c);
        } while (c != -1 && c != 10 && c != 13);
        if (!matched && c == -1) {
            return null;
        }
        if (c == 13) {
            br.mark(1);
            int c2 = br.read();
            if (c2 == 10) {
                sb.append((char)c);
            } else {
                br.reset();
            }
        }
        return sb.toString();
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inStream) throws CertificateException {
        if (inStream == null) {
            throw new CertificateException("input stream is null");
        }
        try {
            DerInputStream dis;
            DerValue[] seq;
            byte[] totalBytes = this.getTotalBytes(new BufferedInputStream(inStream));
            ByteArrayInputStream bais = new ByteArrayInputStream(totalBytes);
            if (this.isBase64(bais)) {
                totalBytes = this.base64_to_binary(bais);
            }
            if ((seq = (dis = new DerInputStream(totalBytes)).getSequence(3)).length == 0) {
                return new CertPathImpl(x509String, Collections.EMPTY_LIST);
            }
            ArrayList<Certificate> certList = new ArrayList<Certificate>(seq.length);
            for (int i = seq.length - 1; i >= 0; --i) {
                ByteArrayInputStream bis = new ByteArrayInputStream(seq[i].toByteArray());
                certList.add(this.engineGenerateCertificate(bis));
                bis.close();
            }
            return new CertPathImpl(x509String, Collections.unmodifiableList(certList));
        }
        catch (IOException ioe) {
            throw new CertificateException("IOException parsing PkiPath data: " + ioe);
        }
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inStream, String encoding) throws CertificateException {
        CertPath certPath = null;
        if (encoding.equals(pkcs7String)) {
            Collection<Certificate> certCollection = this.engineGenerateCertificates(inStream);
            LinkedList<X509Certificate> myList = new LinkedList<X509Certificate>();
            for (X509Certificate x509Certificate : certCollection) {
                myList.add(x509Certificate);
            }
            certPath = this.engineGenerateCertPath(myList);
        } else if (encoding.equals(pkipString)) {
            certPath = this.engineGenerateCertPath(inStream);
        } else {
            throw new CertificateException("Encoding: " + encoding + " not valid.");
        }
        return certPath;
    }

    public CertPath engineGenerateCertPath(List certificates) throws CertificateException {
        int i;
        LinkedList<X509Certificate> certPathList = new LinkedList<X509Certificate>();
        X509Certificate[] certs = new X509Certificate[certificates.size()];
        boolean match = false;
        int matchCount = 0;
        int numberOfCertificates = certificates.size();
        int numberOfCertificatesAdded = 0;
        boolean ordered = false;
        try {
            certificates.toArray(certs);
        }
        catch (ArrayStoreException asex) {
            throw new CertificateException("Not X.509 certificates");
        }
        if (numberOfCertificates > 1) {
            for (i = 0; i < numberOfCertificates - 1; ++i) {
                if (!((Object)certs[i].getIssuerDN()).equals(certs[i + 1].getSubjectDN())) continue;
                ++matchCount;
            }
        }
        if (numberOfCertificates - 1 == matchCount || numberOfCertificates < 2) {
            ordered = true;
            for (i = 0; i < numberOfCertificates; ++i) {
                certPathList.add(certs[i]);
            }
        }
        if (!ordered) {
            certPathList.add(certs[0]);
            certs[0] = null;
            ++numberOfCertificatesAdded;
            while (!ordered) {
                for (i = 0; i < certs.length; ++i) {
                    if (certs[i] == null) continue;
                    if (((Object)((X509Certificate)certPathList.getFirst()).getSubjectDN()).equals(certs[i].getIssuerDN())) {
                        certPathList.addFirst(certs[i]);
                        certs[i] = null;
                        ++numberOfCertificatesAdded;
                        match = true;
                        continue;
                    }
                    if (!((Object)((X509Certificate)certPathList.getLast()).getIssuerDN()).equals(certs[i].getSubjectDN())) continue;
                    certPathList.addLast(certs[i]);
                    certs[i] = null;
                    ++numberOfCertificatesAdded;
                    match = true;
                }
                if (!match) {
                    for (int j = 0; j < certs.length; ++j) {
                        if (certs[j] == null) continue;
                        certPathList.addLast(certs[j]);
                        certs[j] = null;
                        ++numberOfCertificatesAdded;
                    }
                } else {
                    match = false;
                }
                if (numberOfCertificatesAdded != numberOfCertificates) continue;
                ordered = true;
            }
        }
        CertPathImpl certPath = new CertPathImpl(x509String, certPathList);
        return certPath;
    }

    public Iterator engineGetCertPathEncodings() {
        return this.supported_encodings;
    }
}

