/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.security.action.GetPropertyAction;

public final class PluginSysUtil
extends DeploySysRun {
    private static EventQueue pluginEventQueue = null;
    private static ThreadGroup pluginThreadGroup = null;
    private static ClassLoader pluginSysClassLoader = null;

    public static synchronized ThreadGroup getPluginThreadGroup() {
        if (pluginThreadGroup == null) {
            pluginSysClassLoader = Thread.currentThread().getContextClassLoader();
            pluginThreadGroup = new ThreadGroup(Thread.currentThread().getThreadGroup(), "Plugin Thread Group");
            PluginSysUtil.createAppContext(pluginThreadGroup);
        }
        return pluginThreadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            throw new Error("Cannot call invokeAndWait from the event dispatcher thread");
        }
        class AWTInvocationLock {
            AWTInvocationLock() {
            }
        }
        AWTInvocationLock aWTInvocationLock = new AWTInvocationLock();
        InvocationEvent invocationEvent = new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable, aWTInvocationLock, true);
        Object object = aWTInvocationLock;
        synchronized (object) {
            pluginEventQueue.postEvent(invocationEvent);
            aWTInvocationLock.wait();
        }
        object = invocationEvent.getException();
        if (object != null) {
            throw new InvocationTargetException((Throwable)object);
        }
    }

    public static void invokeLater(Runnable runnable) {
        pluginEventQueue.postEvent(new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
    }

    public static Thread createPluginSysThread(Runnable runnable) {
        Thread thread = new Thread(pluginThreadGroup, runnable);
        thread.setContextClassLoader(pluginSysClassLoader);
        return thread;
    }

    public static Thread createPluginSysThread(Runnable runnable, String string) {
        Thread thread = new Thread(pluginThreadGroup, runnable, string);
        thread.setContextClassLoader(pluginSysClassLoader);
        return thread;
    }

    public Object delegate(DeploySysAction deploySysAction) throws Exception {
        return PluginSysUtil.execute(deploySysAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object execute(DeploySysAction deploySysAction) throws Exception {
        if (Thread.currentThread().getThreadGroup().equals(pluginThreadGroup)) {
            return deploySysAction.execute();
        }
        final SysExecutionThread sysExecutionThread = new SysExecutionThread(deploySysAction);
        sysExecutionThread.setContextClassLoader(pluginSysClassLoader);
        if (SwingUtilities.isEventDispatchThread()) {
            Object object = sysExecutionThread.syncObject;
            synchronized (object) {
                DummyDialog dummyDialog;
                sysExecutionThread.theDummy = dummyDialog = new DummyDialog(null, true);
                dummyDialog.addWindowListener(new WindowAdapter(){

                    public void windowOpened(WindowEvent windowEvent) {
                        sysExecutionThread.start();
                    }

                    public void windowClosing(WindowEvent windowEvent) {
                        dummyDialog.hide();
                    }
                });
                Rectangle rectangle = new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize());
                if (!PluginSysUtil.isOnWindows()) {
                    dummyDialog.setLocation(rectangle.x + rectangle.width / 2 - 50, rectangle.y + rectangle.height / 2);
                } else {
                    dummyDialog.setLocation(-100, -100);
                }
                dummyDialog.setResizable(false);
                dummyDialog.toBack();
                dummyDialog.show();
                try {
                    sysExecutionThread.syncObject.wait();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    dummyDialog.hide();
                }
            }
        }
        sysExecutionThread.start();
        try {
            sysExecutionThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (sysExecutionThread.exception != null) {
            throw sysExecutionThread.exception;
        }
        return sysExecutionThread.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createAppContext(ThreadGroup threadGroup) {
        AppContextCreatorThread appContextCreatorThread = new AppContextCreatorThread(threadGroup);
        Object object = appContextCreatorThread.synObject;
        synchronized (object) {
            appContextCreatorThread.start();
            try {
                appContextCreatorThread.synObject.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static boolean isOnWindows() {
        String string = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        return string.indexOf("Windows") != -1;
    }

    static class SysExecutionThread
    extends Thread {
        Exception exception = null;
        Object result = null;
        DeploySysAction action = null;
        Object syncObject = new Object();
        DummyDialog theDummy = null;

        public SysExecutionThread(DeploySysAction deploySysAction) {
            super(pluginThreadGroup, "SysExecutionThead");
            this.action = deploySysAction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.result = this.action.execute();
            }
            catch (Exception exception) {
                this.exception = exception;
            }
            finally {
                if (this.theDummy != null) {
                    this.theDummy.secureHide();
                }
                Object object = this.syncObject;
                synchronized (object) {
                    this.syncObject.notifyAll();
                }
            }
        }
    }

    private static class AppContextCreatorThread
    extends Thread {
        Object synObject = new Object();

        public AppContextCreatorThread(ThreadGroup threadGroup) {
            super(threadGroup, "AppContext Creator Thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.synObject;
            synchronized (object) {
                AppContext appContext = SunToolkit.createNewAppContext();
                pluginEventQueue = (EventQueue)appContext.get(AppContext.EVENT_QUEUE_KEY);
                this.synObject.notifyAll();
            }
        }
    }

    private static class DummyDialog
    extends JDialog {
        private ThreadGroup _unsecureGroup = Thread.currentThread().getThreadGroup();

        DummyDialog(Frame frame, boolean bl) {
            super(frame, bl);
        }

        public void secureHide() {
            new Thread(this._unsecureGroup, new Runnable(){

                public void run() {
                    DummyDialog.this.hide();
                }
            }).start();
        }
    }
}

