/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.CRLExtensions;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CRLEntryImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public final class X509CRLImpl
extends X509CRL
implements DerEncoder {
    private static final int V1 = 0;
    private static final int V2 = 1;
    private byte[] signedCRL = null;
    private byte[] signature = null;
    private byte[] tbsCertList = null;
    private AlgorithmId sigAlgId = null;
    private int version;
    private AlgorithmId infoSigAlgId;
    private X500Name issuer = null;
    private Date thisUpdate = null;
    private Date nextUpdate = null;
    private Hashtable revokedCerts = new Hashtable(11);
    private CRLExtensions extensions = null;
    private static final boolean isExplicit = true;
    private static final long YR_2050 = 2524636800000L;
    private boolean readOnly = false;
    private X500Principal issuerX500Principal = null;
    private PublicKey verifiedPublicKey;
    private String verifiedProvider;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.X509CRLImpl";

    private X509CRLImpl() {
        if (debug != null) {
            debug.entry(8192L, className, "X509CRLImpl");
            debug.exit(8192L, className, "X509CRLImpl");
        }
    }

    public X509CRLImpl(byte[] byArray) throws CRLException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509CRLImpl", (Object)byArray);
        }
        try {
            this.parse(new DerValue(byArray));
        }
        catch (IOException iOException) {
            this.signedCRL = null;
            if (debug != null) {
                debug.exception(16384L, className, "X509CRLImpl", iOException);
            }
            throw new CRLException("Parsing error: " + iOException.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLImpl");
        }
    }

    public X509CRLImpl(DerValue derValue) throws CRLException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509CRLImpl", derValue);
        }
        try {
            this.parse(derValue);
        }
        catch (IOException iOException) {
            this.signedCRL = null;
            if (debug != null) {
                debug.exception(16384L, className, "X509CRLImpl", iOException);
            }
            throw new CRLException("Parsing error: " + iOException.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLImpl");
        }
    }

    public X509CRLImpl(InputStream inputStream) throws CRLException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509CRLImpl", inputStream);
        }
        try {
            this.parse(new DerValue(inputStream));
        }
        catch (IOException iOException) {
            this.signedCRL = null;
            if (debug != null) {
                debug.exception(16384L, className, "X509CRLImpl", iOException);
            }
            throw new CRLException("Parsing error: " + iOException.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLImpl");
        }
    }

    public X509CRLImpl(X500Name x500Name, Date date, Date date2) {
        if (debug != null) {
            Object[] objectArray = new Object[]{x500Name, date, date2};
            debug.entry(16384L, (Object)className, "X509CRLImpl", objectArray);
        }
        this.issuer = x500Name;
        this.thisUpdate = date != null ? new Date(date.getTime()) : date;
        this.nextUpdate = date2 != null ? new Date(date2.getTime()) : date2;
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLImpl");
        }
    }

    public X509CRLImpl(X500Name x500Name, Date date, Date date2, X509CRLEntry[] x509CRLEntryArray) throws CRLException {
        if (debug != null) {
            Object[] objectArray = new Object[]{x500Name, date, date2, x509CRLEntryArray};
            debug.entry(16384L, (Object)className, "X509CRLImpl", objectArray);
        }
        this.issuer = x500Name;
        this.thisUpdate = date != null ? new Date(date.getTime()) : date;
        this.nextUpdate = date2 != null ? new Date(date2.getTime()) : date2;
        if (x509CRLEntryArray != null) {
            for (int i = 0; i < x509CRLEntryArray.length; ++i) {
                if (x509CRLEntryArray[i] == null) continue;
                this.revokedCerts.put(x509CRLEntryArray[i].getSerialNumber(), x509CRLEntryArray[i]);
                if (!x509CRLEntryArray[i].hasExtensions()) continue;
                this.version = 1;
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLImpl");
        }
    }

    public X509CRLImpl(int n, X500Name x500Name, Date date, Date date2, X509CRLEntry[] x509CRLEntryArray, CRLExtensions cRLExtensions) throws CRLException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{new Integer(n), x500Name, date, date2, x509CRLEntryArray, cRLExtensions};
            debug.entry(16384L, (Object)className, "X509CRLImpl", objectArray);
        }
        if (n != 0 && n != 1) {
            throw new CRLException("CRL version " + n + " not supported");
        }
        this.version = n;
        this.issuer = x500Name;
        this.thisUpdate = date != null ? new Date(date.getTime()) : date;
        this.nextUpdate = date2 != null ? new Date(date2.getTime()) : date2;
        if (x509CRLEntryArray != null) {
            for (int i = 0; i < x509CRLEntryArray.length; ++i) {
                if (x509CRLEntryArray[i] == null) continue;
                this.revokedCerts.put(x509CRLEntryArray[i].getSerialNumber(), x509CRLEntryArray[i]);
                if (!x509CRLEntryArray[i].hasExtensions() || this.version >= 1) continue;
                throw new CRLException("Revoked certs extensions present. Invalid version number: " + this.version);
            }
        }
        if (cRLExtensions != null) {
            if (this.version < 1) {
                throw new CRLException("CRL extensions present. Invalid version number: " + this.version);
            }
            if (cRLExtensions != null) {
                objectArray = new DerOutputStream();
                cRLExtensions.encode((OutputStream)objectArray, false);
                DerInputStream derInputStream = null;
                try {
                    derInputStream = new DerInputStream(objectArray.toByteArray());
                }
                catch (IOException iOException) {
                    throw new CRLException(iOException.getMessage());
                }
                this.extensions = new CRLExtensions(derInputStream);
                this.version = 1;
            } else {
                this.extensions = cRLExtensions;
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLImpl");
        }
    }

    public X509CRLImpl(X500Name x500Name, Date date, Date date2, X509CRLEntry[] x509CRLEntryArray, CRLExtensions cRLExtensions) throws CRLException {
        this(x500Name, date, date2, x509CRLEntryArray);
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{x500Name, date, date2, x509CRLEntryArray, cRLExtensions};
            debug.entry(16384L, (Object)className, "X509CRLImpl", objectArray);
        }
        if (cRLExtensions != null) {
            if (cRLExtensions != null) {
                objectArray = new DerOutputStream();
                cRLExtensions.encode((OutputStream)objectArray, false);
                DerInputStream derInputStream = null;
                try {
                    derInputStream = new DerInputStream(objectArray.toByteArray());
                }
                catch (IOException iOException) {
                    throw new CRLException(iOException.getMessage());
                }
                this.extensions = new CRLExtensions(derInputStream);
                this.version = 1;
            } else {
                this.extensions = cRLExtensions;
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CRLImpl");
        }
    }

    public byte[] getEncodedInternal() throws CRLException {
        if (this.signedCRL == null) {
            throw new CRLException("Null CRL to encode");
        }
        return this.signedCRL;
    }

    public byte[] getEncoded() throws CRLException {
        if (debug != null) {
            debug.entry(16384L, className, "getEncoded");
        }
        byte[] byArray = (byte[])this.getEncodedInternal().clone();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getEncoded", (Object)byArray);
        }
        return byArray;
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "derEncode", outputStream);
        }
        try {
            outputStream.write(this.getEncoded());
        }
        catch (CRLException cRLException) {
            if (debug != null) {
                debug.exception(16384L, className, "derEncode", cRLException);
            }
            throw new IOException(cRLException.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "derEncode");
        }
    }

    public void encodeInfo(OutputStream outputStream) throws CRLException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encodeInfo", outputStream);
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            DerOutputStream derOutputStream3 = new DerOutputStream();
            if (this.version != 0) {
                derOutputStream.putInteger(BigInteger.valueOf(this.version));
            }
            this.infoSigAlgId.encode(derOutputStream);
            if (this.version == 0 && this.issuer.toString() == null) {
                if (debug != null) {
                    debug.text(16384L, className, "encodeInfo", "Null Issuer DN not allowed in v1 CRL");
                }
                throw new CRLException("Null Issuer DN not allowed in v1 CRL");
            }
            this.issuer.encode(derOutputStream);
            if (this.thisUpdate.getTime() < 2524636800000L) {
                derOutputStream.putUTCTime(this.thisUpdate);
            } else {
                derOutputStream.putGeneralizedTime(this.thisUpdate);
            }
            if (this.nextUpdate != null) {
                if (this.nextUpdate.getTime() < 2524636800000L) {
                    derOutputStream.putUTCTime(this.nextUpdate);
                } else {
                    derOutputStream.putGeneralizedTime(this.nextUpdate);
                }
            }
            if (!this.revokedCerts.isEmpty()) {
                Enumeration enumeration = this.revokedCerts.elements();
                while (enumeration.hasMoreElements()) {
                    ((X509CRLEntryImpl)enumeration.nextElement()).encode(derOutputStream2);
                }
                derOutputStream.write((byte)48, derOutputStream2);
            }
            if (this.extensions != null) {
                this.extensions.encode(derOutputStream, true);
            }
            derOutputStream3.write((byte)48, derOutputStream);
            this.tbsCertList = derOutputStream3.toByteArray();
            outputStream.write(this.tbsCertList);
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "encodeInfo", iOException);
            }
            throw new CRLException("Encoding error: " + iOException.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, className, "encodeInfo");
        }
    }

    public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "verify", publicKey);
        }
        this.verify(publicKey, "");
        if (debug != null) {
            debug.exit(16384L, className, "verify");
        }
    }

    public void verify(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (debug != null) {
            debug.entry(16384L, className, "verify", publicKey, string);
        }
        if (this.signedCRL == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Uninitialized CRL");
            }
            throw new CRLException("Uninitialized CRL");
        }
        Signature signature = null;
        if (string == null) {
            string = "";
        }
        if (this.verifiedPublicKey != null && this.verifiedPublicKey.equals(publicKey) && string.equals(this.verifiedProvider)) {
            return;
        }
        signature = string.length() == 0 ? Signature.getInstance(this.sigAlgId.getName()) : Signature.getInstance(this.sigAlgId.getName(), string);
        signature.initVerify(publicKey);
        if (this.tbsCertList == null) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Uninitialized CRL");
            }
            throw new CRLException("Uninitialized CRL");
        }
        signature.update(this.tbsCertList, 0, this.tbsCertList.length);
        if (!signature.verify(this.signature)) {
            if (debug != null) {
                debug.text(16384L, className, "verify", "Signature does not match.");
            }
            throw new SignatureException("Signature does not match.");
        }
        this.verifiedPublicKey = publicKey;
        this.verifiedProvider = string;
        if (debug != null) {
            debug.exit(16384L, className, "verify");
        }
    }

    public void sign(PrivateKey privateKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (debug != null) {
            debug.entry(16384L, className, "sign", privateKey, string);
        }
        this.sign(privateKey, string, null);
        if (debug != null) {
            debug.exit(16384L, className, "sign");
        }
    }

    public void sign(PrivateKey privateKey, String string, String string2) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Object object;
        if (debug != null) {
            object = new Object[]{privateKey, string, string2};
            debug.entry(16384L, (Object)className, "sign", (Object[])object);
        }
        try {
            if (this.readOnly) {
                if (debug != null) {
                    debug.text(16384L, className, "sign", "cannot over-write existing CRL");
                }
                throw new CRLException("cannot over-write existing CRL");
            }
            object = null;
            object = string2 == null || string2.length() == 0 ? Signature.getInstance(string) : Signature.getInstance(string, string2);
            ((Signature)object).initSign(privateKey);
            this.infoSigAlgId = this.sigAlgId = AlgorithmId.get(((Signature)object).getAlgorithm());
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encodeInfo(derOutputStream2);
            this.sigAlgId.encode(derOutputStream2);
            ((Signature)object).update(this.tbsCertList, 0, this.tbsCertList.length);
            this.signature = ((Signature)object).sign();
            derOutputStream2.putBitString(this.signature);
            derOutputStream.write((byte)48, derOutputStream2);
            this.signedCRL = derOutputStream.toByteArray();
            this.readOnly = true;
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "sign", iOException);
            }
            throw new CRLException("Error while encoding data: " + iOException.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, className, "sign");
        }
    }

    public String toString() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("X.509 CRL v" + (this.version + 1) + "\r\n");
        if (this.sigAlgId != null) {
            stringBuilder.append("Signature Algorithm: " + this.sigAlgId.toString() + ", OID=" + this.sigAlgId.getOID().toString() + "\r\n");
        }
        if (this.issuer != null) {
            stringBuilder.append("Issuer: " + this.issuer.toString() + "\r\n");
        }
        if (this.thisUpdate != null) {
            stringBuilder.append("\r\nThis Update: " + this.thisUpdate.toString() + "\r\n");
        }
        if (this.nextUpdate != null) {
            stringBuilder.append("Next Update: " + this.nextUpdate.toString() + "\r\n");
        }
        if (this.revokedCerts.isEmpty()) {
            stringBuilder.append("\r\nNO certificates have been revoked\r\n");
        } else {
            stringBuilder.append("\r\nRevoked Certificates: " + this.revokedCerts.size());
            int n = 1;
            object = this.revokedCerts.elements();
            while (object.hasMoreElements()) {
                stringBuilder.append("\r\n[" + n + "] " + ((X509CRLEntry)object.nextElement()).toString());
                ++n;
            }
        }
        if (this.extensions != null) {
            Collection<Extension> collection = this.extensions.getAllExtensions();
            object = collection.toArray();
            stringBuilder.append("\r\nCRL Extensions: " + ((Object)object).length);
            for (int i = 0; i < ((Object)object).length; ++i) {
                stringBuilder.append("\r\n[" + (i + 1) + "]: ");
                Extension extension = (Extension)object[i];
                try {
                    if (OIDMap.getClass(extension.getExtensionId()) == null) {
                        stringBuilder.append(extension.toString());
                        byte[] byArray = extension.getExtensionValue();
                        if (byArray == null) continue;
                        DerOutputStream derOutputStream = new DerOutputStream();
                        derOutputStream.putOctetString(byArray);
                        byArray = derOutputStream.toByteArray();
                        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                        stringBuilder.append("Extension unknown: DER encoded OCTET string =\r\n" + hexDumpEncoder.encodeBuffer(byArray) + "\r\n");
                        continue;
                    }
                    stringBuilder.append(extension.toString());
                    continue;
                }
                catch (Exception exception) {
                    stringBuilder.append(", Error parsing this extension");
                }
            }
        }
        if (this.signature != null) {
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            stringBuilder.append("\r\nSignature:\r\n" + hexDumpEncoder.encodeBuffer(this.signature) + "\r\n");
        } else {
            stringBuilder.append("NOT signed yet\r\n");
        }
        return stringBuilder.toString();
    }

    public boolean isRevoked(Certificate certificate) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isRevoked", certificate);
        }
        if (this.revokedCerts == null || this.revokedCerts.isEmpty()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isRevoked", new Boolean(false));
            }
            return false;
        }
        if (!(certificate instanceof X509Certificate)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isRevoked", new Boolean(false));
            }
            return false;
        }
        BigInteger bigInteger = ((X509Certificate)certificate).getSerialNumber();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isRevoked", new Boolean(this.revokedCerts.containsKey(bigInteger)));
        }
        return this.revokedCerts.containsKey(bigInteger);
    }

    public int getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
            debug.exit(16384L, (Object)className, "getVersion", new Integer(this.version + 1));
        }
        return this.version + 1;
    }

    public Principal getIssuerDN() {
        if (debug != null) {
            debug.entry(16384L, className, "getIssuerDN");
            debug.exit(16384L, (Object)className, "getIssuerDN", this.issuer);
        }
        return this.issuer;
    }

    public X500Principal getIssuerX500Principal() {
        if (this.issuerX500Principal == null || !this.readOnly) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                ((X500Name)this.getIssuerDN()).encode(derOutputStream);
                this.issuerX500Principal = new X500Principal(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.issuerX500Principal;
    }

    public static X500Principal getIssuerX500Principal(X509CRL x509CRL) {
        try {
            DerValue derValue;
            byte[] byArray = x509CRL.getEncoded();
            DerInputStream derInputStream = new DerInputStream(byArray);
            DerValue derValue2 = derInputStream.getSequence(3)[0];
            DerInputStream derInputStream2 = derValue2.getData();
            byte by = (byte)derInputStream2.peekByte();
            if (by == 2) {
                derValue = derInputStream2.getDerValue();
            }
            derValue = derInputStream2.getDerValue();
            derValue = derInputStream2.getDerValue();
            byte[] byArray2 = derValue.toByteArray();
            return new X500Principal(byArray2);
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not parse issuer", exception);
        }
    }

    public Date getThisUpdate() {
        if (debug != null) {
            debug.entry(16384L, className, "getThisUpdate");
            debug.exit(16384L, (Object)className, "getThisUpdate", new Date(this.thisUpdate.getTime()));
        }
        return new Date(this.thisUpdate.getTime());
    }

    public Date getNextUpdate() {
        Date date;
        if (debug != null) {
            debug.entry(16384L, className, "getNextUpdate");
        }
        if (this.nextUpdate == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getNextUpdate", null);
            }
            return null;
        }
        try {
            date = new Date(this.nextUpdate.getTime());
        }
        catch (Exception exception) {
            date = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getNextUpdate_1", date);
        }
        return date;
    }

    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getRevokedCertificate", bigInteger);
        }
        if (this.revokedCerts == null || this.revokedCerts.isEmpty()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getRevokedCertificate", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getRevokedCertificate", this.revokedCerts.get(bigInteger));
        }
        return (X509CRLEntry)this.revokedCerts.get(bigInteger);
    }

    public Set getRevokedCertificates() {
        if (debug != null) {
            debug.entry(16384L, className, "getRevokedCertificates");
        }
        if (this.revokedCerts == null || this.revokedCerts.isEmpty()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getRevokedCertificates", null);
            }
            return null;
        }
        HashSet<Object> hashSet = new HashSet<Object>(11);
        Collection collection = this.revokedCerts.values();
        Object[] objectArray = collection.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            hashSet.add(objectArray[i]);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getRevokedCertificates", hashSet);
        }
        return hashSet;
    }

    public byte[] getTBSCertList() throws CRLException {
        if (debug != null) {
            debug.entry(16384L, className, "getTBSCertList");
        }
        if (this.tbsCertList == null) {
            if (debug != null) {
                debug.text(16384L, className, "getTBSCertList", "Uninitialized CRL");
            }
            throw new CRLException("Uninitialized CRL");
        }
        byte[] byArray = new byte[this.tbsCertList.length];
        System.arraycopy(this.tbsCertList, 0, byArray, 0, byArray.length);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getTBSCertList", byArray);
        }
        return byArray;
    }

    public byte[] getSignature() {
        if (debug != null) {
            debug.entry(16384L, className, "getSignature");
        }
        if (this.signature == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSignature", null);
            }
            return null;
        }
        byte[] byArray = new byte[this.signature.length];
        System.arraycopy(this.signature, 0, byArray, 0, byArray.length);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignature", byArray);
        }
        return byArray;
    }

    public String getSigAlgName() {
        if (debug != null) {
            debug.entry(16384L, className, "getSignature");
        }
        if (this.sigAlgId == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSignature", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignature", this.sigAlgId.getName());
        }
        return this.sigAlgId.getName();
    }

    public String getSigAlgOID() {
        if (debug != null) {
            debug.entry(16384L, className, "getSigAlgOID");
        }
        if (this.sigAlgId == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSigAlgOID", null);
            }
            return null;
        }
        ObjectIdentifier objectIdentifier = this.sigAlgId.getOID();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSigAlgOID", objectIdentifier.toString());
        }
        return objectIdentifier.toString();
    }

    public byte[] getSigAlgParams() {
        if (debug != null) {
            debug.entry(16384L, className, "getSigAlgParams");
        }
        if (this.sigAlgId == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSigAlgParams", null);
            }
            return null;
        }
        try {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSigAlgParams", this.sigAlgId.getEncodedParams());
            }
            return this.sigAlgId.getEncodedParams();
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "getSigAlgParams", iOException);
                debug.exit(16384L, (Object)className, "getSigAlgParams", null);
            }
            return null;
        }
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "hasUnsupportedCriticalExtension");
        }
        if (this.extensions == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "hasUnsupportedCriticalExtension", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasUnsupportedCriticalExtension", new Boolean(this.extensions.hasUnsupportedCriticalExtension()));
        }
        return this.extensions.hasUnsupportedCriticalExtension();
    }

    public Set getCriticalExtensionOIDs() {
        if (debug != null) {
            debug.entry(16384L, className, "getCriticalExtensionOIDs");
        }
        if (this.extensions == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCriticalExtensionOIDs", null);
            }
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>(11);
        Enumeration<Extension> enumeration = this.extensions.getElements();
        while (enumeration.hasMoreElements()) {
            Extension extension = enumeration.nextElement();
            if (!extension.isCritical()) continue;
            hashSet.add(extension.getExtensionId().toString());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCriticalExtensionOIDs", hashSet);
        }
        return hashSet;
    }

    public Set getNonCriticalExtensionOIDs() {
        if (debug != null) {
            debug.entry(16384L, className, "getNonCriticalExtensionOIDs");
        }
        if (this.extensions == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getNonCriticalExtensionOIDs", null);
            }
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>(11);
        Enumeration<Extension> enumeration = this.extensions.getElements();
        while (enumeration.hasMoreElements()) {
            Extension extension = enumeration.nextElement();
            if (extension.isCritical()) continue;
            hashSet.add(extension.getExtensionId().toString());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getNonCriticalExtensionOIDs", hashSet);
        }
        return hashSet;
    }

    public byte[] getExtensionValue(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getExtensionValue", string);
        }
        if (this.extensions == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getExtensionValue_1", null);
            }
            return null;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            String string2 = OIDMap.getName(new ObjectIdentifier(string));
            Object object4 = null;
            if (string2 == null) {
                object3 = new ObjectIdentifier(string);
                object2 = null;
                Enumeration<Extension> enumeration = this.extensions.getElements();
                while (enumeration.hasMoreElements()) {
                    object2 = enumeration.nextElement();
                    object = ((Extension)object2).getExtensionId();
                    if (!((ObjectIdentifier)object).equals((ObjectIdentifier)object3)) continue;
                    object4 = object2;
                    break;
                }
            } else {
                object4 = this.extensions.get(string2);
            }
            if (object4 == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getExtensionValue_2", null);
                }
                return null;
            }
            object3 = ((Extension)object4).getExtensionValue();
            if (object3 == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getExtensionValue_3", null);
                }
                return null;
            }
            object2 = new DerOutputStream();
            ((DerOutputStream)object2).putOctetString((byte[])object3);
            object = ((ByteArrayOutputStream)object2).toByteArray();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getExtensionValue", object);
            }
            return object;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "getExtensionValue", exception);
                debug.exit(16384L, (Object)className, "getExtensionValue_4", null);
            }
            return null;
        }
    }

    private void parse(DerValue derValue) throws CRLException, IOException {
        DerValue derValue2;
        AlgorithmId algorithmId;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "parse", derValue);
        }
        if (this.readOnly) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "parse", "cannot over-write existing CRL");
            }
            throw new CRLException("cannot over-write existing CRL");
        }
        this.signedCRL = derValue.toByteArray();
        DerValue[] derValueArray = new DerValue[]{derValue.getData().getDerValue(), derValue.getData().getDerValue(), derValue.getData().getDerValue()};
        if (derValue.getData().available() != 0) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "parse", "signed overrun, bytes = " + derValue.getData().available());
            }
            throw new CRLException("signed overrun, bytes = " + derValue.getData().available());
        }
        if (derValueArray[0].getTag() != 48) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "parse", "signed CRL fields invalid");
            }
            throw new CRLException("signed CRL fields invalid");
        }
        this.sigAlgId = AlgorithmId.parse(derValueArray[1]);
        this.signature = derValueArray[2].getBitString();
        if (derValueArray[1].getData().available() != 0) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "parse", "AlgorithmId field overrun");
            }
            throw new CRLException("AlgorithmId field overrun");
        }
        if (derValueArray[2].getData().available() != 0) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "parse", "Signature field overrun");
            }
            throw new CRLException("Signature field overrun");
        }
        this.tbsCertList = derValueArray[0].toByteArray();
        DerInputStream derInputStream = derValueArray[0].getData();
        this.version = 0;
        byte by = (byte)derInputStream.peekByte();
        if (by == 2) {
            this.version = derInputStream.getInteger().intValue();
            if (this.version != 1) {
                if (debug != null) {
                    debug.exit(8192L, (Object)className, "parse", "Invalid version");
                }
                throw new CRLException("Invalid version");
            }
        }
        if (!(algorithmId = AlgorithmId.parse(derValue2 = derInputStream.getDerValue())).equals(this.sigAlgId)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "parse", "Signature algorithm mismatch");
            }
            throw new CRLException("Signature algorithm mismatch");
        }
        this.infoSigAlgId = algorithmId;
        this.issuer = new X500Name(derInputStream);
        if (this.issuer.toString() == null && this.version == 0) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "parse", "Null Issuer DN allowed only in v2 CRL");
            }
            throw new CRLException("Null Issuer DN allowed only in v2 CRL");
        }
        by = (byte)derInputStream.peekByte();
        if (by == 23) {
            this.thisUpdate = derInputStream.getUTCTime();
        } else if (by == 24) {
            this.thisUpdate = derInputStream.getGeneralizedTime();
        } else {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "parse", "Invalid encoding for thisUpdate (tag=" + by + ")");
            }
            throw new CRLException("Invalid encoding for thisUpdate (tag=" + by + ")");
        }
        by = (byte)derInputStream.peekByte();
        if (by == 23) {
            this.nextUpdate = derInputStream.getUTCTime();
        } else if (by == 24) {
            this.nextUpdate = derInputStream.getGeneralizedTime();
        }
        if (derInputStream.available() == 0) {
            return;
        }
        by = (byte)derInputStream.peekByte();
        if (by == 48 && (by & 0xC0) != 128) {
            DerValue[] derValueArray2 = derInputStream.getSequence(4);
            for (int i = 0; i < derValueArray2.length; ++i) {
                X509CRLEntryImpl x509CRLEntryImpl = new X509CRLEntryImpl(derValueArray2[i]);
                if (x509CRLEntryImpl.hasExtensions() && this.version == 0) {
                    if (debug != null) {
                        debug.exit(8192L, (Object)className, "parse", "Invalid encoding, extensions not supported in CRL v1 entries.");
                    }
                    throw new CRLException("Invalid encoding, extensions not supported in CRL v1 entries.");
                }
                this.revokedCerts.put(x509CRLEntryImpl.getSerialNumber(), x509CRLEntryImpl);
            }
        }
        if (derInputStream.available() == 0) {
            return;
        }
        derValue2 = derInputStream.getDerValue();
        if (derValue2.isConstructed() && derValue2.isContextSpecific((byte)0)) {
            if (this.version == 0) {
                if (debug != null) {
                    debug.exit(8192L, (Object)className, "parse", "Invalid encoding, extensions not supported in CRL v1.");
                }
                throw new CRLException("Invalid encoding, extensions not supported in CRL v1.");
            }
            this.extensions = new CRLExtensions(derValue2.getData());
        }
        this.readOnly = true;
        if (debug != null) {
            debug.exit(8192L, className, "parse");
        }
    }
}

