/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AVA;
import com.ibm.security.x509.AVAComparator;
import com.ibm.security.x509.DistributionPointName;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RDN
implements DistributionPointName {
    final AVA[] assertion;
    private volatile List<AVA> avaList;
    private volatile String canonicalString;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.RDN";

    public RDN(String string) throws IOException {
        AVA aVA;
        String string2;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        ArrayList<AVA> arrayList = new ArrayList<AVA>(3);
        int n4 = string.indexOf(43);
        while (n4 >= 0) {
            if (n4 > 0 && string.charAt(n4 - 1) != '\\' && (n += X500Name.countQuotes(string, n2, n4)) != 1) {
                string2 = string.substring(n3, n4);
                if (string2.length() == 0) {
                    throw new IOException("empty AVA in RDN \"" + string + "\"");
                }
                aVA = new AVA(new StringReader(string2));
                arrayList.add(aVA);
                n3 = n4 + 1;
                n = 0;
            }
            n2 = n4 + 1;
            n4 = string.indexOf(43, n2);
        }
        string2 = string.substring(n3);
        if (string2.length() == 0) {
            throw new IOException("empty AVA in RDN \"" + string + "\"");
        }
        aVA = new AVA(new StringReader(string2));
        arrayList.add(aVA);
        this.assertion = arrayList.toArray(new AVA[arrayList.size()]);
    }

    RDN(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "RDN", derValue);
        }
        if (derValue.getTag() != 49) {
            if (debug != null) {
                debug.text(16384L, className, "RDN", "X500 RDN");
            }
            throw new IOException("X500 RDN");
        }
        DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
        DerValue[] derValueArray = derInputStream.getSet(1);
        int n = derValueArray.length;
        this.assertion = new AVA[n];
        for (int i = 0; i < n; ++i) {
            derInputStream = new DerInputStream(derValueArray[i].toByteArray());
            this.assertion[i] = new AVA(derInputStream);
        }
        if (debug != null) {
            debug.exit(16384L, className, "RDN");
        }
    }

    public RDN(AVA[] aVAArray) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "RDN", aVAArray);
        }
        this.assertion = new AVA[aVAArray.length];
        for (int i = 0; i < aVAArray.length; ++i) {
            this.assertion[i] = aVAArray[i];
        }
        if (debug != null) {
            debug.exit(16384L, className, "RDN");
        }
    }

    RDN(int n) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "RDN", new Integer(n));
        }
        this.assertion = new AVA[n];
        if (debug != null) {
            debug.exit(16384L, className, "RDN");
        }
    }

    List<AVA> avas() {
        List<AVA> list = this.avaList;
        if (list == null) {
            this.avaList = list = Collections.unmodifiableList(Arrays.asList(this.assertion));
        }
        return list;
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object instanceof RDN) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((RDN)object));
            }
            return this.equals((RDN)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    boolean equals(RDN rDN) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", rDN);
        }
        if (rDN == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (this.assertion.length != rDN.assertion.length) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        for (int i = 0; i < this.assertion.length; ++i) {
            if (this.assertion[i].equals(rDN.assertion[i])) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_4", true);
        }
        return true;
    }

    public int hashCode() {
        return this.toRFC2253String(true).hashCode();
    }

    DerValue findAttribute(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "findAttribute", objectIdentifier);
        }
        for (int i = 0; i < this.assertion.length; ++i) {
            if (!this.assertion[i].oid.equals(objectIdentifier)) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "findAttribute_1", this.assertion[i].value);
            }
            return this.assertion[i].value;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "findAttribute_2", null);
        }
        return null;
    }

    void encode(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", derOutputStream);
        }
        derOutputStream.putOrderedSetOf((byte)49, this.assertion);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putOrderedSetOf((byte)49, this.assertion);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public String toString() {
        String string = null;
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        for (int i = 0; i < this.assertion.length; ++i) {
            string = string == null ? this.assertion[i].toString() : string + " + " + this.assertion[i];
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public int size() {
        if (debug != null) {
            debug.entry(16384L, className, "size");
            debug.exit(16384L, (Object)className, "size", this.assertion.length);
        }
        return this.assertion.length;
    }

    public AVA getAVA(int n) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getAVA", new Integer(n));
            debug.exit(16384L, (Object)className, "getAVA", this.assertion[n]);
        }
        return this.assertion[n];
    }

    public String toRFC1779String() {
        String string = null;
        for (int i = 0; i < this.assertion.length; ++i) {
            string = string == null ? this.assertion[i].toRFC1779String() : string + " + " + this.assertion[i];
        }
        return string;
    }

    public String toRFC2253String() {
        String string = null;
        for (int i = 0; i < this.assertion.length; ++i) {
            string = string == null ? this.assertion[i].toRFC2253String() : string + " + " + this.assertion[i];
        }
        return string;
    }

    public String toRFC2253String(boolean bl) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "toRFC2253String(boolean)", new Boolean(bl));
        }
        if (!bl) {
            return this.toRFC2253StringInternal(false);
        }
        String string = this.canonicalString;
        if (string == null) {
            this.canonicalString = string = this.toRFC2253StringInternal(true);
        }
        return string;
    }

    private String toRFC2253StringInternal(boolean bl) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "toRFC2254StrInl(boolean)", new Boolean(bl));
        }
        if (this.assertion.length == 1) {
            return bl ? this.assertion[0].toRFC2253CanonicalString() : this.assertion[0].toRFC2253String();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!bl) {
            for (int i = 0; i < this.assertion.length; ++i) {
                if (i > 0) {
                    stringBuilder.append('+');
                }
                stringBuilder.append(this.assertion[i].toRFC2253String());
            }
        } else {
            int n;
            ArrayList<AVA> arrayList = new ArrayList<AVA>(this.assertion.length);
            for (n = 0; n < this.assertion.length; ++n) {
                arrayList.add(this.assertion[n]);
            }
            Collections.sort(arrayList, AVAComparator.getInstance());
            for (n = 0; n < arrayList.size(); ++n) {
                if (n > 0) {
                    stringBuilder.append('+');
                }
                stringBuilder.append(((AVA)arrayList.get(n)).toRFC2253CanonicalString());
            }
        }
        return stringBuilder.toString();
    }
}

