/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.util.Date;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrivateKeyUsageExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.PrivateKeyUsage";
    public static final String NAME = "PrivateKeyUsage";
    public static final String NOT_BEFORE = "not_before";
    public static final String NOT_AFTER = "not_after";
    private static final byte TAG_BEFORE = 0;
    private static final byte TAG_AFTER = 1;
    private Date notBefore = null;
    private Date notAfter = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.PrivateKeyUsageExtension";

    private void encodeThis() throws IOException {
        DerOutputStream derOutputStream;
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.notBefore == null && this.notAfter == null) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.notBefore != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putGeneralizedTime(this.notBefore);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), derOutputStream);
        }
        if (this.notAfter != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putGeneralizedTime(this.notAfter);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)1), derOutputStream);
        }
        derOutputStream2.write((byte)48, derOutputStream3);
        this.extensionValue = derOutputStream2.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    public PrivateKeyUsageExtension(Date date, Date date2) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "PrivateKeyUsageExtension", date, date2);
        }
        this.notBefore = date != null ? new Date(date.getTime()) : date;
        this.notAfter = date2 != null ? new Date(date2.getTime()) : date2;
        this.extensionId = PKIXExtensions.PrivateKeyUsage_Id;
        this.critical = false;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "PrivateKeyUsageExtension");
        }
    }

    public PrivateKeyUsageExtension(Boolean bl, Object object) throws CertificateException, IOException {
        if (debug != null) {
            debug.entry(16384L, className, "PrivateKeyUsageExtension", bl, object);
        }
        this.extensionId = PKIXExtensions.PrivateKeyUsage_Id;
        this.critical = bl;
        if (!(object instanceof byte[])) {
            if (debug != null) {
                debug.text(16384L, className, "PrivateKeyUsageExtension", "Illegal argument type");
            }
            throw new CertificateException("Illegal argument type");
        }
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        System.arraycopy(object, 0, byArray, 0, n);
        this.extensionValue = byArray;
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(2);
        for (int i = 0; i < derValueArray.length; ++i) {
            DerValue derValue = derValueArray[i];
            if (derValue.isContextSpecific((byte)0) && !derValue.isConstructed()) {
                if (this.notBefore != null) {
                    if (debug != null) {
                        debug.text(16384L, className, "PrivateKeyUsageExtension", "Duplicate notBefore in PrivateKeyUsage.");
                    }
                    throw new CertificateParsingException("Duplicate notBefore in PrivateKeyUsage.");
                }
                derValue.resetTag((byte)24);
                derInputStream = new DerInputStream(derValue.toByteArray());
                this.notBefore = derInputStream.getGeneralizedTime();
                continue;
            }
            if (derValue.isContextSpecific((byte)1) && !derValue.isConstructed()) {
                if (this.notAfter != null) {
                    if (debug != null) {
                        debug.text(16384L, className, "PrivateKeyUsageExtension", "Duplicate notAfter in PrivateKeyUsage.");
                    }
                    throw new CertificateParsingException("Duplicate notAfter in PrivateKeyUsage.");
                }
                derValue.resetTag((byte)24);
                derInputStream = new DerInputStream(derValue.toByteArray());
                this.notAfter = derInputStream.getGeneralizedTime();
                continue;
            }
            if (debug != null) {
                debug.text(16384L, className, "PrivateKeyUsageExtension", "Invalid encoding of PrivateKeyUsageExtension");
            }
            throw new IOException("Invalid encoding of PrivateKeyUsageExtension");
        }
        if (debug != null) {
            debug.exit(16384L, className, "PrivateKeyUsageExtension");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", super.toString() + "PrivateKeyUsage: [\n" + (this.notBefore == null ? "" : "From: " + this.notBefore.toString() + ", ") + (this.notAfter == null ? "" : "To: " + this.notAfter.toString()) + "]\n");
        }
        return super.toString() + "PrivateKeyUsage: [\n" + (this.notBefore == null ? "" : "From: " + this.notBefore.toString() + ", ") + (this.notAfter == null ? "" : "To: " + this.notAfter.toString()) + "]\n";
    }

    public void valid() throws CertificateNotYetValidException, CertificateExpiredException {
        if (debug != null) {
            debug.entry(16384L, className, "valid");
        }
        Date date = new Date();
        this.valid(date);
        if (debug != null) {
            debug.exit(16384L, className, "valid");
        }
    }

    public void valid(Date date) throws CertificateNotYetValidException, CertificateExpiredException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "valid", date);
        }
        if (this.notBefore.after(date)) {
            if (debug != null) {
                debug.text(16384L, className, "valid", "NotBefore: " + this.notBefore.toString());
            }
            throw new CertificateNotYetValidException("NotBefore: " + this.notBefore.toString());
        }
        if (this.notAfter.before(date)) {
            if (debug != null) {
                debug.text(16384L, className, "valid", "NotAfter: " + this.notAfter.toString());
            }
            throw new CertificateExpiredException("NotAfter: " + this.notAfter.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "valid");
        }
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.PrivateKeyUsage_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void decode(InputStream inputStream) throws CertificateException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new CertificateException("Method not to be called directly.");
    }

    @Override
    public void set(String string, Object object) throws CertificateException, IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (!(object instanceof Date)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute must be of type Date.");
            }
            throw new CertificateException("Attribute must be of type Date.");
        }
        if (string.equalsIgnoreCase(NOT_BEFORE)) {
            this.notBefore = new Date(((Date)object).getTime());
        } else if (string.equalsIgnoreCase(NOT_AFTER)) {
            this.notAfter = new Date(((Date)object).getTime());
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:PrivateKeyUsage.");
            }
            throw new CertificateException("Attribute name not recognized by CertAttrSet:PrivateKeyUsage.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String string) throws CertificateException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (string.equalsIgnoreCase(NOT_BEFORE)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_1", new Date(this.notBefore.getTime()));
            }
            return new Date(this.notBefore.getTime());
        }
        if (string.equalsIgnoreCase(NOT_AFTER)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", new Date(this.notAfter.getTime()));
            }
            return new Date(this.notAfter.getTime());
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:PrivateKeyUsage.");
        }
        throw new CertificateException("Attribute name not recognized by CertAttrSet:PrivateKeyUsage.");
    }

    @Override
    public void delete(String string) throws CertificateException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (string.equalsIgnoreCase(NOT_BEFORE)) {
            this.notBefore = null;
        } else if (string.equalsIgnoreCase(NOT_AFTER)) {
            this.notAfter = null;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:PrivateKeyUsage.");
            }
            throw new CertificateException("Attribute name not recognized by CertAttrSet:PrivateKeyUsage.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(NOT_BEFORE);
        attributeNameEnumeration.addElement(NOT_AFTER);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

