/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.CertificatePolicyMap;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolicyMappingsExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.PolicyMappings";
    public static final String NAME = "PolicyMappings";
    public static final String MAP = "map";
    private Vector<CertificatePolicyMap> maps = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.PolicyMappingsExtension";

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.maps == null || this.maps.isEmpty()) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        for (int i = 0; i < this.maps.size(); ++i) {
            this.maps.elementAt(i).encode(derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream2);
        this.extensionValue = derOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    public PolicyMappingsExtension(Vector<CertificatePolicyMap> vector) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PolicyMappingsExtension", vector);
        }
        this.extensionId = PKIXExtensions.PolicyMappings_Id;
        this.critical = false;
        if (vector != null) {
            this.maps = (Vector)vector.clone();
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "PolicyMappingsExtension");
        }
    }

    public PolicyMappingsExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "PolicyMappingsExtension");
        }
        this.extensionId = PKIXExtensions.PolicyMappings_Id;
        this.critical = false;
        this.maps = new Vector(1, 1);
        if (debug != null) {
            debug.exit(16384L, className, "PolicyMappingsExtension");
        }
    }

    public PolicyMappingsExtension(Boolean bl, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "PolicyMappingsExtension", bl, object);
        }
        this.extensionId = PKIXExtensions.PolicyMappings_Id;
        this.critical = bl;
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = Array.getByte(object, i);
        }
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "PolicyMappingsExtension", "Invalid encoding for PolicyMappingsExtension.");
            }
            throw new IOException("Invalid encoding for PolicyMappingsExtension.");
        }
        this.maps = new Vector(1, 1);
        while (derValue.getData().available() != 0) {
            DerValue derValue2 = derValue.getData().getDerValue();
            CertificatePolicyMap certificatePolicyMap = new CertificatePolicyMap(derValue2);
            this.maps.addElement(certificatePolicyMap);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PolicyMappingsExtension");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.maps == null) {
            return "";
        }
        String string = super.toString() + "PolicyMappings [\n" + this.maps.toString() + "]\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.PolicyMappings_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (string.equalsIgnoreCase(MAP)) {
            if (!(object instanceof Vector)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type Vector.");
                }
                throw new IOException("Attribute value should be of type Vector.");
            }
            this.maps = object != null ? (Vector)((Vector)object).clone() : null;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:PolicyMappingsExtension.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:PolicyMappingsExtension.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (string.equalsIgnoreCase(MAP)) {
            if (this.maps != null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_1", this.maps.clone());
                }
                return this.maps.clone();
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", this.maps);
            }
            return null;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:PolicyMappingsExtension.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:PolicyMappingsExtension.");
    }

    @Override
    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (!string.equalsIgnoreCase(MAP)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:PolicyMappingsExtension.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:PolicyMappingsExtension.");
        }
        this.maps = null;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(MAP);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

