/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.DNSName;
import com.ibm.security.x509.EDIPartyName;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.GeneralSubtree;
import com.ibm.security.x509.IPAddressName;
import com.ibm.security.x509.OIDName;
import com.ibm.security.x509.OtherName;
import com.ibm.security.x509.RFC822Name;
import com.ibm.security.x509.URIName;
import com.ibm.security.x509.X400Address;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GeneralSubtrees
implements Cloneable {
    private final List<GeneralSubtree> trees;
    private static final int NAME_DIFF_TYPE = -1;
    private static final int NAME_MATCH = 0;
    private static final int NAME_NARROWS = 1;
    private static final int NAME_WIDENS = 2;
    private static final int NAME_SAME_TYPE = 3;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.GeneralSubtrees";

    public GeneralSubtrees() {
        this.trees = new ArrayList<GeneralSubtree>();
    }

    private GeneralSubtrees(GeneralSubtrees generalSubtrees) {
        ArrayList arrayList = (ArrayList)generalSubtrees.trees;
        this.trees = (List)arrayList.clone();
    }

    public GeneralSubtrees(Vector<GeneralSubtree> vector) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "GeneralSubtrees", vector);
        }
        if (vector != null) {
            ArrayList<GeneralSubtree> arrayList = new ArrayList<GeneralSubtree>();
            for (int i = 0; i < vector.size(); ++i) {
                GeneralSubtree generalSubtree = vector.get(i);
                DerOutputStream derOutputStream = new DerOutputStream();
                generalSubtree.encode(derOutputStream);
                DerValue derValue = new DerValue(derOutputStream.toByteArray());
                GeneralSubtree generalSubtree2 = new GeneralSubtree(derValue);
                arrayList.add(generalSubtree2);
            }
            this.trees = arrayList;
        } else {
            this.trees = vector;
        }
        if (debug != null) {
            debug.exit(16384L, className, "GeneralSubtrees");
        }
    }

    public GeneralSubtrees(DerValue derValue) throws IOException {
        this();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "GeneralSubtrees", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "GeneralSubtrees", "Invalid encoding of GeneralSubtrees.");
            }
            throw new IOException("Invalid encoding of GeneralSubtrees.");
        }
        while (derValue.getData().available() != 0) {
            DerValue derValue2 = derValue.getData().getDerValue();
            GeneralSubtree generalSubtree = new GeneralSubtree(derValue2);
            this.trees.add(generalSubtree);
        }
        if (debug != null) {
            debug.exit(16384L, className, "GeneralSubtrees");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = "   GeneralSubtrees:\n" + this.trees.toString() + "\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", derOutputStream);
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        for (int i = 0; i < this.trees.size(); ++i) {
            this.trees.get(i).encode(derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream2);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public Vector getSubtrees() {
        if (debug != null) {
            debug.entry(16384L, className, "getSubtrees");
        }
        if (this.trees == null || this.trees.size() == 0) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSubtrees_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSubtrees_2", ((ArrayList)this.trees).clone());
        }
        return new Vector((ArrayList)((ArrayList)this.trees).clone());
    }

    public void add(GeneralSubtree generalSubtree) {
        if (generalSubtree == null) {
            throw new NullPointerException();
        }
        this.trees.add(generalSubtree);
    }

    public Object clone() {
        return new GeneralSubtrees(this);
    }

    public boolean contains(GeneralSubtree generalSubtree) {
        if (generalSubtree == null) {
            throw new NullPointerException();
        }
        return this.trees.contains(generalSubtree);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GeneralSubtrees)) {
            return false;
        }
        GeneralSubtrees generalSubtrees = (GeneralSubtrees)object;
        return ((Object)this.trees).equals(generalSubtrees.trees);
    }

    public int hashCode() {
        return ((Object)this.trees).hashCode();
    }

    public GeneralSubtree get(int n) {
        return this.trees.get(n);
    }

    public GeneralSubtrees intersect(GeneralSubtrees generalSubtrees) {
        Object object;
        int n;
        boolean bl;
        Object object2;
        int n2;
        if (generalSubtrees == null) {
            throw new NullPointerException("other GeneralSubtrees must not be null");
        }
        GeneralSubtrees generalSubtrees2 = new GeneralSubtrees();
        GeneralSubtrees generalSubtrees3 = null;
        if (this.size() == 0) {
            this.union(generalSubtrees);
            return null;
        }
        this.minimize();
        generalSubtrees.minimize();
        for (n2 = 0; n2 < this.size(); ++n2) {
            GeneralNameInterface generalNameInterface;
            object2 = this.getGeneralNameInterface(n2);
            boolean bl2 = false;
            bl = false;
            block10: for (n = 0; n < generalSubtrees.size(); ++n) {
                object = generalSubtrees.get(n);
                generalNameInterface = GeneralSubtrees.getGeneralNameInterface((GeneralSubtree)object);
                switch (object2.constrains(generalNameInterface)) {
                    case 1: {
                        this.remove(n2);
                        --n2;
                        generalSubtrees2.add((GeneralSubtree)object);
                        bl = false;
                        break block10;
                    }
                    case 3: {
                        bl = true;
                        continue block10;
                    }
                    case 0: 
                    case 2: {
                        bl = false;
                        break block10;
                    }
                    default: {
                        continue block10;
                    }
                }
            }
            if (!bl) continue;
            n = 0;
            block11: for (int i = 0; i < this.size(); ++i) {
                generalNameInterface = this.getGeneralNameInterface(i);
                if (generalNameInterface.getType() != object2.getType()) continue;
                for (int j = 0; j < generalSubtrees.size(); ++j) {
                    GeneralNameInterface generalNameInterface2 = generalSubtrees.getGeneralNameInterface(j);
                    int n3 = generalNameInterface.constrains(generalNameInterface2);
                    if (n3 != 0 && n3 != 2 && n3 != 1) continue;
                    n = 1;
                    continue block11;
                }
            }
            if (n == 0) {
                GeneralSubtree generalSubtree;
                if (generalSubtrees3 == null) {
                    generalSubtrees3 = new GeneralSubtrees();
                }
                if (!generalSubtrees3.contains(generalSubtree = this.createWidestSubtree((GeneralNameInterface)object2))) {
                    generalSubtrees3.add(generalSubtree);
                }
            }
            this.remove(n2);
            --n2;
        }
        if (generalSubtrees2.size() > 0) {
            this.union(generalSubtrees2);
        }
        for (n2 = 0; n2 < generalSubtrees.size(); ++n2) {
            object2 = generalSubtrees.get(n2);
            GeneralNameInterface generalNameInterface = GeneralSubtrees.getGeneralNameInterface((GeneralSubtree)object2);
            bl = false;
            block14: for (n = 0; n < this.size(); ++n) {
                object = this.getGeneralNameInterface(n);
                switch (object.constrains(generalNameInterface)) {
                    case -1: {
                        bl = true;
                        continue block14;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        bl = false;
                        break block14;
                    }
                    default: {
                        continue block14;
                    }
                }
            }
            if (!bl) continue;
            this.add((GeneralSubtree)object2);
        }
        return generalSubtrees3;
    }

    public void union(GeneralSubtrees generalSubtrees) {
        if (generalSubtrees != null) {
            int n = generalSubtrees.size();
            for (int i = 0; i < n; ++i) {
                this.add(generalSubtrees.get(i));
            }
            this.minimize();
        }
    }

    public Iterator iterator() {
        return this.trees.iterator();
    }

    public void reduce(GeneralSubtrees generalSubtrees) {
        if (generalSubtrees == null) {
            return;
        }
        int n = generalSubtrees.size();
        for (int i = 0; i < n; ++i) {
            GeneralNameInterface generalNameInterface = generalSubtrees.getGeneralNameInterface(i);
            block7: for (int j = 0; j < this.size(); ++j) {
                GeneralNameInterface generalNameInterface2 = this.getGeneralNameInterface(j);
                switch (generalNameInterface.constrains(generalNameInterface2)) {
                    case -1: {
                        continue block7;
                    }
                    case 0: {
                        this.remove(j);
                        --j;
                        continue block7;
                    }
                    case 1: {
                        this.remove(j);
                        --j;
                        continue block7;
                    }
                    case 2: {
                        continue block7;
                    }
                }
            }
        }
    }

    private void minimize() {
        for (int i = 0; i < this.size(); ++i) {
            boolean bl;
            block9: {
                GeneralNameInterface generalNameInterface = this.getGeneralNameInterface(i);
                bl = false;
                block8: for (int j = i + 1; j < this.size(); ++j) {
                    GeneralNameInterface generalNameInterface2 = this.getGeneralNameInterface(j);
                    switch (generalNameInterface.constrains(generalNameInterface2)) {
                        case -1: {
                            continue block8;
                        }
                        case 0: {
                            bl = true;
                            break block9;
                        }
                        case 1: {
                            this.remove(j);
                            --j;
                            continue block8;
                        }
                        case 2: {
                            bl = true;
                            break block9;
                        }
                        case 3: {
                            continue block8;
                        }
                    }
                }
            }
            if (!bl) continue;
            this.remove(i);
            --i;
        }
    }

    private GeneralSubtree createWidestSubtree(GeneralNameInterface generalNameInterface) {
        try {
            GeneralName generalName;
            switch (generalNameInterface.getType()) {
                case 0: {
                    ObjectIdentifier objectIdentifier = ((OtherName)generalNameInterface).getOID();
                    generalName = new GeneralName(new OtherName(objectIdentifier, null));
                    break;
                }
                case 1: {
                    generalName = new GeneralName(new RFC822Name(""));
                    break;
                }
                case 2: {
                    generalName = new GeneralName(new DNSName(""));
                    break;
                }
                case 3: {
                    generalName = new GeneralName(new X400Address((byte[])null));
                    break;
                }
                case 4: {
                    generalName = new GeneralName(new X500Name(""));
                    break;
                }
                case 5: {
                    generalName = new GeneralName(new EDIPartyName(""));
                    break;
                }
                case 6: {
                    generalName = new GeneralName(new URIName(""));
                    break;
                }
                case 7: {
                    generalName = new GeneralName(new IPAddressName((byte[])null));
                    break;
                }
                case 8: {
                    generalName = new GeneralName(new OIDName(new ObjectIdentifier((int[])null)));
                    break;
                }
                default: {
                    throw new IOException("Unsupported GeneralNameInterface type: " + generalNameInterface.getType());
                }
            }
            return new GeneralSubtree(generalName, 0, -1);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unexpected error: " + iOException);
        }
    }

    private GeneralNameInterface getGeneralNameInterface(int n) {
        return GeneralSubtrees.getGeneralNameInterface(this.get(n));
    }

    private static GeneralNameInterface getGeneralNameInterface(GeneralSubtree generalSubtree) {
        GeneralName generalName = generalSubtree.getBase();
        GeneralNameInterface generalNameInterface = generalName.getName();
        return generalNameInterface;
    }

    public void remove(int n) {
        this.trees.remove(n);
    }

    public int size() {
        return this.trees.size();
    }
}

