/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.SerialNumber;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AuthorityKeyIdentifierExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.AuthorityKeyIdentifier";
    public static final String NAME = "AuthorityKeyIdentifier";
    public static final String KEY_ID = "key_id";
    public static final String AUTH_NAME = "auth_name";
    public static final String SERIAL_NUMBER = "serial_number";
    private static final byte TAG_ID = 0;
    private static final byte TAG_NAMES = 1;
    private static final byte TAG_SERIAL_NUM = 2;
    private KeyIdentifier id = null;
    private GeneralNames names = null;
    private SerialNumber serialNum = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.AuthorityKeyIdentifierExtension";

    private void encodeThis() throws IOException {
        DerOutputStream derOutputStream;
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.id == null && this.names == null && this.serialNum == null) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.id != null) {
            derOutputStream = new DerOutputStream();
            this.id.encode(derOutputStream);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), derOutputStream);
        }
        try {
            if (this.names != null) {
                derOutputStream = new DerOutputStream();
                this.names.encode(derOutputStream);
                derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream);
            }
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "encodeThis", exception);
            }
            throw new IOException(exception.toString());
        }
        if (this.serialNum != null) {
            derOutputStream = new DerOutputStream();
            this.serialNum.encode(derOutputStream);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)2), derOutputStream);
        }
        derOutputStream2.write((byte)48, derOutputStream3);
        this.extensionValue = derOutputStream2.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    public AuthorityKeyIdentifierExtension(KeyIdentifier keyIdentifier, GeneralNames generalNames, SerialNumber serialNumber) throws IOException {
        if (debug != null) {
            Object[] objectArray = new Object[]{keyIdentifier, generalNames, serialNumber};
            debug.entry(16384L, (Object)className, "AuthorityKeyIdentifierExtension", objectArray);
        }
        this.id = keyIdentifier;
        this.names = generalNames != null ? (GeneralNames)generalNames.clone() : generalNames;
        this.serialNum = serialNumber;
        this.extensionId = PKIXExtensions.AuthorityKey_Id;
        this.critical = false;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "AuthorityKeyIdentifierExtension");
        }
    }

    public AuthorityKeyIdentifierExtension(Boolean bl, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "AuthorityKeyIdentifierExtension", bl, object);
        }
        this.extensionId = PKIXExtensions.AuthorityKey_Id;
        this.critical = false;
        if (!(object instanceof byte[])) {
            throw new IOException("Illegal argument type");
        }
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        System.arraycopy(object, 0, byArray, 0, n);
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "AuthorityKeyIdentifierExtension", "Invalid encoding for AuthorityKeyIdentifierExtension.");
            }
            throw new IOException("Invalid encoding for AuthorityKeyIdentifierExtension.");
        }
        while (derValue.getData() != null && derValue.getData().available() != 0) {
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.isContextSpecific((byte)0) && !derValue2.isConstructed()) {
                if (this.id != null) {
                    if (debug != null) {
                        debug.text(16384L, className, "AuthorityKeyIdentifierExtension", "Duplicate KeyIdentifier in AuthorityKeyIdentifier.");
                    }
                    throw new IOException("Duplicate KeyIdentifier in AuthorityKeyIdentifier.");
                }
                derValue2.resetTag((byte)4);
                this.id = new KeyIdentifier(derValue2);
                continue;
            }
            if (derValue2.isContextSpecific((byte)1) && derValue2.isConstructed()) {
                if (this.names != null) {
                    if (debug != null) {
                        debug.text(16384L, className, "AuthorityKeyIdentifierExtension", "Duplicate GeneralNames in AuthorityKeyIdentifier.");
                    }
                    throw new IOException("Duplicate GeneralNames in AuthorityKeyIdentifier.");
                }
                try {
                    derValue2.resetTag((byte)48);
                    this.names = new GeneralNames(derValue2);
                    continue;
                }
                catch (GeneralNamesException generalNamesException) {
                    if (debug != null) {
                        debug.exception(16384L, className, "AuthorityKeyIdentifierExtension", generalNamesException);
                    }
                    throw new IOException(generalNamesException.toString());
                }
            }
            if (derValue2.isContextSpecific((byte)2) && !derValue2.isConstructed()) {
                if (this.serialNum != null) {
                    if (debug != null) {
                        debug.text(16384L, className, "AuthorityKeyIdentifierExtension", "Duplicate SerialNumber in AuthorityKeyIdentifier.");
                    }
                    throw new IOException("Duplicate SerialNumber in AuthorityKeyIdentifier.");
                }
                derValue2.resetTag((byte)2);
                this.serialNum = new SerialNumber(derValue2);
                continue;
            }
            if (debug != null) {
                debug.text(16384L, className, "AuthorityKeyIdentifierExtension", "Invalid encoding of AuthorityKeyIdentifierExtension.");
            }
            throw new IOException("Invalid encoding of AuthorityKeyIdentifierExtension.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "AuthorityKeyIdentifierExtension");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = super.toString() + "AuthorityKeyIdentifier [\n";
        if (this.id != null) {
            string = string + this.id.toString() + "\n";
        }
        if (this.names != null) {
            string = string + this.names.toString() + "\n";
        }
        if (this.serialNum != null) {
            string = string + this.serialNum.toString() + "\n";
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string + "]\n");
        }
        return string + "]\n";
    }

    @Override
    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.AuthorityKey_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (string.equalsIgnoreCase(KEY_ID)) {
            if (!(object instanceof KeyIdentifier)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type KeyIdentifier.");
                }
                throw new IOException("Attribute value should be of type KeyIdentifier.");
            }
            this.id = (KeyIdentifier)object;
        } else if (string.equalsIgnoreCase(AUTH_NAME)) {
            if (!(object instanceof GeneralNames)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type GeneralNames.");
                }
                throw new IOException("Attribute value should be of type GeneralNames.");
            }
            this.names = (GeneralNames)((GeneralNames)object).clone();
        } else if (string.equalsIgnoreCase(SERIAL_NUMBER)) {
            if (!(object instanceof SerialNumber)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type SerialNumber.");
                }
                throw new IOException("Attribute value should be of type SerialNumber.");
            }
            this.serialNum = (SerialNumber)object;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:AuthorityKeyIdentifier.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:AuthorityKeyIdentifier.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (string.equalsIgnoreCase(KEY_ID)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_1", this.id);
            }
            return this.id;
        }
        if (string.equalsIgnoreCase(AUTH_NAME)) {
            if (this.names != null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_2", this.names.clone());
                }
                return this.names.clone();
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_3", this.names);
            }
            return this.names;
        }
        if (string.equalsIgnoreCase(SERIAL_NUMBER)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_4", this.serialNum);
            }
            return this.serialNum;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:AuthorityKeyIdentifier.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:AuthorityKeyIdentifier.");
    }

    @Override
    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (string.equalsIgnoreCase(KEY_ID)) {
            this.id = null;
        } else if (string.equalsIgnoreCase(AUTH_NAME)) {
            this.names = null;
        } else if (string.equalsIgnoreCase(SERIAL_NUMBER)) {
            this.serialNum = null;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:AuthorityKeyIdentifier.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:AuthorityKeyIdentifier.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        attributeNameEnumeration.addElement(KEY_ID);
        attributeNameEnumeration.addElement(AUTH_NAME);
        attributeNameEnumeration.addElement(SERIAL_NUMBER);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

