/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.security.tools.dumpASN1;
import com.ibm.security.tools.dumpASN1OidListItem;
import java.io.IOException;
import java.util.Hashtable;

public final class dumpASN1Atom {
    static final byte CLASS_MASK = -64;
    static final int INT_CLASS_MASK = 192;
    static final byte UNIVERSAL = 0;
    static final byte APPLICATION = 64;
    static final byte CONTEXT = -128;
    static final byte PRIVATE = -64;
    static final byte FORM_MASK = 32;
    static final byte PRIMITIVE = 0;
    static final byte CONSTRUCTED = 32;
    static final byte TAG_MASK = 31;
    static final byte EOC = 0;
    static final byte BOOLEAN = 1;
    static final byte INTEGER = 2;
    static final byte BITSTRING = 3;
    static final byte OCTETSTRING = 4;
    static final byte NULLTAG = 5;
    static final byte OID = 6;
    static final byte OBJDESCRIPTOR = 7;
    static final byte EXTERNAL = 8;
    static final byte REAL = 9;
    static final byte ENUMERATED = 10;
    static final byte EMBEDDED_PDV = 11;
    static final byte UTF8STRING = 12;
    static final byte SEQUENCE = 16;
    static final byte SET = 17;
    static final byte NUMERICSTR = 18;
    static final byte PRINTABLESTR = 19;
    static final byte T61STR = 20;
    static final byte VIDEOTEXSTR = 21;
    static final byte IA5STR = 22;
    static final byte UTCTIME = 23;
    static final byte GENERALIZEDTIME = 24;
    static final byte GRAPHICSTR = 25;
    static final byte VISIBLESTR = 26;
    static final byte GENERALSTR = 27;
    static final byte UNIVERSALSTR = 28;
    static final byte BMPSTR = 30;
    static final byte LEN_XTND = -128;
    static final byte LEN_MASK = 127;
    static final byte STR_NONE = 1;
    static final byte STR_UTCTIME = 2;
    static final byte STR_PRINTABLE = 3;
    static final byte STR_IA5 = 4;
    static Hashtable enumAlgoTable = null;
    static Hashtable enumModeTable = null;
    public byte idOctet1;
    public byte id;
    public int tag;
    public long length;
    public boolean indefinite;
    public int headerSize;
    public int[] header = new int[16];
    private int bInd;
    private int hInd;
    private byte[] bytes;
    static final byte P = 1;
    static final byte I = 2;
    static final byte PI = 3;
    static byte[] charFlags = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 2, 3, 2, 2, 2, 2, 2, 3, 3, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 3, 2, 3, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 0};

    public dumpASN1Atom(byte[] byArray) {
        this(byArray, 0);
    }

    public dumpASN1Atom(byte[] byArray, int n) {
        int n2;
        if (dumpASN1.pd) {
            dumpASN1.ps.print("\n->Inside dumpASN1Atom constructor.  callerBInd:" + n);
        }
        int n3 = 0;
        int n4 = 0;
        this.indefinite = false;
        this.bytes = byArray;
        this.bInd = n;
        this.idOctet1 = this.bytes[this.bInd++];
        this.header[n4++] = this.idOctet1;
        this.id = (byte)(this.idOctet1 & 0xFFFFFFE0);
        this.tag = this.idOctet1 & 0x1F;
        if (this.tag == 31) {
            this.tag = 0;
            do {
                n2 = this.bytes[this.bInd++];
                this.tag = this.tag << 7 | n2 & 0x7F;
                this.header[n4++] = n2;
            } while ((n2 & 0xFFFFFF80) != 0 && this.bytes.length - this.bInd != 0);
        }
        this.header[n4] = this.bytes[this.bInd] & 0xFF;
        ++this.bInd;
        this.headerSize = ++n4;
        if (((n3 |= this.header[n4]) & 0xFFFFFF80) != 0) {
            if ((n3 &= 0x7F) > 4) {
                dumpASN1.ps.print("\nError: Object length field " + n3 + " too large.\n");
            }
            this.headerSize += n3;
            this.length = 0L;
            if (n3 == 0) {
                this.indefinite = true;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                int n5 = this.bytes[this.bInd++] & 0xFF;
                this.length = this.length << 8 | (long)n5;
                this.header[n2 + n4] = n5;
            }
        } else {
            this.length = n3;
        }
        if (dumpASN1.pd) {
            dumpASN1.ps.print("\n<-Exiting dumpASN1Atom constructor.  idOctet1:" + this.idOctet1 + " id:" + this.id + " tag:" + this.tag);
            dumpASN1.ps.print("\n                                 length is " + this.length + " bInd:" + this.bInd);
        }
    }

    private long getValue(long l) {
        int n = 1;
        int n2 = this.bytes[this.bInd++];
        if (((n2 &= 0xFF) & 0x80) != 0) {
            n = -1;
            n2 &= 0x7F;
        }
        long l2 = n2;
        int n3 = 0;
        while ((long)n3 < l - 1L) {
            n2 = this.bytes[this.bInd++] & 0xFF;
            l2 = l2 << 8 | (long)n2;
            ++n3;
        }
        return l2 * (long)n;
    }

    public void printConstructed(int n) throws IOException {
        if (dumpASN1.pd) {
            dumpASN1.ps.print("\n-> printConstructed (Item).  level:" + n);
        }
        if (this.length == 0L && !this.indefinite) {
            dumpASN1.ps.print(" {}\n");
            if (dumpASN1.pd) {
                dumpASN1.ps.print("\n<- printConstructed (Item) zero len object.  level:" + n);
            }
            return;
        }
        dumpASN1.ps.print(" {\n");
        dumpASN1 dumpASN12 = new dumpASN1(this.bytes, this.bInd);
        int n2 = dumpASN12.printASN1(n + 1, this.length, this.indefinite);
        this.bInd = dumpASN12.getByteIndex();
        if (dumpASN1.pd) {
            dumpASN1.ps.print("\ndumpASN1Atom printConstructed.  Back from asn1s.printASN1(" + (n + 1) + ", " + this.length + ", " + this.indefinite + ")");
        }
        if (dumpASN1.pd) {
            dumpASN1.ps.print("\ndumpASN1Atom printConstructed.  Our bInd:" + this.bInd);
        }
        if (n2 != 0) {
            dumpASN1.ps.println("Error: Inconsistent object length, " + n2 + " byte" + (n2 > 1 ? "s" : "") + " difference.");
            ++dumpASN1.noErrors;
        }
        if (!dumpASN1.doPure) {
            dumpASN1.ps.print("            : ");
        }
        dumpASN1.ps.print(dumpASN1.printDots ? ". " : "  ");
        dumpASN1Atom.doIndent(n);
        dumpASN1.ps.print("}\n");
        if (dumpASN1.pd) {
            dumpASN1.ps.print("\n<- printConstructed (Item).  level:" + n);
        }
    }

    public void printASN1Object(int n, int n2) throws IOException {
        byte[] byArray = new byte[64];
        String[] stringArray = new String[]{"UNIVERSAL ", "APPLICATION ", "", "PRIVATE "};
        if (dumpASN1.pd) {
            dumpASN1.ps.print("\n-> Entering Item's printASN1Object.  Level:" + n);
        }
        if ((this.id & 0xFFFFFFC0) != 0) {
            dumpASN1.ps.print("[" + stringArray[(this.id & 0xC0) >> 6] + this.tag + "]");
            if (this.tag != 5 && this.length < 0L) {
                dumpASN1.ps.print("\nError: Object has bad length.\n");
                throw new IOException("Error: Object has bad length");
            }
            if (this.length == 0L && !this.indefinite) {
                dumpASN1.ps.print("\n");
                this.complain("Object has zero length", n);
                return;
            }
            if ((this.id & 0x20) == 32) {
                if (dumpASN1.pd) {
                    dumpASN1.ps.print("\n  Item's printASN1Object calling printConstructed.  Level:" + n);
                }
                this.printConstructed(n);
                if (dumpASN1.pd) {
                    dumpASN1.ps.print("\n  Item's printASN1Object back from printConstructed.  Level:" + n);
                }
                if (dumpASN1.pd) {
                    dumpASN1.ps.print("\n<- Item's printASN1Object returning");
                }
                return;
            }
            if (!dumpASN1.useStdin && this.length >= 4L) {
                int n3;
                int n4 = this.length <= 16L ? (int)this.length : 16;
                System.arraycopy(this.bytes, this.bInd, byArray, 0, n4);
                for (n3 = 0; n3 < n4 && ((n3 & 1) == 0 && byArray[n3] == 0 || byArray[n3] >= 32 && byArray[n3] <= 126); ++n3) {
                }
                if (n3 == n4) {
                    this.displayString(this.length, n, (byte)1);
                    if (dumpASN1.pd) {
                        dumpASN1.ps.print("\n<- Item's printASN1Object returning: i==len");
                    }
                    return;
                }
            }
            this.dumpHex(this.length, n, false);
            if (dumpASN1.pd) {
                dumpASN1.ps.print("\n<- Item's printASN1Object returning.  End of if not universal");
            }
            return;
        }
        dumpASN1.ps.print(this.idstr(this.tag));
        if (this.tag != 5 && this.length < 0L) {
            dumpASN1.ps.print("\nError: Object has bad length field.\n");
        }
        if ((this.id & 0x20) == 32) {
            if (dumpASN1.pd) {
                dumpASN1.ps.print("\nItem's printASN1Object calling printConstructed");
            }
            this.printConstructed(n);
            if (dumpASN1.pd) {
                dumpASN1.ps.print("\nItem's printASN1Object back from printConstructed");
            }
            if (dumpASN1.pd) {
                dumpASN1.ps.print("\n<- Item's printASN1Object returning.  Universal");
            }
            return;
        }
        if (this.length == 0L && this.tag != 5 && this.tag != 0) {
            dumpASN1.ps.println("");
            this.complain("Object has zero length", n);
            return;
        }
        switch (this.tag) {
            case 1: {
                int n5 = this.bytes[this.bInd++] & 0xFF;
                dumpASN1.ps.println(n5 != 0 ? " TRUE" : " FALSE");
                if (n5 == 0 || n5 == 255) break;
                this.complain("BOOLEAN has non-DER encoding", n);
                break;
            }
            case 2: {
                if (this.length > 4L) {
                    this.dumpHex(this.length, n, true);
                    break;
                }
                long l = this.getValue(this.length);
                dumpASN1.ps.println(" " + l);
                if (l >= 0L) break;
                dumpASN1.ps.println(" ");
                this.complain("Integer has a negative value", n);
                break;
            }
            case 10: {
                if (n2 == 0) {
                    dumpASN1.ps.println(" " + dumpASN1Atom.enumAlgo((int)this.getValue(this.length)));
                    break;
                }
                dumpASN1.ps.println(" " + dumpASN1Atom.enumMode((int)this.getValue(this.length)));
                break;
            }
            case 3: {
                byte by = this.bytes[this.bInd++];
                dumpASN1.ps.print(" " + by + " unused bits");
                --this.length;
                if (this.length <= 2L) {
                    this.dumpBitString((int)this.length, by, n);
                    break;
                }
                this.dumpHex(this.length, n, false);
                break;
            }
            case 4: {
                if (this.checkEncapsulate(this.tag)) {
                    dumpASN1.ps.print(", encapsulates");
                    this.printConstructed(n + 1);
                    break;
                }
                this.dumpHex(this.length, n, false);
                break;
            }
            case 6: {
                if (this.length > 64L) {
                    dumpASN1.ps.println("\nError: Object identifier length " + this.length + " too large.");
                    throw new IOException("Error: Object identifier length " + this.length + " too large.");
                }
                System.arraycopy(this.bytes, this.bInd, byArray, 0, (int)this.length);
                this.bInd = (int)((long)this.bInd + this.length);
                dumpASN1OidListItem dumpASN1OidListItem2 = dumpASN1.oidList.getOIDinfo(byArray, (int)this.length);
                if (dumpASN1OidListItem2 != null) {
                    int n6;
                    int n7 = n6 = dumpASN1.doPure ? 0 : 14;
                    if (n6 + n * 2 + 18 + dumpASN1OidListItem2.description.length() >= 80) {
                        dumpASN1.ps.println("");
                        if (!dumpASN1.doPure) {
                            dumpASN1.ps.print("            : ");
                        }
                        dumpASN1Atom.doIndent(n + 1);
                    } else {
                        dumpASN1.ps.print(" ");
                    }
                    dumpASN1.ps.print(dumpASN1OidListItem2.description + "\n");
                    if (dumpASN1.extraOIDinfo && dumpASN1OidListItem2.comment != null) {
                        if (!dumpASN1.doPure) {
                            dumpASN1.ps.print("            : ");
                        }
                        dumpASN1Atom.doIndent(n + 1);
                        dumpASN1.ps.print("(" + dumpASN1OidListItem2.comment + ")\n");
                    }
                    if (!dumpASN1OidListItem2.warning) break;
                    ++dumpASN1.noWarnings;
                    break;
                }
                int n8 = byArray[0] / 40;
                int n9 = byArray[0] % 40;
                if (n8 > 2) {
                    n9 += (n8 - 2) * 40;
                    n8 = 2;
                }
                dumpASN1.ps.print(" '" + n8 + " " + n9);
                long l = 0L;
                n8 = 1;
                while ((long)n8 < this.length) {
                    l = l << 7 | (long)(byArray[n8] & 0x7F);
                    if ((byArray[n8] & 0x80) == 0) {
                        dumpASN1.ps.print(" " + l);
                        l = 0L;
                    }
                    ++n8;
                }
                dumpASN1.ps.println("'");
                break;
            }
            case 0: 
            case 5: {
                dumpASN1.ps.println("");
                break;
            }
            case 7: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: {
                this.displayString(this.length, n, (byte)1);
                break;
            }
            case 19: {
                this.displayString(this.length, n, (byte)3);
                break;
            }
            case 23: {
                this.displayString(this.length, n, (byte)2);
                break;
            }
            case 22: {
                this.displayString(this.length, n, (byte)4);
                break;
            }
            default: {
                dumpASN1.ps.println("");
                if (!dumpASN1.doPure) {
                    dumpASN1.ps.print("            : ");
                }
                dumpASN1Atom.doIndent(n + 1);
                dumpASN1.ps.print("Unrecognised primitive, hex value is:");
                this.dumpHex(this.length, n, false);
                ++dumpASN1.noErrors;
            }
        }
        if (dumpASN1.pd) {
            dumpASN1.ps.print("\n<-Returning from Item's printASN1Object");
        }
    }

    private boolean checkEncapsulate(int n) {
        int n2;
        int n3 = n2 = n == 3 ? dumpASN1.tryBSConstructed : dumpASN1.tryOSConstructed;
        if (n2 == 0) {
            return false;
        }
        byte by = this.bytes[this.bInd];
        if (by == 2 || by == 48) {
            return true;
        }
        if (n == 4 && by == 3) {
            return true;
        }
        return n2 > 1 && by == 22;
    }

    private String idstr(int n) {
        switch (n) {
            case 0: {
                return "End-of-contents octets";
            }
            case 1: {
                return "BOOLEAN";
            }
            case 2: {
                return "INTEGER";
            }
            case 3: {
                return "BIT STRING";
            }
            case 4: {
                return "OCTET STRING";
            }
            case 5: {
                return "NULL";
            }
            case 6: {
                return "OBJECT IDENTIFIER";
            }
            case 7: {
                return "ObjectDescriptor";
            }
            case 8: {
                return "EXTERNAL";
            }
            case 9: {
                return "REAL";
            }
            case 10: {
                return "ENUMERATED";
            }
            case 11: {
                return "EMBEDDED PDV (1993)";
            }
            case 12: {
                return "UTF8String (1997)";
            }
            case 16: {
                return "SEQUENCE";
            }
            case 17: {
                return "SET";
            }
            case 18: {
                return "NumericString";
            }
            case 19: {
                return "PrintableString";
            }
            case 20: {
                return "TeletexString";
            }
            case 21: {
                return "VideotexString";
            }
            case 22: {
                return "IA5String";
            }
            case 23: {
                return "UTCTime";
            }
            case 24: {
                return "GeneralizedTime";
            }
            case 25: {
                return "GraphicString";
            }
            case 26: {
                return "VisibleString";
            }
            case 27: {
                return "GeneralString";
            }
            case 28: {
                return "UniversalString (1993)";
            }
            case 30: {
                return "BMPString (1993)";
            }
        }
        return "Unknown (Reserved)";
    }

    private static String enumAlgo(int n) {
        String string;
        String[] stringArray = new String[]{"  0 CRYPT_ALGO_NONE", "  1 CRYPT_ALGO_DES", "  2 CRYPT_ALGO_3DES", "  3 CRYPT_ALGO_IDEA", "  4 CRYPT_ALGO_CAST", "  5 CRYPT_ALGO_RC2", "  6 CRYPT_ALGO_RC4", "  7 CRYPT_ALGO_RC5", "  8 CRYPT_ALGO_SAFER", "  9 CRYPT_ALGO_BLOWFISH", " 10 CRYPT_ALGO_GOST", " 11 CRYPT_ALGO_SKIPJACK", "100 CRYPT_ALGO_DH", "101 CRYPT_ALGO_RSA", "102 CRYPT_ALGO_DSS", "200 CRYPT_ALGO_MD2", "201 CRYPT_ALGO_MD4", "202 CRYPT_ALGO_MD5", "203 CRYPT_ALGO_SHA", "205 CRYPT_ALGO_RIPEMD160"};
        if (enumAlgoTable == null) {
            enumAlgoTable = new Hashtable();
            enumAlgoTable.put(new Integer(0), "CRYPT_ALGO_NONE");
            enumAlgoTable.put(new Integer(1), "CRYPT_ALGO_DES");
            enumAlgoTable.put(new Integer(2), "CRYPT_ALGO_3DES");
            enumAlgoTable.put(new Integer(3), "CRYPT_ALGO_IDEA");
            enumAlgoTable.put(new Integer(4), "CRYPT_ALGO_CAST");
            enumAlgoTable.put(new Integer(5), "CRYPT_ALGO_RC2");
            enumAlgoTable.put(new Integer(6), "CRYPT_ALGO_RC4");
            enumAlgoTable.put(new Integer(7), "CRYPT_ALGO_RC5");
            enumAlgoTable.put(new Integer(8), "CRYPT_ALGO_SAFER");
            enumAlgoTable.put(new Integer(9), "CRYPT_ALGO_BLOWFISH");
            enumAlgoTable.put(new Integer(10), "CRYPT_ALGO_GOST");
            enumAlgoTable.put(new Integer(11), "CRYPT_ALGO_SKIPJACK");
            enumAlgoTable.put(new Integer(100), "CRYPT_ALGO_DH");
            enumAlgoTable.put(new Integer(101), "CRYPT_ALGO_RSA");
            enumAlgoTable.put(new Integer(102), "CRYPT_ALGO_DSS");
            enumAlgoTable.put(new Integer(200), "CRYPT_ALGO_MD2");
            enumAlgoTable.put(new Integer(201), "CRYPT_ALGO_MD4");
            enumAlgoTable.put(new Integer(202), "CRYPT_ALGO_MD5");
            enumAlgoTable.put(new Integer(203), "CRYPT_ALGO_SHA");
            enumAlgoTable.put(new Integer(205), "CRYPT_ALGO_RIPEMD160");
        }
        if ((string = (String)enumAlgoTable.get(new Integer(n))) == null) {
            string = "CRYPT_ALGO_UNKNOWN";
        }
        return string + " (" + n + ")";
    }

    private static String enumMode(int n) {
        String string;
        if (enumModeTable == null) {
            enumModeTable = new Hashtable();
            enumModeTable.put(new Integer(0), "CRYPT_MODE_NONE");
            enumModeTable.put(new Integer(1), "CRYPT_MODE_STREAM");
            enumModeTable.put(new Integer(2), "CRYPT_MODE_ECB");
            enumModeTable.put(new Integer(3), "CRYPT_MODE_CBC");
            enumModeTable.put(new Integer(4), "CRYPT_MODE_CFB");
            enumModeTable.put(new Integer(5), "CRYPT_MODE_OFB");
            enumModeTable.put(new Integer(100), "CRYPT_MODE_PKC");
        }
        if ((string = (String)enumModeTable.get(new Integer(n))) == null) {
            string = "CRYPT_MODE_UNKNOWN";
        }
        return string + " (" + n + ")";
    }

    public static void doIndent(int n) {
        for (int i = 0; i < n; ++i) {
            dumpASN1.ps.print(dumpASN1.printDots ? ". " : "  ");
        }
    }

    private void complain(String string, int n) {
        if (!dumpASN1.doPure) {
            dumpASN1.ps.print("            : ");
        }
        dumpASN1Atom.doIndent(n + 1);
        dumpASN1.ps.println("Error: " + string + ".");
        ++dumpASN1.noErrors;
    }

    private void dumpHex(long l, int n, boolean bl) {
        int n2;
        long l2 = l;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = bl;
        int n3 = n2 = dumpASN1.doPure ? 15 : 8;
        if (l2 > 128L) {
            l2 = 128L;
        }
        if (n > n2) {
            n = n2;
        }
        int n4 = 0;
        while ((long)n4 < l2) {
            if (n4 % 16 == 0) {
                dumpASN1.ps.println("");
                if (!dumpASN1.doPure) {
                    dumpASN1.ps.print("            : ");
                }
                dumpASN1Atom.doIndent(n + 1);
            }
            byte by = this.bytes[this.bInd++];
            int n5 = by & 0xFF;
            dumpASN1.ps.print((n4 % 16 != 0 ? " " : "") + dumpASN1Atom.hexDigit(by));
            if (n4 == 0) {
                if (by == 0) {
                    bl2 = true;
                }
                if ((n5 & 0x80) == 0) {
                    bl4 = false;
                }
            }
            if (n4 == 1 && bl2 && n5 < 128) {
                bl3 = true;
            }
            ++n4;
        }
        if (l > 128L) {
            l -= 128L;
            dumpASN1.ps.println("");
            if (!dumpASN1.doPure) {
                dumpASN1.ps.print("            : ");
            }
            dumpASN1Atom.doIndent(n + 5);
            dumpASN1.ps.print("[ Another " + l + " bytes skipped ]");
            this.bInd = (int)((long)this.bInd + l);
        }
        dumpASN1.ps.println("");
        if (bl) {
            if (bl3) {
                this.complain("Integer has non-DER encoding", n);
            }
            if (bl4) {
                this.complain("Integer has a negative value", n);
            }
        }
    }

    public static String hexDigit(byte by) {
        String string = "";
        char c = (char)(by >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
        string = String.valueOf(c);
        c = (char)(by & 0xF);
        c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
        string = string + String.valueOf(c);
        return string;
    }

    private void dumpBitString(int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = 128;
        int n7 = 255;
        int n8 = 0;
        String string = "";
        if (n2 < 0 || n2 > 7) {
            this.complain("Invalid number of unused bits", n3);
        }
        int n9 = n * 8 - n2;
        if (n != 0) {
            n5 = this.bytes[this.bInd++];
        }
        if (n9 > 8) {
            n5 = n5 << 8 | this.bytes[this.bInd++];
            n6 = 32768;
            n7 = 65535;
        }
        int n10 = 1;
        for (n4 = 0; n4 < n9; ++n4) {
            if ((n5 & n6) != 0) {
                n8 |= n10;
            }
            if ((n5 & n7) == 0) {
                string = "Spurious zero bits in bitstring";
            }
            n10 <<= 1;
            n5 <<= 1;
        }
        if ((65535 << n9 & n8) != 0) {
            string = "Spurious one bits in bitstring";
        }
        dumpASN1.ps.println("");
        if (!dumpASN1.doPure) {
            dumpASN1.ps.print("            : ");
        }
        dumpASN1Atom.doIndent(n3 + 1);
        dumpASN1.ps.print("'");
        n6 = 1 << n9 - 1;
        for (n4 = 0; n4 < n9; ++n4) {
            dumpASN1.ps.print((n8 & n6) != 0 ? "1" : "0");
            n6 >>= 1;
        }
        dumpASN1.ps.println("'B");
        if (string != "") {
            this.complain(string, n3);
        }
    }

    private void displayString(long l, int n, byte by) {
        char c;
        long l2 = l > 384L ? 384L : l;
        int n2 = dumpASN1.doPure ? 15 : 8;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (by == 2 && l != 13L) {
            bl4 = true;
        }
        if (l <= 40L) {
            dumpASN1.ps.print(" '");
        }
        if (n > n2) {
            n = n2;
        }
        int n3 = 0;
        while ((long)n3 < l2) {
            if (l > 40L && n3 % 48 == 0) {
                if (!bl) {
                    dumpASN1.ps.print("'");
                }
                dumpASN1.ps.println("");
                if (!dumpASN1.doPure) {
                    dumpASN1.ps.print("            : ");
                }
                dumpASN1Atom.doIndent(n + 1);
                dumpASN1.ps.print("'");
                bl = false;
            }
            c = (char)this.bytes[this.bInd++];
            if (by == 3 || by == 4) {
                if (by == 3 && !dumpASN1Atom.isPrintable(c)) {
                    bl3 = true;
                }
                if (by == 4 && !dumpASN1Atom.isIA5(c)) {
                    bl2 = true;
                }
                if (c < ' ' || c >= '\u007f') {
                    c = '.';
                }
            } else if (by == 2) {
                if ("0123456789".indexOf(c) == -1 && c != 'Z') {
                    bl4 = true;
                    c = '.';
                }
            } else if ((c & 0x7F) < 32 || c == '\u00ff') {
                c = '.';
            }
            dumpASN1.ps.print(c);
            ++n3;
        }
        if (l > 384L) {
            l -= 384L;
            dumpASN1.ps.println("'");
            if (!dumpASN1.doPure) {
                dumpASN1.ps.print("            : ");
            }
            dumpASN1Atom.doIndent(n + 5);
            dumpASN1.ps.print("[ Another " + l + " characters skipped ]");
            while (l-- != 0L) {
                c = (char)this.bytes[this.bInd++];
                if (by == 3 && !dumpASN1Atom.isPrintable(c)) {
                    bl3 = true;
                }
                if (by != 4 || dumpASN1Atom.isIA5(c)) continue;
                bl2 = true;
            }
        } else {
            dumpASN1.ps.print("'");
        }
        dumpASN1.ps.println("");
        if (bl3) {
            this.complain("PrintableString contains illegal character(s)", n);
        }
        if (bl2) {
            this.complain("IA5String contains illegal character(s)", n);
        }
        if (bl4) {
            this.complain("UTCTime is encoded incorrectly", n);
        }
    }

    static boolean isPrintable(char c) {
        byte by = (byte)c;
        return by < 128 && (charFlags[by] & 1) != 0;
    }

    static boolean isIA5(char c) {
        byte by = (byte)c;
        return by < 128 && (charFlags[by] & 2) != 0;
    }

    public int getByteIndex() {
        return this.bInd;
    }

    public static String format(String string, int n, char c) {
        String string2 = "                    ";
        if (c != ' ') {
            string2 = string2.replace(' ', c);
        }
        int n2 = n - string.length();
        String string3 = string2.substring(0, n2) + string;
        return string3;
    }

    public static String format(String string, int n) {
        return dumpASN1Atom.format(string, n, ' ');
    }

    public static String format(int n, int n2) {
        String string = String.valueOf(n);
        return dumpASN1Atom.format(string, n2);
    }

    public static String format(long l, int n) {
        String string = String.valueOf(l);
        return dumpASN1Atom.format(string, n);
    }
}

