/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.smime.jmail;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.Data;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.smime.SMIME;
import com.ibm.security.smime.jmail.SMIMEUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class SMIMEMimeMessage
extends MimeMessage {
    private byte[] messageContent;
    ContentInfo contentInfo;
    CertificationRequest certificationRequest;
    private Certificate[] recipientCerts;
    private String provider = null;
    private boolean oldTypes = true;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.smime.jmail.SMIMEMimeMessage";

    protected SMIMEMimeMessage(Folder folder, InputStream inputStream, int n) throws MessagingException {
        super(folder, inputStream, n);
        if (debug != null) {
            Object[] objectArray = new Object[]{folder, inputStream, new Integer(n)};
            debug.entry(16384L, (Object)className, "SMIMEMimeMessage", objectArray);
        }
        this.setContainedObjects();
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMimeMessage");
        }
    }

    protected SMIMEMimeMessage(Folder folder, InputStream inputStream, int n, String string) throws MessagingException {
        super(folder, inputStream, n);
        if (debug != null) {
            Object[] objectArray = new Object[]{folder, inputStream, new Integer(n), string};
            debug.entry(16384L, (Object)className, "SMIMEMimeMessage", objectArray);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        this.setContainedObjects();
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMimeMessage");
        }
    }

    protected SMIMEMimeMessage(Folder folder, int n) throws MessagingException {
        super(folder, n);
        if (debug != null) {
            Object[] objectArray = new Object[]{folder, new Integer(n)};
            debug.entry(16384L, (Object)className, "SMIMEMimeMessage", objectArray);
        }
        this.setContainedObjects();
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMimeMessage");
        }
    }

    protected SMIMEMimeMessage(Folder folder, int n, String string) throws MessagingException {
        super(folder, n);
        if (debug != null) {
            Object[] objectArray = new Object[]{folder, new Integer(n), string};
            debug.entry(16384L, (Object)className, "SMIMEMimeMessage", objectArray);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        this.setContainedObjects();
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMimeMessage");
        }
    }

    protected SMIMEMimeMessage(Folder folder, InternetHeaders internetHeaders, byte[] byArray, int n) throws MessagingException {
        super(folder, internetHeaders, byArray, n);
        if (debug != null) {
            Object[] objectArray = new Object[]{folder, internetHeaders, byArray, new Integer(n)};
            debug.entry(16384L, (Object)className, "SMIMEMimeMessage", objectArray);
        }
        this.setContainedObjects();
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMimeMessage");
        }
    }

    protected SMIMEMimeMessage(Folder folder, InternetHeaders internetHeaders, byte[] byArray, int n, String string) throws MessagingException {
        super(folder, internetHeaders, byArray, n);
        if (debug != null) {
            Object[] objectArray = new Object[]{folder, internetHeaders, byArray, new Integer(n), string};
            debug.entry(16384L, (Object)className, "SMIMEMimeMessage", objectArray);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        this.setContainedObjects();
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMimeMessage");
        }
    }

    public SMIMEMimeMessage(Session session) {
        super(session);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SMIMEMimeMessage", session);
            debug.exit(16384L, className, "SMIMEMimeMessage");
        }
    }

    public SMIMEMimeMessage(Session session, String string) {
        super(session);
        if (debug != null) {
            debug.entry(16384L, className, "SMIMEMimeMessage", session, string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMimeMessage");
        }
    }

    public SMIMEMimeMessage(Session session, InputStream inputStream) throws MessagingException {
        super(session, inputStream);
        if (debug != null) {
            debug.entry(16384L, className, "SMIMEMimeMessage", session, inputStream);
        }
        this.setContainedObjects();
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMimeMessage");
        }
    }

    public SMIMEMimeMessage(Session session, InputStream inputStream, String string) throws MessagingException {
        super(session, inputStream);
        if (debug != null) {
            Object[] objectArray = new Object[]{session, inputStream, string};
            debug.entry(16384L, (Object)className, "SMIMEMimeMessage", objectArray);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        this.setContainedObjects();
        if (debug != null) {
            debug.exit(16384L, className, "SMIMEMimeMessage");
        }
    }

    public boolean isSignedDataSignatureOnly() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "isSignedDataSignatureOnly");
            }
            ContentType contentType = new ContentType(this.getContentType());
            String string = contentType.getBaseType();
            String string2 = contentType.getParameter("protocol");
            if (string == null || string2 == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "isSignedDataSignatureOnly_1", false);
                }
                return false;
            }
            if (string.equalsIgnoreCase("multipart/signed") && (string2.equalsIgnoreCase("application/x-pkcs7-signature") || string2.equalsIgnoreCase("application/pkcs7-signature"))) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "isSignedDataSignatureOnly_2", true);
                }
                return true;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isSignedDataSignatureOnly_3", false);
            }
            return false;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "isSignedDataSignatureOnly", exception);
                debug.exit(16384L, (Object)className, "isSignedDataSignatureOnly_4", false);
            }
            return false;
        }
    }

    public boolean isSignedDataCertificateOnly() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "isSignedDataCertificateOnly");
            }
            ContentType contentType = new ContentType(this.getContentType());
            String string = contentType.getBaseType();
            String string2 = contentType.getParameter("smime-type");
            if (string == null || string2 == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "isSignedDataCertificateOnly_1", false);
                }
                return false;
            }
            if ((string.equalsIgnoreCase("application/x-pkcs7-mime") || string.equalsIgnoreCase("application/pkcs7-mime")) && string2.equalsIgnoreCase("certs-only")) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "isSignedDataCertificateOnly_2", true);
                }
                return true;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isSignedDataCertificateOnly_3", false);
            }
            return false;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "isSignedDataCertificateOnly", exception);
                debug.exit(16384L, (Object)className, "isSignedDataCertificateOnly_4", false);
            }
            return false;
        }
    }

    public boolean isSignedData() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "isSignedData");
            }
            ContentType contentType = new ContentType(this.getContentType());
            String string = contentType.getBaseType();
            String string2 = contentType.getParameter("smime-type");
            if (string == null || string2 == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "isSignedData_1", false);
                }
                return false;
            }
            if ((string.equalsIgnoreCase("application/x-pkcs7-mime") || string.equalsIgnoreCase("application/pkcs7-mime")) && string2.equalsIgnoreCase("signed-data")) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "isSignedData_2", true);
                }
                return true;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isSignedData_3", false);
            }
            return false;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "isSignedData", exception);
                debug.exit(16384L, (Object)className, "isSignedData_4", false);
            }
            return false;
        }
    }

    public boolean isEnvelopedData() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "isEnvelopedData");
            }
            ContentType contentType = new ContentType(this.getContentType());
            String string = contentType.getBaseType();
            String string2 = contentType.getParameter("smime-type");
            if (string == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "isEnvelopedData_1", false);
                }
                return false;
            }
            if ((string.equalsIgnoreCase("application/x-pkcs7-mime") || string.equalsIgnoreCase("application/pkcs7-mime")) && string2 == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "isEnvelopedData_2", true);
                }
                return true;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isEnvelopedData_3", false);
            }
            return false;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "isEnvelopedData", exception);
                debug.exit(16384L, (Object)className, "isEnvelopedData", false);
            }
            return false;
        }
    }

    public boolean isCertificationRequest() {
        try {
            ContentType contentType;
            String string;
            if (debug != null) {
                debug.entry(16384L, className, "isCertificationRequest");
            }
            if ((string = (contentType = new ContentType(this.getContentType())).getBaseType()) == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "isCertificationRequest_1", false);
                }
                return false;
            }
            if (string.equalsIgnoreCase("application/x-pkcs10") || string.equalsIgnoreCase("application/pkcs10")) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "isCertificationRequest_2", true);
                }
                return true;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isCertificationRequest_3", false);
            }
            return false;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "isCertificationRequest", exception);
                debug.exit(16384L, (Object)className, "isCertificationRequest_4", false);
            }
            return false;
        }
    }

    private void checkContainedObjects() throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, className, "checkContainedObjects");
        }
        if (this.contentInfo != null) {
            if (debug != null) {
                debug.text(16384L, className, "checkContainedObjects", "ContentInfo object already set for this SMIMEMimeMessage object.");
            }
            throw new PKCSException("ContentInfo object already set for this SMIMEMimeMessage object.");
        }
        if (this.certificationRequest != null) {
            if (debug != null) {
                debug.text(16384L, className, "checkContainedObjects", "CertificationRequest object already set for this SMIMEMimeMessage object.");
            }
            throw new PKCSException("CertificationRequest object already set for this SMIMEMimeMessage object.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "checkContainedObjects");
        }
    }

    public void setSMIMEContentType(boolean bl) {
        this.oldTypes = bl;
    }

    public boolean getSMIMEContentType() {
        return this.oldTypes;
    }

    public void setCertificationRequest(CertificationRequest certificationRequest) throws MessagingException, PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setCertificationRequest", certificationRequest);
        }
        this.checkContainedObjects();
        if (certificationRequest == null) {
            if (debug != null) {
                debug.text(16384L, className, "setCertificationRequest", "CertificationRequest is null.");
            }
            throw new IllegalArgumentException("CertificationRequest is null.");
        }
        this.certificationRequest = certificationRequest;
        String string = SMIMEUtils.getContentType(certificationRequest, this.oldTypes);
        String string2 = SMIMEUtils.getDisposition(certificationRequest);
        this.setContent(this.certificationRequest, string);
        this.setDisposition(string2);
        this.saveChanges();
        if (debug != null) {
            debug.exit(16384L, className, "setCertificationRequest");
        }
    }

    private void addRecipientCertificate(Certificate certificate) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "addRecipientCertificate", certificate);
        }
        if (certificate == null) {
            if (debug != null) {
                debug.exit(8192L, className, "addRecipientCertificate_1");
            }
            return;
        }
        if (this.recipientCerts == null) {
            this.recipientCerts = new Certificate[1];
            this.recipientCerts[0] = certificate;
        } else {
            int n = this.recipientCerts.length;
            Certificate[] certificateArray = new Certificate[n + 1];
            for (int i = 0; i < n; ++i) {
                certificateArray[i] = this.recipientCerts[i];
            }
            certificateArray[n] = certificate;
            this.recipientCerts = certificateArray;
        }
        if (debug != null) {
            debug.exit(8192L, className, "addRecipientCertificate_2");
        }
    }

    public void addRecipientCertificate(Certificate[] certificateArray) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addRecipientCertificate", certificateArray);
        }
        if (certificateArray == null || certificateArray.length == 0) {
            if (debug != null) {
                debug.exit(16384L, className, "addRecipientCertificate_1");
            }
            return;
        }
        if (this.recipientCerts == null) {
            this.recipientCerts = new Certificate[certificateArray.length];
            for (int i = 0; i < certificateArray.length; ++i) {
                this.recipientCerts[i] = certificateArray[i];
            }
        } else {
            int n;
            int n2 = this.recipientCerts.length;
            Certificate[] certificateArray2 = new Certificate[n2 + certificateArray.length];
            for (n = 0; n < n2; ++n) {
                certificateArray2[n] = this.recipientCerts[n];
            }
            for (n = 0; n < certificateArray.length; ++n) {
                certificateArray2[n2 + n] = certificateArray[n];
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "addRecipientCertificate_2");
        }
    }

    private void setRecipientCertificate(Certificate certificate) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setRecipientCertificate", certificate);
        }
        if (certificate == null) {
            this.recipientCerts = null;
            if (debug != null) {
                debug.exit(8192L, className, "setRecipientCertificate_1");
            }
            return;
        }
        this.recipientCerts = null;
        this.addRecipientCertificate(certificate);
        if (debug != null) {
            debug.exit(8192L, className, "setRecipientCertificate_2");
        }
    }

    public void setRecipientCertificate(Certificate[] certificateArray) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setRecipientCertificate", certificateArray);
        }
        if (certificateArray == null) {
            this.recipientCerts = null;
            if (debug != null) {
                debug.exit(16384L, className, "setRecipientCertificate_1");
            }
            return;
        }
        this.recipientCerts = null;
        this.addRecipientCertificate(certificateArray);
        if (debug != null) {
            debug.exit(16384L, className, "setRecipientCertificate_2");
        }
    }

    public void setCertificateOnly(Certificate[] certificateArray) throws PKCSException, IOException, NoSuchAlgorithmException, MessagingException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setCertificateOnly", certificateArray);
        }
        this.checkContainedObjects();
        if (certificateArray == null) {
            if (debug != null) {
                debug.text(16384L, className, "setCertificateOnly", "Certificate must be specified.");
            }
            throw new IllegalArgumentException("Certificate must be specified.");
        }
        if (certificateArray.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "setCertificateOnly", "Certificate array is empty.");
            }
            throw new IllegalArgumentException("Certificate array is empty.");
        }
        SignedData signedData = new SignedData(certificateArray, null, this.provider);
        this.contentInfo = new ContentInfo(signedData, this.provider);
        String string = SMIMEUtils.getContentType(this.contentInfo, this.oldTypes);
        String string2 = SMIMEUtils.getDisposition(this.contentInfo);
        this.setContent(this.contentInfo, string);
        this.setDisposition(string2);
        this.saveChanges();
        if (debug != null) {
            debug.exit(16384L, className, "setCertificateOnly");
        }
    }

    public void sign(Object object, Certificate certificate, PrivateKey privateKey, String string) throws PKCSException, IOException, NoSuchAlgorithmException, MessagingException {
        Object object2;
        Object object3;
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{object, certificate, privateKey, string};
            debug.entry(16384L, (Object)className, "sign", objectArray);
        }
        this.checkContainedObjects();
        if (object == null) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "Message must be specified.");
            }
            throw new IllegalArgumentException("Message must be specified.");
        }
        objectArray = null;
        if (object instanceof String) {
            try {
                objectArray = ((String)object).getBytes("8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (debug != null) {
                    debug.exception(16384L, className, "sign", unsupportedEncodingException);
                }
                objectArray = ((String)object).getBytes();
            }
        } else if (object instanceof byte[]) {
            objectArray = (byte[])((byte[])object).clone();
        } else if (object instanceof Data) {
            objectArray = ((Data)object).getData();
        } else if (object instanceof Multipart) {
            object3 = (Multipart)object;
            object2 = new ByteArrayOutputStream();
            object3.writeTo((OutputStream)object2);
            objectArray = ((ByteArrayOutputStream)object2).toByteArray();
        } else {
            if (debug != null) {
                debug.text(16384L, className, "sign", "Message must be an instance of String or Multipart.  Instead message is an instance of " + object.getClass().getName());
            }
            throw new IllegalArgumentException("Message must be an instance of String or Multipart.  Instead message is an instance of " + object.getClass().getName());
        }
        this.messageContent = objectArray;
        object3 = new Data(this.provider);
        ((Data)object3).setData((byte[])objectArray);
        object2 = new ContentInfo((Content)object3, this.provider);
        boolean bl = false;
        SignedData signedData = new SignedData(certificate, (ContentInfo)object2, string, privateKey, bl, this.provider);
        this.contentInfo = new ContentInfo(signedData, this.provider);
        String string2 = SMIMEUtils.getContentType(this.contentInfo, this.oldTypes);
        String string3 = SMIMEUtils.getDisposition(this.contentInfo);
        this.setContent(this.contentInfo, string2);
        this.setDisposition(string3);
        this.saveChanges();
        if (debug != null) {
            debug.exit(16384L, className, "sign");
        }
    }

    public void encrypt(Object object, int n) throws PKCSException, IOException, NoSuchAlgorithmException, MessagingException {
        if (debug != null) {
            debug.entry(16384L, className, "encrypt", object, new Integer(n));
        }
        String string = SMIME.getEncryptionAlgorithm(n);
        int n2 = SMIME.getEncryptionKeySize(n);
        this.encrypt(object, string, n2);
        if (debug != null) {
            debug.exit(16384L, className, "encrypt");
        }
    }

    public void encrypt(Object object, String string, int n) throws PKCSException, IOException, NoSuchAlgorithmException, MessagingException {
        Object object2;
        Object object3;
        Object object4;
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{object, string, new Integer(n)};
            debug.entry(16384L, (Object)className, "encrypt", objectArray);
        }
        this.checkContainedObjects();
        if (string == null) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "encryptionAlgorithm not specified.");
            }
            throw new IllegalArgumentException("encryptionAlgorithm not specified.");
        }
        if (object == null) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "Message must be specified.");
            }
            throw new IllegalArgumentException("Message must be specified.");
        }
        if (this.recipientCerts == null || this.recipientCerts.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "One or more recipient certificates must be specified.");
            }
            throw new IllegalArgumentException("One or more recipient certificates must be specified.");
        }
        objectArray = null;
        if (object instanceof String) {
            object4 = (String)object;
            object3 = new MimeBodyPart();
            object3.setText(object4);
            object2 = new ByteArrayOutputStream();
            object3.writeTo((OutputStream)object2);
            objectArray = ((ByteArrayOutputStream)object2).toByteArray();
        } else if (object instanceof Multipart) {
            object4 = (Multipart)object;
            object3 = new ByteArrayOutputStream();
            object2 = "Content-Type: " + object4.getContentType() + "\r\n\r\n";
            try {
                ((OutputStream)object3).write(((String)object2).getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (debug != null) {
                    debug.exception(16384L, className, "encrypt", unsupportedEncodingException);
                }
                ((OutputStream)object3).write(((String)object2).getBytes());
            }
            object4.writeTo((OutputStream)object3);
            objectArray = ((ByteArrayOutputStream)object3).toByteArray();
        } else if (object instanceof SMIMEMimeMessage) {
            object4 = (SMIMEMimeMessage)((Object)object);
            if (!((SMIMEMimeMessage)((Object)object4)).isSignedData()) {
                if (debug != null) {
                    debug.text(16384L, className, "encrypt", "SMIMEMimeMessage must be of type SignedData");
                }
                throw new PKCSException("SMIMEMimeMessage must be of type SignedData");
            }
            object3 = new ByteArrayOutputStream();
            object4.writeTo((OutputStream)object3);
            objectArray = ((ByteArrayOutputStream)object3).toByteArray();
        } else {
            if (debug != null) {
                debug.text(16384L, className, "encrypt", "message must be an instance of String or Multipart.  Instead message is an instance of " + object.getClass().getName());
            }
            throw new IllegalArgumentException("message must be an instance of String or Multipart.  Instead message is an instance of " + object.getClass().getName());
        }
        this.messageContent = (byte[])objectArray;
        object4 = new Data(this.provider);
        ((Data)object4).setData((byte[])objectArray);
        object3 = new ContentInfo((Content)object4, this.provider);
        this.contentInfo = ((ContentInfo)object3).encrypt(this.recipientCerts, string, n);
        object2 = SMIMEUtils.getContentType(this.contentInfo, this.oldTypes);
        String string2 = SMIMEUtils.getDisposition(this.contentInfo);
        String string3 = SMIMEUtils.getDescription(this.contentInfo);
        this.setContent(this.contentInfo, (String)object2);
        this.setDisposition(string2);
        this.setDescription(string3);
        this.saveChanges();
        if (debug != null) {
            debug.exit(16384L, className, "encrypt");
        }
    }

    public boolean verify(Certificate certificate) throws PKCSException, IOException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "verify", certificate);
            debug.exit(16384L, (Object)className, "verify", this.verify(certificate, null));
        }
        return this.verify(certificate, null);
    }

    public boolean verify(Certificate certificate, byte[] byArray) throws PKCSException, IOException, NoSuchAlgorithmException {
        byte[] byArray2 = null;
        if (debug != null) {
            debug.entry(16384L, className, "verify", certificate, byArray);
        }
        if (this.isSignedDataSignatureOnly()) {
            byArray2 = byArray == null ? this.getSignatureOnlyMessage() : (byte[])byArray.clone();
            ContentInfo contentInfo = this.getSignatureOnlyContentInfo();
            SignedData signedData = (SignedData)contentInfo.getContent();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verify_1", signedData.verify(certificate, byArray2));
            }
            return signedData.verify(certificate, byArray2);
        }
        if (this.isSignedData()) {
            if (this.contentInfo == null) {
                if (debug != null) {
                    debug.text(16384L, className, "verify", "SMIMEMimeMessage does not contain a contentInfo to verify.");
                }
                throw new PKCSException("SMIMEMimeMessage does not contain a contentInfo to verify.");
            }
            if (!this.contentInfo.isSignedData()) {
                if (debug != null) {
                    debug.text(16384L, className, "verify", "SMIMEMimeMessage contentInfo is not of type SignedData.");
                }
                throw new PKCSException("SMIMEMimeMessage contentInfo is not of type SignedData.");
            }
            if (byArray == null && this.messageContent != null) {
                byArray2 = this.messageContent;
            } else if (byArray != null) {
                byArray2 = (byte[])byArray.clone();
            }
            SignedData signedData = (SignedData)this.contentInfo.getContent();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "verify_2", signedData.verify(certificate, byArray2));
            }
            return signedData.verify(certificate, byArray2);
        }
        if (debug != null) {
            debug.text(16384L, className, "verify_2", "SMIMEMimeMessage is not of type signed-data or signed/multipart");
        }
        throw new PKCSException("SMIMEMimeMessage is not of type signed-data or signed/multipart");
    }

    public ContentInfo decrypt(PrivateKey privateKey, Certificate certificate) throws IOException, PKCSException, MessagingException {
        if (debug != null) {
            debug.entry(16384L, className, "decrypt", privateKey, certificate);
        }
        if (privateKey == null) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "recipientPrivateKey not specified.");
            }
            throw new IllegalArgumentException("recipientPrivateKey not specified.");
        }
        if (certificate == null) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "recipientCert not specified.");
            }
            throw new IllegalArgumentException("recipientCert not specified.");
        }
        if (!this.isEnvelopedData()) {
            if (debug != null) {
                debug.text(16384L, className, "decrypt", "SMIMEMimeMessage is not of type enveloped-data");
            }
            throw new PKCSException("SMIMEMimeMessage is not of type enveloped-data");
        }
        ContentInfo contentInfo = (ContentInfo)this.getContent();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "decrypt", contentInfo.decrypt(privateKey, certificate));
        }
        return contentInfo.decrypt(privateKey, certificate);
    }

    private byte[] getSignatureOnlyMessage() throws PKCSException, IOException {
        if (debug != null) {
            debug.entry(8192L, className, "getSignatureOnlyMessage");
        }
        if (!this.isSignedDataSignatureOnly()) {
            if (debug != null) {
                debug.entry(8192L, (Object)className, "getSignatureOnlyMessage", "SMIMEMimeMessage is not of type signature-only SignedData.");
            }
            throw new PKCSException("SMIMEMimeMessage is not of type signature-only SignedData.");
        }
        try {
            Object object = this.getContent();
            if (object instanceof MimeMultipart) {
                MimeMultipart mimeMultipart = (MimeMultipart)object;
                int n = mimeMultipart.getCount();
                if (n == 2) {
                    MimeBodyPart mimeBodyPart = (MimeBodyPart)mimeMultipart.getBodyPart(0);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    mimeBodyPart.writeTo((OutputStream)byteArrayOutputStream);
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    if (debug != null) {
                        debug.exit(8192L, (Object)className, "getSignatureOnlyMessage", byArray);
                    }
                    return byArray;
                }
                if (debug != null) {
                    debug.text(8192L, className, "getSignatureOnlyMessage", "SMIMEMimeMessage MimeMultipart object does not contain two MimeBodyPart objects.");
                }
                throw new PKCSException("SMIMEMimeMessage MimeMultipart object does not contain two MimeBodyPart objects.");
            }
            if (debug != null) {
                debug.text(8192L, className, "getSignatureOnlyMessage", "SMIMEMimeMessage does not contain a MimeMultipart object.");
            }
            throw new PKCSException("SMIMEMimeMessage does not contain a MimeMultipart object.");
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "getSignatureOnlyMessage", exception);
            }
            throw new PKCSException(exception, exception.toString());
        }
    }

    private ContentInfo getSignatureOnlyContentInfo() throws PKCSException {
        if (debug != null) {
            debug.entry(8192L, className, "getSignatureOnlyContentInfo");
        }
        if (!this.isSignedDataSignatureOnly()) {
            if (debug != null) {
                debug.text(8192L, className, "getSignatureOnlyContentInfo", "SMIMEMimeMessage is not of type signature-only SignedData.");
            }
            throw new PKCSException("SMIMEMimeMessage is not of type signature-only SignedData.");
        }
        try {
            Object object = this.getContent();
            if (object instanceof MimeMultipart) {
                MimeMultipart mimeMultipart = (MimeMultipart)object;
                int n = mimeMultipart.getCount();
                if (n == 2) {
                    MimeBodyPart mimeBodyPart = (MimeBodyPart)mimeMultipart.getBodyPart(1);
                    if (debug != null) {
                        debug.exit(8192L, (Object)className, "getSignatureOnlyContentInfo", (ContentInfo)mimeBodyPart.getContent());
                    }
                    return (ContentInfo)mimeBodyPart.getContent();
                }
                if (debug != null) {
                    debug.text(8192L, className, "getSignatureOnlyContentInfo", "SMIMEMimeMessage MimeMultipart object does not contain two MimeBodyPart objects.");
                }
                throw new PKCSException("SMIMEMimeMessage MimeMultipart object does not contain two MimeBodyPart objects.");
            }
            if (debug != null) {
                debug.text(8192L, className, "getSignatureOnlyContentInfo", "SMIMEMimeMessage does not contain a MimeMultipart object.");
            }
            throw new PKCSException("SMIMEMimeMessage does not contain a MimeMultipart object.");
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "getSignatureOnlyContentInfo", exception);
            }
            throw new PKCSException(exception, exception.toString());
        }
    }

    private void setContainedObjects() throws MessagingException {
        try {
            Object object;
            if (debug != null) {
                debug.entry(8192L, className, "setContainedObjects");
            }
            if ((object = this.getContent()) != null) {
                if (object instanceof ContentInfo) {
                    this.contentInfo = (ContentInfo)object;
                } else if (object instanceof CertificationRequest) {
                    this.certificationRequest = (CertificationRequest)object;
                }
            }
            if (this.isSignedDataSignatureOnly() && object instanceof MimeMultipart) {
                MimeMultipart mimeMultipart = (MimeMultipart)object;
                MimeBodyPart mimeBodyPart = (MimeBodyPart)mimeMultipart.getBodyPart(0);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                mimeBodyPart.writeTo((OutputStream)byteArrayOutputStream);
                this.messageContent = byteArrayOutputStream.toByteArray();
            }
            if (debug != null) {
                debug.exit(8192L, className, "setContainedObjects");
            }
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(8192L, className, "setContainedObjects", iOException);
            }
            iOException.printStackTrace();
            throw new MessagingException(iOException.toString());
        }
    }

    private void debugContainedObjects() throws MessagingException {
        try {
            if (debug != null) {
                debug.entry(8192L, className, "debugContainedObjects");
            }
            Object object = this.getContent();
            ContentType contentType = new ContentType(this.getContentType());
            if (debug != null) {
                debug.exit(8192L, className, "debugContainedObjects");
            }
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(8192L, className, "debugContainedObjects", iOException);
            }
            throw new MessagingException(iOException.toString());
        }
    }

    public ContentInfo getContentInfo() {
        if (debug != null) {
            debug.entry(16384L, className, "getContentInfo");
        }
        if (this.contentInfo == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentInfo_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentInfo_2", this.contentInfo.clone());
        }
        return (ContentInfo)this.contentInfo.clone();
    }

    public CertificationRequest getCertificationRequest() {
        if (debug != null) {
            debug.entry(16384L, className, "getCertificationRequest");
        }
        if (this.certificationRequest == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getCertificationRequest_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertificationRequest_2", this.certificationRequest);
        }
        return this.certificationRequest;
    }

    byte[] getContentBytes() {
        if (debug != null) {
            debug.entry(16384L, className, "getContentBytes");
        }
        if (this.content == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentBytes_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentBytes_2", (byte[])this.content.clone());
        }
        return (byte[])this.content.clone();
    }

    public String toString() {
        String string = "SMIMEMimeMessage:  ";
        String string2 = "PKCS #7 or #10 message type not set or unknown.";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        string = this.isSignedData() ? string + "PKCS #7 SignedData message." : (this.isSignedDataSignatureOnly() ? string + "PKCS #7 SignedData signature-only message." : (this.isSignedDataCertificateOnly() ? string + "PKCS #7 SignedData certificate-only message." : (this.isEnvelopedData() ? string + "PKCS #7 EnvelopedData message." : (this.isCertificationRequest() ? string + "PKCS #10 CertificationRequest message." : string + string2))));
        string = this.contentInfo != null ? string + "\r\n\tContains a ContentInfo object of type " + this.contentInfo.getContentTypeString() + "." : (this.certificationRequest != null ? string + "\r\n\tContains a CertificationRequest object." : string + "\r\n\tDoes not contain a ContentInfo or CertificationRequest object.");
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }
}

