/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;

public final class SigningTime
extends PKCS9DerObject
implements Cloneable {
    private Date date;
    private boolean bUTCTime;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.SigningTime";
    private volatile int cachedHashVal = 0;

    public SigningTime(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SigningTime", (Object)byArray);
            debug.exit(16384L, className, "SigningTime");
        }
    }

    public SigningTime(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "SigningTime", byArray, string);
            debug.exit(16384L, className, "SigningTime");
        }
    }

    public SigningTime(Date date) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SigningTime", date);
        }
        this.date = date;
        this.bUTCTime = true;
        if (debug != null) {
            debug.exit(16384L, className, "SigningTime");
        }
    }

    public SigningTime(Date date, String string) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "SigningTime", date, string);
        }
        this.date = date;
        this.bUTCTime = true;
        if (debug != null) {
            debug.exit(16384L, className, "SigningTime");
        }
    }

    public SigningTime(Date date, boolean bl) {
        if (debug != null) {
            debug.entry(16384L, className, "SigningTime", date, new Boolean(bl));
        }
        this.date = date;
        this.bUTCTime = bl;
        if (debug != null) {
            debug.exit(16384L, className, "SigningTime");
        }
    }

    public SigningTime(Date date, boolean bl, String string) {
        super(string);
        if (debug != null) {
            Object[] objectArray = new Object[]{date, new Boolean(bl), string};
            debug.entry(16384L, (Object)className, "SigningTime", objectArray);
        }
        this.date = date;
        this.bUTCTime = bl;
        if (debug != null) {
            debug.exit(16384L, className, "SigningTime");
        }
    }

    public SigningTime(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "SigningTime", string, new Boolean(bl));
            debug.exit(16384L, className, "SigningTime");
        }
    }

    public SigningTime(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "SigningTime", objectArray);
            debug.exit(16384L, className, "SigningTime");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            SigningTime signingTime = new SigningTime(derOutputStream.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", signingTime);
            }
            return signingTime;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, className, "equals");
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        if (object instanceof SigningTime) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(this.equals((SigningTime)object)));
            }
            return this.equals((SigningTime)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(false));
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.SIGNING_TIME_OID);
        }
        return PKCSOID.SIGNING_TIME_OID;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.date == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Date not specified.");
            }
            throw new IOException("Date not specified.");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.getObjectIdentifier());
        if (this.bUTCTime) {
            derOutputStream2.putUTCTime(this.date);
        } else {
            derOutputStream2.putGeneralizedTime(this.date);
        }
        derOutputStream.write((byte)49, derOutputStream2.toByteArray());
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream.toByteArray());
        outputStream.write(derOutputStream3.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public Date getDate() {
        if (debug != null) {
            debug.entry(16384L, className, "getDate");
            debug.exit(16384L, (Object)className, "getDate", this.date.clone());
        }
        return (Date)this.date.clone();
    }

    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.getDate());
        }
        return this.getDate();
    }

    public boolean isTagValid(byte by) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isTagValid", new Byte(by));
        }
        if (by == 23 || by == 24) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isTagValid", new Boolean(true));
            }
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isTagValid", new Boolean(false));
        }
        return false;
    }

    public boolean isSingleValued() {
        if (debug != null) {
            debug.entry(16384L, className, "isSingleValued");
            debug.exit(16384L, (Object)className, "isSingleValued", new Boolean(true));
        }
        return true;
    }

    public String getAttributeName() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributeName");
            debug.exit(16384L, (Object)className, "getAttributeName", "SigningTime");
        }
        return "SigningTime";
    }

    public String toString() {
        String string = "PKCS9 SigningTime:\r\n";
        string = this.date != null ? string + "\t" + this.date + "\r\n" : string + "\tnull\r\n";
        string = this.bUTCTime ? string + "\tEncoded in UTCTime\r\n" : string + "\tEncoded in GeneralizedTime\r\n";
        return string;
    }

    protected void decode(DerValue derValue) throws IOException {
        super.decode(derValue);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        DerValue[] derValueArray = null;
        if (derValue.getTag() == 48) {
            DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
            DerValue[] derValueArray2 = derInputStream.getSequence(2);
            derValueArray = new DerInputStream(derValueArray2[1].toByteArray()).getSet(1);
        } else {
            derValueArray = new DerInputStream(derValue.toByteArray()).getSet(1);
        }
        if (derValueArray[0].getTag() == 23) {
            this.date = new DerInputStream(derValueArray[0].toByteArray()).getUTCTime();
            this.bUTCTime = true;
            if (debug != null) {
                debug.exit(16384L, className, "decode");
            }
            return;
        }
        if (derValueArray[0].getTag() == 24) {
            this.date = new DerInputStream(derValueArray[0].toByteArray()).getGeneralizedTime();
            this.bUTCTime = false;
            if (debug != null) {
                debug.exit(16384L, className, "decode");
            }
            return;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "decode", "tag " + derValueArray[0].getTag() + " not valid.");
        }
        throw new IOException("tag " + derValueArray[0].getTag() + " not valid.");
    }

    private boolean equals(SigningTime signingTime) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", signingTime);
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            signingTime.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }
}

