/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs9.ESSCertID;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.PolicyInformation;
import com.ibm.security.x509.SerialNumber;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SigningCertificate
extends PKCS9DerObject
implements Cloneable {
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.SigningCertificate";
    private static final int MAX_SIZE = 5;
    private ArrayList<ESSCertID> certIds;
    private ArrayList<PolicyInformation> policyInfos;
    private volatile int cachedHashVal = 0;

    public SigningCertificate(byte[] byArray) throws IOException {
        super(byArray);
    }

    public SigningCertificate(byte[] byArray, String string) throws IOException {
        super(byArray, string);
    }

    public SigningCertificate(String string, boolean bl) throws IOException {
        super(string, bl);
    }

    public SigningCertificate(X509Certificate[] x509CertificateArray, PolicyInformation[] policyInformationArray, boolean bl) throws NoSuchAlgorithmException, CertificateEncodingException {
        if (x509CertificateArray != null && x509CertificateArray.length > 0) {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                messageDigest.update(x509CertificateArray[i].getEncoded());
                byte[] byArray = messageDigest.digest();
                messageDigest.reset();
                if (bl) {
                    SerialNumber serialNumber = new SerialNumber(x509CertificateArray[i].getSerialNumber());
                    GeneralNames generalNames = new GeneralNames();
                    generalNames.add(new GeneralName((X500Name)x509CertificateArray[i].getIssuerDN()));
                    this.addCertID(byArray, serialNumber, generalNames);
                    continue;
                }
                this.addCertID(byArray, null, null);
            }
        }
        if (policyInformationArray != null && policyInformationArray.length > 0) {
            for (int i = 0; i < policyInformationArray.length; ++i) {
                this.addPolicyInfo(policyInformationArray[i]);
            }
        }
    }

    public SigningCertificate(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
    }

    @Override
    public boolean isTagValid(byte by) {
        return by == 48;
    }

    @Override
    public boolean isSingleValued() {
        return true;
    }

    @Override
    public String getAttributeName() {
        return "SigningCertificate";
    }

    @Override
    public Object getValue() {
        return this.clone();
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        DerEncoder[] derEncoderArray;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.certIds == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "ESSCertID objects not specified.");
            }
            throw new IOException("ESSCertID objects not specified.");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        Iterator<Object> iterator = this.certIds.iterator();
        while (iterator.hasNext()) {
            iterator.next().encode(derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream2);
        if (this.policyInfos != null && this.policyInfos.size() > 0) {
            derEncoderArray = new DerOutputStream();
            iterator = this.policyInfos.iterator();
            while (iterator.hasNext()) {
                ((PolicyInformation)iterator.next()).encode((OutputStream)derEncoderArray);
            }
            derOutputStream.write((byte)48, (DerOutputStream)derEncoderArray);
        }
        derEncoderArray = new DerOutputStream[]{new DerOutputStream()};
        derEncoderArray[0].write((byte)48, derOutputStream);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.putOID(this.getObjectIdentifier());
        derOutputStream3.putOrderedSetOf((byte)49, derEncoderArray);
        DerOutputStream derOutputStream4 = new DerOutputStream();
        derOutputStream4.write((byte)48, derOutputStream3);
        outputStream.write(derOutputStream4.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[\n");
        Iterator<Object> iterator = this.certIds.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Object)iterator.next()).toString());
        }
        if (this.policyInfos != null && this.policyInfos.size() > 0) {
            iterator = this.policyInfos.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString());
            }
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        if (object instanceof SigningCertificate) {
            DerValue derValue;
            DerValue derValue2;
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                DerOutputStream derOutputStream2 = new DerOutputStream();
                this.encode(derOutputStream);
                derValue2 = new DerValue(derOutputStream.toByteArray());
                ((SigningCertificate)object).encode(derOutputStream2);
                derValue = new DerValue(derOutputStream2.toByteArray());
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.exception(16388L, className, "equals", exception);
                }
                return false;
            }
            if (!derValue2.equals(derValue)) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "equals", new Boolean(false));
                }
                return false;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                this.cachedHashVal = Arrays.hashCode(derOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    private void addCertID(byte[] byArray, SerialNumber serialNumber, GeneralNames generalNames) {
        if (this.certIds == null) {
            this.certIds = new ArrayList(5);
        }
        this.certIds.add(new ESSCertID(byArray, serialNumber, generalNames));
    }

    private void addPolicyInfo(PolicyInformation policyInformation) {
        if (this.policyInfos == null) {
            this.policyInfos = new ArrayList(5);
        }
        this.policyInfos.add((PolicyInformation)policyInformation.clone());
    }

    public Iterator<PolicyInformation> getPolicyInfos() {
        if (this.policyInfos != null) {
            return this.policyInfos.iterator();
        }
        if (debug != null) {
            debug.text(16384L, className, "getPolicyInfos", "No Policy Infos exist");
        }
        return null;
    }

    public byte[] getVerificationCertificateHash() {
        if (this.certIds != null && this.certIds.size() > 0) {
            return this.certIds.get(0).getCertHash();
        }
        if (debug != null) {
            debug.text(16384L, className, "getVerificationCertificateHash", "No CertIDs exist");
        }
        return null;
    }

    public SerialNumber getVerificationCertificateSerialNumber() throws IOException {
        if (this.certIds != null && this.certIds.size() > 0) {
            return this.certIds.get(0).getSerialNumber();
        }
        if (debug != null) {
            debug.text(16384L, className, "getVerificationCertificateSerialNumber", "No CertIDs exist");
        }
        return null;
    }

    public GeneralNames getVerificationCertificateIssuer() {
        if (this.certIds != null && this.certIds.size() > 0) {
            return this.certIds.get(0).getIssuer();
        }
        if (debug != null) {
            debug.text(16384L, className, "getVerificationCertificateIssuer", "No CertIDs exist");
        }
        return null;
    }

    public boolean isAuthorizationCertificate(X509Certificate x509Certificate) throws IOException, NoSuchAlgorithmException, CertificateEncodingException {
        if (this.certIds == null || this.certIds.size() == 0) {
            return false;
        }
        if (this.certIds.size() == 1) {
            return true;
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        messageDigest.update(x509Certificate.getEncoded());
        byte[] byArray = messageDigest.digest();
        SerialNumber serialNumber = new SerialNumber(x509Certificate.getSerialNumber());
        GeneralNames generalNames = new GeneralNames();
        generalNames.add(new GeneralName((X500Name)x509Certificate.getIssuerDN()));
        for (int i = 1; i < this.certIds.size(); ++i) {
            int n;
            ESSCertID eSSCertID = this.certIds.get(i);
            byte[] byArray2 = eSSCertID.getCertHash();
            if (byArray.length != byArray2.length) continue;
            boolean bl = true;
            for (n = 0; n < byArray.length; ++n) {
                if (byArray[n] == byArray2[n]) continue;
                bl = false;
                break;
            }
            n = 1;
            if (eSSCertID.getIssuer() != null && eSSCertID.getSerialNumber() != null) {
                int n2 = n = eSSCertID.getIssuer().equals(generalNames) && eSSCertID.getSerialNumber().getNumber().equals(serialNumber.getNumber()) ? 1 : 0;
            }
            if (!bl || n == 0) continue;
            return true;
        }
        return false;
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            SigningCertificate signingCertificate = new SigningCertificate(derOutputStream.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", signingCertificate);
            }
            return signingCertificate;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    @Override
    protected void decode(DerValue derValue) throws IOException {
        DerValue[] derValueArray;
        super.decode(derValue);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        DerValue[] derValueArray2 = null;
        if (derValue.getTag() == 48) {
            derValueArray = new DerInputStream(derValue.toByteArray());
            DerValue[] derValueArray3 = derValueArray.getSequence(2);
            derValueArray2 = new DerInputStream(derValueArray3[1].toByteArray()).getSet(1);
        } else {
            derValueArray2 = new DerInputStream(derValue.toByteArray()).getSet(1);
        }
        if (derValueArray2[0].getTag() != 48) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "decode", derValue);
            }
            throw new IOException("Bad encoding for signingCertificate");
        }
        derValueArray = derValueArray2[0].getData().getSequence(1);
        this.certIds = new ArrayList(derValueArray.length);
        for (int i = 0; i < derValueArray.length; ++i) {
            this.certIds.add(new ESSCertID(derValueArray[i]));
        }
        if (derValueArray2[0].getData().available() > 0) {
            DerValue[] derValueArray4 = derValueArray2[0].getData().getSequence(1);
            this.policyInfos = new ArrayList(derValueArray4.length);
            for (int i = 0; i < derValueArray4.length; ++i) {
                this.policyInfos.add(new PolicyInformation(derValueArray4[i].toByteArray()));
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "decode", derValue);
        }
    }

    @Override
    public ObjectIdentifier getObjectIdentifier() {
        return PKCSOID.SIGNING_CERTIFICATE_OID;
    }
}

