/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.PKCS12Utils;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.SignerInfo;
import com.ibm.security.pkcs9.ChallengePassword;
import com.ibm.security.pkcs9.ContentType;
import com.ibm.security.pkcs9.Countersignature;
import com.ibm.security.pkcs9.EmailAddress;
import com.ibm.security.pkcs9.ExtendedCertificateAttributes;
import com.ibm.security.pkcs9.ExtensionRequest;
import com.ibm.security.pkcs9.FriendlyName;
import com.ibm.security.pkcs9.LocalKeyId;
import com.ibm.security.pkcs9.MessageDigest;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcs9.SignatureTimestampToken;
import com.ibm.security.pkcs9.SigningCertificate;
import com.ibm.security.pkcs9.SigningTime;
import com.ibm.security.pkcs9.UnstructuredAddress;
import com.ibm.security.pkcs9.UnstructuredName;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.CertificateExtensions;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;

public final class PKCS9 {
    public static final String EMAIL_ADDRESS_STR = "EmailAddress";
    public static final String UNSTRUCTURED_NAME_STR = "UnstructuredName";
    public static final String CONTENT_TYPE_STR = "ContentType";
    public static final String MESSAGE_DIGEST_STR = "MessageDigest";
    public static final String SIGNING_TIME_STR = "SigningTime";
    public static final String COUNTERSIGNATURE_STR = "Countersignature";
    public static final String CHALLENGE_PASSWORD_STR = "ChallengePassword";
    public static final String UNSTRUCTURED_ADDRESS_STR = "UnstructuredAddress";
    public static final String EXTENDED_CERTIFICATE_ATTRIBUTES_STR = "ExtendedCertificateAttributes";
    public static final String FRIENDLY_NAME_STR = "FriendlyName";
    public static final String LOCAL_KEY_ID_STR = "LocalKeyId";
    public static final String SIGNING_CERTIFICATE_STR = "SigningCertificate";
    public static final String EXTENSION_REQUEST_STR = "ExtensionRequest";
    public static final String SIGNATURE_TIMESTAMP_TOKEN_STR = "SignatureTimestampToken";
    private static final int TABLE_SIZE = 14;
    private static final Hashtable NAME_OID_TABLE = new Hashtable(14);
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.PKCS9";
    private static final Hashtable OID_NAME_TABLE;

    private PKCS9() {
    }

    public static ObjectIdentifier getObjectIdentifier(String string) {
        return (ObjectIdentifier)NAME_OID_TABLE.get(string.toLowerCase());
    }

    public static String getName(ObjectIdentifier objectIdentifier) {
        return (String)OID_NAME_TABLE.get(objectIdentifier);
    }

    public static PKCS9DerObject getPKCS9Attribute(ObjectIdentifier objectIdentifier, Object object) {
        return PKCS9.init(objectIdentifier, object);
    }

    public static PKCS9DerObject getPKCS9Attribute(ObjectIdentifier objectIdentifier, Object object, String string) {
        return PKCS9.init(objectIdentifier, object, string);
    }

    public static PKCS9DerObject getPKCS9Attribute(String string, Object object) {
        ObjectIdentifier objectIdentifier = PKCS9.getObjectIdentifier(string);
        if (objectIdentifier == null) {
            throw new IllegalArgumentException("Unrecognized attribute name " + string + ".");
        }
        return PKCS9.init(objectIdentifier, object);
    }

    public static PKCS9DerObject getPKCS9Attribute(String string, Object object, String string2) {
        ObjectIdentifier objectIdentifier = PKCS9.getObjectIdentifier(string);
        if (objectIdentifier == null) {
            throw new IllegalArgumentException("Unrecognized attribute name " + string + ".");
        }
        return PKCS9.init(objectIdentifier, object, string2);
    }

    public static PKCS9DerObject getPKCS9Attribute(byte[] byArray) throws IOException {
        return PKCS9.getPKCS9Attribute(byArray, null);
    }

    public static PKCS9DerObject getPKCS9Attribute(byte[] byArray, String string) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(2);
        if (derInputStream.available() != 0) {
            throw new IOException("Excess data parsing PKCS9 Attribute");
        }
        if (derValueArray.length != 2) {
            throw new IOException("PKCS9 Attribute does not have two components");
        }
        ObjectIdentifier objectIdentifier = derValueArray[0].getOID();
        if (objectIdentifier.equals(PKCSOID.EMAIL_ADDRESS_OID)) {
            return new EmailAddress(byArray, string);
        }
        if (objectIdentifier.equals(PKCSOID.UNSTRUCTURED_NAME_OID)) {
            return new UnstructuredName(byArray, string);
        }
        if (objectIdentifier.equals(PKCSOID.CONTENT_TYPE_OID)) {
            return new ContentType(byArray, string);
        }
        if (objectIdentifier.equals(PKCSOID.MESSAGE_DIGEST_OID)) {
            return new MessageDigest(byArray, string);
        }
        if (objectIdentifier.equals(PKCSOID.SIGNING_TIME_OID)) {
            return new SigningTime(byArray, string);
        }
        if (objectIdentifier.equals(PKCSOID.COUNTERSIGNATURE_OID)) {
            return new Countersignature(byArray, string);
        }
        if (objectIdentifier.equals(PKCSOID.CHALLENGE_PASSWORD_OID)) {
            return new ChallengePassword(byArray, string);
        }
        if (objectIdentifier.equals(PKCSOID.UNSTRUCTURED_ADDRESS_OID)) {
            return new UnstructuredAddress(byArray, string);
        }
        if (objectIdentifier.equals(PKCSOID.EXTENDED_CERTIFICATE_ATTRIBUTES_OID)) {
            return new ExtendedCertificateAttributes(byArray, string);
        }
        if (objectIdentifier.equals(PKCSOID.FRIENDLY_NAME_OID)) {
            return new FriendlyName(byArray, string);
        }
        if (objectIdentifier.equals(PKCSOID.LOCAL_KEY_ID_OID)) {
            return new LocalKeyId(byArray, string);
        }
        if (objectIdentifier.equals(PKCSOID.SIGNING_CERTIFICATE_OID)) {
            return new SigningCertificate(byArray, string);
        }
        if (objectIdentifier.equals(PKCSOID.EXTENSION_REQUEST_OID)) {
            return new ExtensionRequest(byArray, string);
        }
        if (objectIdentifier.equals(PKCSOID.SIGNATURE_TIMESTAMP_TOKEN_OID)) {
            return new SignatureTimestampToken(byArray, string);
        }
        throw new IOException("Unrecognized Object Identifier " + objectIdentifier + ".");
    }

    public static boolean isAuthenticatedData(String string) {
        return string.equals(PKCSOID.AUTHENTICATED_DATA_OID.toString());
    }

    public static boolean isAuthenticatedData(ObjectIdentifier objectIdentifier) {
        return objectIdentifier.equals(PKCSOID.AUTHENTICATED_DATA_OID);
    }

    private static PKCS9DerObject init(ObjectIdentifier objectIdentifier, Object object) {
        return PKCS9.init(objectIdentifier, object, null);
    }

    private static PKCS9DerObject init(ObjectIdentifier objectIdentifier, Object object, String string) {
        try {
            if (objectIdentifier.equals(PKCSOID.EMAIL_ADDRESS_OID)) {
                if (object instanceof String) {
                    return new EmailAddress((String)object, string);
                }
                return new EmailAddress((String[])object, string);
            }
            if (objectIdentifier.equals(PKCSOID.UNSTRUCTURED_NAME_OID)) {
                if (object instanceof String) {
                    String[] stringArray = new String[]{(String)object};
                    return new UnstructuredName(stringArray, string);
                }
                return new UnstructuredName((String[])object, string);
            }
            if (objectIdentifier.equals(PKCSOID.CONTENT_TYPE_OID)) {
                return new ContentType((ObjectIdentifier)object, string);
            }
            if (objectIdentifier.equals(PKCSOID.MESSAGE_DIGEST_OID)) {
                DerOutputStream derOutputStream = new DerOutputStream();
                DerOutputStream derOutputStream2 = new DerOutputStream();
                derOutputStream.putOID(PKCSOID.MESSAGE_DIGEST_OID);
                derOutputStream2.putOctetString((byte[])object);
                derOutputStream.write((byte)49, derOutputStream2.toByteArray());
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.write((byte)48, derOutputStream.toByteArray());
                return new MessageDigest(derOutputStream3.toByteArray(), string);
            }
            if (objectIdentifier.equals(PKCSOID.SIGNING_TIME_OID)) {
                return new SigningTime((Date)object, string);
            }
            if (objectIdentifier.equals(PKCSOID.COUNTERSIGNATURE_OID)) {
                return new Countersignature((SignerInfo[])object, string);
            }
            if (objectIdentifier.equals(PKCSOID.CHALLENGE_PASSWORD_OID)) {
                return new ChallengePassword((char[])object, string);
            }
            if (objectIdentifier.equals(PKCSOID.UNSTRUCTURED_ADDRESS_OID)) {
                if (object instanceof String) {
                    String[] stringArray = new String[]{(String)object};
                    return new UnstructuredAddress(stringArray, 19, string);
                }
                return new UnstructuredAddress((String[])object, 19, string);
            }
            if (objectIdentifier.equals(PKCSOID.EXTENDED_CERTIFICATE_ATTRIBUTES_OID)) {
                return new ExtendedCertificateAttributes((PKCSAttributes)object, string);
            }
            if (objectIdentifier.equals(PKCSOID.FRIENDLY_NAME_OID)) {
                DerOutputStream derOutputStream = new DerOutputStream();
                DerOutputStream derOutputStream4 = new DerOutputStream();
                DerOutputStream derOutputStream5 = new DerOutputStream();
                derOutputStream.putOID(PKCSOID.FRIENDLY_NAME_OID);
                if (object instanceof String) {
                    String string2 = (String)object;
                    derOutputStream4.putBMPString(PKCS12Utils.ascii2bmp(string2.toCharArray()));
                } else {
                    derOutputStream4.putBMPString((byte[])object);
                }
                derOutputStream.write((byte)49, derOutputStream4.toByteArray());
                derOutputStream5.write((byte)48, derOutputStream.toByteArray());
                return new FriendlyName(derOutputStream5.toByteArray(), string);
            }
            if (objectIdentifier.equals(PKCSOID.LOCAL_KEY_ID_OID)) {
                DerOutputStream derOutputStream = new DerOutputStream();
                DerOutputStream derOutputStream6 = new DerOutputStream();
                DerOutputStream derOutputStream7 = new DerOutputStream();
                derOutputStream.putOID(PKCSOID.LOCAL_KEY_ID_OID);
                derOutputStream6.putOctetString((byte[])object);
                derOutputStream.write((byte)49, derOutputStream6.toByteArray());
                derOutputStream7.write((byte)48, derOutputStream.toByteArray());
                return new LocalKeyId(derOutputStream7.toByteArray(), string);
            }
            if (objectIdentifier.equals(PKCSOID.SIGNING_CERTIFICATE_OID)) {
                return (SigningCertificate)object;
            }
            if (objectIdentifier.equals(PKCSOID.EXTENSION_REQUEST_OID)) {
                return new ExtensionRequest((CertificateExtensions)object);
            }
            if (objectIdentifier.equals(PKCSOID.TSTINFO_OID)) {
                return new SignatureTimestampToken((ContentInfo)object);
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Class " + object.getClass().getName() + " does not match the class required for Object Identifier " + objectIdentifier);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot construct attribute from input value.");
        }
        throw new IllegalArgumentException("Unrecognized Object Identifier " + objectIdentifier + ".");
    }

    static {
        NAME_OID_TABLE.put(new String(EMAIL_ADDRESS_STR).toLowerCase(), PKCSOID.EMAIL_ADDRESS_OID);
        NAME_OID_TABLE.put(new String(UNSTRUCTURED_NAME_STR).toLowerCase(), PKCSOID.UNSTRUCTURED_NAME_OID);
        NAME_OID_TABLE.put(new String(CONTENT_TYPE_STR).toLowerCase(), PKCSOID.CONTENT_TYPE_OID);
        NAME_OID_TABLE.put(new String(MESSAGE_DIGEST_STR).toLowerCase(), PKCSOID.MESSAGE_DIGEST_OID);
        NAME_OID_TABLE.put(new String(SIGNING_TIME_STR).toLowerCase(), PKCSOID.SIGNING_TIME_OID);
        NAME_OID_TABLE.put(new String(COUNTERSIGNATURE_STR).toLowerCase(), PKCSOID.COUNTERSIGNATURE_OID);
        NAME_OID_TABLE.put(new String(CHALLENGE_PASSWORD_STR).toLowerCase(), PKCSOID.CHALLENGE_PASSWORD_OID);
        NAME_OID_TABLE.put(new String(UNSTRUCTURED_ADDRESS_STR).toLowerCase(), PKCSOID.UNSTRUCTURED_ADDRESS_OID);
        NAME_OID_TABLE.put(new String(EXTENDED_CERTIFICATE_ATTRIBUTES_STR).toLowerCase(), PKCSOID.EXTENDED_CERTIFICATE_ATTRIBUTES_OID);
        NAME_OID_TABLE.put(new String(FRIENDLY_NAME_STR).toLowerCase(), PKCSOID.FRIENDLY_NAME_OID);
        NAME_OID_TABLE.put(new String(LOCAL_KEY_ID_STR).toLowerCase(), PKCSOID.LOCAL_KEY_ID_OID);
        NAME_OID_TABLE.put(new String(SIGNING_CERTIFICATE_STR).toLowerCase(), PKCSOID.SIGNING_CERTIFICATE_OID);
        NAME_OID_TABLE.put(new String(EXTENSION_REQUEST_STR).toLowerCase(), PKCSOID.EXTENSION_REQUEST_OID);
        NAME_OID_TABLE.put(new String(SIGNATURE_TIMESTAMP_TOKEN_STR).toLowerCase(), PKCSOID.SIGNATURE_TIMESTAMP_TOKEN_OID);
        OID_NAME_TABLE = new Hashtable(14);
        OID_NAME_TABLE.put(PKCSOID.EMAIL_ADDRESS_OID, EMAIL_ADDRESS_STR);
        OID_NAME_TABLE.put(PKCSOID.UNSTRUCTURED_NAME_OID, UNSTRUCTURED_NAME_STR);
        OID_NAME_TABLE.put(PKCSOID.CONTENT_TYPE_OID, CONTENT_TYPE_STR);
        OID_NAME_TABLE.put(PKCSOID.MESSAGE_DIGEST_OID, MESSAGE_DIGEST_STR);
        OID_NAME_TABLE.put(PKCSOID.SIGNING_TIME_OID, SIGNING_TIME_STR);
        OID_NAME_TABLE.put(PKCSOID.COUNTERSIGNATURE_OID, COUNTERSIGNATURE_STR);
        OID_NAME_TABLE.put(PKCSOID.CHALLENGE_PASSWORD_OID, CHALLENGE_PASSWORD_STR);
        OID_NAME_TABLE.put(PKCSOID.UNSTRUCTURED_ADDRESS_OID, UNSTRUCTURED_ADDRESS_STR);
        OID_NAME_TABLE.put(PKCSOID.EXTENDED_CERTIFICATE_ATTRIBUTES_OID, EXTENDED_CERTIFICATE_ATTRIBUTES_STR);
        OID_NAME_TABLE.put(PKCSOID.FRIENDLY_NAME_OID, FRIENDLY_NAME_STR);
        OID_NAME_TABLE.put(PKCSOID.LOCAL_KEY_ID_OID, LOCAL_KEY_ID_STR);
        OID_NAME_TABLE.put(PKCSOID.SIGNING_CERTIFICATE_OID, SIGNING_CERTIFICATE_STR);
        OID_NAME_TABLE.put(PKCSOID.EXTENSION_REQUEST_OID, EXTENSION_REQUEST_STR);
        OID_NAME_TABLE.put(PKCSOID.SIGNATURE_TIMESTAMP_TOKEN_OID, SIGNATURE_TIMESTAMP_TOKEN_STR);
    }
}

